//---------------------------------------------------------------------------
//packet32.c ---- DLL di interfaccia per il driver packet.sys
//---------------------------------------------------------------------------

#define UNICODE 1

#include <windows.h>
#include <windowsx.h>

#include "ntddndis.h"
#include "ntddpack.h"
#include "packet32.h"

//---------------------------------------------------------------------------
TCHAR   szWindowTitle[] = TEXT("PACKET32.DLL");

#if DBG
#define ODS(_x) OutputDebugString(TEXT(_x))
#else
#define ODS(_x)
#endif

BOOLEAN StartPacketDriver(LPTSTR ServiceName);

//---------------------------------------------------------------------------
BOOL PacketInit(IN PVOID DllHandle,IN ULONG Reason,IN PCONTEXT Context OPTIONAL)

{
    BOOLEAN     Status;

    ODS("Packet32: DllEntry\n");
    switch ( Reason )
    {
        case DLL_PROCESS_ATTACH:
            Status=StartPacketDriver(TEXT("PACKET"));
            break;
        case DLL_PROCESS_DETACH:
            break;
        default:
            break;
    }
    return Status;
}

//---------------------------------------------------------------------------

LPADAPTER PacketOpenAdapter(LPTSTR AdapterName)

{
    LPADAPTER  lpAdapter;
    BOOLEAN    Result;

    ODS("Packet32: PacketOpenAdapter\n");
    lpAdapter=(LPADAPTER)GlobalAllocPtr(GMEM_MOVEABLE | GMEM_ZEROINIT,sizeof(ADAPTER));
    if (lpAdapter==NULL)
    {
        ODS("Packet32: PacketOpenAdapter GlobalAlloc Failed\n");
        return NULL;
    }
    wsprintf(lpAdapter->SymbolicLink,TEXT("\\\\.\\%s%s"),DOSNAMEPREFIX,&AdapterName[8]);
    Result=DefineDosDevice(DDD_RAW_TARGET_PATH,&lpAdapter->SymbolicLink[4],AdapterName);
    if (Result)
    {
        lpAdapter->hFile=CreateFile(lpAdapter->SymbolicLink,GENERIC_WRITE | GENERIC_READ,
                                    0,NULL,CREATE_ALWAYS,FILE_FLAG_OVERLAPPED,0);
        if (lpAdapter->hFile != INVALID_HANDLE_VALUE)
        {
            return lpAdapter;
        }
    }
    ODS("Packet32: PacketOpenAdapter Could not open adapter\n");
    GlobalFreePtr(lpAdapter);
    return NULL;
}

//---------------------------------------------------------------------------

VOID PacketCloseAdapter(LPADAPTER lpAdapter)
{
    ODS("Packet32: PacketCloseAdapter\n");
    CloseHandle(lpAdapter->hFile);
    GlobalFreePtr(lpAdapter);
}

//---------------------------------------------------------------------------

LPPACKET PacketAllocatePacket(void)
{

    LPPACKET    lpPacket;
    lpPacket=(LPPACKET)GlobalAllocPtr(GMEM_MOVEABLE | GMEM_ZEROINIT,sizeof(PACKET));
    if (lpPacket==NULL)
    {
        ODS("Packet32: PacketAllocateSendPacket: GlobalAlloc Failed\n");
        return NULL;
    }
    lpPacket->OverLapped.hEvent=CreateEvent(NULL,FALSE,FALSE,NULL);
    if (lpPacket->OverLapped.hEvent==NULL)
    {
        ODS("Packet32: PacketAllocateSendPacket: CreateEvent Failed\n");
        GlobalFreePtr(lpPacket);
        return NULL;
    }
    return lpPacket;
}

//---------------------------------------------------------------------------
LPPACKET PacketAllocateNPacket(UINT n)
{

    LPPACKET    lpPacket;
    LPPACKET    packetlist, prevpacket;
    UINT i;    
    
	if (n <= 0 || n > NMAX_PACKET)
		return NULL;

    lpPacket=(LPPACKET)GlobalAllocPtr(GMEM_MOVEABLE | GMEM_ZEROINIT,sizeof(PACKET));
    if (lpPacket==NULL)
        {
                ODS("Packet32: PacketAllocateSendPacket: GlobalAlloc Failed\n");
                return NULL;
        }
    lpPacket->Next = NULL;
    packetlist = prevpacket = lpPacket;    
    lpPacket->OverLapped.hEvent=CreateEvent(NULL,FALSE,FALSE,NULL);
    if (lpPacket->OverLapped.hEvent==NULL)
        {
                ODS("Packet32: PacketAllocateSendPacket: CreateEvent Failed\n");
                GlobalFreePtr(lpPacket);
                return NULL;
        }
		  
    for (i = 1; i < n; i++)
    {     
        lpPacket=(LPPACKET)GlobalAllocPtr(GMEM_MOVEABLE | GMEM_ZEROINIT,sizeof(PACKET));
        if (lpPacket==NULL)
		  {
                ODS("Packet32: PacketAllocateSendPacket: GlobalAlloc Failed\n");
                return NULL;
        }
        lpPacket->OverLapped.hEvent=CreateEvent(NULL,FALSE,FALSE,NULL);
        if (lpPacket->OverLapped.hEvent==NULL)
        {
                ODS("Packet32: PacketAllocateSendPacket: CreateEvent Failed\n");
                GlobalFreePtr(lpPacket);
                return NULL;
        }
        prevpacket->Next = lpPacket;
		prevpacket = lpPacket;
        lpPacket->Next=NULL;        
    }    
    return packetlist;
}

//---------------------------------------------------------------------------
VOID PacketSetNextPacket(LPPACKET lpPacket, LPPACKET next)

{
	lpPacket->Next = next;
}

//---------------------------------------------------------------------------
VOID PacketSetLengthBuffer(LPPACKET lpPacket, UINT dim)

{
	lpPacket->Length = dim;
}

//---------------------------------------------------------------------------
VOID PacketSetLengthPacket(LPPACKET lpPacket, UINT numBytes)

{
	lpPacket->ulBytesReceived = numBytes;
}

//---------------------------------------------------------------------------
LPPACKET PacketGetNextPacket(LPPACKET lpPacket)

{
	return lpPacket->Next;
}

//---------------------------------------------------------------------------
VOID PacketFreePacket(LPPACKET lpPacket)

{
    CloseHandle(lpPacket->OverLapped.hEvent);
    GlobalFreePtr(lpPacket);
}

//---------------------------------------------------------------------------

VOID PacketInitPacket(LPPACKET lpPacket,PVOID Buffer,UINT Length)

{
    lpPacket->Buffer = Buffer;
    lpPacket->Length = Length;
	lpPacket->Next = NULL;
	lpPacket->ulBytesReceived = 0;
	lpPacket->bIoComplete = FALSE;
}

//---------------------------------------------------------------------------

BOOLEAN PacketSendPacket(LPADAPTER AdapterObject,LPPACKET lpPacket,BOOLEAN Sync)

{
    BOOLEAN      Result;
    DWORD        BytesTransfered;
    
	lpPacket->OverLapped.Offset=0;
    lpPacket->OverLapped.OffsetHigh=0;
    if (!ResetEvent(lpPacket->OverLapped.hEvent))
    {
        return FALSE;
    }
    Result=WriteFile(AdapterObject->hFile,lpPacket->Buffer,lpPacket->ulBytesReceived,&BytesTransfered,&lpPacket->OverLapped);
    if (Sync)
    {
        //  They want to wait
        Result=GetOverlappedResult(AdapterObject->hFile,&lpPacket->OverLapped,&BytesTransfered,TRUE);
		lpPacket->bIoComplete = Result;
    }
    else
    {
        //  They don't want to wait, they will call PacketWaitPacket to get
        //  The real result
        Result=TRUE;
    }
    return Result;
}


//---------------------------------------------------------------------------

BOOLEAN PacketReceiveNPacket(LPADAPTER AdapterObject,LPPACKET headLPacket,UINT n,UINT length,BYTE* buffer,BOOLEAN Sync)
{
    BOOLEAN Result;
	LPPACKET lpPacket = headLPacket;
	BYTE * p = buffer;
	UINT i;

	if (n <= 0 || n > NMAX_PACKET)
		return FALSE;

	Result = FALSE;
	for (i=1; (i <= n) && (lpPacket != NULL); i++)
	{	
	    lpPacket->Buffer = p;
	    lpPacket->Length = length;
		lpPacket->OverLapped.Offset=0;
		lpPacket->OverLapped.OffsetHigh=0;
		if (!ResetEvent(lpPacket->OverLapped.hEvent))
		{
			return FALSE;
		}
		ReadFile(AdapterObject->hFile,lpPacket->Buffer,lpPacket->Length, &lpPacket->ulBytesReceived,&lpPacket->OverLapped);
		p += lpPacket->ulBytesReceived;
		lpPacket = lpPacket->Next;
	}
	lpPacket = headLPacket;
	if (Sync)
		for (i=1; (i <= n) && (lpPacket != NULL); i++)
		{	
			Result=GetOverlappedResult(AdapterObject->hFile,&lpPacket->OverLapped, &lpPacket->ulBytesReceived,TRUE);
			lpPacket->bIoComplete = Result;
			lpPacket = lpPacket->Next;
		}
	else
		Result = TRUE;
	return Result;
}


//---------------------------------------------------------------------------

BOOLEAN PacketReceivePacket(LPADAPTER   AdapterObject,LPPACKET lpPacket,BOOLEAN Sync)

{
    BOOLEAN      Result;
    lpPacket->OverLapped.Offset=0;
    lpPacket->OverLapped.OffsetHigh=0;
    if (!ResetEvent(lpPacket->OverLapped.hEvent))
    {
        return FALSE;
    }
    Result=ReadFile(AdapterObject->hFile,lpPacket->Buffer,lpPacket->Length, &lpPacket->ulBytesReceived,&lpPacket->OverLapped);
    if (Sync)
    {
        //  They want to wait
        Result=GetOverlappedResult(AdapterObject->hFile,&lpPacket->OverLapped, &lpPacket->ulBytesReceived,TRUE);
		lpPacket->bIoComplete = Result;
    }
    else
    {
        //  They don't want to wait, they will call PacketWaitPacket to get
        //  The real result
        Result=TRUE;
    }
    return Result;
}


//---------------------------------------------------------------------------

BOOLEAN PacketWaitPacket(LPADAPTER AdapterObject,LPPACKET lpPacket)
{
    lpPacket->bIoComplete = GetOverlappedResult(AdapterObject->hFile,&lpPacket->OverLapped,&lpPacket->ulBytesReceived,TRUE);
	return lpPacket->bIoComplete;
}

//---------------------------------------------------------------------------

BOOLEAN PacketResetAdapter(LPADAPTER  AdapterObject)

{
    UINT       BytesReturned;

    DeviceIoControl(AdapterObject->hFile,(DWORD)IOCTL_PROTOCOL_RESET,NULL,0,NULL,0,&BytesReturned,NULL);
    return TRUE;
}

//---------------------------------------------------------------------------

BOOLEAN PacketRequest(LPADAPTER  AdapterObject,BOOLEAN Set,PPACKET_OID_DATA  OidData)
{
    UINT       BytesReturned;
    BOOLEAN    Result;

    Result=DeviceIoControl(AdapterObject->hFile,(DWORD) Set ? IOCTL_PROTOCOL_SET_OID : IOCTL_PROTOCOL_QUERY_OID,
                           OidData,sizeof(PACKET_OID_DATA)-1+OidData->Length,OidData,
                           sizeof(PACKET_OID_DATA)-1+OidData->Length,&BytesReturned,NULL);
    return Result;
}

//---------------------------------------------------------------------------

BOOLEAN PacketSetFilter(LPADAPTER  AdapterObject,ULONG Filter)
{
    BOOLEAN    Status;
    ULONG      IoCtlBufferLength=(sizeof(PACKET_OID_DATA)+sizeof(ULONG)-1);
    PPACKET_OID_DATA  OidData;

    OidData=GlobalAllocPtr(GMEM_MOVEABLE | GMEM_ZEROINIT,IoCtlBufferLength);
    if (OidData == NULL) {
        return FALSE;
    }
    OidData->Oid=OID_GEN_CURRENT_PACKET_FILTER;
    OidData->Length=sizeof(ULONG);
    *((PULONG)OidData->Data)=Filter;
    Status=PacketRequest(AdapterObject,TRUE,OidData);
    GlobalFreePtr(OidData);
    return Status;
}

//---------------------------------------------------------------------------

BOOLEAN StartPacketDriver(LPTSTR ServiceName)
{
    BOOLEAN  Status;
    SC_HANDLE  SCManagerHandle;
    SC_HANDLE  SCServiceHandle;

    /* Open a handle to the SC Manager database. */
    SCManagerHandle = OpenSCManager(
                      NULL,                   /* local machine           */
                      NULL,                   /* ServicesActive database */
                      SC_MANAGER_ALL_ACCESS); /* full access rights      */
    if (SCManagerHandle==NULL)
    {
        MessageBox(NULL,TEXT("Could not open SC"),szWindowTitle,MB_OK);
        return FALSE;
    }
    else
    {
        SCServiceHandle=OpenService(SCManagerHandle,ServiceName,SERVICE_START);

        if (SCServiceHandle == NULL)
        {
            MessageBox(NULL,TEXT("Could not open service"),szWindowTitle,MB_OK);
        }
        Status=StartService(SCServiceHandle,0,NULL);
        if (!Status)
        {
            if (GetLastError()==ERROR_SERVICE_ALREADY_RUNNING) {
                ODS("Packet32: Packet service already started\n");
                return TRUE;
            }
        }
        return Status;
    }
    return FALSE;
}

//---------------------------------------------------------------------------

ULONG PacketGetAdapterNames(PTSTR   pStr,PULONG  BufferSize)
{
    HKEY       SystemKey;
    HKEY       ControlSetKey;
    HKEY       ServicesKey;
    HKEY       NdisPerfKey;
    HKEY       LinkageKey;
    LONG       Status;
    DWORD      RegType;

    Status=RegOpenKeyEx(HKEY_LOCAL_MACHINE,TEXT("SYSTEM"),0,KEY_READ,&SystemKey);
    if (Status == ERROR_SUCCESS)
    {
        Status=RegOpenKeyEx(SystemKey,TEXT("CurrentControlSet"),0,KEY_READ,&ControlSetKey);
        if (Status == ERROR_SUCCESS)
        {
            Status=RegOpenKeyEx(ControlSetKey,TEXT("Services"),0,KEY_READ,&ServicesKey);
            if (Status == ERROR_SUCCESS)
            {
                Status=RegOpenKeyEx(ServicesKey,TEXT("Packet"),0,KEY_READ,&NdisPerfKey);
                if (Status == ERROR_SUCCESS)
                {
                    Status=RegOpenKeyEx(NdisPerfKey,TEXT("Linkage"),0,KEY_READ,&LinkageKey);
                    if (Status == ERROR_SUCCESS)
                    {
                        Status=RegQueryValueEx(LinkageKey,TEXT("Export"),NULL,&RegType,(LPBYTE)pStr,BufferSize);
                        RegCloseKey(LinkageKey);
                    }
                    RegCloseKey(NdisPerfKey);
                }
                RegCloseKey(ServicesKey);
            }
            RegCloseKey(ControlSetKey);
        }
        RegCloseKey(SystemKey);
    }
    return Status;
}

//---------------------------------------------------------------------------

