//***********************************************************************
//
//  HexView.h
//
//***********************************************************************
#ifndef __HexView
#define __HexView

#include "resource.h"

class CHexView : public CScrollView
{
    DECLARE_DYNCREATE (CHexView)

private:
    CFont m_screenFont;
    CFont m_printerFont;

    UINT m_cyScreen;
    UINT m_cyPrinter;
    UINT m_cxOffset;
    UINT m_cxWidth;

    UINT m_nLinesTotal;
    UINT m_nLinesPerPage;

	LPADAPTER Adapter;
	UINT NPacket; // n di pacchetti da catturare
	char AdapterName1[64];
	char AdapterName2[64];


    CHexDoc* GetDocument () { return (CHexDoc*) m_pDocument; }
    int FormatLine (UINT, CString&);
    void PrintPageHeader (CDC*, UINT);
    void PrintPage (CDC*, UINT);

public:
    virtual void OnInitialUpdate ();
	void OnPacket();
	void OnSend();
    void OnCapture();
    void OnOpenAdapter1();
    void OnOpenAdapter2();
    void OnCloseAdapter();
    void OnDumpFile();
	void OnGetAdaptersName();
	void OnDirected();
	void OnMulticast();
	void OnBroadcast();
	void OnAllMulticast();
	void OnPromiscuous();

	void OnNumber();


protected:
    virtual void OnDraw (CDC*);
    virtual BOOL OnPreparePrinting (CPrintInfo*);
    virtual void OnBeginPrinting (CDC*, CPrintInfo*);
    virtual void OnPrint (CDC*, CPrintInfo*);
    virtual void OnEndPrinting (CDC*, CPrintInfo*);

    afx_msg int OnCreate (LPCREATESTRUCT);
    DECLARE_MESSAGE_MAP ()
};

//***********************************************************************

class CDialogNumber : public CDialog
{
private:
	CEdit& edit1 (); 

public:
	UINT num;

	CDialogNumber(CWnd* pParentWnd = NULL) :
	CDialog(IDD_DIALOG1, pParentWnd){}  

	virtual BOOL OnInitDialog(UINT);

protected:
	virtual void OnOK();

	DECLARE_MESSAGE_MAP ()
};

//***********************************************************************
#endif //__HexView
