/************************************************************
MODULO: Debug.h
	In questo include sono definite le macro per il debugging.
	Queste sono valide solo se  settata la variabile DEBUG 
	altrimenti no.
************************************************************/
#if DEBUG
#define IF_PACKETDEBUG(f) if ( PacketTraceImpt & (f) )
extern ULONG PacketTraceImpt;
#define PACKET_TRACE_IMPT				0x00000001  
#define PACKET_DEBUG_VERY_LOUD			0x00000002  
#define PACKET_DEBUG_INIT				0x00000100  
#define PACKET_DEBUG_BREAK				0x00000200

#define IF_BREAK_SET 		IF_PACKETDEBUG( PACKET_DEBUG_BREAK ) DbgBreakPoint();
#define IF_INIT_TRACE(A)	IF_PACKETDEBUG( PACKET_DEBUG_INIT ) { DbgPrint("Packet: %s\r\n", A); DbgBreakPoint(); }
#define IF_TRACE(A) 			IF_PACKETDEBUG( PACKET_TRACE_IMPT ) { DbgPrint("Packet: %s\r\n", A); IF_BREAK_SET }
#define IF_VERY_LOUD(A) 	IF_PACKETDEBUG( PACKET_DEBUG_VERY_LOUD ) { DbgPrint("Packet: %s\r\n", A); IF_BREAK_SET }
#define IF_TRACE_MSG(A,B)	IF_PACKETDEBUG( PACKET_TRACE_IMPT ) { DbgPrint("Packet: "); DbgPrint(A,B); DbgPrint("\r\n"); IF_BREAK_SET }
#define IF_TRACE_MSG2(A,B,C)	IF_PACKETDEBUG( PACKET_TRACE_IMPT ) { DbgPrint("Packet: "); DbgPrint(A,B,C); DbgPrint("\r\n"); IF_BREAK_SET }
#define IF_TRACE_MSG3(A,B,C,D)	IF_PACKETDEBUG( PACKET_TRACE_IMPT ) { DbgPrint("Packet: "); DbgPrint(A,B,C,D); DbgPrint("\r\n"); IF_BREAK_SET }
#define IF_TRACE_MSG4(A,B,C,D,E)	IF_PACKETDEBUG( PACKET_TRACE_IMPT ) { DbgPrint("Packet: "); DbgPrint(A,B,C,D,E); DbgPrint("\r\n"); IF_BREAK_SET }
#define INIT_ENTER(A)		IF_PACKETDEBUG( PACKET_DEBUG_INIT ) { DbgPrint("==> Packet: %s\r\n", A); DbgBreakPoint();}
#define INIT_LEAVE(A)		IF_PACKETDEBUG( PACKET_DEBUG_INIT ) { DbgPrint("<== Packet: %s\r\n", A); IF_BREAK_SET}
#define TRACE_ENTER(A)		IF_PACKETDEBUG( PACKET_TRACE_IMPT ) { DbgPrint("==> Packet: %s\r\n", A); IF_BREAK_SET}
#define TRACE_LEAVE(A)		IF_PACKETDEBUG( PACKET_TRACE_IMPT ) { DbgPrint("<== Packet: %s\r\n", A); IF_BREAK_SET}
#else
#define IF_PACKETDEBUG(f) 
#define IF_BREAK_SET
#define IF_INIT_TRACE(A)
#define IF_TRACE(A)
#define IF_VERY_LOUD(A)
#define IF_TRACE_MSG(A,B)
#define IF_TRACE_MSG2(A,B)
#define IF_TRACE_MSG3(A,B)
#define IF_TRACE_MSG4(A,B)
#define INIT_ENTER(A)
#define INIT_LEAVE(A)
#define TRACE_ENTER(A)
#define TRACE_LEAVE(A)
#endif
