#include <windows.h>
#include <stdio.h>
#include <conio.h>

// File presenti nella directory Inc del disco fornito

#include "..\Inc\ntddndis.h"
#include "..\Inc\ntddpack.h"
#include "..\Inc\packet32.h"


#define SIMULTANEOU_READS 10
#define MAX_ETHERNET_FRAME_SIZE 1514

#define Max_Num_Adapter 10

// Prototipi delle funzioni implementate

BOOLEAN QueryHardwareAddress( LPADAPTER  AdapterObject, PBYTE Addr);
BOOLEAN CheckForData( LPADAPTER lpAdapter, LPPACKET *lplpPacket );
BOOLEAN ReadPacket(	LPADAPTER	lpAdapter, LPPACKET   *lplpPacket, 	BOOLEAN		bSync );
void PrintPacket(LPPACKET lpPacket);
PPACKET_OID_DATA QueryOid (LPADAPTER lpAdapter, ULONG ulOid, ULONG ulLength);

		char        AdapterList[Max_Num_Adapter][10];

int main()
{

	// Definisco il puntatore alla struttura ADAPTER

	LPADAPTER  lpAdapter = 0;

	// Dichiaro un vettore di SIMULTANEOU_READS elementi
	// Ogni elemento  un puntatore ad una struttura PACKET

	LPPACKET   lpPacket[SIMULTANEOU_READS];

	int        i;
	DWORD      dwErrorCode;
	// Variabile che contiene la lista degli adattatori installati nel sistema

	char		AdapterName[30];
	char		*temp,*temp1;
	int			AdapterNum=0,Open;
	ULONG		AdapterLength;
	// Variabile che contiene il MAC ADDRESS dell'adattatore aperto
	
	BYTE       MacAddr[6];
	

	// Inizializzo a NULL i puntatori del Vettore

	memset(lpPacket,0,sizeof(LPPACKET)*SIMULTANEOU_READS);

	// Ottengo il nome degli Adattatori installati
	AdapterLength=30;
	PacketGetAdapterNames(AdapterName,&AdapterLength);
	
	printf("Adattatori installati nel sistema\n");
	
	i=0;	
	temp=AdapterName;
	temp1=AdapterName;
	while (*temp)
	{
		if (*temp==' ') 
		{
			strncpy(AdapterList[i],temp1,temp-temp1);
			temp1=temp+1;
			i++;
	}

	temp++;
	}
	  
	AdapterNum=i;
	for (i=0;i<AdapterNum;i++)
		printf("\n%d- %s\n",i+1,AdapterList[i]);
	printf("\n");
	//lpAdapter =   PacketOpenAdapter("PPPMAC");
	do 
	{
		printf("Indicare l'adattatore da aprire : ");scanf("%d",&Open);
		if (Open>AdapterNum) printf("\nDeve essere minore %d",AdapterNum); 
	} while (Open>AdapterNum);
	
	//lpAdapter =   PacketOpenAdapter("PPPMAC");

	lpAdapter =   PacketOpenAdapter(AdapterList[Open-1]);
	
	if (!lpAdapter || (lpAdapter->hFile == INVALID_HANDLE_VALUE))
	{
		dwErrorCode=GetLastError();
		printf("Unable to open VxD, Error Code : %lx\n",dwErrorCode); 

		// Termino il programma se si verifica un errore (p.e se il VxD non  installato)
		return(0);
	}	

	// Faccio una QUERY per ottenere il MAC ADDRESS dell'adattatore aperto 
	// Passo alla funzione il puntatore alla struttura Adapter e il puntatore ad
	// una stringa di 6 bytes

	if (QueryHardwareAddress(lpAdapter , MacAddr))
	{
		printf("\nMAC ADDRESS della scheda selezionata : ");
		for(i=0;i<6;i++) printf("%3X",MacAddr[i]); 
		printf("\n");
	}

	
 	
	
	// Imposto i filtri di cattura  in modalit promiscua
	// Vedi il file ntddndis.h

	
	PacketSetFilter(lpAdapter,NDIS_PACKET_TYPE_PROMISCUOUS);

	
	printf("\n\nPremi un tasto per Iniziare la cattura  . . . \n");
	getch();
	//  Inizializzo i buffer invocando la funzione  CheckForData e . . .
	//  (N.B. Vedi dopo per la sua descrizione)


	for (i=0;i<SIMULTANEOU_READS;i++) CheckForData(lpAdapter,&(lpPacket[i]));

	//   . . . comincio a catturare pacchetti !!

	// Il seguente ciclo non fa altro che testare la ricezione di 
	// un pacchetto con la CheckForData e quindi visualizzarne il 
	// contenuto sullo schermo.
	// Per la ricezione il vettore  gestito come un buffer circolare

	i=0;
	while (!kbhit())
	{
		if (CheckForData(lpAdapter,&(lpPacket[i])))
		{
          PrintPacket(lpPacket[i]);
		}
		i=(i+1) % SIMULTANEOU_READS;
	}
	 

	for (i=0;i<SIMULTANEOU_READS;i++) PacketFreePacket(lpPacket[i]);
	
	// Elimino le impostazioni dei filtri hardware

	PacketSetFilter(lpAdapter,0);

	// Termino chiudendo l'adattatore 

	PacketCloseAdapter(lpAdapter);
	return (0);
}

 
// Questa funzione chiama una routine esportata dalla DLL 
// che  la PacketRequest

BOOLEAN QueryHardwareAddress( LPADAPTER  AdapterObject, PBYTE MacAddr)
{
    BOOLEAN    Status;
    ULONG      IoCtlBufferLength=(sizeof(PACKET_OID_DATA)+6-1);
    PPACKET_OID_DATA  OidData;

	// Alloco una struttura di tipo PACKET_OID_DATA 

    OidData=(PPACKET_OID_DATA) malloc(IoCtlBufferLength);

    if (OidData == NULL) 
	{
        return FALSE;
    }

	// Imposto il campo Oid al valore OID_802_3_PERMANENT_ADDRESS 
 
    OidData->Oid=OID_802_3_PERMANENT_ADDRESS;
    OidData->Length=6;

	// Vedi il file ntddndis.h
    Status=PacketRequest(AdapterObject,FALSE,OidData);

	// Copio il risultato della Query nel Parametro della funzione
	memcpy (MacAddr, OidData->Data, 6);  

	// Rilascio la memoria 

    free(OidData);

    return Status;
}


BOOLEAN CheckForData( LPADAPTER lpAdapter, LPPACKET *lplpPacket )
{
	LPPACKET lpPacket = *lplpPacket;
	int i;
 	BOOLEAN bIoComplete;
	
  	
	if ( !lpPacket // Se la struttura Packet non  stata ancora MAI allocata allora (1) . . . 
		  
		 || lpPacket->bIoComplete ) // oppure  stata gi allocata (Ricorda si usa un buffer circolare) 
									// ma il campo BioComplete vale TRUE (NO PENDING READ) allora (2) . . .
									// Altrimenti (3) . . .
	{
		
		if ( !lpPacket )
		{
			//  (1) . . . creo lpPacket e leggo un  pacchetto  

			bIoComplete = ReadPacket( lpAdapter, lplpPacket, FALSE );

			lpPacket    = *lplpPacket;

			if ( bIoComplete ) // Segnala se l'operazione  stata completata in maniera sincrona . . .

				printf("%-20s: %s \n", "ReadPacket", "Ritornato in maniera sincrona !" );
		}
		else if ( lpPacket->bIoComplete )
		{
			//   . . . (2) faccio una nuova richiesta in maniera asincrona !
			

			bIoComplete = PacketReceivePacket( lpAdapter, 
											   lpPacket, 
											   FALSE );
		}


		// Segnalo eventuali errori successi . . . 

		if ( !bIoComplete && ( (i = GetLastError()) != ERROR_IO_PENDING ) )
		{
			printf( "%-20s: i != ERROR_IO_PENDING (%lx) \n", 
		 			"GetLastError", 
		 			i, 
		 			ERROR_IO_PENDING );

		 	// . . . e in tal caso rilascio la memoria
			
			if ( *lplpPacket )
				PacketFreePacket( *lplpPacket );

			*lplpPacket = 0;
		 
		 	return TRUE;
		}
	}
	else
	{
		
	//  . . . (3) Aspetto di completare la lettura PENDENTE testando  l'evento 
	// di ricezione del paccetto con la funzione GetOverlappedResult e . . .

		bIoComplete = GetOverlappedResult( lpAdapter->hFile,
					 						&lpPacket->OverLapped,
					 						&lpPacket->ulBytesReceived,
					 						TRUE );

	// . . . memorizzo il risultato nel campo bIoComplete della struttura Packet 	

		lpPacket->bIoComplete = bIoComplete;
	}
 
	return bIoComplete;
	 
} 


 
 
// Questa funzione alloca correttamente la struttura di tipo packet  . . .

BOOLEAN ReadPacket(	LPADAPTER	lpAdapter, 
					LPPACKET   *lplpPacket, 
					BOOLEAN		bSync )
{
	PBYTE Buffer;

	// . . . con la funzione PacketAllocatePacket. Pur essendo la struttura allocata in maniera corretta,
	// il campo Buffer non viene impostato; occorre infatti  . . . 

	*lplpPacket = PacketAllocatePacket();
	if ( *lplpPacket )
	{
		//  . . . allocare esternamente un buffer e . . .

		if ((Buffer=malloc(sizeof(BYTE)*MAX_ETHERNET_FRAME_SIZE)))
		{
			// . . . legarlo alla struttura PACKET con la PacketInitPacket!

			PacketInitPacket( *lplpPacket,Buffer,MAX_ETHERNET_FRAME_SIZE);

			// A questo punto provo a fare una lettura sincrona 

			return PacketReceivePacket( lpAdapter, *lplpPacket, bSync );
		}
		PacketFreePacket( *lplpPacket );
	}
	return FALSE;
}


// Questa funzione si occupa di stampare il contenuto di un pacchetto 

void PrintPacket(LPPACKET lpPacket)
{

	ULONG	i, j, ulLines, ulLen, ulBytesReceived;
	char	*pChar, *pLine;
	

		ulBytesReceived = lpPacket->ulBytesReceived;

		ulLines = (ulBytesReceived + 15) / 16;

		// Stampa solo 10 linee da 16 byte. Quindi modificare questa linea per 
		// far visualizzare i byte voluti

		if (ulLines > 5) ulLines=5;
		printf("Byte Ricevuti : %ld\n",ulBytesReceived);
 		pChar = lpPacket->Buffer;

		for ( i=0; i<ulLines; i++ )
		{
			pLine = pChar;

			printf( "%08lx : ", pChar );

			ulLen = ulBytesReceived;
			ulLen = ( ulLen > 16 ) ? 16 : ulLen;
			ulBytesReceived -= ulLen;

			for ( j=0; j<ulLen; j++ )
				printf( "%02x ", *(BYTE *)pChar++ );

			if ( ulLen < 16 )
				printf( "%*s", (16-ulLen)*3, " " );

			pChar = pLine;

			for ( j=0; j<ulLen; j++, pChar++ )
				printf( "%c", isprint( *pChar ) ? *pChar : '.' );

			printf( "\n" );
		} 

		printf( "\n" );
} 

 