
#define OTHER_MESSAGE9 "DNS Error!"


void SaveEndString(LPSTR endstring,LPSTR s,int count);
BOOL GetHostNameType(LPSTR);
UINT GetHostAddrByName(LPSTR);



/*************************************************************************
*																		 *	
*  FUNCTION: TcpOpen(char FAR *addr,unsigned short portnumber)           *
*						                         						 *
*																		 *
*  Description:	open a tcp socket                                        *
*                               										 *
*  Parameter:      														 *
*  		addr:the IP address in dot format                       		 *
*		portnumber: the tcp port number                                  *
*																         *
*  Return value: 														 *
*      if succeed return the open socket                        		 *
*      otherwise return 0xffff                                   		 *
*																         *
*																		 * 
*																		 * 
**************************************************************************/

SOCKET FAR PASCAL TcpOpen(char FAR *addr,unsigned short portnumber)
{

	SOCKADDR_IN addr_in;
	SOCKET sock;
	int status;
		
	sock=socket(AF_INET,SOCK_STREAM,0);
   	if(sock==INVALID_SOCKET) 
   	{
		return 0xffff;
	}

   	
   	/*fill address struct*/

   	addr_in.sin_family=AF_INET;
	
	if(GetHostNameType(addr))
   		addr_in.sin_addr.S_un.S_addr=inet_addr(addr);
	else
		addr_in.sin_addr.S_un.S_addr=GetHostAddrByName(addr);

   	addr_in.sin_port=ntohs(portnumber);
	      	
	if(addr_in.sin_addr.S_un.S_addr==0) return 0xffff;

	/*call non-blocking connect() function*/

    status=connect(sock,(struct sockaddr FAR *)&addr_in,sizeof(addr_in));

	if(status==0) return sock;
	else return 0xffff;

}
		
CPopService::CPopService()
{
	sock=0xffff;
	iMailLength=0;
}

CPopService::~CPopService()
{
//	if(sock!=0xffff)
//		Close();
}


BOOL CPopService::Open(LPSTR lpAddress)
{

	int status;
	char buffer[128];
	
	/*open the tcp socket in 110 prot*/
	this->sock=TcpOpen(lpAddress,POPPORT);
	
	/*if error*/
	if(this->sock==0xffff) 
		return FALSE;

	/*receive OK message*/
	status=recv(this->sock,buffer,128,0);

	/*if receive a error message or other error	*/
	if(status==0||status==SOCKET_ERROR||buffer[0]!='+')
	{
		closesocket(sock);
		return FALSE;
	}

	else 
		return TRUE;
}
			



void CPopService::Close()
{
	
	closesocket(this->sock);
	return;
	 
}



BOOL CPopService::IsGood()
{

	//ingore now!
	return TRUE;
}





BOOL CPopService::Quit()
{
	
	int status;
	char command[7]="QUIT\r\n";
	char buffer[128];

	if(!this->IsGood()) return FALSE;
	
	this->Clear();

	send(this->sock,command,6,0);
		
	status=recv(this->sock,buffer,128,0);

	if(status==SOCKET_ERROR||status==0||buffer[0]!='+')	return FALSE;
	else return TRUE;

}



BOOL CPopService::Authorize(LPSTR lpUser,LPSTR lpPass)
{

	char FAR buffer[128];
	int status;
	
	if(!this->IsGood()) return FALSE;
	this->Clear();

	
	strcpy(buffer,"USER ");
	strcat(buffer,lpUser);
	status=strlen(buffer);
	buffer[status]=0x0d;
	buffer[status+1]=0x0a;

	send(this->sock,buffer,status+2,0);
	
	status=recv(this->sock,buffer,128,0);

	if(status==SOCKET_ERROR||status==0||buffer[0]!='+')	return FALSE;
	

	strcpy(buffer,"PASS ");
	strcat(buffer,lpPass);
	status=strlen(buffer);
	buffer[status]=0x0d;
	buffer[status+1]=0x0a;

	send(this->sock,buffer,status+2,0);
	

	status=recv(this->sock,buffer,128,0);

	if(status==SOCKET_ERROR||status==0||buffer[0]!='+')	return FALSE;
	else return TRUE;

}


BOOL CPopService::Delete(int iIndex)
{

	char buffer[128];
	int status;

	if(!this->IsGood()) return FALSE;
	this->Clear();
	
	strcpy(buffer,"DELE ");
	itoa(iIndex,&buffer[5],10);
	status=strlen(buffer);
	buffer[status]=0x0d;
	buffer[status+1]=0x0a;


	send(this->sock,buffer,status+2,0);
								
  	status=recv(this->sock,buffer,128,0);

	if(status==SOCKET_ERROR||status==0||buffer[0]!='+')	return FALSE;
	else return TRUE;

}







int CPopService::GetCount()
{

	char buffer[128];
	int status;

	if(!this->IsGood()) return 0xffff;
	this->Clear();	

	strcpy(buffer,"STAT\r\n");
	send(this->sock,buffer,6,0);

	
	status=recv(this->sock,buffer,128,0);

	if(status==SOCKET_ERROR||status==0||buffer[0]!='+')	
		status=0xffff;
	else 
		status=atoi(&buffer[4]);

	return status;

}



int CPopService::GetSize(int iIndex)
{

	char buffer[128];
	int status;
	long size;
	int i;

	if(!this->IsGood()) return 0xffff;
	this->Clear();

	strcpy(buffer,"LIST ");
	itoa(iIndex,&buffer[5],10);
	status=strlen(buffer);
	buffer[status]=0x0d;
	buffer[status+1]=0x0a;

	send(this->sock,buffer,status+2,0);

	status=recv(this->sock,buffer,128,0);

	if(status==SOCKET_ERROR||status==0||buffer[0]!='+')	
		size=0xffff;
	else 
	{

		buffer[status-2]=0;
		status=0;

		for(i=0;i<128&&status<2;i++)
		{
			if(buffer[i]==' ') status++;
			if(buffer[i]==0x0d&&buffer[i+1]==0x0a) i=128;
		}
		
		if(i>=128) size=-1;
		else size=atol(&buffer[i]);
	}

	return size;

}
			

void CPopService::Clear()
{

	/*
	char FAR *buffer;

	if(!this->IsGood()) return; 

	buffer=GlobalAlloc(GMEM_FIXED,65535);
	if(buffer==NULL) return FALSE;      

	
	if(recv(p->Sock,buffer,65535,0)==65535)
	while(recv(p->Sock,buffer,65535)==65535);

	GlobalFree(buffer);
	return TRUE;*/

	return;

}


LPSTR CPopService::GetMail(int iIndex)
{

	int status;
	int mail_end=0;
	char buffer[SOCKETBUFFER];
	LPSTR mailbuffer;
	char end_string[5]="";
	CMemFile tmpfile;
	int progress=0;


	if(!this->IsGood()) return NULL;
	this->Clear();

	strcpy(buffer,"RETR ");
	itoa(iIndex,&buffer[5],10);
	strcat(buffer,"\r\n");

	send(this->sock,buffer,strlen(buffer),0);

 	status=recv(this->sock,buffer,5,0);

	if(status==SOCKET_ERROR||status==0||buffer[0]!='+')
	{
		return NULL;
	}

	while(!mail_end)
	{
		
		status=recv(this->sock,buffer,SOCKETBUFFER,0);

		if(status==SOCKET_ERROR||status==0) break;
			
		SaveEndString(end_string,buffer,status);
		if(memcmp(end_string,"\r\n.\r\n",5)==0) mail_end=1;

		if(mail_end&&status>=3) status-=3;
		tmpfile.Write(buffer,status);
		
		progress+=status;
		//ShowProgress(progress);

	}

	mailbuffer=(LPSTR)GlobalAlloc(GMEM_FIXED,tmpfile.GetLength());
	if(mailbuffer==NULL) return NULL;

	tmpfile.SeekToBegin();
	tmpfile.Read(mailbuffer,tmpfile.GetLength());

	iMailLength=tmpfile.GetLength();
		
	return mailbuffer;

}







void SaveEndString(LPSTR endstring,LPSTR s,int count)
{

	int i;
	char buffer[5];
	
	if(count>=5)
	{
		memcpy(endstring,&s[count-5],5);
	}
	else
	{

		for(i=0;i<5;i++)
		if(endstring[i]==0) break;
	
		if(i+count<=5) 
		{
			memcpy(&endstring[i],s,count);
			if(i+count<5) endstring[i+count]=0;
		}
		else
		{
			memcpy(buffer,&endstring[i+count-5],5-count);
			memcpy(endstring,buffer,5-count);
			memcpy(&endstring[5-count],s,count);
		}
			
	}

	return;
}



LPSTR CPopService::GetHeader(int iIndex,int iLine)
{

	int status;
	int point=0;
	int QuitFlag=0;
	int mail_end=0;
	char buffer[SOCKETBUFFER];
	LPSTR mailbuffer;
	char end_string[5]="";
	CMemFile tmpfile;


	if(!this->IsGood()) return NULL;
	this->Clear();
				  
	strcpy(buffer,"TOP ");
	itoa(iIndex,&buffer[5],10);
	itoa(iLine,&buffer[strlen(buffer)],10);
	strcat(buffer,"\r\n");

	send(this->sock,buffer,strlen(buffer),0);

   	status=recv(this->sock,buffer,5,0);

	if(status==SOCKET_ERROR||status==0||buffer[0]!='+')
	{
		return NULL;
	}

	while(!mail_end)
	{
		
		status=recv(this->sock,buffer,SOCKETBUFFER,0);

		if(status==SOCKET_ERROR||status==0) break;
			
		SaveEndString(end_string,buffer,status);
		if(memcmp(end_string,"\r\n.\r\n",5)==0) mail_end=1;

		if(mail_end&&status>=3) status-=3;
		tmpfile.Write(buffer,status);

	}

	mailbuffer=(LPSTR)GlobalAlloc(GMEM_FIXED,tmpfile.GetLength());
	if(mailbuffer==NULL) return NULL;

	tmpfile.Read(mailbuffer,tmpfile.GetLength());
		
	return mailbuffer;

}


BOOL CPopService::Reset()
{
	
	int status;
	char command[7]="RSET\r\n";
	char buffer[128];

	if(!this->IsGood()) return FALSE;
	this->Clear();

	send(this->sock,command,6,0);
					  	
	status=recv(this->sock,buffer,128,0);

	if(status==SOCKET_ERROR||status==0||buffer[0]!='+')	return FALSE;
	else return TRUE;

}










CSmtpService::CSmtpService()
{
	sock=0xffff;
}

CSmtpService::~CSmtpService()
{
//	if(sock!=0xffff) Close();
}



BOOL CSmtpService::Open(LPSTR lpAddress)
{

	int status;
	char buffer[128];
	
	
	/*open the tcp socket in 25 prot*/
	this->sock=TcpOpen(lpAddress,SMTPPORT);

	
	/*if error*/
	if(this->sock==0xffff) 
	{
		return FALSE;
	}


	/*receive OK message*/
	status=recv(this->sock,buffer,128-1,0);

	/*if receive a error message or other error	*/
	
	buffer[3]=0;

	if(status==SOCKET_ERROR||status==0||strcmp(buffer,OPEN_OK)!=0)
	{
		closesocket(this->sock);
		return FALSE;
	}

	else 
		return TRUE;
}
			


BOOL CSmtpService::Hello(LPSTR HostName)
{

	char buffer[128];
	int status;
	
	if(!this->IsGood()) return FALSE;
	this->Clear();

	
	
	strcpy(buffer,"HELO ");
	strcat(buffer,HostName);
	status=strlen(buffer);
	buffer[status]=0x0d;
	buffer[status+1]=0x0a;


	send(this->sock,buffer,status+2,0);
	

	status=recv(this->sock,buffer,128-1,0);

	buffer[3]=0;

	if(status==SOCKET_ERROR||status==0||strcmp(buffer,OK)!=0)    return FALSE;
	else return TRUE;

}


BOOL CSmtpService::IsGood()
{
	return TRUE;

}



void CSmtpService::Clear()
{

	return;

}



 
BOOL CSmtpService::From(LPSTR lpFrom)
{

	char buffer[128];
	int status;
	
	if(!this->IsGood()) return FALSE;
	this->Clear();

	
	
	strcpy(buffer,"MAIL FROM:<");
	strcat(buffer,lpFrom);
	strcat(buffer,">");
	status=strlen(buffer);
	buffer[status]=0x0d;
	buffer[status+1]=0x0a;


	send(this->sock,buffer,status+2,0);
	

	status=recv(this->sock,buffer,128,0);

	buffer[3]=0;

	if(status==SOCKET_ERROR||status==0||strcmp(buffer,OK)!=0)    return FALSE;
	else return TRUE;

}



BOOL CSmtpService::Rcpt(LPSTR lpRcpt)
{

	char buffer[128];
	int status;
	
	if(!this->IsGood()) return FALSE;
	this->Clear();

	
	
	strcpy(buffer,"RCPT TO:<");
	strcat(buffer,lpRcpt);
	strcat(buffer,">");
	status=strlen(buffer);
	buffer[status]=0x0d;
	buffer[status+1]=0x0a;


	send(this->sock,buffer,status+2,0);
	

	status=recv(this->sock,buffer,128,0);

	buffer[3]=0;

	if(status==SOCKET_ERROR||status==0||(strcmp(buffer,OK)!=0&&strcmp(buffer,RCPT_OK)!=0))    return FALSE;
	else return TRUE;

}


BOOL CSmtpService::Data(LPSTR lpBuffer,int iLen)
{

	char buffer[128];
	int status;
	LPSTR point=lpBuffer;
	
	if(!this->IsGood()) return FALSE;
	this->Clear();

	
	
	strcpy(buffer,"DATA");
	status=strlen(buffer);
	buffer[status]=0x0d;
	buffer[status+1]=0x0a;


	send(this->sock,buffer,status+2,0);
	

	status=recv(this->sock,buffer,128,0);

	buffer[3]=0;

	if(status==SOCKET_ERROR||status==0||strcmp(buffer,START_DATA_INPUT)!=0) 
		return FALSE;

	while(point-lpBuffer<iLen)
	{
		if(iLen-(point-lpBuffer)>=SOCKETBUFFER)
			send(this->sock,point,SOCKETBUFFER,0);
		else
			send(this->sock,point,iLen-(point-lpBuffer),0);
		point+=SOCKETBUFFER;
	}

	strcpy(buffer,"\r\n.\r\n");
	send(this->sock,buffer,5,0);

	status=recv(this->sock,buffer,128,0);

	buffer[3]=0;

	if(status==SOCKET_ERROR||status==0||strcmp(buffer,OK)!=0) 
		return FALSE;
	else return TRUE;

}




void CSmtpService::Close()
{
	int status;
	char command[7]="QUIT\r\n";
	char buffer[128];

	if(!this->IsGood()) 
	{
		send(this->sock,command,6,0);
		status=recv(this->sock,buffer,128,0);
	}
   
    closesocket(this->sock);
	
	return ;

}
  


BOOL GetHostNameType(LPSTR addr)
{
	int i=0;

	while(addr[i]!=0)	
	{
		if((addr[i]>='0'&&addr[i]<='9')||addr[i]=='.'||addr[i]==' ')
			i++;
		else return FALSE;
	}

	return TRUE;
}

UINT GetHostAddrByName(LPSTR addr)
{
	PHOSTENT phe;
	UINT IpAddr;

    phe = gethostbyname(addr);
  
  	if (phe == NULL) 
  	{
    	AfxGetApp()->m_pMainWnd->MessageBox(OTHER_MESSAGE9);
     	return 0;
    }
   

  	memcpy((char FAR *)&IpAddr,phe->h_addr,
    	  phe->h_length);

	return IpAddr;
}
