/*investigate hailstone numbers:
	if n == odd then multiply it by 3 and add 1
	if n == even  divide it by 2
	call this function until it return 1.
	if n is negative <0 then the result is also negative.
	if the result is bigger than int or n=0, it return 0 (failure).
	n=77671 is the first number that return 0.
	if you want to investigate all big numbers,I recommend you to use the
	c/c++ miracl library:
	ftp://ftp.compapp.dcu.ie/pub/crypto/miracl.zip

	ex.:
	
	n=25267;
	while(n!=1){
		n=am_hailstone(n);
			if(n==0){
				printf("n is to big\n");
				exit();
			}
		printf("%d\n",n);
	}
	
*/


#include "defs.h"


int am_hailstone(int n){

	if(n>0){
		if(n==1)
			return 1;
		if(n>715827882)
			return 0;
     	if (n&1)
			return n*3+1;
		return n/2;	
	}
	else if(n<0){
		n=-n;
		if(n==1)
			return 1;
	 	if(n>715827882)
			return 0;
     	if (n&1)
			return -(n*3+1);
		return -(n/2);	
	}
	else
		return 0;
}