/* Algomath header file */
/* release 1.0.5 // 3.2000 */
/* see Readme.txt for details */

#ifndef ALGOMATH_H 
#define ALGOMATH_H

/* this include the the assembler function int am_isPrime(unsigned int)*/
#define USE_ISPRIME_ASM 

int am_init();
void am_exit();

int am_numlength(int n);
int am_sumdigits(int n);
int am_sumdigitsalt(int n);
int am_extract(int n, int x);
int am_replace(int n, int d1, int d2);
int am_swap(int n, int d1, int d2);
int am_rotate(int n, int x, int p);
int am_sort(int n);


int am_sumdivisors(int n);
int am_gcd(int a,int b);
int am_hailstone(int n);

int am_isprime(int n);
int am_prime_ba(int n, int x);
int am_goldbach(int n, int *d1, int *d2);
int *am_primes_array (int n, int x);
int *am_primes_between (int n1, int n2, int *p);
int *am_factorize(int n, int *factors);

#ifdef USE_ISPRIME_ASM
extern int am_isPrime(unsigned int n);
#endif

#endif