unit Scan_Unit;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls, yupack, main_unit, StdCtrls, Klabel, ComCtrls, WSocket, Wait,
  Wordcap;

type
  TScan_Form = class(TForm)
    YusoftWallpaper1: TYusoftWallpaper;
    Image1: TImage;
    Image2: TImage;
    Image3: TImage;
    Image4: TImage;
    ip1_UpDown: TUpDown;
    ip2_UpDown: TUpDown;
    ip3_UpDown: TUpDown;
    ip1_Edit: TEdit;
    ip2_Edit: TEdit;
    ip3_Edit: TEdit;
    KLabel1: TKLabel;
    KLabel2: TKLabel;
    Ip_begin_KLabel: TKLabel;
    Ip_end_KLabel: TKLabel;
    ip_begin_Edit: TEdit;
    ip_end_Edit: TEdit;
    UpDown4: TUpDown;
    UpDown5: TUpDown;
    KLabel5: TKLabel;
    wait_Edit: TEdit;
    UpDown7: TUpDown;
    Start_Button: TYusoftGradientButton;
    Bevel1: TBevel;
    scanfor_Label: TKLabel;
    Wait1: TWait;
    WSocket1: TWSocket;
    Close_Button: TYusoftGradientButton;
    MSOfficeCaption1: TMSOfficeCaption;
    Timer1: TTimer;
    Abort_Scan_Button: TYusoftGradientButton;
    ip4_Edit: TEdit;
    ip4_UpDown: TUpDown;
    IP_ComboBox: TComboBox;
    KLabel6: TKLabel;
    procedure Start_ButtonClick(Sender: TObject);
    procedure Wait1Timeout(Sender: TObject);
    procedure Close_ButtonClick(Sender: TObject);
    procedure FormActivate(Sender: TObject);
    procedure Abort_Scan_ButtonClick(Sender: TObject);
    procedure Timer1Timer(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure IP_ComboBoxChange(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
  private
    procedure restore_ip_edit;
    { Private-Deklarationen }
  public
    { Public-Deklarationen }
  end;

var
  Scan_Form: TScan_Form;

implementation

{$R *.DFM}

var
	stop_flag : boolean;
  timer_ok : boolean;

procedure TScan_Form.Start_ButtonClick(Sender: TObject);
var
	connect_flag : boolean;
  x, ip_start, ip_end : integer;
  //ip_addr_str : string;
  a : integer;
begin
	Start_Button.Enabled := false;
  Start_Button.ShadowColor := cl3DDkShadow;
  Close_Button.Enabled := false;
  Close_Button.ShadowColor := cl3DDkShadow;
  Abort_Scan_Button.Enabled := true;
  Abort_Scan_Button.ShadowColor := clTeal;

	connect_flag := false;
  ip_start := StrToInt( ip_begin_edit.text);
  ip_end := StrToInt( ip_end_edit.text);

  // ********


  //ip_addr_str := ip1_Edit.text + '.' + ip2_Edit.Text + '.' + ip3_edit.text + '.';


  { Wartezeit setzen ... }
  Wait1.Interval := StrToInt( wait_edit.Text) - Timer1.Interval;
  if Wait1.Interval = 0 then Wait1.Interval := 1;

  { Schon connected ?  wenn ja Exit ...}
  if WSocket1.State = wsConnected then Exit;

  { Scanning - Schleife }
  stop_flag := false;
  for x := ip_start to ip_end do
  begin
    timer_ok := false;
    timer1.Enabled := true;
    repeat
      a := 0;
      application.ProcessMessages;
    until timer_ok;
  	if stop_flag then
    begin
    	Start_Button.Enabled := true;
  		Start_Button.ShadowColor := clTeal;
  		Close_Button.Enabled := true;
  		Close_Button.ShadowColor := clTeal;
      Abort_Scan_Button.Enabled := false;
		  Abort_Scan_Button.ShadowColor := cl3DDkShadow;

      main_form.memo1.Lines.Add( 'Abort scanning ...');
    	Scanfor_Label.Caption := 'Abort scanning !';
      exit;
    end;

  	WSocket1.Port := main_form.var_TCP_SCAN_PORT;
    WSocket1.Proto := main_form.var_TCP_PROTO;

    // ************
    case ip_combobox.ItemIndex of
    	0:
      	WSocket1.Addr := IntToStr( x) + '.' + ip2_Edit.text + '.' + ip3_Edit.Text +
         	'.' + ip4_edit.text;
      1:
      	WSocket1.Addr := ip1_Edit.text + '.' + IntToStr( x) + '.' + ip3_Edit.text +
         '.' + ip4_Edit.Text;
      2:
      	WSocket1.Addr := ip1_Edit.text + '.' + ip2_Edit.Text + '.' +
        	IntToStr( x) + '.' + ip4_edit.text;
      3:
      	WSocket1.Addr := ip1_Edit.text + '.' + ip2_Edit.Text + '.' +
        	ip3_edit.text + '.' + IntToStr( x);
    end;

    //WSocket1.Addr := ip_addr_str + IntToStr( x);

    Scanfor_Label.Caption := 'Scanning for : ' + WSocket1.Addr;
    main_form.memo1.Lines.add( 'Scanning for : ' + WSocket1.addr);

    WSocket1.Connect;
    if WSocket1.Wait( 1, wsConnected) then
    begin
    	connect_flag := true;
      Application.ProcessMessages;
      WSocket1.Close;
      break;
    end;
    Application.ProcessMessages;
    WSocket1.Close;
    Application.ProcessMessages;

  end;  //for x := ip_start to ip_end do
  { Scanning - Schleife ENDE }
  if connect_flag then
  begin
  	main_form.IP_Edit.Text := WSocket1.Addr;
    main_form.memo1.Lines.Add( '');
    main_form.memo1.Lines.Add( '***********************************');
    main_form.Memo1.Lines.Add( 'Found valid IP : ' + WSocket1.Addr);
    Scanfor_Label.Caption := 'Valid IP : ' + WSocket1.Addr;
    //showmessage( 'Found valid IP : ' + WSocket1.Addr);
  end
  else
  begin
    main_form.memo1.Lines.Add( 'No valid IP found ...');
    Scanfor_Label.Caption := 'No valid IP found !';
  	//showmessage( 'NO valid IP found !');
  end;

  Start_Button.Enabled := true;
  Start_Button.ShadowColor := clTeal;
  Close_Button.Enabled := true;
  Close_Button.ShadowColor := clTeal;
  Abort_Scan_Button.Enabled := false;
	Abort_Scan_Button.ShadowColor := cl3DDkShadow;
end;

procedure TScan_Form.Wait1Timeout(Sender: TObject);
begin
  {
	if sabotage_flag then
  begin
    WSocket1.Close;
    application.processmessages;
  end;
  }
end;

procedure TScan_Form.Close_ButtonClick(Sender: TObject);
begin
	close;
end;

procedure TScan_Form.FormActivate(Sender: TObject);
begin
	MSOfficeCaption1.CaptionText.Caption := 'Client - ' + main_form.var_CLIENT_VERSION;
  MSOfficeCaption1.CompanyText.Caption := main_form.var_COMPANY_TEXT;
  ip_combobox.ItemIndex := 3;
  ip4_edit.Enabled := false;
  ip4_updown.Enabled := false;
end;

procedure TScan_Form.Abort_Scan_ButtonClick(Sender: TObject);
begin
	stop_flag := true;
end;

procedure TScan_Form.Timer1Timer(Sender: TObject);
begin
	timer1.Enabled := false;
  timer_ok := true;
end;

procedure TScan_Form.FormCreate(Sender: TObject);
begin
	Scan_Form.HelpFile := main_form.program_dir + '\' + HELP_FILE;
	Scan_Form.HelpContext := 104;
end;

procedure TScan_Form.IP_ComboBoxChange(Sender: TObject);
begin
	case ip_combobox.ItemIndex of
  	0 :
    	begin
        restore_ip_edit;

        ip1_edit.Enabled := false;
        ip1_edit.Text := 'xxx';
      	ip1_updown.Enabled := false;

        ip_begin_klabel.Caption := '1. IP begin:';
        ip_end_klabel.Caption := '1. IP end:';
      end;
    1 :
    	begin
        restore_ip_edit;

        ip2_edit.Enabled := false;
        ip2_edit.Text := 'xxx';
        ip2_updown.Enabled := false;

        ip_begin_klabel.Caption := '2. IP begin:';
        ip_end_klabel.Caption := '2. IP end:';
      end;
    2 :
    	begin
        restore_ip_edit;

      	ip3_edit.Enabled := false;
        ip3_edit.Text := 'xxx';
        ip3_updown.Enabled := false;

        ip_begin_klabel.Caption := '3. IP begin:';
        ip_end_klabel.Caption := '3. IP end:';
      end;
    3 :
    	begin
        restore_ip_edit;

        ip4_edit.Enabled := false;
        ip4_edit.Text := 'xxx';
        ip4_updown.Enabled := false;

        ip_begin_klabel.Caption := '4. IP begin:';
        ip_end_klabel.Caption := '4. IP end:';
      end;
  end;
end;

procedure TScan_Form.restore_ip_edit;
begin
  ip1_edit.Enabled := true;
  ip1_edit.Text := '100';
  ip1_updown.Enabled := true;
  ip1_updown.Position := 100;

	ip2_edit.Enabled := true;
  ip2_edit.Text := '100';
  ip2_updown.Enabled := true;
  ip2_updown.Position := 100;

	ip3_edit.Enabled := true;
  ip3_edit.Text := '100';
  ip3_updown.Enabled := true;
  ip3_updown.Position := 100;

  ip4_edit.Enabled := true;
  ip4_edit.Text := '100';
  ip4_updown.Enabled := true;
  ip4_updown.Position := 100;
end;


procedure TScan_Form.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  restore_ip_edit;
end;

end.
