{ SkFDater 1.0

  you can set the file date by either calling SkFdater1.Execute; or
  SkFdater1.SetFileDate;
}

unit SkFdater;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ComCtrls;

type


  TSkFdater = class(TComponent)
  private

    FTheDay : LongInt;
    FTheMonth : LongInt;
    FTheYear : LongInt;
    FTheHour : LongInt;
    FTheMinute : LongInt;
    FTheSeconds : LongInt;
    FFileName : String;
    FFileDate : TFileTime;
    FBogusDate : TDateTime;
    FTempFileDate : TDateTime;
  public
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
    Function SetFileDate : Boolean;
    Procedure Execute;
  published

    property Date_Day : LongInt read FTheDay write FTheDay Stored True;
    property Date_Month : LongInt read FTheMonth write FTheMonth Stored True;
    property Date_Year : LongInt read FTheYear write FTheYear Stored True;
    property Time_Hour : LongInt read FTheHour write FTheHour Stored True;
    property Time_Minute : LongInt read FTheMinute write FTheMinute Stored True;
    property Time_Seconds : LongInt read FTheSeconds write FTheSeconds Stored True;
    property FileName : String read FFileName write FFileName Stored True;
    property FileDate : TDateTime read FTempFileDate write FBogusDate;
  end;


procedure Register;

implementation


Procedure TSkFdater.Execute;
Begin
 If Not SetFileDate Then
  ShowMessage('There was an error in setting the file date' + #13 + 'Check to be sure that ' + FFileName + ' exists and that the date format is correct');
End;

Function TSkFdater.SetFileDate : Boolean;
 Var
  FHan : Integer;
  FStruct : TOFSTRUCT;
  NewDate, NewTime : TDateTime;
  IsSet : Boolean;
  intFullTime : LongInt;
  LocalFileTime: TFileTime;
Begin
 IsSet := False;
 If Not FileExists(FFileName) Then
  ShowMessage(FFileName + ' does not exist')
 Else
 Begin
    NewDate := EncodeDate(FTheYear, FTheMonth, FTheDay);
    NewTime := NewDate + EncodeTime(FTheHour, FTheMinute, FTheSeconds, 0);
    intFullTime := DateTimeToFileDate(NewTime);
    DosDateTimeToFileTime(LongRec(intFullTime).Hi, LongRec(intFullTime).Lo, LocalFileTime);
    LocalFileTimeToFileTime(LocalFileTime, FFileDate);
    FHan := OpenFile(PChar(FFileName), FStruct, OF_READWRITE);
    IsSet := SetFileTime(FHan, @FFileDate, @FFileDate, @FFileDate);
    FTempFileDate := FileDateToDateTime(FileGetDate(FHan));
   _lclose(FHan);
  End;
   Result := IsSet;
End;

constructor TSkFdater.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  
end;

destructor TSkFdater.Destroy;
begin
  inherited Destroy;
end;


procedure Register;
begin
  RegisterComponents('SK', [TSkFdater]);
  
end;

end.
