{* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *

Author:       Franois PIETTE
Description:  Demonstration for Server program using TWSocket.
              Presented at the conference held octber 17 at Technotheque
              in Liege. Works only with Delphi 2 or 3 because of
              string use. Should be easy to adapt with old string style.
EMail:        francois.piette@ping.be  http://www.rtfm.be/fpiette
              francois.piette@f2202.n293.z2.fidonet.org
              2:293/2202@fidonet.org, BBS +32-4-3651395
Creation:     17 october 1997
Version:      1.00
WebSite:      http://www.rtfm.be/fpiette/indexuk.htm
Support:      Use the mailing list twsocket@rtfm.be See website for details.
Legal issues: Copyright (C) 1997 by Franois PIETTE <francois.piette@ping.be>

              This software is provided 'as-is', without any express or
              implied warranty.  In no event will the author be held liable
              for any  damages arising from the use of this software.

              Permission is granted to anyone to use this software for any
              purpose, including commercial applications, and to alter it
              and redistribute it freely, subject to the following
              restrictions:

              1. The origin of this software must not be misrepresented,
                 you must not claim that you wrote the original software.
                 If you use this software in a product, an acknowledgment
                 in the product documentation would be appreciated but is
                 not required.

              2. Altered source versions must be plainly marked as such, and
                 must not be misrepresented as being the original software.

              3. This notice may not be removed or altered from any source
                 distribution.

Updates:


 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *}
unit Srv1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, WSocket, WinSock, Srv2, Db, DBTables;

type
  TSrvForm = class(TForm)
    SrvSocket: TWSocket;
    ClientListBox: TListBox;
    DataTable: TTable;
    procedure FormShow(Sender: TObject);
    procedure SrvSocketSessionAvailable(Sender: TObject; Error: Word);
  private
    { Dclarations prives }
    Initialized : Boolean;
    procedure   WMUser(var msg: TMessage); message WM_USER;
  public
    { Dclarations publiques }
  end;

var
  SrvForm: TSrvForm;

implementation

{$R *.DFM}

procedure TSrvForm.FormShow(Sender: TObject);
begin
    if not Initialized then begin
        Initialized     := TRUE;
        DataTable.Open;
        SrvSocket.Addr  := '0.0.0.0';
        SrvSocket.Port  := 'telnet';
        SrvSocket.Proto := 'tcp';
        SrvSocket.Listen;
    end;
end;

procedure TSrvForm.SrvSocketSessionAvailable(Sender: TObject; Error: Word);
var
    Form    : TCliForm;
begin
    Form := TCliForm.Create(self);
    ClientListBox.Items.Add(IntToStr(integer(Form)));
    Form.CliSocket.HSocket := SrvSocket.Accept;
    Form.DataTable         := DataTable;
    Form.Show;
end;

procedure TSrvForm.WMUser(var msg: TMessage);
var
    Form : TCliForm;
    I    : Integer;
begin
    Form := TCliForm(Msg.lParam);
    Form.Release;
    for I := 0 to ClientListBox.Items.Count - 1 do begin
        if ClientListBox.Items[I] = IntToStr(Integer(Form)) then begin
            ClientListBox.Items.Delete(I);
            break;
        end;
    end;
end;


end.

