unit sysinfo;

interface

uses
   SysUtils, WinTypes, WinProcs, Classes, BBRegis;

type
   TSysInfo = class(TComponent)
   private
      FOrganisation : string;
      FOwner : string;
      FCPU : string;
      FOperatingSystem : string;
      FWinVersion : string;
      FBuild : string;
      FTotalMemory : string;
      FDriveC : string;
      procedure SetOrganisation(Value : string);
      procedure SetOwner(Value : string);
      procedure SetCPU(Value : string);
      procedure SetOperatingSystem(Value : string);
      procedure SetWinVersion(Value : string);
      procedure SetBuild(Value : string);
      procedure SetTotalMemory(Value : string);
      procedure SetDriveC(Value : string);
   protected
   public
      constructor Create(AOwner:TComponent);override;
      destructor Destroy;override;
   published
      Property Organisation : string read FOrganisation write SetOrganisation;
      Property Owner : string read FOwner write SetOwner;
      Property CPU : string read FCPU write SetCPU;
      Property OperatingSystem : string read FOperatingSystem write SetOperatingSystem;
      Property WinVersion : string read FWinVersion write SetWinVersion;
      Property Build : string read FBuild write SetBuild;
      Property TotalMemory : string read FTotalMemory write SetTotalMemory;
      Property DriveC : string read FDriveC write SetDriveC;
      Property Name;
      Property Tag;
end;

procedure Register;

implementation

procedure Register;
begin
   RegisterComponents('Samples',[TSysInfo]);
end;

constructor TSysInfo.Create(AOwner:TComponent);
var
   RegIni : TBBRegIniFile;
   SI : TSystemInfo;
   OS : TOSVersionInfo;
   MemStat : TMemoryStatus;
begin
   inherited Create(AOwner);

   RegIni := TBBRegIniFile.Create('\SOFTWARE\Microsoft\Windows', HKEY_LOCAL_MACHINE);
   FOrganisation := RegIni.ReadString('CurrentVersion', 'RegisteredOrganization', 'Failure');
   FOwner := RegIni.ReadString('CurrentVersion', 'RegisteredOwner', 'Failure');
   RegIni.Free;

   GetSystemInfo(SI);
   case Si.dwProcessorType of
      386 : FCPU := 'Intel 386';
      486 : FCPU := 'Intel 486';
      586 : FCPU := 'Intel Pentium';
   end;

   OS.dwOSVersionInfoSize := sizeof(TOSVERSIONINFO);
   GetVersionEx(OS);
   case OS.dwPlatformId of
      VER_PLATFORM_WIN32s        : FOperatingSystem := 'Windows 3.1';
      VER_PLATFORM_WIN32_WINDOWS : FOperatingSystem := 'Windows 95';
      VER_PLATFORM_WIN32_NT	 : FOperatingSystem := 'Windows NT';
   end;

   FWinVersion := format ('%d.%d', [OS.dwMajorVersion,OS.dwMinorVersion]);
   FBuild := format('%d', [LOWORD(OS.dwBuildNumber)]);

   MemStat.dwLength := sizeof(TMemoryStatus);
   GlobalMemoryStatus(MemStat);
   FTotalMemory := format('%d KB',[Trunc(MemStat.dwTotalPhys/1024)]);

   if DiskSize(3) <> -1 then
      FDriveC := format('%d MB', [Trunc(DiskSize(3)/1024/1024)])
   else
      FDriveC := '';
end;

destructor TSysInfo.Destroy;
begin
   inherited Destroy;
end;

procedure TSysInfo.SetOrganisation(Value : string);
begin
   FOrganisation := FOrganisation;
end;

procedure TSysInfo.SetOwner(Value : string);
begin
   FOwner := FOwner;
end;

procedure TSysInfo.SetCPU(Value : string);
begin
   FCPU := FCPU;
end;

procedure TSysInfo.SetOperatingSystem(Value : string);
begin
   FOperatingSystem := FOperatingSystem;
end;

procedure TSysInfo.SetWinVersion(Value : string);
begin
   FWinVersion := FWinVersion;
end;

procedure TSysInfo.SetBuild(Value : string);
begin
   FBuild := FBuild;
end;

procedure TSysInfo.SetTotalMemory(Value : string);
begin
   FTotalMemory := FTotalmemory;
end;

procedure TSysInfo.SetDriveC(Value : string);
begin
   FDriveC := FDriveC;
end;

end.
