{* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *

Author:       Franois PIETTE
Creation:     November 23, 1997
Version:      1.02
Description:  Sample program to demonstrate some of the THttpCli features.
EMail:        francois.piette@pophost.eunet.be    francois.piette@ping.be
              francois.piette@rtfm.be             http://www.rtfm.be/fpiette
Support:      Use the mailing list twsocket@rtfm.be See website for details.
Legal issues: Copyright (C) 1997, 1998 by Franois PIETTE
              Rue de Grady 24, 4053 Embourg, Belgium. Fax: +32-4-365.74.56
              <francois.piette@pophost.eunet.be>

              This software is provided 'as-is', without any express or
  	          implied warranty.  In no event will the author be held liable
              for any  damages arising from the use of this software.

              Permission is granted to anyone to use this software for any
              purpose, including commercial applications, and to alter it
              and redistribute it freely, subject to the following
              restrictions:

              1. The origin of this software must not be misrepresented,
                 you must not claim that you wrote the original software.
                 If you use this software in a product, an acknowledgment
                 in the product documentation would be appreciated but is
                 not required.

              2. Altered source versions must be plainly marked as such, and
                 must not be misrepresented as being the original software.

              3. This notice may not be removed or altered from any source
                 distribution.

Updates:
Jan 16, 1998  V1.00 Adapted for reviced HTTP component.
Apr 13, 1998  V1.01 Call HttpCli1DocEnd when to request failed, to close the
              document file in the case it is already opened.
Jul 09, 1998  V1.02 Adapted for Delphi 4


 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *}
unit httptst1;

interface

uses
  WinTypes, WinProcs, Messages, SysUtils, Classes, Graphics, Controls, Forms,
  Dialogs, HttpProt, WSocket, StdCtrls, ExtCtrls, IniFiles;

const
  HttpTstVersion = 102;
  IniFileName    = 'httptest';

type
  THttpTestForm = class(TForm)
    Panel1: TPanel;
    GetButton: TButton;
    HttpCli1: THttpCli;
    URLEdit: TEdit;
    DisplayMemo: TMemo;
    Label1: TLabel;
    Label2: TLabel;
    ProxyHostEdit: TEdit;
    ProxyPortEdit: TEdit;
    PostButton: TButton;
    Check64Button: TButton;
    DataEdit: TEdit;
    Label3: TLabel;
    DateTimeEdit: TEdit;
    DocumentMemo: TMemo;
    Label4: TLabel;
    HeadButton: TButton;
    AbortButton: TButton;
    Label5: TLabel;
    Label6: TLabel;
    procedure GetButtonClick(Sender: TObject);
    procedure HttpCli1Command(Sender: TObject; const s: String);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure FormShow(Sender: TObject);
    procedure HttpCli1DocBegin(Sender: TObject);
    procedure HttpCli1DocEnd(Sender: TObject);
    procedure PostButtonClick(Sender: TObject);
    procedure Check64ButtonClick(Sender: TObject);
    procedure HeadButtonClick(Sender: TObject);
    procedure HttpCli1RequestDone(Sender: TObject; RqType: THttpRequest;
      Error: Word);
    procedure AbortButtonClick(Sender: TObject);
  private
    { Dclarations prives }
    Initialized : Boolean;
    procedure SetButtonState(State : Boolean);
  public
    { Dclarations publiques }
  end;

var
  HttpTestForm: THttpTestForm;

implementation

{$R *.DFM}

{* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *}
procedure THttpTestForm.FormShow(Sender: TObject);
var
    IniFile : TIniFile;
begin
    if not Initialized then begin
        Initialized        := TRUE;
        IniFile            := TIniFile.Create(IniFileName);
        URLEdit.Text       := IniFile.ReadString('Data', 'URL',       '');
        ProxyHostEdit.Text := IniFile.ReadString('Data', 'ProxyHost', '');
        ProxyPortEdit.Text := IniFile.ReadString('Data', 'ProxyPort', '80');
        DataEdit.Text      := IniFile.ReadString('Data', 'Data',      '');
        DateTimeEdit.Text  := IniFile.ReadString('Data', 'DateTime',  '');
        IniFile.Free;
    end;
end;


{* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *}
procedure THttpTestForm.FormClose(Sender: TObject;
  var Action: TCloseAction);
var
    IniFile : TIniFile;
begin
    IniFile := TIniFile.Create(IniFileName);
    IniFile.WriteString('Data', 'URL',       URLEdit.Text);
    IniFile.WriteString('Data', 'ProxyHost', ProxyHostEdit.Text);
    IniFile.WriteString('Data', 'ProxyPort', ProxyPortEdit.Text);
    IniFile.WriteString('Data', 'Data',      DataEdit.Text);
    IniFile.WriteString('Data', 'DateTime',  DateTimeEdit.Text);
    IniFile.Free;
end;


{* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *}
procedure THttpTestForm.HeadButtonClick(Sender: TObject);
var
    I       : Integer;
begin
    DisplayMemo.Clear;
    DocumentMemo.Clear;
    SetButtonState(FALSE);

    try
        httpcli1.URL        := URLEdit.Text;
        httpcli1.Proxy      := ProxyHostEdit.Text;
        httpcli1.ProxyPort  := ProxyPortEdit.Text;
        httpcli1.RcvdStream := nil;
        if DateTimeEdit.Text <> '' then
            httpcli1.ModifiedSince := StrToDateTime(DateTimeEdit.Text)
        else
            httpcli1.ModifiedSince := 0;

        try
            httpcli1.Head;
        except
            DisplayMemo.Lines.Add('HEAD Failed !');
            DisplayMemo.Lines.Add('StatusCode   = ' + IntToStr(httpcli1.StatusCode));
            DisplayMemo.Lines.Add('ReasonPhrase = ' + httpcli1.ReasonPhrase);
            Exit;
        end;

        DisplayMemo.Lines.Add('StatusCode = ' + IntToStr(httpcli1.StatusCode));

        for I := 0 to httpcli1.RcvdHeader.Count - 1 do
            DisplayMemo.Lines.Add('hdr>' + httpcli1.RcvdHeader.Strings[I]);
    finally
        SetButtonState(TRUE);
    end;
end;


{* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *}
procedure THttpTestForm.GetButtonClick(Sender: TObject);
var
    I       : Integer;
    DataIn  : TStream;
begin
    DisplayMemo.Clear;
    DocumentMemo.Clear;
    SetButtonState(FALSE);

    try
        httpcli1.URL        := URLEdit.Text;
        httpcli1.Proxy      := ProxyHostEdit.Text;
        httpcli1.ProxyPort  := ProxyPortEdit.Text;
        httpcli1.RcvdStream := nil;
        if DateTimeEdit.Text <> '' then
            httpcli1.ModifiedSince := StrToDateTime(DateTimeEdit.Text)
        else
            httpcli1.ModifiedSince := 0;

        try
            httpcli1.Get;
        except
            DisplayMemo.Lines.Add('GET Failed !');
            DisplayMemo.Lines.Add('StatusCode   = ' + IntToStr(httpcli1.StatusCode));
            DisplayMemo.Lines.Add('ReasonPhrase = ' + httpcli1.ReasonPhrase);
            HttpCli1DocEnd(nil);  { This will close the file }
            Exit;
        end;

        DisplayMemo.Lines.Add('StatusCode = ' + IntToStr(httpcli1.StatusCode));

        for I := 0 to httpcli1.RcvdHeader.Count - 1 do
            DisplayMemo.Lines.Add('hdr>' + httpcli1.RcvdHeader.Strings[I]);

        DataIn := TFileStream.Create(httpcli1.DocName, fmOpenRead);
        DocumentMemo.Lines.LoadFromStream(DataIn);
        DataIn.Free;
    finally
        SetButtonState(TRUE);
    end;
end;


{* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *}
procedure THttpTestForm.PostButtonClick(Sender: TObject);
var
    DataOut : TMemoryStream;
    DataIn  : TFileStream;
    Buf     : String;
    I       : Integer;
begin
    DisplayMemo.Clear;
    DocumentMemo.Clear;
    SetButtonState(FALSE);

    try
        DataOut := TMemoryStream.Create;
        Buf     := DataEdit.Text;
        DataOut.Write(Buf[1], Length(Buf));
        DataOut.Seek(0, soFromBeginning);

        httpcli1.SendStream := DataOut;
        httpcli1.Proxy      := ProxyHostEdit.Text;
        httpcli1.ProxyPort  := ProxyPortEdit.Text;
        httpcli1.RcvdStream := nil;
        httpcli1.URL        := URLEdit.Text;
        try
            httpcli1.Post;
        except
            DataOut.Free;
            DisplayMemo.Lines.Add('POST Failed !');
            DisplayMemo.Lines.Add('StatusCode   = ' + IntToStr(httpcli1.StatusCode));
            DisplayMemo.Lines.Add('ReasonPhrase = ' + httpcli1.ReasonPhrase);
            Exit;
        end;
        DataOut.Free;

        DisplayMemo.Lines.Add('StatusCode = ' + IntToStr(httpcli1.StatusCode));

        for I := 0 to httpcli1.RcvdHeader.Count - 1 do
            DisplayMemo.Lines.Add('hdr>' + httpcli1.RcvdHeader.Strings[I]);

        DataIn := TFileStream.Create(httpcli1.DocName, fmOpenRead);
        DocumentMemo.Lines.LoadFromStream(DataIn);
        DataIn.Free;
    finally
        SetButtonState(TRUE);
    end;
end;


{* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *}
procedure THttpTestForm.HttpCli1Command(Sender: TObject; const s: String);
begin
    DisplayMemo.Lines.Add('cmd> ' + s);
end;


{* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *}
procedure THttpTestForm.HttpCli1DocBegin(Sender: TObject);
begin
    DisplayMemo.Lines.Add(HttpCli1.ContentType + ' => ' + httpcli1.DocName);
    DisplayMemo.Lines.Add('Document = ' + httpcli1.DocName);
    httpcli1.RcvdStream := TFileStream.Create(httpcli1.DocName, fmCreate);
end;


{* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *}
procedure THttpTestForm.HttpCli1DocEnd(Sender: TObject);
begin
    if httpcli1.RcvdStream <> nil then begin
        httpcli1.RcvdStream.Free;
        httpcli1.RcvdStream := nil;
    end;
end;


{* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *}
procedure THttpTestForm.Check64ButtonClick(Sender: TObject);
const
    Inp : String = 'Aladdin:open sesame';
    Res : String = 'QWxhZGRpbjpvcGVuIHNlc2FtZQ==';
begin
    if EncodeLine(encBase64, @Inp[1], Length(Inp)) <> Res then
        DisplayMemo.Lines.Add('Base64 encoding do not work !')
    else
        DisplayMemo.Lines.Add('Base64 encoding works OK !');
end;


{* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *}
procedure THttpTestForm.SetButtonState(State : Boolean);
begin
    GetButton.Enabled   := State;
    PostButton.Enabled  := State;
    HeadButton.Enabled  := State;
    AbortButton.Enabled := not State;
end;


{* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *}
procedure THttpTestForm.HttpCli1RequestDone(Sender: TObject;
  RqType: THttpRequest; Error: Word);
begin
    SetButtonState(TRUE);
    DisplayMemo.Lines.Add('RequestDone Error = ' + IntToStr(Error));
end;


{* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *}
procedure THttpTestForm.AbortButtonClick(Sender: TObject);
begin
    HttpCli1.Abort;
end;


{* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *}

end.

