{* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *

Author:       Franois PIETTE
Description:  Demonstration for Server program using TWSocket.
              Presented at the conference held octber 17 at Technotheque
              in Liege. Works only with Delphi 2 or 3 because of
              string use. Should be easy to adapt with old string style.
EMail:        francois.piette@ping.be  http://www.rtfm.be/fpiette
              francois.piette@f2202.n293.z2.fidonet.org
              2:293/2202@fidonet.org, BBS +32-4-3651395
Creation:     17 october 1997
Version:      1.00
WebSite:      http://www.rtfm.be/fpiette/indexuk.htm
Support:      Use the mailing list twsocket@rtfm.be See website for details.
Legal issues: Copyright (C) 1997 by Franois PIETTE <francois.piette@ping.be>

              This software is provided 'as-is', without any express or
              implied warranty.  In no event will the author be held liable
              for any  damages arising from the use of this software.

              Permission is granted to anyone to use this software for any
              purpose, including commercial applications, and to alter it
              and redistribute it freely, subject to the following
              restrictions:

              1. The origin of this software must not be misrepresented,
                 you must not claim that you wrote the original software.
                 If you use this software in a product, an acknowledgment
                 in the product documentation would be appreciated but is
                 not required.

              2. Altered source versions must be plainly marked as such, and
                 must not be misrepresented as being the original software.

              3. This notice may not be removed or altered from any source
                 distribution.

Updates:


 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *}
unit Srv2;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  WSocket, StdCtrls, Db, DBTables;

type
  TCliForm = class(TForm)
    CliSocket: TWSocket;
    DisplayMemo: TMemo;
    LineLabel: TLabel;
    SendEdit: TEdit;
    SendButton: TButton;
    procedure FormShow(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure CliSocketDataAvailable(Sender: TObject; Error: Word);
    procedure CliSocketSessionClosed(Sender: TObject; Error: Word);
    procedure SendButtonClick(Sender: TObject);
  private
    { Dclarations prives }
    Initialized : Boolean;
    Buffer : array [0..1023] of char;
    Count  : Integer;
    procedure ProcessCommand(Cmd : PChar);
  public
    { Dclarations publiques }
    DataTable : TTable;
  end;

var
  CliForm: TCliForm;

implementation

{$R *.DFM}

procedure TCliForm.FormShow(Sender: TObject);
begin
    if not Initialized then begin
        Initialized   := TRUE;
        ActiveControl := SendEdit;
        CliSocket.SendStr('Hello' + #13 + #10);
    end;
end;

procedure TCliForm.FormClose(Sender: TObject; var Action: TCloseAction);
begin
    PostMessage(TForm(Owner).Handle, WM_USER, 0, LPARAM(Self));
end;

procedure TCliForm.ProcessCommand(Cmd : PChar);
begin
    DisplayMemo.Lines.Add(Cmd);
    DataTable.SetKey;
    DataTable.FieldByName('NOM').AsString := Cmd;
    if DataTable.GotoKey then
        CliSocket.SendStr(DataTable.FieldByName('PRENOM').AsString + #13 + #10)
    else
        CliSocket.SendStr('Pas trouv' + #13 + #10);
end;


procedure TCliForm.CliSocketDataAvailable(Sender: TObject; Error: Word);
var
    Len : Integer;
    I   : Integer;
begin
    Len := CliSocket.Receive(@Buffer[Count], SizeOf(Buffer) - Count - 1);
    if Len <= 0 then
        Exit;

    Count := Count + Len;
    Buffer[Count] := #0;
    LineLabel.Caption := Buffer;

    while TRUE do begin
        I := Pos(#10, Buffer) - 1;
        if I <= 0 then
            Exit;
        Buffer[I] := #0;
        ProcessCommand(Buffer);
        Buffer[I] := #10;
        Count             := 0;
        LineLabel.Caption := '';
        if I >= StrLen(Buffer) then
            break;
        Move(Buffer[I + 1], Buffer, Strlen(Buffer) - I);
        LineLabel.Caption := Buffer;
        Count             := StrLen(Buffer);
    end;
end;

procedure TCliForm.CliSocketSessionClosed(Sender: TObject; Error: Word);
begin
    Close;
end;

procedure TCliForm.SendButtonClick(Sender: TObject);
begin
    CliSocket.SendStr(SendEdit.Text + #13 + #10);
    ActiveControl := SendEdit;
end;

end.
