{* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *

Author:       Franois PIETTE
Description:  Demonstration for Client program using TWSocket.
              Presented at the conference held octber 17 at Technotheque
              in Liege. Works only with Delphi 2 or 3 because of
              string use. Should be easy to adapt with old string style.
EMail:        francois.piette@ping.be  http://www.rtfm.be/fpiette
              francois.piette@f2202.n293.z2.fidonet.org
              2:293/2202@fidonet.org, BBS +32-4-3651395
Creation:     17 october 1997
Version:      1.00
WebSite:      http://www.rtfm.be/fpiette/indexuk.htm
Support:      Use the mailing list twsocket@rtfm.be See website for details.
Legal issues: Copyright (C) 1997 by Franois PIETTE <francois.piette@ping.be>

              This software is provided 'as-is', without any express or
              implied warranty.  In no event will the author be held liable
              for any  damages arising from the use of this software.

              Permission is granted to anyone to use this software for any
              purpose, including commercial applications, and to alter it
              and redistribute it freely, subject to the following
              restrictions:

              1. The origin of this software must not be misrepresented,
                 you must not claim that you wrote the original software.
                 If you use this software in a product, an acknowledgment
                 in the product documentation would be appreciated but is
                 not required.

              2. Altered source versions must be plainly marked as such, and
                 must not be misrepresented as being the original software.

              3. This notice may not be removed or altered from any source
                 distribution.

Updates:


 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *}
unit client1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, WSocket;

type
  TClientForm = class(TForm)
    CliSocket: TWSocket;
    ConnectButton: TButton;
    SendEdit: TEdit;
    SendButton: TButton;
    DisconnectButton: TButton;
    DisplayMemo: TMemo;
    PortEdit: TEdit;
    ServerEdit: TEdit;
    LineLabel: TLabel;
    procedure ConnectButtonClick(Sender: TObject);
    procedure DisconnectButtonClick(Sender: TObject);
    procedure SendButtonClick(Sender: TObject);
    procedure CliSocketDataAvailable(Sender: TObject; Error: Word);
  private
    { Dclarations prives }
    Buffer : array [0..1023] of char;
    Count  : Integer;
    procedure ProcessCommand(Cmd : PChar);
  public
    { Dclarations publiques }
  end;

var
  ClientForm: TClientForm;

implementation

{$R *.DFM}

procedure TClientForm.ConnectButtonClick(Sender: TObject);
begin
    CliSocket.Port  := PortEdit.Text;
    CliSocket.Addr  := ServerEdit.Text;
    CliSocket.Proto := 'tcp';
    CliSocket.Connect;
end;

procedure TClientForm.DisconnectButtonClick(Sender: TObject);
begin
    CliSocket.Close;
end;

procedure TClientForm.SendButtonClick(Sender: TObject);
begin
    CliSocket.SendStr(SendEdit.Text + #13 + #10);
    ActiveControl := SendEdit;
    SendEdit.SelectAll;
end;

procedure TClientForm.ProcessCommand(Cmd : PChar);
begin
    DisplayMemo.Lines.Add(Cmd);
end;

procedure TClientForm.CliSocketDataAvailable(Sender: TObject; Error: Word);
var
    Len : Integer;
    I   : Integer;
begin
    Len := CliSocket.Receive(@Buffer[Count], SizeOf(Buffer) - Count - 1);
    if Len <= 0 then
        Exit;

    Count := Count + Len;
    Buffer[Count] := #0;
    LineLabel.Caption := Buffer;

    while TRUE do begin
        I := Pos(#10, Buffer) - 1;
        if I <= 0 then
            Exit;
        Buffer[I] := #0;
        ProcessCommand(Buffer);
        Buffer[I] := #10;
        Count             := 0;
        LineLabel.Caption := '';
        if I >= StrLen(Buffer) then
            break;
        Move(Buffer[I + 1], Buffer, Strlen(Buffer) - I);
        LineLabel.Caption := Buffer;
        Count             := StrLen(Buffer);
    end;
end;

end.
