{$A-}
unit D_IOCTL;

{ This unit maintains IOCTL MS-DOS functions calls from Windows 95
  Win32 API application. For Windows NT use other way of call!!! }

interface

uses Windows, SysUtils;

type
   PDiskIO = ^TDiskIO;
   TDiskIO = packed record
     diStartSector: Longint; //sector number to start
     diSectors: Word;        //number of sectors
     diBuffer: Longint;      //address of buffer
   end;

const
{ Main constants declarations }
    VWIN32_DIOC_DOS_IOCTL = 1; { MS-DOS Int 21h 44xxh functions call }
    VWIN32_DIOC_DOS_INT25 = 2; { MS-DOS Int 25h function call }
    VWIN32_DIOC_DOS_INT26 = 3; { MS-DOS Int 26h function call }
    VWIN32_DIOC_DOS_INT13 = 4; { MS-DOS Int 13h functions call }
    VWIN32_DIOC_DOS_DRIVEINFO = 6; {MS-DOS Int 21h function 730X}

type
{ Definition for 32-bit processor registers.
  Note: for Win32 all data segment registers are assumed to the single
  segment and does not require to be changed! }
    P32Regs = ^T32Regs;
    T32Regs = record
      EBX: Longint;
      EDX: Longint;
      ECX: Longint;
      EAX: Longint;
      EDI: Longint;
      ESI: Longint;
      Flags: Longint;
    end;

    TWin95 = (Win95, OSR2, NoWin95);

    TLockType = (lPhysical, lLogical);

    PBPB = ^TBPB;
    TBPB = packed record
      bpbSectorSize: Word; 
      bpbSectorsPerCluster: Byte; 
      bpbReservedSectors: Word;
      bpbFATCount: Byte;
      bpbRootDirEntries: Word;
      bpbTotalSectors: Word;
      bpbMediaDescriptor: Byte;
      bpbSectorsPerFAT: Word;
      bpbSectorsPerTrack: Word;
      bpbHeads: Word;
      bpbHiddenSectors: Longint;
      bpbBigTotalSectors: Longint;
    end;

    PExt_BPB = ^TExt_BPB;
    TExt_BPB = packed record
      bpbSectorSize: Word;
      bpbSectorsPerCluster: Byte;
      bpbReservedSectors: Word;
      bpbFATCount: Byte;
      bpbRootDirEntries: Word;
      bpbTotalSectors: Word;
      bpbMediaDescriptor: Byte;
      bpbSectorsPerFAT: Word;
      bpbSectorsPerTrack: Word;
      bpbHeads: Word;
      bpbHiddenSectors: Longint;
      bpbBigTotalSectors: Longint;
      bpbBigSectorsPerFAT: Longint;
      bpbExtFlags: Word;
      bpbFSVersion: Word;
      bpbRootDirStartCluster: Longint;
      bpbFSInfoSec: Word;
      bpbBkUpBootSec: Word;
      bpbReserved: array[1..6] of Byte;
    end;

    PDeviceParams = ^TDeviceParams;
    TDeviceParams = packed record
      dpSpecialFunctions: Byte;
      dpDeviceType: Byte;
      dpDeviceAttributes: Word;
      dpNumberOfCylinders: Word;
      dpMediaType: Byte;
      dpBPB: TBPB;
      dpSectorsPerTrack: Word;
      dpHeads: Word;
      dpHiddenSectors: Word;
      dpReserved1: Longint;
      dpReserved2: Longint;
      dpReserved3: Word;
      dpDeviceBPBSize: Byte; {31}
      dpSectorsCount: Word;
      dpSectorNoSectorSize: array[0..$FFFF] of Longint;
    end;

    PExt_DeviceParams = ^TExt_DeviceParams;
    TExt_DeviceParams = packed record
      dpSpecialFunctions: Byte;
      dpDeviceType: Byte;
      dpDeviceAttributes: Word;
      dpNumberOfCylinders: Word;
      dpMediaType: Byte;
      dpBPB: TExt_BPB;
      dpReserved_: array[0..31] of Byte;
      dpSectorsCount: Word;
      dpSectorNoSectorSize: array[0..$FFFF] of Longint;
    end;

    PDriveMapInfo = ^TDriveMapInfo;
    TDriveMapInfo = packed record
      dmiAllocationLength: Byte;
      dmiInfoLength: Byte;
      dmiFlags: Byte;
      dmiInt13Unit: Byte;
      dmiAssociatedDriveMap: Longint;
      dmiPartitionStartRBA: Longint;
      dmiPartitionStartRBAHi: Longint;
    end;

    PBOOTSECT = ^TBOOTSECT;
    TBOOTSECT = record
      bsJump: array [1..3] of Byte;      // jmp instruction
      bsOemName: array [1..8]of Char;    // OEM name and version
	  // This portion is the BPB (BIOS Parameter Block)
      bsBytesPerSec: Word;	   	 // bytes per sector
      bsSecPerClust: Byte;		 // sectors per cluster
      bsResSectors: Word;		 // number of reserved sectors
      bsFATs: Byte;			 // number of file allocation tables
      bsRootDirEnts: Word;		 // number of root-directory entries
      bsSectors: Word;			 // total number of sectors
      bsMedia: Byte;			 // media descriptor
      bsFATsecs: Word;			 // number of sectors per FAT
      bsSecPerTrack: Word;		 // number of sectors per track
      bsHeads: Word;			 // number of read/write heads
      bsHiddenSectors: Longint;	         // number of hidden sectors
      bsHugeSectors: Longint;		 // number of sectors if bsSectors==0
	  // End of BPB

      bsDriveNumber: Byte;		 // 80h if first hard drive
      bsReserved: Byte;
      bsBootSignature: Byte;             // 29h if extended boot-signature record
      bsVolumeID: Longint;                 // volume ID number
      bsVolumeLabel: array [1..11] of Char;  // volume label
      bsFileSysType: array [1..8] of Char;   // file-system type (FAT12 or FAT16)
    end;

    PDIRENTRY = ^TDIRENTRY;
    TDIRENTRY = record
      deName: array [1..8] of Char;       // base name
      deExtension: array [1..3] of Char;  // extension
      deAttributes: Byte;	  // file or directory attributes
      deReserved: array [1..6] of Byte;
      deLastAccessDate: Word;	  // *New Win95* - last access date
      deEAhandle: Word;		  // *New FAT32* - high word of starting cluster
      deCreateTime: Word;  	  // creation or last modification time
      deCreateDate: Word;  	  // creation or last modification date
      deStartCluster: Word;	  // starting cluster of the file or directory
      deFileSize: Longint;	  // size of the file in bytes
    end;

    PLONGDIRENTRY = ^TLONGDIRENTRY;
    TLONGDIRENTRY = record
      leSequence: Byte;			// sequence byte:1,2,3,..., last entry is or'ed with 40h
      leName: array [1..5] of WChar;    // Unicode characters of name
      leAttributes: Byte;		// Attributes: 0fh
      leType: Byte;         		// Long Entry Type: 0
      leChksum: Byte;    		// Checksum for matching short name alias
      leName2: array [1..6] of WChar;	// More Unicode characters of name
      leZero: Word;			// reserved
      leName3: array [1..2] of WChar;	// More Unicode characters of name
    end;

////////////////// FAT32 Structures ///////////////////

// BPB for a Fat32 partition
    PA_BF_BPB = ^TA_BF_BPB;
    TA_BF_BPB = record
      A_BF_BPB_BytesPerSector: Word;
      A_BF_BPB_SectorsPerCluster: Byte;
      A_BF_BPB_ReservedSectors: Word;
      A_BF_BPB_NumberOfFATs: Byte;
      A_BF_BPB_RootEntries: Word;
      A_BF_BPB_TotalSectors: Word;
      A_BF_BPB_MediaDescriptor: Byte;
      A_BF_BPB_SectorsPerFAT: Word;
      A_BF_BPB_SectorsPerTrack: Word;
      A_BF_BPB_Heads: Word;
      A_BF_BPB_HiddenSectors: Word;
      A_BF_BPB_HiddenSectorsHigh: Word;
      A_BF_BPB_BigTotalSectors: Word;
      A_BF_BPB_BigTotalSectorsHigh: Word;
      A_BF_BPB_BigSectorsPerFat: Word;
      A_BF_BPB_BigSectorsPerFatHi: Word;
      A_BF_BPB_ExtFlags: Word;
      A_BF_BPB_FS_Version: Word;
      A_BF_BPB_RootDirStrtClus: Word;
      A_BF_BPB_RootDirStrtClusHi: Word;
      A_BF_BPB_FSInfoSec: Word;
      A_BF_BPB_BkUpBootSec: Word;
      A_BF_BPB_Reserved: array [1..6] of Word;
    end;

    PBOOTSECT32 = ^TBOOTSECT32;
    TBOOTSECT32 = record
      bsJump: array [1..3] of Byte;      // jmp instruction
      bsOemName: array [1..8] of Char;   // OEM name and version

	  // This portion is the FAT32 BPB
      bpb: TA_BF_BPB;

      bsDriveNumber: Byte;		  // 80h if first hard drive
      bsReserved: Byte;
      bsBootSignature: Byte;              // 29h if extended boot-signature record
      bsVolumeID: Longint;                  // volume ID number
      bsVolumeLabel: array [1..11] of Char;  // volume label
      bsFileSysType: array [1..8] of Char;   // file-system type (FAT32)
    end;

    PMID = ^TMID;
    TMID = record
      midInfoLevel: Word;       // information level, must be 0
      midSerialNum: Longint;      // serial number for the medium
      midVolLabel: array [1..11] of Char;   // volume label for the medium
      midFileSysType: array [1..8] of Char; // type of file system as 8-byte ASCII
    end;

    TPASMID = record
      midInfoLevel: Word;       // information level, must be 0
      midSerialNum: Longint;      // serial number for the medium
      midVolLabel: String[255];   // volume label for the medium
      midFileSysType: String[255]; // type of file system as 8-byte ASCII
    end;

{ Main procedures }

{Check Windows 95 version}
function CheckWindows95: TWin95;

procedure TMID2TPASMID(MID: TMID; var AMID: TPASMID);

implementation

procedure TMID2TPASMID(MID: TMID; var AMID: TPASMID);
var I: Longint;
begin
   AMID.midInfoLevel := MID.midInfoLevel;
   AMID.midSerialNum := MID.midSerialNum;
   AMID.midVolLabel[0] := #11;
   for I := 1 to 11 do AMID.midVolLabel[I] := MID.midVolLabel[I];
   while (AMID.midVolLabel[0] <> #0) and (AMID.midVolLabel[Byte(AMID.midVolLabel[0])]=' ') do
         Dec(Byte(AMID.midVolLabel[0]));
   AMID.midFileSysType[0] := #8;
   for I := 1 to 8 do AMID.midFileSysType[I] := MID.midFileSysType[I];
   while (AMID.midFileSysType[0] <> #0) and (AMID.midFileSysType[Byte(AMID.midFileSysType[0])]=' ') do
         Dec(Byte(AMID.midFileSysType[0]));
   AMID.midVolLabel := UpperCase(AMID.midVolLabel);
   AMID.midFileSysType := UpperCase(AMID.midFileSysType);
end;

function CheckWindows95: TWin95;
var V: TOSVersionInfo;
begin
   V.dwOSVersionInfoSize := SizeOf(V);
   Result := NoWin95;
   if not GetVersionEx(V) then Exit;
   if V.dwPlatformId <> 1 then Exit;
   if V.dwBuildNumber > 1080 then Result := OSR2
                             else Result := Win95;
end;

end.
