program SecretService_Client;

uses
  Forms,
  Main_Unit in 'Main_Unit.pas' {Main_Form},
  mail_settings_unit in 'mail_settings_unit.pas' {mail_settings_Form},
  Info_Unit in 'Info_Unit.pas' {Info_Form},
  Scan_Unit in 'Scan_Unit.pas' {Scan_Form},
  Remote_Unit in 'Remote_Unit.pas' {Remote_Form},
  change_address_Unit in 'change_address_Unit.pas' {change_address_form},
  Start in 'Start.pas' {Start_Form},
  WinProcs;

{$R *.RES}

const
	DELAY_TIME = 150;		// 150 ms Delay ...

procedure Wait( zeit : longint);
var
	zeit1 : longint;
begin
	zeit1 := GetTickCount;
  repeat
  	Application.ProcessMessages
  until ( GetTickCount - zeit1 > zeit)
end;

procedure Prozent( p : integer);
const
	First : Boolean = true;
begin
	if First then
  begin
    Start_Form.Gauge1.MaxValue := p;
    Start_Form.Show;
    Start_Form.Refresh;
    First := false;
  end
  else
  begin
  	Start_Form.Gauge1.Progress := p;
    Start_Form.Gauge1.Refresh;
    wait( DELAY_TIME);
  end;
end;

begin
  Application.Initialize;
  Application.Title := 'Secret Service - Client v1.2';
  Application.CreateForm(TMain_Form, Main_Form);
  Application.CreateForm(TStart_Form, Start_Form);
  prozent( 5);
  prozent( 0);
  Application.CreateForm(Tmail_settings_Form, mail_settings_Form);
  prozent( 1);
  Application.CreateForm(TInfo_Form, Info_Form);
  prozent( 2);
  Application.CreateForm(TScan_Form, Scan_Form);
  prozent( 3);
  Application.CreateForm(TRemote_Form, Remote_Form);
  prozent( 4);
  Application.CreateForm(Tchange_address_form, change_address_form);
  prozent( 5);
  Start_Form.Close;
  Application.Run;
end.
