unit main;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls,  ExtCtrls, yupack, Menus, ComCtrls;

type
  TfmMain = class(TForm)
    YusoftGradientButton1: TYusoftGradientButton;
    YusoftGradientButton2: TYusoftGradientButton;
    YusoftGradientButton3: TYusoftGradientButton;
    StatusBar1: TStatusBar;
    YusoftGradientButton4: TYusoftGradientButton;
    YusoftGradientButton5: TYusoftGradientButton;
    YusoftGradientButton6: TYusoftGradientButton;
    YusoftGradientButton7: TYusoftGradientButton;
    Notebook1: TNotebook;
    YusoftWallpaper1: TYusoftWallpaper;
    YuSoftButton1: TYuSoftButton;
    YuSoftLabel1: TYuSoftLabel;
    YuSoftButton2: TYuSoftButton;
    YuSoftLabel2: TYuSoftLabel;
    CheckBox1: TCheckBox;
    YuSoftLabel3: TYuSoftLabel;
    YuSoftButton3: TYuSoftButton;
    YuSoftLabel4: TYuSoftLabel;
    YuSoftLabel5: TYuSoftLabel;
    YuSoftLabel6: TYuSoftLabel;
    YuSoftLabel7: TYuSoftLabel;
    YuSoftLabel8: TYuSoftLabel;
    Image1: TImage;
    Image2: TImage;
    Image3: TImage;
    Image4: TImage;
    procedure YusoftGradientButton2MouseEnter(Sender: TObject);
    procedure YusoftGradientButton2MouseLeave(Sender: TObject);
    procedure YusoftGradientButton2Click(Sender: TObject);
    procedure YusoftGradientButton1MouseMove(Sender: TObject;
      Shift: TShiftState; X, Y: Integer);

    procedure CreateParams(var Params: TCreateParams); override;
    procedure FormCreate(Sender: TObject);
    procedure CheckBox1Click(Sender: TObject);
    procedure YusoftGradientButton5Click(Sender: TObject);
    procedure YuSoftButton3MouseUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
  private
    { Private declarations }
    procedure MyHint(Sender: TObject);
  public
    { Public declarations }
  end;

var
  fmMain: TfmMain;

implementation
{$R *.DFM}

procedure TfmMain.CreateParams(var Params: TCreateParams);
begin
  inherited CreateParams(Params);
  with Params do
   Style := (Style or WS_POPUP) and (not WS_DLGFRAME);

 {I think this is the best way to get form without captiom
  BorderStyle=bsNone is not beatiful}
end;

procedure TfmMain.MyHint(Sender: TObject);
begin
  StatusBar1.SimpleText:=Application.Hint;
end;

procedure TfmMain.FormCreate(Sender: TObject);
begin
  Application.OnHint:=MyHint;
  YusoftGradientButton5Click(YusoftGradientButton5);
end;

procedure TfmMain.YusoftGradientButton2MouseEnter(Sender: TObject);
begin
  (Sender as TYusoftGradientButton).Font.Color:=clYellow;
end;

procedure TfmMain.YusoftGradientButton2MouseLeave(Sender: TObject);
begin
  (Sender as TYusoftGradientButton).Font.Color:=clWhite;
end;

procedure TfmMain.YusoftGradientButton2Click(Sender: TObject);
begin
  case (Sender as TYusoftGradientButton).Tag  of
    1: Application.Minimize;
    2: Application.Terminate;
   end;
end;

procedure TfmMain.YusoftGradientButton1MouseMove(Sender: TObject;
  Shift: TShiftState; X, Y: Integer);
begin
  if ssleft in shift then
  begin
    ReleaseCapture;
    fmMain.perform(WM_syscommand, $F012, 0);
  end;
end;

procedure TfmMain.CheckBox1Click(Sender: TObject);
begin
  YuSoftButton2.Enabled:=CheckBox1.Checked;
  {
   Note:
   YusoftLabel.Enabled property will change too!
  }
end;

procedure TfmMain.YusoftGradientButton5Click(Sender: TObject);
begin
  Notebook1.ActivePage:=IntToStr((Sender as TYusoftGradientButton).Tag);
  (Sender as TYusoftGradientButton).Font.Style:=(Sender as TYusoftGradientButton).Font.Style+[fsBold];
  if (Sender as TYusoftGradientButton).Tag=2 then  YusoftGradientButton5.Font.Style:=YusoftGradientButton5.Font.Style-[fsBold]
    else YusoftGradientButton6.Font.Style:=YusoftGradientButton6.Font.Style-[fsBold];
end;

procedure TfmMain.YuSoftButton3MouseUp(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
  Close;
end;

end.
