{***********************************************************************
*  TKabel version 1.0                                                  *
*                                                                      *
*    Copyright  1997, 1998  Karlos, Inc. All Rights Reserved.         *
*    Developed By: Karlos Jorge Pinto                                  *
*    E-MAIL: Karlospinto@hotmail.com                                   *
*    Delphi Super Site o---> Delphi@pt <---o:                          *
*    http://www.terravista.pt/bilene/1412 ---> In English/Portuguese   *
*                                                                      *
************************************************************************
*  IRC: #portugal - Undernet. Nick: kArLoS.                            *
*  This is shareware, if you want to use in your projects you have to  *
*  pay *only* $5, for registrate this component. To do this please read*
*  the Register.txt, for more details.                   Made: 12/97   *
***********************************************************************}

unit Klabel;

interface

   uses
     SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
     Forms, Dialogs, StdCtrls, DsgnIntf;

   type
     TTextStyle = ( tsNone, tsRaised, tsRecessed );
     TKLabel = class( TLabel )

     private
       { Private declarations }
       FAbout:	string;
       FTextStyle : TTextStyle;
       procedure DoDrawText(var Rect: TRect; Flags: Word);
     protected
       procedure Paint; override;
       procedure SetTextStyle( Value : TTextStyle );
     public
       { Public declarations }
       procedure ShowAbout;Virtual;
       constructor Create( AOwner : TComponent ); override;
     published
       { Published declarations }
       property About: string read FAbout write FAbout stored False;
       property TextStyle : TTextStyle read FTextStyle
                                      write SetTextStyle
                                      default tsRecessed;

     end;

   procedure Register;

implementation


type
  TAboutProperty = class(TPropertyEditor)
  public
    procedure Edit; override;
    function GetAttributes: TPropertyAttributes; override;
    function GetValue:string; override;
  end;

{/////////////////////////////////////////////////////////////////////////////}
{/////////////////////////////////////////////////////////////////////////////}
{/////////////////////////////////////////////////////////////////////////////}
{/////////////////////////////////////////////////////////////////////////////}


procedure TAboutProperty.Edit;
{call the 'About' dialog window when clicking on in the Object Inspector}
begin
  TKlabel(GetComponent(0)).ShowAbout;
end;
function TAboutProperty.GetAttributes: TPropertyAttributes;
{set up to display a string in the Object Inspector}
begin
  GetAttributes := [paDialog, paReadOnly];
end;
function TAboutProperty.GetValue: String;
{set string to appear in the Object Inspector}
begin
  GetValue := '(About Klabel v.1.0)';
end;
procedure TKlabel.ShowAbout;
var
	msg: string;
const
  cr = chr(13);
begin
  msg := '  --> The KLabel a 3D Label. Version: 1.0 <--' + cr;
  msg := msg + 'TKlabel:' + ' a 16/32-Bit Component for Delphi' + cr;
  {$IFDEF WIN32}
  msg := msg + '(This is the 32 bit version)' + cr + cr;
  {$ELSE}
  msg := msg + '(This is the 16 bit version)' + cr + cr;
  {$ENDIF}
  msg := msg + 'Copyright  1997/98 Karlos Inc.' + cr;
  msg := msg + 'Made By: Karlos Pinto' + cr;
  msg := msg + '*****************************************************************' + cr;
  msg := msg + 'Delphi@pt site: http://www.terravista.pt/bilene/1412' + cr;
  msg := msg + 'E-Mail: Karlospinto@hotmail.com' + cr;
  msg := msg + '*****************************************************************' + cr;
  msg := msg + 'This Component is SHAREWARE, please read Register.TXT.' + cr;
  msg := msg + '        ...---**** KARLOS PINTO Inc.****---...' + cr;
  msg := msg + '  IRC: #portugal - Undernet, Nick: kArLoS :)' + cr;
  msg := msg + 'If you want more comp., apz., games please send a' + cr;
  msg := msg + 'E-Mail to me, or go to the IRC, Wed 10.30 GMT. :-)' + cr;

    MessageDlg(msg,mtInformation,[MBOK],0);
end;

{/////////////////////////////////////////////////////////////////////////////}
{/////////////////////////////////////////////////////////////////////////////}
{/////////////////////////////////////////////////////////////////////////////}
{/////////////////////////////////////////////////////////////////////////////}

  procedure Register;
  begin
    RegisterComponents( 'Karlos Inc.', [ TKLabel ] );
    {register the 'About' property editor}
     RegisterPropertyEditor(TypeInfo(String), TKlabel, 'About',
     TAboutProperty);

  end;
{########################################################################}
{########################################################################}
{########################################################################}
{########################################################################}
{########################################################################}


   constructor TKLabel.Create( AOwner : TComponent );
   begin
     inherited Create( AOwner );
     FTextStyle := tsRaised;
   end;


   procedure TKLabel.SetTextStyle( Value : TTextStyle );
   begin
     if Value <> FTextStyle then
     begin
       FTextStyle := Value;
       Invalidate;
     end;
   end; {= TKLabel.SetTextStyle =}


   procedure TKLabel.DoDrawText( var Rect : TRect; Flags : Word );
   var
     Text       : array[ 0..255 ] of Char;
     TmpRect    : TRect;
     UpperColor : TColor;
     LowerColor : TColor;
   begin
     GetTextBuf(Text, SizeOf(Text));
     if ( Flags and DT_CALCRECT <> 0) and
        ( ( Text[0] = #0 ) or ShowAccelChar and
          ( Text[0] = '&' ) and
          ( Text[1] = #0 ) ) then
       StrCopy(Text, ' ');

     if not ShowAccelChar then
       Flags := Flags or DT_NOPREFIX;
     Canvas.Font := Font;

     UpperColor := clBtnHighlight;
     LowerColor := clBtnShadow;
     if FTextStyle = tsRecessed then
     begin
       UpperColor := clBtnShadow;
       LowerColor := clBtnHighlight;
     end;

     if FTextStyle in [ tsRecessed, tsRaised ] then
     begin
       TmpRect := Rect;
       OffsetRect( TmpRect, 1, 1 );
       Canvas.Font.Color := LowerColor;
       DrawText(Canvas.Handle, Text, StrLen(Text), TmpRect, Flags);

       TmpRect := Rect;
       OffsetRect( TmpRect, -1, -1 );
       Canvas.Font.Color := UpperColor;
       DrawText(Canvas.Handle, Text, StrLen(Text), TmpRect, Flags);
     end;

     Canvas.Font.Color := Font.Color;
     if not Enabled then
       Canvas.Font.Color := clGrayText;
       DrawText(Canvas.Handle, Text, StrLen(Text), Rect, Flags);
     end; {= TKLabel.DoDrawText =}


   procedure TKLabel.Paint;
   const
     Alignments: array[TAlignment] of Word = (DT_LEFT, DT_RIGHT, DT_CENTER);
   var
     Rect: TRect;
   begin
    with Canvas do
    begin
       if not Transparent then
      begin
        Brush.Color := Self.Color;
        Brush.Style := bsSolid;
        FillRect(ClientRect);
      end;
      Brush.Style := bsClear;
      Rect := ClientRect;
      DoDrawText( Rect, ( DT_EXPANDTABS or DT_WORDBREAK ) or
                  Alignments[ Alignment ] );
    end;
  end;

end.
