{ͻ
  Unit      _Dt.pas                                      
                                                         
  Compiler  Turbo Pascal 6.0                             
                                                         
  Date      13.05.90                                     
                                                         
  Update    21.07.90                                     
                                                         
  Autor     Reiner Schlles                              
 Ķ
  Inhalt    Enthlt nur die Routinen, die von der Pro-   
            zedur _NeuenDtErstellen aus der Unit         
            _Drucker aufgerufen werden. Die Trennung in  
            zwei Units dient ausschlielich der besseren 
            bersicht.                                   
 ͼ}
Unit _Dt;
{ͻ
  Interface (ffentlicher Teil)                           
 ͼ}
Interface

  {Verzeichnis der globalen Routinen}

  procedure DrStZInFelderInit;
  procedure DrStZInEingabeMaskePos(Anz: byte);
  procedure DrStZInEingeben(Anz: byte; Beenden: char);

{ͻ
  Implementation (Nicht-ffentlicher Teil)                
 ͼ}
Implementation
uses {Einzubindende Bibliotheken}
  Crt,                    {Unit aus dem Turbo Pascal-System}
  _Declare,_Drucker,_Input,
  _IO,_Disk,_Windows,_Help;      {Units aus dem Unit-System}

const {Lokale Konstanten}
  SpL        =  1;                            {Spalte Links}
  SpM        = 27;                            {Spalte Mitte}
  SpR        = 55;                           {Spalte Rechts}
  LenIn      = 15;                     {Lnge Eingabefelder}

var {Lokale Variablen}
  DrStZIn: array[1..DrStZInAnz] of _InputRec;

{ͻ
  DrStZInFelderInit                                       
 Ķ
  Initialisiert die Eingabefelder der entsprechenden Vari-
  ablen.                                                  
 ͼ}
procedure DrStZInFelderInit;
var i: byte;                                  {Zhlvariable}

begin
  {Fr alle Felder (v. 2 an) gleich}
  for i:= 2 to DrStZInAnz do
  begin
    DrStZIn[i].Antwort:= '';
    DrStZIn[i].Laenge := LenIn;
    DrStZIn[i].Typ    := 0;              {Datentyp _WorkStr}
    DrStZIn[i].VorAnt := DrStZIn[i].Antwort;
  end;
  {Die 3 Spalten initialisieren}
  for i:=  1 to 16         do DrStZIn[i].Spalte := SpL;
  for i:= 17 to 31         do DrStZIn[i].Spalte := SpM;
  for i:= 32 to DrStZInAnz do DrStZIn[i].Spalte := SpR;
  {}

  DrStZIn[1].Antwort:= '';
  DrStZIn[1].Zeile  := 5;
  DrStZIn[1].Laenge := 25;
  DrStZIn[1].Typ    := 0;
  DrStZIn[1].Mld    := 'Druckername:';
  DrStZIn[1].VorAnt := DrStZIn[1].Antwort;
  DrStZIn[1].Mld25  := 'Name bzw. Bezeichnung Ihres Druckers';

  DrStZIn[2].Zeile  := 7;
  DrStZIn[2].Mld    := 'Reset  :';
  DrStZIn[2].Mld25  := 'Drucker normieren (Reset)';

  DrStZIn[3].Zeile  := 8;
  DrStZIn[3].Mld    := 'Papier+:';
  DrStZIn[3].Mld25  := 'Papierendeerkennung einschalten';

  DrStZIn[4].Zeile  := 9;
  DrStZIn[4].Mld    := 'Papier-:';
  DrStZIn[4].Mld25  := 'Papierendeerkennung ausschalten';

  DrStZIn[5].Zeile  := 10;
  DrStZIn[5].Mld    := 'FF     :';
  DrStZIn[5].Mld25  := 'Seitenvorschub';

  DrStZIn[6].Zeile  := 11;
  DrStZIn[6].Mld    := 'Perf.  :';
  DrStZIn[6].Mld25  := 'Perforation berspringen' +
                       'ausschalten';

  DrStZIn[7].Zeile  := 12;
  DrStZIn[7].Mld    := 'Perf.Z.:';
  DrStZIn[7].Mld25  := 'Perforation um n Zeilen' +
                       'berspringen';

  DrStZIn[8].Zeile  := 13;
  DrStZIn[8].Mld    := 'Normal :';
  DrStZIn[8].Mld25  := 'Normalschrift einschalten';

  DrStZIn[9].Zeile  := 14;
  DrStZIn[9].Mld    := 'Elite+ :';
  DrStZIn[9].Mld25  := 'Eliteschrift einschalten';

  DrStZIn[10].Zeile  := 15;
  DrStZIn[10].Mld    := 'Elite- :';
  DrStZIn[10].Mld25  := 'Eliteschrift ausschalten';

  DrStZIn[11].Zeile  := 16;
  DrStZIn[11].Mld    := 'Gedeh.+:';
  DrStZIn[11].Mld25  := 'Gedehnte Schrift einschalten';

  DrStZIn[12].Zeile  := 17;
  DrStZIn[12].Mld    := 'Gedeh.-:';
  DrStZIn[12].Mld25  := 'Gedehnte Schrift ausschalten';

  DrStZIn[13].Zeile  := 18;
  DrStZIn[13].Mld    := 'Klein+ :';
  DrStZIn[13].Mld25  := 'Kleinschrift einschalten';

  DrStZIn[14].Zeile  := 19;
  DrStZIn[14].Mld    := 'Klein- :';
  DrStZIn[14].Mld25  := 'Kleinschrift ausschalten';

  DrStZIn[15].Zeile  := 20;
  DrStZIn[15].Mld    := 'Fett+  :';
  DrStZIn[15].Mld25  := 'Fettdruck einschalten';

  DrStZIn[16].Zeile  := 21;
  DrStZIn[16].Mld    := 'Fett-  :';
  DrStZIn[16].Mld25  := 'Fettdruck ausschalten';

  DrStZIn[17].Zeile  := 7;
  DrStZIn[17].Mld    := 'Doppel+:';
  DrStZIn[17].Mld25  := 'Doppeldruck einschalten';

  DrStZIn[18].Zeile  := 8;
  DrStZIn[18].Mld    := 'Doppel-:';
  DrStZIn[18].Mld25  := 'Doppeldruck ausschalten';

  DrStZIn[19].Zeile  := 9;
  DrStZIn[19].Mld    := 'Italic+:';
  DrStZIn[19].Mld25  := 'Italic (Kursiv) einschalten';

  DrStZIn[20].Zeile  := 10;
  DrStZIn[20].Mld    := 'Italic-:';
  DrStZIn[20].Mld25  := 'Italic (Kursiv) ausschalten';

  DrStZIn[21].Zeile  := 11;
  DrStZIn[21].Mld    := 'Unidir.:';
  DrStZIn[21].Mld25  := 'Unidirektionaler Druck (Nur von' +
                        ' links nach rechts)';

  DrStZIn[22].Zeile  := 12;
  DrStZIn[22].Mld    := 'Bidir. :';
  DrStZIn[22].Mld25  := 'Bidirektionaler Druck (Von ' +
                        'links nach rechts und von ' +
                        'rechts nach links)';

  DrStZIn[23].Zeile  := 13;
  DrStZIn[23].Mld    := 'LRand  :';
  DrStZIn[23].Mld25  := 'Linken Rand setzen';

  DrStZIn[24].Zeile  := 14;
  DrStZIn[24].Mld    := 'RRand  :';
  DrStZIn[24].Mld25  := 'Rechten Rand setzen';

  DrStZIn[25].Zeile  := 15;
  DrStZIn[25].Mld    := 'ZA Zoll:';
  DrStZIn[25].Mld25  := 'Zeilenabstand auf n/72 Zoll';

  DrStZIn[26].Zeile  := 16;
  DrStZIn[26].Mld    := 'Fl Zei.:';
  DrStZIn[26].Mld25  := 'Formularlnge auf n Zeilen';

  DrStZIn[27].Zeile  := 17;
  DrStZIn[27].Mld    := 'Fl Zoll:';
  DrStZIn[27].Mld25  := 'Formularlnge auf n Zoll';

  DrStZIn[28].Zeile  := 18;
  DrStZIn[28].Mld    := 'Langs.+:';
  DrStZIn[28].Mld25  := 'Langsamdruck einschalten';

  DrStZIn[29].Zeile  := 19;
  DrStZIn[29].Mld    := 'Langs.-:';
  DrStZIn[29].Mld25  := 'Langsamdruck ausschalten ' +
                        '(Wieder normale ' +
                        'Druckgeschwindigkeit)';

  DrStZIn[30].Zeile  := 20;
  DrStZIn[30].Mld    := 'ZS USA :';
  DrStZIn[30].Mld25  := 'Zeichensatz USA';

  DrStZIn[31].Zeile  := 21;
  DrStZIn[31].Mld    := 'ZS FR  :';
  DrStZIn[31].Mld25  := 'Zeichensatz France';

  DrStZIn[32].Zeile  := 7;
  DrStZIn[32].Mld    := 'ZS GR  :';
  DrStZIn[32].Mld25  := 'Zeichensatz Germany';

  DrStZIn[33].Zeile  := 8;
  DrStZIn[33].Mld    := 'ZS UK  :';
  DrStZIn[33].Mld25  := 'Zeichensatz England';

  DrStZIn[34].Zeile  := 9;
  DrStZIn[34].Mld    := 'ZS S   :';
  DrStZIn[34].Mld25  := 'Zeichensatz Sweden';

  DrStZIn[35].Zeile  := 10;
  DrStZIn[35].Mld    := 'ZS I   :';
  DrStZIn[35].Mld25  := 'Zeichensatz Italy';

  DrStZIn[36].Zeile  := 11;
  DrStZIn[36].Mld    := 'ZS Sp  :';
  DrStZIn[36].Mld25  := 'Zeichensatz Spain';

  DrStZIn[37].Zeile  := 12;
  DrStZIn[37].Mld    := 'Unter+ :';
  DrStZIn[37].Mld25  := 'Unterstreichen einschalten';

  DrStZIn[38].Zeile  := 13;
  DrStZIn[38].Mld    := 'Unter- :';
  DrStZIn[38].Mld25  := 'Unterstreichen ausschalten';

  DrStZIn[39].Zeile  := 14;
  DrStZIn[39].Mld    := 'LQ+    :';
  DrStZIn[39].Mld25  := 'Schnschrift (Letter Quality)' +
                        ' einschalten';

  DrStZIn[40].Zeile  := 15;
  DrStZIn[40].Mld    := 'LQ-    :';
  DrStZIn[40].Mld25  := 'Schnschrift (Letter Quality)' +
                        ' ausschalten';

  DrStZIn[41].Zeile  := 16;
  DrStZIn[41].Mld    := 'Hoch+  :';
  DrStZIn[41].Mld25  := 'Hochstellung (Potenzierung)' +
                        ' einschalten';

  DrStZIn[42].Zeile  := 17;
  DrStZIn[42].Mld    := 'Hoch-  :';
  DrStZIn[42].Mld25  := 'Hochstellung (Potenzierung)' +
                        ' ausschalten';

  DrStZIn[43].Zeile  := 18;
  DrStZIn[43].Mld    := 'Tief+  :';
  DrStZIn[43].Mld25  := 'Tiefstellung (Indizierung)' +
                        ' einschalten';

  DrStZIn[44].Zeile  := 19;
  DrStZIn[44].Mld    := 'Tief-  :';
  DrStZIn[44].Mld25  := 'Tiefstellung (Indizierung)' +
                        ' ausschalten';
end;
{ͻ
  DrStZInEingabeMaskePos                                  
 Ķ
  Positioniert die Eingabemaske fr die entsprechenden    
  Eingabefelder.                                          
 ͼ}
procedure DrStZInEingabeMaskePos(Anz: byte);
var i: byte;

begin
  for i:= 1 to Anz do
  begin
    _Go(DrStZIn[i].Spalte,DrStZIn[i].Zeile);
    write(DrStZIn[i].Mld);
  end; {for}
end;
{ͻ
  DtSpeichern                                             
 Ķ
  Speichert den erstellten Druckertreiber unter einem vom 
  Anwender zu vergebenden Namen auf Diskette.             
 ͼ}
procedure DtSpeichern(var Name: _WorkStr);

{Speichern}
procedure Speichern;
var f: Text;                                     {Textdatei}
    i: byte;                                  {Zhlvariable}
    Z: _WorkStr;                                {Eine Zeile}

begin
  Assign(f,Name);
  Rewrite(f);
  Z:= DrStZIn[1].Antwort;
  writeln(f,Z);
  for i:= 2 to _ZDtDatei do
  begin
    Z:= '';
    Z:= Copy(_StDtZ[i-1],1,31);
    Z:= Z + DrStZIn[i].Antwort;
    writeln(f,Z);
  end;
  Close(f);
end;
{}

begin
  Name:= _InputBox(20,23,40,0,'Dateiname (ohne Endung)',
                   Name);
  if Name <> '' then
  begin
    Name:= Name + '.DT';
    if _SaveDatei(Name,true)
     then Speichern;
  end;
end;
{ͻ
  Hilfestellung                                           
 Ķ
  Zeigt eine Hilfestellung zum Erstellen eines neuen Dt   
  auf dem Bildschirm an.                                  
 ͼ}
procedure Hilfestellung;
begin
  _BeforeHelpWin;
  if _HelpWin('HilfeDt',_SysHelpFile) then
  begin
    _CursorAus;
    _LiesChar(_Esc);
    _CursorEin;
    _SetConfigColor;
  end;
  _AfterHelpWin;
end;
{ͻ
  DrStZInEingeben                                         
 Ķ
  Steuert die Eingabe in die dafr vorgesehenen Eingabe-  
  felder.                                                 
 ͼ}
procedure DrStZInEingeben(Anz: byte; Beenden: char);
var
  Ctrl: char;                                {Fr Ctrl-Code}
  i,                                          {Laufvariable}
  j   : byte;                                 {Zhlvariable}
  Name: _WorkStr;                                {Dateiname}

begin
  i:= 1;
  Ctrl:= ' ';                                  {Anfangswert}
  Name:= '';                                   {Anfangswert}
  repeat
    DrStZIn[i].Antwort:=
       _Eingabe(DrStZIn[i].Spalte,
                DrStZIn[i].Zeile,
                DrStZIn[i].Laenge,
                DrStZIn[i].Typ,
                false,true,true,
                DrStZIn[i].Mld,
                DrStZIn[i].Antwort,
                DrStZIn[i].Mld25,
                Ctrl);
    case Ctrl of
      _Cr,_Dn: begin
                 inc(i);
                 if i > Anz then i:= 1;
               end;
      _Up    : begin
                 dec(i);
                 if i < 1 then i:= Anz;
               end;
      _F1    : Hilfestellung; {Hilfe Druckertreiber}
      _F2    : begin {Standard-Dt einlesen}
                 if _FrageBox(16,23,'','Standard-Dt ' +
                             '(Epson RX-80) einlesen') then
                 begin
                   for j:= 0 to _ZDtDatei-1 do
                   begin
                     if j = 0
                     then DrStZIn[j+1].Antwort:=
                           Copy(_StDtZ[j],1,
                                Length(_StDtZ[j]))
                     else DrStZIn[j+1].Antwort:=
                           Copy(_StDtZ[j],_SpStCode,
                                Length(_StDtZ[j]));
                     GotoXY(DrStZIn[j+1].Spalte +
                            Length(DrStZIn[j+1].Mld) + 1,
                            DrStZIn[j+1].Zeile);
                     write(DrStZIn[j+1].Antwort);
                   end;
                 end;
               end;
      _F3    : begin {Alle Felder lschen}
                 if _FrageBox(24,23,'',
                              'Alle Felder lschen') then
                 begin
                   for j:= 1 to _ZDtDatei do
                   begin
                     DrStZIn[j].Antwort:= '';
                     GotoXY(DrStZIn[j].Spalte +
                            Length(DrStZIn[j].Mld) + 1,
                            DrStZIn[j].Zeile);
                     if j = 1
                      then write(' ':25)
                      else write(' ':LenIn);
                   end;
                 end;
               end;
      _F10   : begin

                 DtSpeichern(Name);
               end;
      _PgUp  : i:= 1;
      _PgDn  : i:= Anz;
      _Esc   : begin {Ende?}
                 if not _FrageBox(24,23,'','Wirklich ' +
                              'beenden')
                 then Ctrl:= ' ';
               end;
    end; {case}
  until Ctrl = Beenden;
end;
{ͻ
  End of Unit                                             
 ͼ}
end.