{ͻ
  Unit      _Input.pas                                   
                                                         
  Compiler  Turbo Pascal 6.0                             
                                                         
  Date      03.03.90                                     
                                                         
  Update    19.06.90                                     
                                                         
  Autor     Reiner Schlles                              
 Ķ
  Inhalt    Vereinbarung von Konstanten fr Funktions-   
            und Sondertasten. Routinen zur Eingabe in ein
            oder mehrere Eingabefelder.                  
 ͼ}
Unit _Input;
{ͻ
  Interface (ffentlicher Teil)                           
 ͼ}
Interface
uses {Einzubindende Bibliotheken}
  Crt,                    {Unit aus dem Turbo Pascal-System}
  _Declare;                        {Unit aus dem Unitsystem}

type {Globale Datentypen}
  {Ŀ
    Jedes Eingabefeld ist durch den Datentyp 
    _InputRec eindeutig festgelegt. Es fehlt 
    nur noch der entsprechende Ctrl-Code.    
   }
  _InputRec = record
    Antwort      : _WorkStr;
    Spalte,Zeile,
    Laenge,Typ   : byte;
    Anf,Inv,Ret  : boolean;
    Mld,VorAnt,
    Mld25        : _WorkStr;
  end;

const {Globale Konstanten}
  _F1  =  #250;     _ShiftF1  =  #240;    _CtrlF1  =  #230;
  _F2  =  #249;     _ShiftF2  =  #239;    _CtrlF2  =  #229;
  _F3  =  #248;     _ShiftF3  =  #238;    _CtrlF3  =  #228;
  _F4  =  #247;     _ShiftF4  =  #237;    _CtrlF4  =  #227;
  _F5  =  #246;     _ShiftF5  =  #236;    _CtrlF5  =  #226;
  _F6  =  #245;     _ShiftF6  =  #235;    _CtrlF6  =  #224;
  _F7  =  #244;     _ShiftF7  =  #234;    _CtrlF7  =  #223;
  _F8  =  #243;     _ShiftF8  =  #233;    _CtrlF8  =  #222;
  _F9  =  #242;     _ShiftF9  =  #232;    _CtrlF9  =  #221;
  _F10 =  #241;     _ShiftF10 =  #231;    _CtrlF10 =  #220;

  _AltF1  = #219;   _AltQ = #209;     _AltA = #199;
  _AltF2  = #218;   _AltW = #208;     _AltS = #198;
  _AltF3  = #217;   _AltE = #207;     _AltD = #197;
  _AltF4  = #216;   _AltR = #206;     _AltF = #196;
  _AltF5  = #215;   _AltT = #205;     _AltG = #195;
  _AltF6  = #214;   _AltY = #204;     _AltH = #194;
  _AltF7  = #213;   _AltU = #203;     _AltJ = #193;
  _AltF8  = #212;   _AltI = #202;     _AltK = #192;
  _AltF9  = #211;   _AltO = #201;     _AltL = #191;
  _AltF10 = #210;   _AltP = #200;


  _AltZ = #190;     _Alt1  = #183;    _Home  = #173;
  _AltX = #189;     _Alt2  = #182;    _PgUp  = #172;
  _AltC = #188;     _Alt3  = #181;    _End   = #171;
  _AltV = #187;     _Alt4  = #180;    _PgDn  = #170;
  _AltB = #186;     _Alt5  = #179;    _Ins   = #163;
  _AltN = #185;     _Alt6  = #178;    _Del   = #162;
  _AltM = #184;     _Alt7  = #177;    _Up    = #161;
                    _Alt8  = #176;    _Dn    = #160;
                    _Alt9  = #175;    _Right = #159;
                    _Alt0  = #174;    _Left  = #158;

  _CtrlLeft  = #169;   _CtrlPrtSc = #165;
  _CtrlRight = #168;   _Esc       = #164;
  _CtrlEnd   = #167;
  _CtrlPgDn  = #166;   _Cr        =  ^M;
  _CtrlHome  = #157;   _Bsp       =  ^H;

  CMld25: byte = Yellow;               {Farbe Mld 25. Zeile}

  {Verzeichnis der globalen Routinen}

  function _Readkey: char;
  function _Eingabe(Sp,Zeile,Laenge: byte;
                           Datentyp: byte;
                                Anf: boolean;
                                Inv: boolean;
                                Ret: boolean;
                                Mld: _WorkStr;
                             VorAnt: _WorkStr;
                              Mld25: _WorkStr;
              var CtrlTaste : char): _WorkStr;

{ͻ
  Implementation (Nicht-ffentlicher Teil)                
 ͼ}
Implementation
uses {Einzubindende Bibliotheken}
 _Fehler,_Check,
 _IO,_Windows,_Help;              {Units aus dem Unit-System}

{ͻ
  _Readkey                                                
 Ķ
  Erweitert die Routine Readkey aus der Unit Crt um die   
  Mglichkeit, sowohl Funktionstasten als auch Sonder-    
  tasten abzufragen.                                      
 ͼ}
function _Readkey: char;
const Esc = #27;
var   ch  : char;

{FunktionsTaste}
procedure FunktionsTaste(cch: char);
begin
  case cch of
    #59: ch:= _F1;  #84: ch:= _ShiftF1;  #94: ch:= _CtrlF1;
    #60: ch:= _F2;  #85: ch:= _ShiftF2;  #95: ch:= _CtrlF2;
    #61: ch:= _F3;  #86: ch:= _ShiftF3;  #96: ch:= _CtrlF3;
    #62: ch:= _F4;  #87: ch:= _ShiftF4;  #97: ch:= _CtrlF4;
    #63: ch:= _F5;  #88: ch:= _ShiftF5;  #98: ch:= _CtrlF5;
    #64: ch:= _F6;  #89: ch:= _ShiftF6;  #99: ch:= _CtrlF6;
    #65: ch:= _F7;  #90: ch:= _ShiftF7;  #100:ch:= _CtrlF7;
    #66: ch:= _F8;  #91: ch:= _ShiftF8;  #101:ch:= _CtrlF8;
    #67: ch:= _F9;  #92: ch:= _ShiftF9;  #102:ch:= _CtrlF9;
    #68: ch:= _F10; #93: ch:= _ShiftF10; #103:ch:=_CtrlF10;

    #104: ch:= _AltF1;       #120: ch:= _Alt1;
    #105: ch:= _AltF2;       #121: ch:= _Alt2;
    #106: ch:= _AltF3;       #122: ch:= _Alt3;
    #107: ch:= _AltF4;       #123: ch:= _Alt4;
    #108: ch:= _AltF5;       #124: ch:= _Alt5;
    #109: ch:= _AltF6;       #125: ch:= _Alt6;
    #110: ch:= _AltF7;       #126: ch:= _Alt7;
    #111: ch:= _AltF8;       #127: ch:= _Alt8;
    #112: ch:= _AltF9;       #128: ch:= _Alt9;
    #113: ch:= _AltF10;      #129: ch:= _Alt0;

    #16: ch:= _AltQ;   #30: ch:= _AltA;   #44: ch:= _AltZ;
    #17: ch:= _AltW;   #31: ch:= _AltS;   #45: ch:= _AltX;
    #18: ch:= _AltE;   #32: ch:= _AltD;   #46: ch:= _AltC;
    #19: ch:= _AltR;   #33: ch:= _AltF;   #47: ch:= _AltV;
    #20: ch:= _AltT;   #34: ch:= _AltG;   #48: ch:= _AltB;
    #21: ch:= _AltY;   #35: ch:= _AltH;   #49: ch:= _AltN;
    #22: ch:= _AltU;   #36: ch:= _AltJ;   #50: ch:= _AltM;
    #23: ch:= _AltI;   #37: ch:= _AltK;
    #24: ch:= _AltO;   #38: ch:= _AltL;
    #25: ch:= _AltP;

    #71: ch:= _Home;   #114: ch:= _CtrlPrtSc;
    #73: ch:= _PgUp;   #115: ch:= _CtrlLeft;
    #79: ch:= _End;    #116: ch:= _CtrlRight;
    #81: ch:= _PgDn;   #117: ch:= _CtrlEnd;
    #82: ch:= _Ins;    #118: ch:= _CtrlPgDn;
    #83: ch:= _Del;    #119: ch:= _CtrlHome;
    #72: ch:= _Up;
    #80: ch:= _Dn;
    #77: ch:= _Right;
    #75: ch:= _Left;
  end; { case }
end;
{}

begin
  ch:= Readkey;
  if ch <> #0 then begin end
              else FunktionsTaste(Readkey);
  if ch = Esc then ch:= _Esc;
  if ch = ^M  then ch:= _Cr;
  if ch = ^H  then ch:= _Bsp;
  _Readkey:= ch;
end;
{ͻ
  _Eingabe                                                
 Ķ
  bernimmt die Eingabe in ein Eingabefeld. In der Variab-
  len CtrlTaste wird ein evtl. Ctrl-Code, der die Eingabe 
  abbricht, gespeichert. Der Ctrl-Code entspricht einer   
  der in dieser Unit vereinbarten Konstanten. Das verwen- 
  dete Editor-Kommando ^T entspricht in seiner Wirkungs-  
  weise nicht genau dem aus WordStar, kommt diesem aber   
  am nchsten.                                            
  Auerdem kann der entsprechende Datentyp der Eingabe    
  vorgegeben werden. Dabei gelten folgende Werte:         
                                                          
           0 Datentyp _WorkStr (String der Lnge 79)      
           1 Datentyp Real     (Dezimalzahl)              
           2 Datentyp Integer  (Ganze Zahl)               
           3 Datentyp Datum                               
           4 Datentyp Uhrzeit                             
           5 Datentyp Boolean  (<J>,<N>/Ja,Nein)          
 ͼ}
function _Eingabe(Sp,Zeile,Laenge: byte;
                         Datentyp: byte;
                              Anf: boolean;
                              Inv: boolean;
                              Ret: boolean;
                              Mld: _WorkStr;
                           VorAnt: _WorkStr;
                            Mld25: _WorkStr;
            var CtrlTaste : char): _WorkStr;

const
  MaxDatentyp = 5;                       {Hchster Datentyp}

var
  i      : 0..79;                          {Cursor-Position}
  ch     : char;                   {Das eingegebene Zeichen}
  Antwort: _WorkStr;
  Spalte : byte;                      {Sp + length(Mld) + 1}
  Ende   : boolean;                        {Eingabe beenden}

{WriteMld25}
procedure WriteMld25;
var x: byte;                               {Position Spalte}

begin
  if Mld25 <> '' then
  begin
    Gotoxy(1,25);
    ClrEol;
    x:= 1 + Trunc(39-(Length(Mld25)/2));
    _WriteColor(x,25,CMld25,Mld25);
  end;
end;
{DeleteMld25}
procedure DeleteMld25;
begin
  if Mld25 <> '' then
  begin
    Gotoxy(1,25);
    ClrEol;
  end;
end;
{AntwortErneuern}
procedure AntwortErneuern;
begin
  _Write(Spalte,Zeile,Antwort);
  _horizontale(Spalte+Length(Antwort),Zeile,
                Laenge-(Length(Antwort)),32);
end;
{InversBeginnen}
procedure InversBeginnen;
begin
  if Inv then
  begin
    TextBackground(_Config.Vordergrund);
    TextColor(_Config.Vordergrund);
    _Horizontale(Spalte,Zeile,Laenge,32);
    GotoXY(Spalte,Zeile);
    TextColor(_Config.Hintergrund);
  end;
end;
{InversBeenden}
procedure InversBeenden;
begin
  if Inv then
  begin
    TextBackground(_Config.Hintergrund);
    TextColor(_Config.Hintergrund);
    _Horizontale(Spalte,Zeile,Laenge,32);
    TextColor(_Config.Vordergrund);
    AntwortErneuern;
  end;
end;
{BachspaceTaste}
procedure BachspaceTaste;
begin
  if _IntRange(1,Length(Antwort),i) then
  begin
    Delete(Antwort,I,1);
    dec(i);
    AntwortErneuern;
    GotoXY(Spalte+i,Zeile);
  end;
end;
{SpezielleTaste}
procedure SpezielleTaste;
{Loeschen - innerhalb von SpezielleTaste}
procedure Loeschen;
begin
  if _IntRange(1,Length(Antwort),Length(Antwort)) and
     _IntRange(0,Length(Antwort)-1,i)
     then Delete(Antwort,i+1,1);
end;
{Einfuegen - innerhalb von SpezielleTaste}
procedure Einfuegen;
begin
  if _IntRange(0,Laenge-1,Length(Antwort))
  then Antwort:= Concat(copy(Antwort,1,i),' ',
                        copy(Antwort,i+1,Laenge));
end;
{}

begin {SpezielleTaste}
  case ch of
    {_Home, _Left, _Right, _End bewegen}
    {nur den Cursor in der Zeile}
    _Home : i:= 0;                            {Anfang Zeile}
    _Left : if _IntRange(1,Length(Antwort),i)
              then dec(i)               {Zeichen nach links}
              else _SignalTon(1);
    _Right: if _IntRange(0,Length(Antwort)-1,i)
              then inc(i)              {Zeichen nach rechts}
              else _SignalTon(1);
    _End  : i:= Length(Antwort);                {Ende Zeile}
    {_Del, _Ins, ^Y, ^T verndern die Antwort}
    _Del  : Loeschen;
    _Ins  : Einfuegen;
    ^T    : Antwort:= Copy(Antwort,1,i);
    ^Y    : begin
              i:= 0;
              Antwort:= '';
            end;
  end; {case}
  if ch in [_Del,_Ins,^T,^Y]
  then AntwortErneuern;
end;
{FeldVerlassen}
procedure FeldVerlassen;
begin
  CtrlTaste:= ch;                        {Zeichen Speichern}
  Ende:= true;
end;
{NormaleTaste}
procedure NormaleTaste;
begin
  if _IntRange(0,Length(Antwort)-1,i)
  then begin
         _Write(Spalte+i,Zeile,ch);
         inc(i);
         Antwort[I]:= CH;
       end
  else begin
         if _IntRange(0,Laenge-1,Length(Antwort))
         then begin
                _Write(Spalte+i,Zeile,ch);
                inc(i);
                Antwort:= Antwort+ch;
                if (i = Laenge) and not Ret then
                begin
                  AntwortErneuern;
                  ch:= _Cr;
                  FeldVerlassen;
                end;
              end;
       end; {else}
end;
{EingabeVorbereiten}
procedure EingabeVorbereiten;
begin
  if not _IntRange(0,MaxDatentyp,Datentyp)  {Ung. Datentyp,}
   then Datentyp:= 0;               {dann _WorkStr annehmen}
  case Datentyp of
    3: Laenge:= 10;                  {Wenn Datentyp = Datum}
    4: Laenge:=  8;                {Wenn Datentyp = Uhrzeit}
    5: Laenge:=  1;                {Wenn Datentyp = Boolean}
  end; {case}
  Spalte:= Sp + Length(Mld) + 1;
  Antwort:= '';                         {Noch keine Antwort}
  _Write(Sp,Zeile,Mld);
  AntwortErneuern;
  if Anf
   then i:= 0                              {Anfangsposition}
   else i:= Length(VorAnt);
  GotoXY(Spalte,Zeile);
  Antwort:= VorAnt;                     {Antwort bernehmen}
  InversBeginnen;
  AntwortErneuern;
  GotoXY(Spalte+i,Zeile);             {Cursor positionieren}
  Ende:= false;                            {Bitte eingeben!}
end;
{DatumPruefen}
procedure DatumPruefen;
var
  Datum: _Str10;                          {Datum als String}

begin
  Datum:= _DateToStr(_StrToInteger(copy(Antwort,1,2)),
                     _StrToInteger(copy(Antwort,4,2)),
                     _StrToInteger(copy(Antwort,7,4)));
  if Datum = '00.00.0000'
  then begin                           {Eingabe wiederholen}
         Ende:= false;
         _Fehlerton;
       end
  else Antwort:= Datum;
end;
{UhrzeitPruefen}
procedure UhrzeitPruefen;
var
  Uhrzeit: _Str8;                       {Uhrzeit als String}
  hh,mm,ss: integer;                 {Stunde,Minute,Sekunde}
  E1,E2,E3: byte;         {Fehler bei Stunde,Minute,Sekunde}

begin
  hh:= _StrToInteger(copy(Antwort,1,2));
  E1:= _ErrorResult;
  mm:= _StrToInteger(copy(Antwort,4,2));
  E2:= _ErrorResult;
  ss:= _StrToInteger(copy(Antwort,7,2));
  E3:= _ErrorResult;
  Uhrzeit:= _TimeToStr(hh,mm,ss,0,true,false);
  if (Uhrzeit = '00:00:00')            {Eingabe wiederholen}
   or (E1 <> 0) or (E2 <> 0) or (E3 <> 0)
  then begin
         Ende:= false;
         _Fehlerton;
       end
  else Antwort:= Uhrzeit;
end;
{BooleanPruefen}
procedure BooleanPruefen;
begin
  Antwort[1]:= Upcase(Antwort[1]);
  if (Antwort[1] <> 'J') and
     (Antwort[1] <> 'N') then
  begin
    Ende:= false;
    _Fehlerton;
  end;
end;
{DatentypPruefen}
procedure DatentypPruefen;
var
  RealZahl: real;                        {Fr Konvertierung}
  IntZahl : integer;                     {     - " -       }

begin
  case Datentyp of
    0: begin {Keine berprfung, da Datentyp _WorkStr} end;
    1: RealZahl:= _StrToReal(Antwort);       {Datentyp Real}
    2: IntZahl:= _StrToInteger(Antwort);  {Datentyp Integer}
    3: DatumPruefen;                        {Datentyp Datum}
    4: UhrzeitPruefen;                    {Datentyp Uhrzeit}
    5: BooleanPruefen;                    {Datentyp Boolean}
  end; {case}
  if _IntRange(1,2,Datentyp) then
    if _ErrorResult <> 0 then
    begin
      Ende:= false; {Eingabe wiederholen! Falscher Datentyp}
      _Fehlerton;
    end;
end;
{Hilfestellung}
procedure Hilfestellung;
begin
  _BeforeHelpWin;
  if _HelpWin('HilfeEingabefeld',
              _SysHelpFile) then
  begin
    _Write(3,2,Chr(26));               {Pfeile nachtrglich}
    _Write(3,3,Chr(27));                         {schreiben}
    _Write(3,4,Chr(24));
    _Write(3,5,Chr(25));
    _CursorAus;
    _LiesChar(_Esc);
    _CursorEin;
  end;
  _AfterHelpWin;
  TextColor(_Config.Hintergrund);         {Wieder inverse}
  TextBackGround(_Config.Vordergrund);       {Darstellung}
end;
{}

begin
  WriteMld25;
  EingabeVorbereiten;
  while not Ende do
  begin
    ch:= _Readkey;                       {Ein Zeichen lesen}
    case ch of
      _Right,_Left,_Home,_End,
      _Del,_Ins,^Y,^T           : SpezielleTaste;

      _Bsp                      : BachspaceTaste;

      _AltH                     : Hilfestellung;

      _F1,   _ShiftF1,   _CtrlF1,   _AltF1,
      _F2,   _ShiftF2,   _CtrlF2,   _AltF2,
      _F3,   _ShiftF3,   _CtrlF3,   _AltF3,
      _F4,   _ShiftF4,   _CtrlF4,   _AltF4,
      _F5,   _ShiftF5,   _CtrlF5,   _AltF5,
      _F6,   _ShiftF6,   _CtrlF6,   _AltF6,
      _F7,   _ShiftF7,   _CtrlF7,   _AltF7,
      _F8,   _ShiftF8,   _CtrlF8,   _AltF8,
      _F9,   _ShiftF9,   _CtrlF9,   _AltF9,
      _F10,  _ShiftF10,  _CtrlF10,  _AltF10,

     _AltQ,   _AltA,     _AltZ,     _Alt1,
     _AltW,   _AltS,     _AltX,     _Alt2,
     _AltE,   _AltD,     _AltC,     _Alt3,
     _AltR,   _AltF,     _AltV,     _Alt4,
     _AltT,   _AltG,     _AltB,     _Alt5,
     _AltY,              _AltN,     _Alt6,
     _AltU,   _AltJ,     _AltM,     _Alt7,
     _AltI,   _AltK,                _Alt8,
     _AltO,   _AltL,                _Alt9,
     _AltP,                         _Alt0,

     _Esc,    _CtrlLeft,           _CtrlPrtSc,
     _PgUp,   _CtrlRight,          _CtrlPgDn,
     _PgDn,   _CtrlEnd,
     _Cr,     _CtrlHome,
     _Up,
     _Dn                        : FeldVerlassen;

      else NormaleTaste;
    end; {case}
    GotoXY(Spalte+i,Zeile);
    if Ende then DatentypPruefen;
  end; {while}
  InversBeenden;
  _Eingabe:= Antwort;
  DeleteMld25;
end;
{ͻ
  End of Unit                                             
 ͼ}
end.

{

  Hier folgen "halbfertige" Routinen zur Bearbeitung mehre-
  rer Eingabefelder, die in einem Zusammenhang stehen (z.B.
  die Felder Name, Vorname, Strasse, PLZ, Ort und Telefon-
  nummer einer Adresse).
  Die Routinen mssen an Ihre eigenen Bedrfnisse angepat
  werden, sind jedoch bereits soweit vorbereitet, da die
  Schreibarbeit auf ein Minimum reduziert wird. Der Typ der
  Eingabedaten ist auf _WorkStr (0) voreingestellt. Er mu
  eventuell angepat werden (Real oder Integer).
  Der Ausdruck <Name> dient nachfolgend als Platzhalter und
  mu in Ihren eigenen Anwendungen entsprechend ersetzt
  werden (am besten mit der "Suche- und Ersetze-Funktion"
  des Pascal-Systems!).
  Kopieren Sie die nachfolgenden Teile in Ihr aufrufendes
  Programm. Nehmen Sie anschlieend die Anpassungen und
  Vernderungen vor.
  Ein vollstndiges Beispiel, mit Anleitung zum Vorgehen,
  finden Sie im Buch im Kapitel zu dieser Unit!

  }

const
  <Name>Anz = ?;                      {Anzahl Eingabefelder}

var
  <Name>: array[1..<Name>Anz] of _InputRec;

{ͻ
  <Name>FelderInit                                        
 Ķ
  Initialisiert die Eingabefelder der entsprechenden Vari-
  ablen. Diese Routine mu stets aufgerufen werden, bevor 
  die Eingabemaske positioniert und Eingaben in die ent-  
  sprechenden Felder vorgenommen werden. Sechs Felder sind
  bereits vordefiniert. Werden mehr Felder bentigt,      
  mssen Felder hinzugefgt, andernfalls Felder entfernt  
  werden.                                                 
 ͼ}
procedure <Name>FelderInit;
begin
  <Name>[1].Antwort:= '';
  <Name>[1].Spalte := ;
  <Name>[1].Zeile  := ;
  <Name>[1].Laenge := ;
  <Name>[1].Typ    := 0;                 {Datentyp _WorkStr}
  <Name>[1].Anf    := false;
  <Name>[1].Inv    := true;
  <Name>[1].Ret    := true;
  <Name>[1].Mld    := '';
  <Name>[1].VorAnt := <Name>[1].Antwort;
  <Name>[1].Mld25  := '';

  <Name>[2].Antwort:= '';
  <Name>[2].Spalte := ;
  <Name>[2].Zeile  := ;
  <Name>[2].Laenge := ;
  <Name>[2].Typ    := 0;                 {Datentyp _WorkStr}
  <Name>[2].Anf    := false;
  <Name>[2].Inv    := true;
  <Name>[2].Ret    := true;
  <Name>[2].Mld    := '';
  <Name>[2].VorAnt := <Name>[2].Antwort;
  <Name>[2].Mld25  := '';

  <Name>[3].Antwort:= '';
  <Name>[3].Spalte := ;
  <Name>[3].Zeile  := ;
  <Name>[3].Laenge := ;
  <Name>[3].Typ    := 0;                 {Datentyp _WorkStr}
  <Name>[3].Anf    := false;
  <Name>[3].Inv    := true;
  <Name>[3].Ret    := true;
  <Name>[3].Mld    := '';
  <Name>[3].VorAnt := <Name>[3].Antwort;
  <Name>[3].Mld25  := '';

  <Name>[4].Antwort:= '';
  <Name>[4].Spalte := ;
  <Name>[4].Zeile  := ;
  <Name>[4].Laenge := ;
  <Name>[4].Typ    := 0;                 {Datentyp _WorkStr}
  <Name>[4].Anf    := false;
  <Name>[4].Inv    := true;
  <Name>[4].Ret    := true;
  <Name>[4].Mld    := '';
  <Name>[4].VorAnt := <Name>[4].Antwort;
  <Name>[4].Mld25  := '';

  <Name>[5].Antwort:= '';
  <Name>[5].Spalte := ;
  <Name>[5].Zeile  := ;
  <Name>[5].Laenge := ;
  <Name>[5].Typ    := 0;                 {Datentyp _WorkStr}
  <Name>[5].Anf    := false;
  <Name>[5].Inv    := true;
  <Name>[5].Ret    := true;
  <Name>[5].Mld    := '';
  <Name>[5].VorAnt := <Name>[5].Antwort;
  <Name>[5].Mld25  := '';

  <Name>[6].Antwort:= '';
  <Name>[6].Spalte := ;
  <Name>[6].Zeile  := ;
  <Name>[6].Laenge := ;
  <Name>[6].Typ    := 0;                 {Datentyp _WorkStr}
  <Name>[6].Anf    := false;
  <Name>[6].Inv    := true;
  <Name>[6].Ret    := true;
  <Name>[6].Mld    := '';
  <Name>[6].VorAnt := <Name>[6].Antwort;
  <Name>[6].Mld25  := '';
end;
{ͻ
  <Name>EingabeMaskePos                                   
 Ķ
  Positioniert die Eingabemaske fr die entsprechenden    
  Eingabefelder. Die Anzahl der Felder mu in Form eines  
  Parameters bergeben werden.                            
 ͼ}
procedure <Name>EingabeMaskePos(<Name>Anz: byte);
var i: byte;

begin
  for i:= 1 to <Name>Anz do
  begin
    _Go(<Name>[i].Spalte,<Name>[i].Zeile);
    write(<Name>[i].Mld);
    write(' ',<Name>[i].VorAnt);
  end; {for}
end;
{ͻ
  <Name>Eingeben                                          
 Ķ
  Steuert, nur mit den notwendigsten Funktionen, die Ein- 
  gabe in die dafr vorgesehenen Eingabefelder. Diese     
  Routine mu auf jeden Fall an Ihre eigenen Bedrfnisse  
  angepat werden. Die Anzahl der Eingabefelder und der   
  Abbruchcode mssen der Prozedur bergeben werden.       
 ͼ}
procedure <Name>Eingeben(<Name>Anz: byte; Beenden: char);
var
  Ctrl: char;                                {Fr Ctrl-Code}
  i   : byte;                                 {Laufvariable}

begin
  i:= 1;
  repeat
    <Name>[i].Antwort:= _Eingabe(<Name>[i].Spalte,
                                 <Name>[i].Zeile,
                                 <Name>[i].Laenge,
                                 <Name>[i].Typ,
                                 <Name>[i].Anf,
                                 <Name>[i].Inv,
                                 <Name>[i].Ret,
                                 <Name>[i].Mld,
                                 <Name>[i].Antwort,
                                 <Name>[i].Mld25,
                                 Ctrl);
    case Ctrl of
      _Cr,_Dn: begin
                 inc(i);
                 if i > <Name>Anz then i:= 1;
               end;
      _Up    : begin
                 dec(i);
                 if i < 1 then i:= <Name>Anz;
               end;
    end; {case}
  until Ctrl = Beenden;
end;
{}
