{ͻ
  Unit      _Disk.pas                                    
                                                         
  Compiler  Turbo Pascal 6.0                             
                                                         
  Date      20.03.90                                     
                                                         
  Update    20.05.90                                     
                                                         
  Autor     Reiner Schlles                              
 Ķ
  Inhalt    Beinhaltet Routinen, die sich im weitesten   
            Sinne auf Disk/Harddisk oder Dateien be-     
            ziehen.                                      
 ͼ}
Unit _Disk;
{ͻ
  Interface (ffentlicher Teil)                           
 ͼ}
Interface
uses {Einzubindende Bibliotheken}
  _Declare;                {Unit aus dem Turbo Pascal-System}

  {Verzeichnis der globalen Routinen}

  function _FreierPlatz(Lw: char): longint;
  function _ReichtPlatz(Lw: char; Kb: longint): boolean;
  function _GesetztesLw: string;
  function _LwWechseln(Lw: string): boolean;
  function _DateiExist(Dateiname: _WorkStr): boolean;
  function _DateiErzeugen(Dateiname: _WorkStr): boolean;
  function _SaveDatei(Name : _WorkStr;
                      Exist: boolean): boolean;
  procedure _Rename(Quelle,Ziel: _WorkStr);
  function _DateiLaenge(Dateiname: _WorkStr): integer;
  procedure _ZeigeDatei(Name: _WorkStr);
  function _DateiAttr(Attr: byte): _Str5;
  function _Dir(Suchweg: _WorkStr): _WorkStr;
  function _BildAufDisk(Name   : _WorkStr;
                        Replace: boolean): boolean;
  function _BildVonDisk(Name: _WorkStr;
                         Del: boolean): boolean;

{ͻ
  Implementation (Nicht-ffentlicher Teil)                
 ͼ}
Implementation
uses {Einzubindende Bibliotheken}
  Crt,Dos,                {Units aus dem Turbo Pascal-System}
  _Check,_IO,_Input,
  _Windows,_Help;                  {Units aus dem Unitsystem}

{ͻ
  _FreierPlatz                                            
 Ķ
  Liefert den freien Speicherplatz des angegebenen Lauf-  
  werks in KByte zurck.                                  
 ͼ}
function _FreierPlatz(Lw: char): longint;
var
  Drive: word;                                    {Laufwerk}

begin
  Lw:= Upcase(Lw);
  if (Lw in ['A'..'Z']) or (Lw = '0')
  then begin                             {Gltige Laufwerke}
         if Lw = '0'           {Momentan gesetztes Laufwerk}
          then Drive:= 0
          else Drive:= Ord(Lw)-64;
         if DiskFree(Drive) = -1
           then _FreierPlatz:= 0
           else _FreierPlatz:= DiskFree(Drive) div 1024;
       end
  else _FreierPlatz:= 0;               {Ungltiges Laufwerk}
end;
{ͻ
  _ReichtPlatz                                            
 Ķ
  berprft, ob noch mindestens der angegebene Speicher-  
  platz auf dem LW verfgbar ist.                         
 ͼ}
function _ReichtPlatz(Lw: char; Kb: longint): boolean;
begin
  if _FreierPlatz(Lw) >= Kb
    then _ReichtPlatz:= true
    else _ReichtPlatz:= false;
end;
{ͻ
  _GesetztesLw                                            
 Ķ
  Ermittelt das momentan gesetzte Directory eines Lauf-   
  werks.                                                  
 ͼ}
function _GesetztesLw: string;
var
  Suchweg: string;

begin
  Suchweg:= '';                                 {Leerstring}
  {$I-}  GetDir(0,Suchweg);  {$I+}   {Momentan gesetztes Lw}
  if IoResult = 0                   {Fehlerfreie Ausfhrung}
  then begin
         if copy(Suchweg,Length(Suchweg),1) = '\'
          then Suchweg:= copy(Suchweg,1,Length(Suchweg)-1);
         _GesetztesLw:= Suchweg;
       end
  else _GesetztesLw:= 'A:';         {Sonst Lw A: annehmen!!}
end;                  {Else-Zweig wird wohl nie ausgefhrt!}
{ͻ
  _LwWechseln                                             
 Ķ
  Wechselt auf das angegebene Laufwerk/Directory, wenn    
  dieses vorhanden ist.                                   
 ͼ}
function _LwWechseln(Lw: string): boolean;
var
  AltesLw,
  NeuesLw : string;
  Lw1     : _Str1;            {1 Zeichen aus Lw-Bezeichnung}
  Laenge  : byte;

{WiederAltesLw}
procedure WiederAltesLw;
begin
  _LwWechseln:= false;                  {Lw nicht vorhanden}
  ChDir(AltesLw);                   {Wieder das alte nehmen}
end;
{}

begin
  AltesLw:= _GesetztesLw;              {Altes Lw festhalten}
  NeuesLw:= _AlleLeerEntf(Lw); {Evtl. Leerzeichen entfernen}
  Laenge:= Length(NeuesLw);
  if Laenge >= 1 then
  begin {(1)}
    {$I-}  ChDir(NeuesLw);  {$I+}              {Lw wechseln}
    if IoResult = 0                 {Fehlerfreie Ausfhrung}
    then begin {(2)}
           Lw1:= copy(NeuesLw,1,1);
           if _ReichtPlatz(Lw1[1],1)
            then _LwWechseln:= true              {Alles Ok!}
            else WiederAltesLw;
         end {if-then (2)}
    else WiederAltesLw;                 {Fehler aufgetreten}
  end {if-then (1)}
  else _LwWechseln:= false;     {Leerstring wurde bergeben}
end;
{ͻ
  _DateiExist                                             
 Ķ
  berprft, ob die angegebene Datei auf der Diskette/    
  Festplatte vorhanden ist.                               
 ͼ}
function _DateiExist(Dateiname: _WorkStr): boolean;
var
  f: file;                        {Beliebige Diskettendatei}

begin
  if length(dateiname) < 1 then dateiname:= ' ';
  assign(f,dateiname);
  {$I-} reset(f); {$I+}
  if IOResult = 0
  then begin
         _DateiExist:= true;
         close(f);
       end
  else _DateiExist:= false;
end;
{ͻ
  _DateiErzeugen                                          
 Ķ
  berprft, ob eine Datei erzeugt (neu angelegt) werden  
  kann, d.h. ob Rewrite fehlerfrei ausgefhrt werden      
  konnte. Die Datei darf noch nicht existieren, da sie    
  sonst gelscht wird.                                    
 ͼ}
function _DateiErzeugen(Dateiname: _WorkStr): boolean;
var
  f  : file;                      {Beliebige Diskettendatei}
  Err: byte;                                    {Fehlercode}

begin
  assign(f,Dateiname);
  {$I-}  rewrite(f);  {$I+}                   {Datei ffnen}
  if IoResult = 0 then
  begin
    _DateiErzeugen:= true;
    {$I-}
    close(f);                       {Datei wieder schlieen}
    erase(f);                         {Datei wieder lschen}
    {$I+}
    Err:= IOResult;                      {Ergebnis abfangen}
  end
  else _DateiErzeugen:= false;
end;
{ͻ
  _SaveDatei                                              
 Ķ
  Prft, ob die angegebene Datei (Name) gespeichert werden
  kann. Ist EXIST gleich True, wird bei einer existieren- 
  den Datei gefragt, ob berschrieben werden soll, bei    
  False wird ohne Rckfrage berschrieben.                
 ͼ}
function _SaveDatei(Name : _WorkStr;
                    Exist: boolean): boolean;
begin
  if _DateiExist(Name)
  then begin
         if Exist
         then begin
                if _FrageBox(16,23,'','Datei bereits ' +
                             'vorhanden. berschreiben')
                 then _SaveDatei:= true
                 else _SaveDatei:= false;
              end
         else _SaveDatei:= true;
       end
  else begin
         if _DateiErzeugen(Name)
         then _SaveDatei:= true
         else begin
                _SaveDatei:= false;
                _ErrorBox('Dateiname oder Laufwerk ' +
                          'nicht ok!');
              end;
       end;
end;
{ͻ
  _Rename                                                 
 Ķ
  Quelle: Dateiname der Quelldatei                        
  Ziel  : Neuer Dateiname (Zieldatei)                     
                                                          
  Einer Diskettendatei wird ein neuer Name gegeben. Die   
  Abfrage der globalen Variablen _Error gibt Auskunft, ob 
  die Operation erfolgreich war (mgliche Fehler: 2,4,5). 
 ͼ}
procedure _Rename(Quelle,Ziel: _WorkStr);
var
  f: file;

begin
  Assign(f,Quelle);
  if _DateiExist(Quelle)
  then begin
         if not _DateiExist(Ziel)
         then begin
                {$I-}              {I/O-Fehlererkennung aus}
                Rename(f,Ziel);
                {$I+}              {I/O-Fehlererkennung ein}
                if IOResult <> 0
                 then _Error:= 5;     {Ungltiger Dateiname}
              end
         else _Error:= 4;      {Zieldatei bereits vorhanden}
       end
  else _Error:= 2;              {Quelldatei nicht vorhanden}
end;
{ͻ
  _DateiLaenge                                            
 Ķ
  Ermittelt die Lnge einer (Text-)Datei in Zeilen.       
 ͼ}
function _DateiLaenge(Dateiname: _WorkStr): integer;
var
  f    : Text;                                   {Textdatei}
  Zeile: string[1];               {Nur 1. Zeichen der Zeile}
  Anz  : integer;                        {Anzahl der Zeilen}

begin
  if _DateiExist(Dateiname)
  then begin
         Anz:= 0;
         Assign(f,Dateiname);
         Reset(f);
         while not Eof(f) do
         begin
           readln(f,Zeile);
           Inc(Anz);
         end; {while}
         Close(f);
         _DateiLaenge:= Anz;
         _Error:= 0;                {Fehlerfreie Ausfhrung}
       end {if-then}
  else begin
         _DateiLaenge:= 0;
         _Error:= 1;                 {Datei nicht vorhanden}
       end; {if-else}
end;
{ͻ
  _ZeigeDatei                                             
 Ķ
  Zeigt den Inhalt einer Textdatei auf dem Bildschirm an. 
 ͼ}
procedure _ZeigeDatei(Name: _WorkStr);
const
  MaxZ = 1500;                         {Max.Anz.der Zeilen}
  Mld  = ' Anz.Zeilen:                     [F1] = Hilfe ' +
         '                     [Esc] = Ende ';

var
  f    : Text;                                   {Textdatei}
  St   : array[1..MaxZ] of ^_WorkStr;      {Feld mit Zeilen}
  Anz,                                       {Anzahl Zeilen}
  i,                                          {Zhlvariable}
  Ez,Lz: integer;        {Erste/letzte aktuelle Zeile Datei}
  ZNr  : boolean;                       {Zeilen-Nr. ein/aus}

{Hilfestellung}
procedure Hilfestellung;
begin
  _CloseWin(_MaxWin-1);           {Fensterparameter sichern}
  _BeforeHelpWin;
  if _HelpWin('HilfeZeigeDatei',
              _SysHelpFile) then
  begin
    _Write(3,2,chr(24));                  {Pfeile schreiben}
    _Write(3,3,chr(25));
    GotoXY(23,10);
    write(MaxZ:4);                {Anz.Max.Zeilen schreiben}
    _LiesChar(_Esc);
  end;
  _AfterHelpWin;
  _GotoWin(_MaxWin-1,false);         {Alte Fensterparameter}
end;
{KleineDatei}
procedure KleineDatei;
var k: integer;                               {Zhlvariable}

begin
  for k:= Ez to Lz do
  begin
    GotoXY(1,k);
    if ZNr
     then write(k:4,': ',St[k]^)
     else write(St[k]^);
  end;
  _CursorAus;
  _LiesChar(_Esc);
  _CursorEin;
end;
{DateiAufBildschirm}
procedure DateiAufBildschirm;
var
  ch: char;                                {Gedrckte Taste}
  j : integer;                                {Zhlvariable}

begin
  for j:= Ez to Lz do
  Begin
    GotoXY(1,j);
    if ZNr
     then write(j:4,': ',St[j]^)
     else write(St[j]^);
  end;
  ch:= ' ';
  _CursorAus;
  repeat
    repeat
      ch:= Upcase(_Readkey);
    until ch in [_Up,_Dn,_F1,_Home,_End,
                 _PgUp,_PgDn,'Z',_Esc];
    case ch of
      _Up  : begin
               if Ez > 1 then
               begin
                 Dec(Ez);
                 Dec(Lz);
                 GotoXY(1,1);
                 InsLine;
                 if ZNr
                  then write(Ez:4,': ',St[Ez]^)
                  else write(St[Ez]^);
               end
               else _SignalTon(1);
             end;
      _Dn  : begin
               if Lz < Anz then
               begin
                 Inc(Ez);
                 Inc(Lz);
                 GotoXY(1,1);
                 DelLine;
                 GotoXY(1,21);
                 if ZNr
                  then write(Lz:4,': ',St[Lz]^)
                  else write(St[Lz]^);
               end
               else _SignalTon(1);
             end;
      _Home: begin
               if Ez > 1 then
               begin
                 Ez:=  1;
                 Lz:= 21;
                 ClrScr;
                 for j:= Ez to Lz do
                 Begin
                   GotoXY(1,j);
                   if ZNr
                    then write(j:4,': ',St[j]^)
                    else write(St[j]^);
                 end;
               end
               else _SignalTon(1);
             end;
      _End : begin
               if Lz < Anz then
               begin
                 Ez:= Anz-20;
                 Lz:= Anz;
                 ClrScr;
                 for j:= 0 to 20 do
                 begin
                   GotoXY(1,j+1);
                   if ZNr
                    then write((Ez+j):4,': ',St[Ez+j]^)
                    else write(St[Ez+j]^);
                 end;
               end
               else _SignalTon(1);
             end;
      _PgUp: begin
               if (Ez-20) >= 1 then
               begin
                 Dec(Ez,20);
                 Dec(Lz,20);
                 ClrScr;
                 for j:= 0 to 20 do
                 begin
                   GotoXY(1,j+1);
                   if ZNr
                    then write((Ez+j):4,': ',St[Ez+j]^)
                    else write(St[Ez+j]^);
                 end;
               end
               else _SignalTon(1);
             end;
      _PgDn: begin
               if (Lz+20) <= Anz then
               begin
                 Inc(Ez,20);
                 Inc(Lz,20);
                 ClrScr;
                 for j:= 0 to 20 do
                 begin
                   GotoXY(1,j+1);
                   if ZNr
                    then write((Ez+j):4,': ',St[Ez+j]^)
                    else write(St[Ez+j]^);
                 end;
               end
               else _SignalTon(1);
             end;
      'Z'  : begin {Zeilne-Nr. ein/aus}
               if ZNr
                then ZNr:= false
                else ZNr:= true;
               ClrScr;
               for j:= 0 to 20 do
               begin
                 GotoXY(1,j+1);
                 if ZNr
                  then write((Ez+j):4,': ',St[Ez+j]^)
                  else write(St[Ez+j]^);
               end;
             end;
      _F1  : Hilfestellung;
    end; {case}
  until ch = _Esc;
  _CursorEin;
end;
{ExtensionOk}
function ExtensionOk: boolean;
var
  Dir  : DirStr;
  DName: NameStr;
  Ext  : ExtStr;

begin
  Name:= FExpand(Name);        {Dateinamen vervollstndigen}
  FSplit(Name,Dir,DName,Ext);          {Dateinamen splitten}
  if (Ext = '.EXE') or (Ext = '.COM')
   then ExtensionOk:= false
   else ExtensionOk:= true;
end;
{}

begin
  _SaveScr;                             {Bildschirm sichern}
  if ExtensionOk then
  begin
    _Clean25;
    _WriteZen(1,79,25,'Datei wird geladen...',
              false,false);
    ZNr:= false;                 {Keine Zeilen-Nr. anzeigen}
    if _DateiExist(Name) then
    begin
      {Datei einlesen}
      Assign(f,Name);
      Reset(f);
      Anz:= 0;
      while not Eof(f) and (Anz < MaxZ) do
      begin
        Inc(Anz);
        New(St[Anz]);
        readln(f,St[Anz]^);
      end; {while}
      {Window erstellen}
      ClrScr;
      Ez:=  1;                  {Erste aktuelle Zeile Datei}
      Lz:= 21;                 {Letzte aktuelle Zeile Datei}
      TextBackGround(LightCyan); {Hintergrund helles Trkis}
      _Horizontale(1,24,80,32);
      TextColor(White);
      _Write(1,24,Mld);
      if Anz <= Lz
       then _Horizontale(34,24,12,32);      {"<F1>" lschen}
      GotoXY(14,24); write(Anz:4);
      _SetConfigColor;
      _MakeWin(_MaxWin-1,1,1,80,23,1,_Config.Vordergrund,
               _Config.Hintergrund,
               '[ ' + Name + ' ]','');
      if not Eof(f) and (Anz = MaxZ)
      then _MldBox(20,19,'','Zuviele Zeilen' +
                   ' in der Quelldatei');
      close(f);                     {Datei wieder schlieen}
      {}
      if Anz <= Lz                 {Nur eine "kleine" Datei}
      then begin
             Lz:= Anz;
             KleineDatei;            {Kein Blttern mglich}
           end
      else DateiAufBildschirm;             {Zeilen anzeigen}
      for i:= 1 to Anz do
       Dispose(St[i]);      {Dyn.Variablen wieder entfernen}
    end {if}
    else _MldBox((40 - (Length(Name) div 2) - 11),23,
                 '','Datei ' + Name + ' nicht vorhanden');
  end
  else begin
         _NormWindow;
         ClrScr;
         _WriteZen(1,80,21,' Zu listende Datei: '
                   + Name + ' ',true,false);
         _ErrorBox('.COM- bzw. .EXE-Dateien knnen nicht ' +
                   'gelistet werden!');
       end;
  _RestoreScr;                    {Bildschirm wieder zurck}
  _NormWindow;                       {Volle Bildschirmgre}
end;
{ͻ
  _DateiAttr                                              
 Ķ
  Ermittelt fr einen bergebenen Byte-Wert, der sich     
  additiv aus den Konstanten der Units Dos zusammensetzt, 
  die entsprechenden Attribute einer Datei als String:    
                                                          
       ReadOnly  =  1 ($01)     Hidden   =  2 ($02)       
       SysFile   =  4 ($04)     VolumeID =  8 ($08)       
       Directory = 16 ($10)     Archive  = 32 ($20)       
                                                          
  Eine Kombination dieser Attribute kann dann folgende    
  dezimale Werte ergeben: 3,5,6,7,33,34,35,36,37,38,39.   
                                                          
  Als Ergebnis wird ein String der Lnge 5 zurckge-      
  liefert, wobei nicht gesetzte Attribute als Punkt, ge-  
  setzte mit dem entsprechenden Buchstaben dargestellt    
  werden:                                                 
  ReadOnly (r), Archive (a), SysFile (s), Hidden (h) und  
  Directory (d).                                          
 ͼ}
function _DateiAttr(Attr: byte): _Str5;
var
  AttrStr: _Str5;

begin
  AttrStr:= '.....';
  {Dateiattribute im String ablegen}
  case Attr of
    ReadOnly : AttrStr[1]:= 'r';
    Archive  : AttrStr[2]:= 'a';
    SysFile  : AttrStr[3]:= 's';
    Hidden   : AttrStr[4]:= 'h';
    Directory: AttrStr[5]:= 'd';
    33       : begin
                 AttrStr[1]:= 'r';
                 AttrStr[2]:= 'a';
               end;
    5        : begin
                 AttrStr[1]:= 'r';
                 AttrStr[3]:= 's';
               end;
    3        : begin
                 AttrStr[1]:= 'r';
                 AttrStr[4]:= 'h';
               end;
    36       : begin
                 AttrStr[2]:= 'a';
                 AttrStr[3]:= 's';
               end;
    34       : begin
                 AttrStr[2]:= 'a';
                 AttrStr[4]:= 'h';
               end;
    6        : begin
                 AttrStr[3]:= 's';
                 AttrStr[4]:= 'h';
               end;
    37       : begin
                 AttrStr[1]:= 'r';
                 AttrStr[2]:= 'a';
                 AttrStr[3]:= 's';
               end;
    35       : begin
                 AttrStr[1]:= 'r';
                 AttrStr[2]:= 'a';
                 AttrStr[4]:= 'h';
               end;
    7        : begin
                 AttrStr[1]:= 'r';
                 AttrStr[3]:= 's';
                 AttrStr[4]:= 'h';
               end;
    38       : begin
                 AttrStr[2]:= 'a';
                 AttrStr[3]:= 's';
                 AttrStr[4]:= 'h';
               end;
    39       : begin
                 AttrStr[1]:= 'r';
                 AttrStr[2]:= 'a';
                 AttrStr[3]:= 's';
                 AttrStr[4]:= 'h';
               end;
  end; {case}
  _DateiAttr:= AttrStr;
end;
{ͻ
  _Dir                                                    
 Ķ
  Zeigt auf dem Bildschirm das Inhaltsverzeichnis eines   
  externen Speichermediums (Disk/Harddisk) an, wobei max. 
  120 Eintrge gelistet werden knnen (sonst berlauf mit 
  Fehlrmeldung) und eine Datei, deren Name als Ergebnis   
  der Funktion zurckgeliefert wird, ausgewhlt werden    
  kann.                                                   
  Zwischen den Subdirectories kann beliebig gewechselt    
  werden. Der Funktion mu ein Suchweg mit Dateispezifi-  
  kation bergeben werden. Ein Leerstring setzt das       
  momentane Directory und *.* als Dateikennung.           
 ͼ}
function _Dir(Suchweg: _WorkStr): _WorkStr;
const
  {Mgliche Fehlermeldungen (DosError)}
  Err2  = '2: Datei nicht gefunden!';
  Err3  = '3: Suchweg nicht gefunden!';
  Err5  = '5: Zugriff verweigert!';
  Err6  = '6: Handle nicht definiert/ungltig!';
  Err8  = '8: Nicht gengend Platz im Speicher!';
  Err10 = '10: "Umgebungs"-Parameter ungltig!';
  Err11 = '11: Ungltiges Befehlsformat!';
  Err18 = 'Keine (weiteren) Eintrge!';

  MaxDateien = 120;                    {Maximal 120 Dateien}

type
  DirRec = record
             Sp,Zei: byte;
             Name  : _Str12;
             Attr  : _Str5;                {Attribute .....}
             Zeit  : _Str5;                        {Uhrzeit}
             Datum : _Str10;                         {Datum}
             Size  : longint;           {Dateigre in Byte}
           end;

  DirAry = array[1..MaxDateien] of DirRec;

var
  DosDir  : DirStr;                  {Directory mit Suchweg}
  Name    : NameStr;              {Dateiname ohne Extension}
  Ext     : ExtStr;                    {Extension mit Punkt}
  Datei   : DirAry;                    {Feld mit Dateinamen}
  Gewaehlt: _WorkStr;                    {Ausgewhlte Datei}
  Err     : _WorkStr;                        {Fehlermeldung}
  DosNr   : byte;                          {DosError-Nummer}
  DirEnde : boolean;                    {Diranzeige beendet}
  Anz     : byte;                      {Anzahl der Eintrge}

{ArrayInitialisieren}
procedure ArrayInitialisieren;
var Spalte,
    Zeile  : integer;
    i      : byte;

begin
  i:= 0;
  Spalte:= -11;
  for Zeile:= 3 to 22 do
  begin
    while Spalte < 67 do
    begin
      inc(Spalte,13);
      inc(i);
      Datei[i].Sp   := Spalte;
      Datei[i].Zei  := Zeile;
      Datei[i].Name := '';
      Datei[i].Attr := '.....';
      Datei[i].Zeit := '00:00';
      Datei[i].Datum:= '00.00.0000';
      Datei[i].Size := 0;
    end; {while}
    Spalte:= -11;
  end; {for}
end;
{SuchwegZerlegen}
procedure SuchwegZerlegen;
begin
  FSplit(Suchweg,DosDir,Name,Ext);
  if DosDir = '' then DosDir:= _GesetztesLW + '\';
  if Name   = '' then Name:= '*';
  if Ext    = '' then Ext := '.*';
  Suchweg:= DosDir + Name + Ext;
end;
{DateienSortieren (Bubble-Sort)}
procedure DateienSortieren(Var SortAry: DirAry; N: byte);
var
  Help: DirRec;                 {Hilfsvariable f. Datensatz}
  i,j : byte;                                 {Laufvariable}

begin
  for i:= 1 to N-1 do
  begin
    for j:= i+1 to N do
    begin
      if SortAry[i].Name > SortAry[j].Name then
      begin
        {Zuerst ganzen Datensatz vertauschen}
        Help      := SortAry[i];
        SortAry[i]:= SortAry[j];
        SortAry[j]:= Help;
        {Dann Spalte zurck tauschen}
        Help.Sp      := SortAry[i].Sp;
        SortAry[i].Sp:= SortAry[j].Sp;
        SortAry[j].Sp:= Help.Sp;
        {Dann Zeile zurck tauschen}
        Help.Zei      := SortAry[i].Zei;
        SortAry[i].Zei:= SortAry[j].Zei;
        SortAry[j].Zei:= Help.Zei;
      end; {if}
    end; {for j}
  end; {for i}
end;
{DateiInfoInAry}
procedure DateiInfoInAry(Info: SearchRec);
var
  DT: DateTime;                    {Record aus der Unit Dos}

begin
  UnpackTime(Info.Time,DT);            {Date+Time umwandeln}
  Datei[Anz].Name:= Info.Name;
  Datei[Anz].Size:= Info.Size;
  Datei[Anz].Attr:= _DateiAttr(Info.Attr);
  Datei[Anz].Zeit:= _TimeToStr(DT.Hour,DT.Min,DT.Sec,0,
                               false,false);
  Datei[Anz].Datum:= _DateToStr(DT.Day,DT.Month,DT.Year);
end;
{DateienEinlesen}
function DateienEinlesen(Var DosNr: byte): boolean;
var
  DirInfo: SearchRec;           {SearchRec aus der Unit Dos}
  j      : byte;                              {Zhlvariable}

begin
  DateienEinlesen:= true;
  Anz:= 0;                       {Noch keine Datei gefunden}
  repeat
    FindFirst(Suchweg,ReadOnly + Hidden + SysFile +
                      Directory + Archive,DirInfo);
    if DosError <> 0 then
     begin
       Gewaehlt:= '';
       DateienEinlesen:= false;
       DosNr:= DosError;
     end;
    while (DosError = 0) and (Anz < MaxDateien) do
    begin
      Inc(Anz);                        {Anzahl um 1 erhhen}
      if DirInfo.Attr = Directory             {Subdirectory}
       then DirInfo.Name:= DirInfo.Name + '\';
      if Length(DirInfo.Name) < 12
      then begin
             for j:= 1 to (12-Length(DirInfo.Name)) do
              DirInfo.Name:= DirInfo.Name + ' ';
           end;
      DateiInfoInAry(DirInfo);
      FindNext(DirInfo);
    end; {while}
  until (DosError <> 0) or (Anz = MaxDateien);
end;
{DateienAufBildschirm}
procedure DateienAufBildschirm;
const
  Mld: _WorkStr = 'berlauf: Mehr als 120 Dateien! ' +
                  'Nicht alle gelistet.';

var
  i: byte;                                    {Zhlvariable}

begin
  for i:= 1 to Anz do
    _Write(Datei[i].Sp,Datei[i].Zei,Datei[i].Name);
  if Anz = MaxDateien then _ErrorBox(Mld);
end;
{DirZurueck}
procedure DirZurueck;
begin
  DosDir:= Copy(DosDir,1,Length(DosDir)-1);
  while DosDir[Length(DosDir)] <> '\'
   do DosDir:= Copy(DosDir,1,Length(DosDir)-1);
  Suchweg:= DosDir + Name + Ext;
end;
{DirVor}
procedure DirVor;
begin
  DosDir:= DosDir + Gewaehlt;
  Suchweg:= DosDir + Name + Ext;
end;
{SchreibeDateiNormal}
procedure SchreibeDateiNormal(N: byte);
begin
 _Write(Datei[N].Sp,Datei[N].Zei,Datei[N].Name);
end;
{SchreibeDateiInvers}
procedure SchreibeDateiInvers(N: byte);
begin
  _WriteInv(Datei[N].Sp,Datei[N].Zei,Datei[N].Name);
  {Zustzliche Informationen in der 25. Zeile}
  _SetTempColor(Yellow,Black,false);
  GotoXY(1,25);
  ClrEol;
  _Write(11,25,Datei[N].Name + ':');
  if Datei[N].Attr[5] = 'd'
   then write('     <DIR>    ')
   else write(Datei[N].Size:10,'    ');
  write(Datei[N].Attr,'     ');
  write(Datei[N].Zeit,'     ');
  write(Datei[N].Datum);
  _GetOldColor(false);
end;
{DateiAuswhlen}
procedure DateiAuswaehlen;
var
  i : byte;                                   {Laufvariable}
  ch: char;                                          {Taste}

begin
  i:= 1;                                       {Anfangswert}
  SchreibeDateiInvers(i);
  _CursorAus;
  repeat
    repeat
      ch:= _Readkey;
      case ch of
        _Right: begin
                  SchreibeDateiNormal(i);
                  Inc(i);
                  if i > Anz then i:= 1;
                  SchreibeDateiInvers(i);
                end;
        _Left : begin
                  SchreibeDateiNormal(i);
                  Dec(i);
                  if i < 1 then i:= Anz;
                  SchreibeDateiInvers(i);
                end;
        _Up   : begin
                  if (i-6) >= 1 then
                  begin
                    SchreibeDateiNormal(i);
                    Dec(i,6);
                    SchreibeDateiInvers(i);
                  end; {if}
                end;
        _Dn   : begin
                  if (i+6) <= Anz then
                  begin
                    SchreibeDateiNormal(i);
                    Inc(i,6);
                    SchreibeDateiInvers(i);
                  end; {if}
                end;
        _Home : begin
                  SchreibeDateiNormal(i);
                  i:= 1;
                  SchreibeDateiInvers(i);
                end;
        _End  : begin
                  SchreibeDateiNormal(i);
                  i:= Anz;
                  SchreibeDateiInvers(i);
                end;
        _Esc  : Begin
                  Gewaehlt:= '';
                  DirEnde:= true;
                end;
        _Cr   : begin
                  Gewaehlt:= _AlleLeerEntf(Datei[i].Name);
                  if Gewaehlt[Length(Gewaehlt)] = '\'
                  then begin
                         if Gewaehlt = '.\'
                          then ch:= ' '
                          else begin
                                 if Gewaehlt = '..\'
                                  then DirZurueck
                                  else DirVor;
                                  SuchwegZerlegen;
                               end;
                       end
                  else begin
                         DirEnde:= true;
                         Gewaehlt:= DosDir + Gewaehlt;
                       end;
                end;
      end; {case}
    until ch in [_Right,_Left,_Up,_Dn,_Home,_End,_Cr,_Esc];
  until ch in [_Cr,_Esc];
  _CursorEin;
end;
{}

begin
  SuchwegZerlegen;
  DirEnde:= false;
  _SaveScr;
  repeat
    Clrscr;                             {Bildschirm lschen}
    TextBackground(LightCyan);   {Hintergrund helles Trkis}
    _Horizontale(1,1,80,32);
    _Horizontale(1,24,80,32);
    Textcolor(White);                     {Vordergrund Wei}
    _WriteZen(1,79,1,'Inhaltsverzeichnis von: ' +
              Suchweg,false,false);
    _WriteZen(1,79,24,'Positionieren: ' + Chr(24) + ' ' +
              Chr(25) + ' ' + Chr(26) + ' ' + Chr(27) +
              ' <Home>,<End>     Auswhlen: <CR>' +
              '     Abbruch: <ESC>',
              false,false);
    _SetConfigColor;
    ArrayInitialisieren;
    if DateienEinlesen(DosNr)
    then begin
           DateienSortieren(Datei,Anz);
           DateienAufBildschirm;
           DateiAuswaehlen;
         end {if}
    else begin
           case DosNr of
              2: Err:= Err2;
              3: Err:= Err3;
              5: Err:= Err5;
              6: Err:= Err6;
              8: Err:= Err8;
             10: Err:= Err10;
             11: Err:= Err11;
             18: Err:= Err18;
             else Err:='Undefinierter Fehler ' +
                       '(Z.B.: Laufwerk nicht bereit)!';
           end; {case}
           if DosNr = 18
            then _MldBox(23,11,'>> Hinweis <<',Err)
            else _ErrorBox(Err);
           DirEnde:= true;
         end; {else}
  until DirEnde;
  _RestoreScr;
  _Dir:= Gewaehlt;                       {Ausgewhlte Datei}
end;
{ͻ
  _BildAufDisk                                            
 Ķ
  Speichert einen Bildschirminhalt auf Disk/Harddisk. Der 
  Name der Diskettendatei mu ohne Endung bergeben wer-  
  den, er wird um den Zusatz .SCR ergnzt. Es kann ange-  
  geben werden, ob eine bereits existierende Datei ber-  
  schrieben werden soll.                                  
 ͼ}
function _BildAufDisk(Name   : _WorkStr;
                      Replace: boolean): boolean;

var
  f : File of _Bildschirm;                  {Diskettendatei}
  Lw: _Str1;                        {Laufwerk zum Speichern}

{SpeicherVersuch}
procedure SpeicherVersuch;
begin
  if (_ReichtPlatz(Lw[1],4)) and (_DateiErzeugen(Name))
  then begin
         Rewrite(f);
         if _Farbmonitor then write(f,_Farb)
                         else write(f,_Mono);
         close(f);
         _BildAufDisk:= true;            {Datei gespeichert}
       end
  else _BildAufDisk:= false;             {Nicht gespeichert}
end;
{}

begin
  Name:= Name + 'SCR';                {Endung wird angefgt}
  if Name[2] = ':'
   then Lw:= Name[1]
   else Lw:= copy(_GesetztesLw,1,1);
  Assign(f,Name);
  if Replace
  then SpeicherVersuch
  else begin
         if _DateiExist(Name)
          then _BildAufDisk:= false      {Nicht gespeichert}
          else SpeicherVersuch;
       end;
end;
{ͻ
  _BildVonDisk                                            
 Ķ
  Ldt einen mit _BildAufDisk gespeicherten Bildschirmin- 
  halt direkt in den Bildschirmspeicher. Konnte die Datei 
  geladen werden, ist das Ergebnis der Funktion True,     
  False. Ist DEL = True, wird die Datei anschlieend ge-  
  lscht.                                                 
 ͼ}
function _BildVonDisk(Name: _WorkStr;
                       Del: boolean): boolean;

var f: File of _Bildschirm;

begin
  Name:= Name + 'SCR';                {Endung wird angefgt}
  Assign(f,Name);
  if _DateiExist(Name)
  then begin
         Reset(f);
         if _Farbmonitor
          then read(f,_Farb)
          else read(f,_Mono);
         close(f);
         if Del then Erase(f);           {Bilddatei lschen}
         _BildVonDisk:= true;           {Bild wurde geladen}
       end
  else _BildVonDisk:= false;            {Bild nicht geladen}
end;
{ͻ
  End of Unit                                             
 ͼ}
end.