{ͻ
  Unit      _Check.pas                                   
                                                         
  Compiler  Turbo Pascal 6.0                             
                                                         
  Date      02.02.90                                     
                                                         
  Update    05.10.90                                     
                                                         
  Autor     Reiner Schlles                              
 Ķ
  Inhalt    Allgemeine berprfungs-Routinen.            
 ͼ}
Unit _Check;
{ͻ
  Interface (ffentlicher Teil)                           
 ͼ}
Interface
uses {Einzubindende Bibliotheken}
  _Declare; {Unit aus dem Unitsystem}

  {Verzeichnis der globalen Routinen}

  function _IntRange(Min,Max,Zahl: integer): boolean;
  function _RealRange(Min,Max,Zahl: real): boolean;
  function _Kleinbuchstabe(ch: char): boolean;
  function _Grossbuchstabe(ch: char): boolean;
  function _Buchstabe(ch: char): boolean;
  function _Numerisch(ch: char): boolean;
  function _ReplaceReservedWords(InStr: _LongStr): _LongStr;
  function _AlleLeerEntf(St: _WorkStr): _WorkStr;
  function _LastLeerEntf(St: _WorkStr): _WorkStr;
  function _Wochentag: _Str10;
  function _TimeToStr(Hour,Min,
                      Second,Sec100: Word;
                         Sek,Sek100: boolean): _Str11;
  function _DateToStr(Day,Month,Year: Word): _Str10;
  function _Datum: _Str10;
  function _Uhrzeit(Sek,Sek100: boolean): _Str11;
  function _StrToInteger(Str: _WorkStr): integer;
  function _StrToReal(Str: _WorkStr): real;
  function _NumToStr(Zahl:real;Laenge,Nach:byte): _WorkStr;
  procedure _HeapMin(Groesse: longint);

  function _FarbMonitor: boolean;

{ͻ
  Implementation (Nicht-ffentlicher Teil)                
 ͼ}
Implementation
uses {Einzubindende Bibliotheken}
  Crt,Dos,                {Units aus dem Turbo Pascal-System}
  _Fehler,_IO,_Windows;            {Units aus dem Unitsystem}

const {Lokale Konstanten}

  {Ŀ
    Wenn hier bei den reservierten Wrtern nderungen vor-
    genommen werden, mssen auch innerhalb der Case-An-   
    weisung in der Funktion _ReplaseReservedWords ent-    
    sprechende nderungen vorgenommen werden!             
   }

  _MaxRW  = 52;                   {Anzahl Reservierte Wrter}

  _ReservedWords:  array[1.._MaxRW] of _Str14 =

       {1 bis 6}         ('DO','IF','IN','OF','OR','TO',

       {7 bis 18}         'AND','DIV','END','FOR','MOD',
                          'NIL','NOT','SET','SHL','SHR',
                          'VAR','XOR',

      {19 bis 27}         'CASE','ELSE','FILE','GOTO',
                          'THEN','TYPE','UNIT','USES',
                          'WITH',

      {28 bis 33}         'ARRAY','BEGIN','CONST','LABEL',
                          'UNTIL','WHILE',

      {34 bis 40}         'DOWNTO','INLINE','OBJECT',
                          'PACKED','RECORD','REPEAT',
                          'STRING',

      {41 bis 43}         'FORWARD','PROGRAM','VIRTUAL',

      {44 bis 46}         'ABSOLUTE','EXTERNAL','FUNCTION',

      {47 bis 49}         'INTERFACE','INTERRUPT',
                          'PROCEDURE',

      {50 bis 52}         'DESTRUCTOR','CONSTRUCTOR',
                          'IMPLEMENTATION');

{ͻ
  _IntRange                                               
 Ķ
  berprft, ob die Integerzahl innerhalb des angegebenen 
  Bereiches liegt, also ob gilt: Min <= Zahl <= Max.      
  Ist die Bedingung erfllt, liefert die Funktion das Er- 
  gebnis True, sonst False.                               
 ͼ}
function _IntRange(Min,Max,Zahl: integer): boolean;
begin
  if (Zahl >= Min) and (Zahl <= Max)
    then _IntRange:= true
    else _IntRange:= false;
end;
{ͻ
  _RealRange                                              
 Ķ
  berprft, ob die Dezimalzahl innerhalb des angegebenen 
  Bereiches liegt, also ob gilt: Min <= Zahl <= Max.      
  Ist die Bedingung erfllt, liefert die Funktion das Er- 
  gebnis True, sonst False.                               
 ͼ}
function _RealRange(Min,Max,Zahl: real): boolean;
begin
  if (Zahl >= Min) and (Zahl <= Max)
    then _RealRange:= true
    else _RealRange:= false;
end;
{ͻ
  _Kleinbuchstabe                                         
 Ķ
  berprft, ob das bergebene Zeichen ein Kleinbuchstabe 
  ist ("a..z"). Wenn ja, dann ist das Ergebnis der Funk-  
  tion True, sonst False.                                 
 ͼ}
function _Kleinbuchstabe(ch: char): boolean;
begin
  if ch in ['a'..'z'] then _Kleinbuchstabe:= true
                      else _Kleinbuchstabe:= false;
end;
{ͻ
  _Grossbuchstabe                                         
 Ķ
  berprft, ob das bergebene Zeichen ein Grobuchstabe  
  ist ("A..Z"). Wenn ja, dann ist das Ergebnis der Funk-  
  tion True, sonst False.                                 
 ͼ}
function _Grossbuchstabe(ch: char): boolean;
begin
  if ch in ['A'..'Z'] then _Grossbuchstabe:= true
                      else _Grossbuchstabe:= false;
end;
{ͻ
  _Buchstabe                                              
 Ķ
  berprft, ob das bergebene Zeichen ein Buchstabe ist  
  ("a..z" oder "A..Z"). Wenn ja, dann ist das Ergebnis der
  Funktion True, sonst False.                             
 ͼ}
function _Buchstabe(ch: char): boolean;
begin
  if _Kleinbuchstabe(ch) or _Grossbuchstabe(ch)
    then _Buchstabe:= true
    else _Buchstabe:= false;
end;
{ͻ
  _Numerisch                                              
 Ķ
  berprft, ob das bergebene Zeichen eine Ziffer ist    
  ("0..9"). Wenn ja, dann ist das Ergebnis der Funktion   
  True, sonst False.                                      
 ͼ}
function _Numerisch(ch: char): boolean;
begin
  if ch in ['0'..'9'] then _Numerisch:= true
                      else _Numerisch:= false;
end;
{ͻ
  _ReplaceReservedWords                                   
 Ķ
  Wandelt in einem String (_LongStr) smtliche reservierte
  Wrter in Groschreibung um und liefert den vernderten 
  String als Ergebnis der Funktion zurck. Die reser-     
  vierten Wrter sind in dieser Unit als Konstante abge-  
  legt.                                                   
 ͼ}
function _ReplaceReservedWords(InStr: _LongStr): _LongStr;
var
  OutStr: _LongStr;                     {Vernderter String}
  Len   : byte;                                {InStr-Lnge}
  i     : byte;                               {Laufvariable}
  ok    : boolean;                        {Ob Wort gefunden}
  Wort  : _LongStr;                               {Ein Wort}
  Help  : _LongStr;                              {Hilfswort}

{Nach reservierten Wrtern suchen}
procedure Rw(Anf,Ende: byte);
begin
  Dec(Anf);                               {Um 1 erniedrigen}
  ok:= false;
  repeat
    inc(Anf);
    if Help = _ReservedWords[Anf]
     then ok:= true;
  until (Anf = Ende) or ok;
  if ok then Wort:= Help;
end;
{}

begin
  {Anfangswerte}
  OutStr:= '';                       {Zuerst als Leerstring}
  Wort:= '';                      {Auch Wort als Leerstring}
  Len:= Length(InStr);                     {Lnge bestimmen}
  i:= 0;                                      {Zhler auf 0}
  if InStr <> '' then
  begin
    {String berprfen}
    while i < Len do
    begin
      inc(i);                          {Zhler um 1 erhhen}
      if not _Buchstabe(InStr[i])
      then OutStr:= OutStr + InStr[i]
      else begin
             repeat
               Wort:= Wort + InStr[i];
               inc(i);
             until not _Buchstabe(InStr[i]) or (i > Len);
             Dec(i);
             Help:= Wort;          {Mit Help weiterarbeiten}
             _Grossbuchstaben(Help);
             case Length(Wort) of
                    2: Rw(1,6);      {Die bergebenen Werte}
                    3: Rw(7,18);     {entsprechen der Ord- }
                    4: Rw(19,27);    {nungszahl der reser- }
                    5: Rw(28,33);    {vierten Wrter in der}
                    6: Rw(34,40);    {Konstantenvereinba-  }
                    7: Rw(41,43);    {rung.                }
                    8: Rw(44,46);
                    9: Rw(47,49);
               10..14: Rw(50,52);
             end; {case}
             OutStr:= OutStr + Wort;
             Wort:= '';
           end; {else}
    end;                          {Bis alle Zeichen gelesen}
  end; {if-then}
  _ReplaceReservedWords:= OutStr;
end;
{ͻ
  _AlleLeerEntf                                           
 Ķ
  Entfernt aus einem String smtliche Leerzeichen.        
 ͼ}
function _AlleLeerEntf(St: _WorkStr): _WorkStr;
var
  HelpStr: _WorkStr;
  i      : byte;                              {Zhlvariable}

begin
  if (Length(St) > 79) or (Length(St) = 0)
  then begin
         HelpStr:= '';                          {Leerstring}
         _Error:= 10;         {String zu lang (>79 Zeichen)}
       end
  else begin
         HelpStr:= '';                 {Leerstring vorgeben}
         for i:= 1 to Length(St) do
         begin
           if (Copy(St,i,1)) <> ' '
             then HelpStr:= HelpStr + Copy(St,i,1);
         end; {for}
         _Error:= 0;                {Fehlerfreie Ausfhrung}
       end; {if-else}
  _AlleLeerEntf:= HelpStr;
end;
{ͻ
  _LastLeerEntf                                           
 Ķ
  Entfernt aus einem String nachfolgende Leerzeichen (also
  diejenigen, die noch nach dem letzten Zeichen folgen!). 
 ͼ}
function _LastLeerEntf(St: _WorkStr): _WorkStr;
var
  HelpStr: _WorkStr;
  i      : byte;                              {Zhlvariable}
  j      : byte;                    {Letztes Zeichen <> ' '}

begin
  if (Length(St) > 79) or (Length(St) = 0)
  then begin
         HelpStr:= '';                          {Leerstring}
         _Error:= 10;        {String zu lang ( >79 Zeichen)}
       end
  else begin
         j:= 0;
         HelpStr:= '';                 {Leerstring vorgeben}
         for i:= 1 to Length(St) do
         begin
           if St[i] <> ' ' then j:= i;
         end; {for}
         if (j > 0) and (j < Length(St))
         then begin
                for i:= 1 to j do
                 HelpStr:= HelpStr + St[i];
              end
         else if j <> 0 then HelpStr:= St;
       end;
  _LastLeerEntf:= HelpStr;
end;
{ͻ
  _Wochentag                                              
 Ķ
  Ermittelt aus dem Systemdatum den Wochentag und liefert 
  ihn als String zurck.                                  
 ͼ}
function _Wochentag: _str10;
var
  year,month,day,DayOfWeek: word;

begin
  GetDate(year,month,day,DayOfWeek);
  case DayOfWeek of
    0: _Wochentag:= 'Sonntag';
    1: _Wochentag:= 'Montag';
    2: _Wochentag:= 'Dienstag';
    3: _Wochentag:= 'Mittwoch';
    4: _Wochentag:= 'Donnerstag';
    5: _Wochentag:= 'Freitag';
    6: _Wochentag:= 'Samstag';
  end; {case}
end;
{ͻ
  _TimeToStr                                              
 Ķ
  Wandelt eine beliebige Uhrzeit in einen String um und   
  liefert diesen an das aufrufende Programm in der Form   
  (HH:MM:SS:ss) zurck.                                   
 ͼ}
function _TimeToStr(Hour,Min,
                    Second,Sec100: Word;
                       Sek,Sek100: boolean): _Str11;
var
  Stunde,Minute,Sekunde,S100: string[2];
  Zeit                      : _Str11;

begin
  {Bereiche berprfen}
  if   not _IntRange(0,23,Hour)
   or not _IntRange(0,59,Min)
   or not _IntRange(0,59,Second)
   or not _IntRange(0,99,Sec100) then
  begin
    Hour  := 0;
    Min   := 0;
    Second:= 0;
    Sec100:= 0;
  end;
  {Std,Min,Sec in String umwandeln}
  Stunde := _AlleLeerEntf(_NumToStr(Hour,2,0));
  Minute := _AlleLeerEntf(_NumToStr(Min,2,0));
  Sekunde:= _AlleLeerEntf(_NumToStr(Second,2,0));
  S100   := _AlleLeerEntf(_NumToStr(Sec100,2,0));
  {Auf richtige Lnge prfen}
  if Length(Stunde)  < 2 then Stunde := '0' + Stunde;
  if Length(Minute)  < 2 then Minute := '0' + Minute;
  if Length(Sekunde) < 2 then Sekunde:= '0' + Sekunde;
  if Length(S100)    < 2 then S100   := '0' + S100;
  {Uhrzeit als String}
  Zeit:= Stunde + ':' + Minute;
  if Sek then
  begin
    Zeit:= Zeit + ':' + Sekunde;
    if Sek100 then Zeit:= Zeit + ':' + S100;
  end;
  _TimeToStr:= Zeit;
end;
{ͻ
  _DateToStr                                              
 Ķ
  Wandelt ein beliebiges Datum in einen String der Form   
  (TT.MM.JJJJ) um und liefert ihn an das aufrufende Pro-  
  gram zurck.                                            
 ͼ}
function _DateToStr(Day,Month,Year: Word): _Str10;
var
  SysTag,SysMonat: string[2];
  SysJahr        : string[4];

begin
  {Bereiche beprfen}
  if not _IntRange(1,31,Day)
   or not _IntRange(1,12,Month)
   or not _IntRange(1900,2099,Year)
  then _DateToStr:= '00.00.0000' else
  begin {else}
    Str(Year:4,SysJahr);                     {Jahr zuordnen}
    {Text fr den Monat ermitteln}
    if _IntRange(1,9,Month)
     then SysMonat:= '0' + _NumToStr(Month,1,0)
     else SysMonat:= _NumToStr(Month,2,0);
    {Text fr den Tag ermitteln}
    if _IntRange(1,9,Day)
     then SysTag:= '0' + _NumToStr(Day,1,0)
     else SysTag:= _NumToStr(Day,2,0);
    {}
    _DateToStr:= SysTag+'.'+SysMonat+'.'+SysJahr;
  end; {else}
end;
{ͻ
  _Datum                                                  
 Ķ
  Ermittelt aus dem Systemdatum das heutige Datum in der  
  Form (TT.MM.JJJJ) und liefert es als String zurck.     
 ͼ}
function _Datum: _Str10;
var
  Day,Month,Year,
  DayOfWeek      : word;

begin
  GetDate(Year,Month,Day,DayOfWeek);       {Datum ermitteln}
  _Datum:= _DateToStr(Day,Month,Year);
end;
{ͻ
  _Uhrzeit                                                
 Ķ
  Ermittelt die momentane Systemuhrzeit in der Form       
  (HH:MM:SS:ss) und liefert sie als String zurck.        
 ͼ}
function _Uhrzeit(Sek,Sek100: boolean): _Str11;
var
  Hour,Min,Second,Sec100    : word;

begin
  GetTime(Hour,Min,Second,Sec100);          {Zeit ermitteln}
  _Uhrzeit:= _TimeToStr(Hour,Min,Second,Sec100,Sek,Sek100);
end;
{ͻ
  _StrToInteger                                           
 Ķ
  Konvertiert einen String in einen Integerwert.          
 ͼ}
function _StrToInteger(Str: _WorkStr): integer;
var
  Erg   : real;               {Umwandlung erst in Real-Zahl}
  i     : byte;                               {Zhlvariable}
  Ok    : boolean;                     {Ob Konvertierung ok}

{KeineIntegerZahl}
procedure KeineIntegerZahl;
begin
  _Error:= 20;                           {Keine Integerzahl}
  _StrToInteger:= 0;
end;
{}

begin
  Str:= _AlleLeerEntf(Str);          {Leerzeichen entfernen}
  Ok:= true;                       {Angenommen Integer-Zahl}
  {Integerzahl hat keinen Dez.Punkt und kein Komma}
  for i:= 1 to Length(Str) do
  begin
    if (Str[i] = '.') or (Str[i] = ',')
      then Ok:= false;                  {Keine Integerzahl!}
  end;
  if Ok
  then begin {(1)}
         Erg:= _StrToReal(Str);
         if _ErrorResult = 0    {Erfolgreiche Konvertierung}
         then begin {(2)}
                if _RealRange(-32768.0,32767.0,Erg)
                then begin {(3)}
                       _StrToInteger:= Trunc(Erg);
                       _Error:= 0;
                     end {if-then (3)}
                else KeineIntegerZahl;
              end {if-then (2)}
         else KeineIntegerZahl;
       end {if-then (1)}
  else KeineIntegerZahl;
end;
{ͻ
  _StrToReal                                              
 Ķ
  Konvertiert einen String in einen numerischen Wert. Das 
  Ergebnis ist vom Typ Real. Leerzeichen werden entfernt, 
  ein evtl. "," wird durch den "." ersetzt.               
 ͼ}
function _StrToReal(Str: _WorkStr): real;
var
  RealZahl: real;            {Umgewandelter String als Real}
  Fehler  : integer;            {Innerhalb der Val-Prozedur}
  i       : byte;                             {Zhlvariable}

{KeineRealZahl}
procedure KeineRealZahl;
begin
  _Error:= 21;                              {Keine Realzahl}
  _StrToReal:= 0;
end;
{}

begin
  Str:= _AlleLeerEntf(Str);        {Evtl. Leerzeichen entfernen}
  if Length(Str) > 0
  then begin {(1)}
         for i:= 1 to Length(Str) do
         begin
           if Str[i] = ',' then Str[i]:= '.';
         end;
         Val(Str,RealZahl,Fehler);
         if Fehler = 0
         then begin {(2)}                {Konvertierung ok!}
                _StrToReal:= RealZahl;
                _Error:= 0;      {Fehlerfreie Konvertierung}
              end {if-then (2)}
         else KeineRealZahl;       {Konvertierung nicht ok!}
       end {if-then (1)}
  else KeineRealZahl;                      {Wenn Nullstring}
end;
{ͻ
  _NumToStr                                               
 Ķ
  Konvertiert einen numerischen Ausdruck in einen String. 
 ͼ}
function _NumToStr(Zahl:real;Laenge,Nach:byte): _WorkStr;
var St: _WorkStr;

begin
  St:= '';
  Str(Zahl:Laenge:Nach,St);
  _NumToStr:= St;
end;
{ͻ
  _HeapMin                                                
 Ķ
  Prft, ob auf dem Heap noch mindestens der in GROESSE   
  angegebene Speicherplatz (in Bytes) als zusammenhngen- 
  der Block zur Verfgung steht. Ist dies nicht der Fall, 
  erscheint eine Fehlermeldung und das laufende Programm  
  wird abgebrochen.                                       
 ͼ}
procedure _HeapMin(Groesse: longint);
const
  Error = ' Nicht gengend Speicherplatz auf dem ' +
          'Heap. Programm wird abgebrochen!';

begin
  if MaxAvail < Groesse then
  begin
    _ErrorBox(Error);
    NormVideo;
    _NormWindow;
    Clrscr;
    Halt;
  end; {if}
end;
{ͻ
  _FarbMonitor                                            
 Ķ
  Liefert True, wenn ein Farbmonitor angeschlossen ist,   
  sonst False.                                            
 ͼ}
function _FarbMonitor: boolean;
begin
  intr($11,_Regs);                      {Software-Interrupt}
  if _Regs.ax and $30=$30
    then _FarbMonitor:= false
    else _FarbMonitor:= true;
end;
{ͻ
  End of Unit                                             
 ͼ}
end.