Program Txt_Conv;
uses dos,crt,my2,version;

Var f, g          : file of byte;
    _in, _out     :byte;
    fname1, fname2:string;
    c1,c2         :byte;
    mode          :byte;
    tmp           :string;
    rem,size,count:longint;
    a, b, c       :byte;


procedure HELP;
begin
   writeln('Syntax : TXT-CONV.EXE <InputFile> <Outputfile> <converttype>');
   writeln;
   writeln('All 3 Options must be specified. Valid specifications for <converttype> are:');
   writeln('7E1  - Converts an 8N1 file to 7E1');
   writeln('7O1  - Converts an 8N1 file to 7O1');
   writeln('REMOVE - removes all characters >122');
   writeln('LF   - removes all Carriage Return characters ($0D) to be used for unix/amiga');
   writeln('CRLF - adds a Carriage Return before any Linefeed if not exist to use for msdos');
   writeln('CR   - removes all Linefeed characters ($0A) (some rare OS)');
   writeln;
   writeln('If an "-" is specified for a file, stdin/stdout is used for that file.');
   writeln;
   halt;
end;

Procedure Error(typ:byte);
begin
   writeln('Error (',typ,') : '); case typ of
     1:writeln('Inputfile not found! -> ',fname1);
     2:writeln('Invalid <converttype> option! -> ',tmp);
     3:writeln('Could not create outputfile! -> ',fname2);
   end;
   halt;
end;


begin
   writeln('TEXT-CONVERTER ',ver,author,email);writeln;
   if Paramcount<>3 then help;
   Checkbreak:=false; SetCBreak(FALSE);
   fname1:=ParamStr(1);fname2:=ParamStr(2);mode:=0;rem:=0;tmp:=ParamStr(3);Upc(fname1);Upc(fname2);Upc(tmp);
   if not Checkfile(fname1) then Error(1);
   if tmp='7E1' then mode:=1;    if tmp='7O1' then mode:=2;
   if tmp='LF' then mode:=6;     if tmp='CRLF' then mode:=7;   if tmp='CR' then mode:=8;
   if tmp[1]='R' then mode:=5;   if mode=0 then Error(2);
   if fname1='-' then fname1:=''; if fname2='-' then fname2:='';
   assign(f,fname1); reset(f); assign(g,fname2); {I-} rewrite(g); {I+} if IOResult<>0 then Error(3);
   size:=FSize(fname1); count:=0;
   case mode of
    1:begin
       writeln('Mode : Convert from 8N1 to 7E1');
       writeln('Inputfile : ',fname1,' (',size,' bytes)');
       write  ('Outputfile: ',fname2);
       repeat
           inc(count); a:=0; Read(f,_in);
           if _in AND 1 = 1 then inc(A); if _in AND 2 = 2 then inc(A);
           if _in AND 4 = 4 then inc(A); if _in AND 8 = 8 then inc(A);
           if _in AND 16 = 16 then inc(A);if _in AND 32 = 32 then inc(A);
           if _in AND 64 = 64 then inc(A);b:=a mod 2;
           if ((b=0)and(_in<128)) then begin _out:=_in; write(g,_out); end;
           if ((b=1)and(_in>127)) then begin _out:=_in-128; write(g,_out); end;
       until count>=size;
    end;
    2:begin
       writeln('Mode : Convert from 8N1 to 7O1');
       writeln('Inputfile : ',fname1,' (',size,' bytes)');
       write  ('Outputfile: ',fname2);
       repeat
           inc(count); a:=0; Read(f,_in);
           if _in AND 1 = 1 then inc(A); if _in AND 2 = 2 then inc(A);
           if _in AND 4 = 4 then inc(A); if _in AND 8 = 8 then inc(A);
           if _in AND 16 = 16 then inc(A);if _in AND 32 = 32 then inc(A);
           if _in AND 64 = 64 then inc(A);b:=a mod 2;
           if ((b=1)and(_in<128)) then begin _out:=_in; write(g,_out); end;
           if ((b=0)and(_in>127)) then begin _out:=_in-128; write(g,_out); end;
       until count>=size;
    end;
{ for source readers, guess what I planned to put in here, eh? }

    5:begin
       writeln('Mode : Remove >122');
       writeln('Inputfile : ',fname1,' (',size,' bytes)');
       write  ('Outputfile: ',fname2);
       repeat
           inc(count); Read(f,_in);
           if _in <=122 then Write(g,_in);
       until count>=size;
    end;
    6:begin
       writeln('Mode : Convert to Linefeed only (to Amiga/Unix Format)');
       writeln('Inputfile : ',fname1,' (',size,' bytes)');
       write  ('Outputfile: ',fname2);
       repeat
           inc(count); Read(f,_in);
           if _in <>13 then Write(g,_in);
       until count>=size;
    end;
    7:begin
       writeln('Mode : Convert to Carriage Return + Linefeed (to MsDos Format)');
       writeln('Inputfile : ',fname1,' (',size,' bytes)');
       write  ('Outputfile: ',fname2); _out:=0; c1:=13; c2:=10;
       repeat
           inc(count); Read(f,_in);
           if (_in =10) and (_out<>13) then write(g,c1);
           if (_out=13) and (_in <>10) then write(g,c2);
           write(g,_in); _out:=_in;
       until count>=size;
    end;
    8:begin
       writeln('Mode : Convert to Carriage Return only (some rare OS type Format)');
       writeln('Inputfile : ',fname1,' (',size,' bytes)');
       write  ('Outputfile: ',fname2);
       repeat
           inc(count); Read(f,_in);
           if _in <>10 then Write(g,_in);
       until count>=size;
    end;
    end;
    close(f);close(g); size:=FSize(fname2); writeln(' (',size,' bytes)');
end.