{ͻ
  Unit      _Mat.pas                                     
                                                         
  Compiler  Turbo Pascal 6.0                             
                                                         
  Date      24.05.90                                     
                                                         
  Update    08.03.91                                     
                                                         
  Autor     Reiner Schlles                              
 Ķ
  Inhalt    Mathematische Routinen.                      
 ͼ}
Unit _Mat;
{ͻ
  Interface (ffentlicher Teil)                           
 ͼ}
Interface

const {Globale Konstanten}
  _MaxVecKom = 100;              {Max.Anz.Vektorkomponenten}

type {Globale Datentypen}
  _Vector = array[1.._MaxVecKom]
              of real;                           {Vektortyp}

  _StatKennGr = record {Vektorkenngren}
                  Sum,                   {Summe des Vektors}
                  AM,                {Arithmetisches Mittel}
                  HM,                  {Harmonisches Mittel}
                  GM,                 {Geometrisches Mittel}
                  StAbw,                {Standardabweichung}
                  Varianz,
                  Min,Max : real;{Kleinster u. grter Wert}
               end;

  {Verzeichnis der globalen Routinen}

  function _Potenz(Basis,Exponent: real): real;
  procedure _SortVector(var X: _Vector;
                        Anz: byte; Up: boolean);
  procedure _DelVecKom(var X: _Vector;
                       var Anz: byte; Kom: byte);
  procedure _Mean(X: _Vector; Anz: byte;
                  var KennGr: _StatKennGr);

{ͻ
  Implementation (Nicht-ffentlicher Teil)                
 ͼ}
Implementation
uses {Einzubindende Bibliotheken}
  _Declare,_Check;                {Units aus dem Unit-System}

{ͻ
  _Potenz                                                 
 Ķ
  Berechnet die Potenz einer Zahl mit Hilfe des natr-    
  lichen Logarithmus. Ist die Basis <= 0, dann ist das Er-
  gebnis der Funktion -1.                                 
 ͼ}
function _Potenz(Basis,Exponent: real): real;
begin
  if Basis <> 1.0 then
  begin
    if (Basis > 0) and (Exponent < (Ln(_MaxReal)/Ln(Basis)))
     then _Potenz:= exp(Exponent * Ln(Basis))
     else _Potenz:= -1;
  end
  else _Potenz:= 1;
end;
{ͻ
  _SortVector                                             
 Ķ
  X  : Das zu sortierende Vektorfeld.                     
  Anz: Anzahl der enthaltenen Komponenten.                
  Up : Wenn TRUE, dann auf-, sonst absteigend sortieren.  
                                                          
  Sortiert ein Vektorfeld entweder auf- oder absteigend   
  und liefert das sortierte Feld an das aufrufende Pro-   
  gramm zurck. Verwendet wird der Bubble-Sort.           
 ͼ}
procedure _SortVector(var X: _Vector;
                      Anz: byte; Up: boolean);

var
  i,j : byte;                                 {Zhlvariable}
  Help: real;                                {Hilfsvariable}

{Tausche}
procedure Tausche;
begin
  Help:= X[i];
  X[i]:= X[j];
  X[j]:= Help;
end;
{}

begin
  if _IntRange(1,_MaxVecKom,Anz) then
  begin
    for i:= 1 to Anz-1 do
    begin
      for j:= i+1 to Anz do
      begin
        if Up
        then begin {Aufsteigend}
               if X[i] > X[j]
                then Tausche;
             end
        else begin {Absteigend}
               if X[i] < X[j]
                then Tausche;
             end;
      end; {for j}
    end; {for i}
  end;
end;
{ͻ
  _DelVecKom                                              
 Ķ
  Lscht aus einer Datenreihe die i-te (Kom) Komponente.  
 ͼ}
procedure _DelVecKom(var X: _Vector;
                     var Anz: byte; Kom: byte);

var
  i: integer;                                 {Zhlvariable}

begin
  if (_IntRange(1,_MaxVecKom,Anz)) and
     (_IntRange(1,Anz,Kom)) then
  begin
    for i:= Kom to Anz-1 do
     X[i]:= X[i+1];
    Dec(Anz);                       {Anzahl um 1 verringern}
  end; {if}
end;
{ͻ
  _Mean                                                   
 Ķ
  Berechnet aus einer vorliegenden Datenreihe statistische
  Kennwerte und liefert diese durch die Variable KennGr an
  das aufrufende Programm zurck.                         
 ͼ}
procedure _Mean(X: _Vector; Anz: byte;
                var KennGr: _StatKennGr);

var
  HelpVec: _Vector;                          {Hilfsvariable}

{SummeBerechnen}
procedure SummeBerechnen;
var
  i    : integer;                             {Zhlvariable}
  Summe: real;                     {Summe aller Komponenten}

begin
  Summe:= 0;                                   {Anfangswert}
  for i:= 1 to Anz do
    Summe:= Summe + HelpVec[i];
  KennGr.Sum:= Summe;                       {Summe zuweisen}
end;
{StAbwUndVarianzBerechnen}
procedure StAbwUndVarianzBerechnen;
var
  S,                                                 {Summe}
  Ab : real;                                    {Abweichung}
  i: integer;                                 {Zhlvariable}

begin
  S:= 0;                                       {Anfangswert}
  for i:= 1 to Anz do
  begin
    Ab:= HelpVec[i] - KennGr.AM;
    S:= S + Ab * Ab;                         {Aufsummierung}
  end; {for}
  KennGr.Varianz:= S/(Anz-1);           {Berechnung Varianz}
  KennGr.StAbw:= Sqrt(KennGr.Varianz); {Standard-Abweichung}
end;
{AlleKomGrNull}
function AlleKomGrNull: boolean;
var
  ok: boolean;
  i : integer;

begin
  ok:= true;                                   {Anfangswert}
  for i:= 1 to Anz do
  begin
    if HelpVec[i] <= 0
     then ok:= false;         {Komponente negativ oder Null}
  end;
  if ok then AlleKomGrNull:= true
        else begin
               AlleKomGrNull:= false;
               KennGr.HM:= -1;
               KennGr.GM:= -1;
             end;
end;
{HarmMittel}
{Alle Komponenten mssen > 0 sein}
procedure HarmMittel;
var
  S: real;                             {Summe rezipr. Werte}
  i: integer;                                 {Zhlvariable}

begin
  S:= 0;                                       {Anfangswert}
  for i:= 1 to Anz do
   S:= S + (1/HelpVec[i]);
  KennGr.HM:= Anz/S;                   {Harmonisches Mittel}
end;
{GeomMittel}
{Alle Komponenten mssen > 0 sein}
procedure GeomMittel;
var
  Exponent: real;
  i       : integer;                          {Zhlvariable}

begin
  KennGr.GM:= 1;                               {Anfangswert}
  Exponent:= 1/Anz;
  for i:= 1 to Anz do
   KennGr.GM:= KennGr.GM * _Potenz(HelpVec[i],Exponent);
end;
{}

begin
  {Voreinstellung der Variablen}
  With KennGr do
  begin
    Sum:= 0; AM:= 0; HM:= 0; GM:= 0; Min:= 0; Max:= 0;
    StAbw:= 0; Varianz:= 0;
  end; {with}
  HelpVec:= X;                    {Mit Hilfsvektor arbeiten}
  {}
  if _IntRange(2,_MaxVecKom,Anz) then
  begin
    _SortVector(HelpVec,Anz,true);        {Vektor sortieren}
    KennGr.Min:= HelpVec[1];                {Kleinster Wert}
    KennGr.Max:= HelpVec[Anz];                {Grter Wert}
    SummeBerechnen;
    KennGr.AM:= KennGr.Sum / Anz;    {Arithmetisches Mittel}
    StAbwUndVarianzBerechnen;
    if AlleKomGrNull then                  {Komponenten > 0}
    begin
      HarmMittel;                      {Harmonisches Mittel}
      GeomMittel;                     {Geometrisches Mittel}
    end;
  end; {if}
end;
{ͻ
  End of Unit                                             
 ͼ}
end.