{ͻ
  Unit      _Drucker.pas                                 
                                                         
  Compiler  Turbo Pascal 6.0                             
                                                         
  Date      02.05.90                                     
                                                         
  Update    13.05.90                                     
                                                         
  Autor     Reiner Schlles                              
 Ķ
  Inhalt    Enthlt Druckersteuerungen.                  
 ͼ}
Unit _Drucker;
{ͻ
  Interface (ffentlicher Teil)                           
 ͼ}
Interface
uses {Einzubindende Bibliotheken}
  _Declare;                {Unit aus dem Turbo Pascal-System}

const {Globale Konstanten}
  _TreiberDatei: _WorkStr = 'STANDARD.DT';

  _SpStCode  = 32;  {Spalte 1. Steuercode im Druckertreiber}
  _ZDtDatei  = 44;   {Mindestens soviele Zeilen in DT-Datei}
  DrStZInAnz = _ZDtDatei;          {Anzahl Eingabefelder Dt}

var {Globale Variablen}
  _DrStr,                           {Texte des aktuellen Dt}
  _StDtZ : array[0.._ZDtDatei-1]     {Texte des Standard-Dt}
            of _WorkStr;

  {Verzeichnis der globalen Routinen}

  procedure _ResetLst;
  procedure _PapierendeEin;
  procedure _PapierendeAus;
  procedure _Seitenvorschub;
  procedure _PerforationAus;
  procedure _PerforationZeilen(n: byte);
  procedure _NormalEin;
  procedure _EliteEin;
  procedure _EliteAus;
  procedure _GedehntEin;
  procedure _GedehntAus;
  procedure _KleinEin;
  procedure _KleinAus;
  procedure _FettEin;
  procedure _FettAus;
  procedure _DoppeldruckEin;
  procedure _DoppeldruckAus;
  procedure _ItalicEin;
  procedure _ItalicAus;
  procedure _Unidirektional;
  procedure _Bidirektional;
  procedure _LRand(n: byte);
  procedure _RRand(n: byte);
  procedure _Zeilenabstand(n: byte);
  procedure _FlZeilen(n: byte);
  procedure _FlZoll(n: byte);
  procedure _LangsamDruckEin;
  procedure _LangsamDruckAus;
  procedure _ZsUSA;
  procedure _ZsFrance;
  procedure _ZsGermany;
  procedure _ZsEngland;
  procedure _ZsSweden;
  procedure _ZsItaly;
  procedure _ZsSpain;
  procedure _UnterstreichenEin;
  procedure _UnterstreichenAus;
  procedure _LQEin;
  procedure _LQAus;
  procedure _HochEin;
  procedure _HochAus;
  procedure _TiefEin;
  procedure _TiefAus;
  procedure _HorizontaleLst(Len,Zeichen: byte);
  procedure _LeerLst(n: byte);
  function _DruckerName: _WorkStr;
  function _DruckerOk: boolean;
  procedure _UeberschrLst(Ueberschr: _WorkStr; Leer: byte);
  procedure _NeueDtDatei(Name: _WorkStr);
  procedure _NeuenDtErstellen;

{ͻ
  Implementation (Nicht-ffentlicher Teil)                
 ͼ}
Implementation
uses {Einzubindende Bibliotheken}
  Printer,                {Unit aus dem Turbo Pascal-System}
  _Disk,_Check,_Windows,
  _IO,_Input,_Dt;                {Units aus dem Unit-System}

{ͻ
  _StZZumDrucker                                          
 Ķ
  Nr: Nummer der Routine.                                 
  n : Eventuell vorhandener Parameter, der der entspre-   
      chenden Routine bergeben wurde. Wird eine Routine  
      ohne Parameter aufgerufen, wird fr N Null berge-  
      ben.                                                
                                                          
  Sendet die fr die jeweilige Routine notwendigen Steuer-
  zeichen zum Drucker. Ist das erste Zeichen des Steuer-  
  zeichens ein Punkt ('.'), so wird der Steuercode nicht  
  ausgefhrt (nicht an den Drucker gesendet).             
 ͼ}
procedure _StZZumDrucker(Nr,n: byte);
var
  St  : _Str3;                                 {Steuer-Code}
  i   : byte;                                 {Zhlvariable}
  Wert: integer;               {Konvertiertes Steuerzeichen}

begin
  if _DrStr[Nr][_SpStCode] <> '.' then
  begin
    St:= '';                      {Anfangswert = Leerstring}
    i:= _SpStCode - 1;              {i+1 = 1. Steuerzeichen}
    while i < Length(_DrStr[Nr]) do
    begin
      inc(i);
      if (_DrStr[Nr][i] = ' ') or (i = Length(_DrStr[Nr]))
      then begin
             if i = Length(_DrStr[Nr])
              then St:= St + _DrStr[Nr][i];
             if St = 'n'
             then begin
                    if (Nr = 6) or _IntRange(22,26,Nr)
                     then write(lst,chr(n));
                  end
             else begin
                    Wert:= _StrToInteger(St);
                    write(lst,chr(Wert));
                  end;
             St:= '';                    {Wieder Leerstring}
           end
      else St:= St + _DrStr[Nr][i];
    end; {while}
  end; {if}
end;
{ͻ
  Drucker normieren                                       
 ͼ}
procedure _ResetLst;
begin
  _StZZumDrucker(1,0);
end;
{ͻ
  Papierenderkennung                                      
 ͼ}
procedure _PapierendeEin;
begin
  _StZZumDrucker(2,0);
end;
{}
procedure _PapierendeAus;
begin
  _StZZumDrucker(3,0);
end;
{ͻ
  Seitenvorschub                                          
 ͼ}
procedure _Seitenvorschub;
begin
  _StZZumDrucker(4,0);
end;
{ͻ
  Perforation berspringen                                
 ͼ}
procedure _PerforationAus;
begin
  _StZZumDrucker(5,0);
end;
{}
procedure _PerforationZeilen(n: byte);
begin
  _StZZumDrucker(6,n);
end;
{ͻ
  Normal-Schrift                                          
 ͼ}
procedure _NormalEin;
begin
  _StZZumDrucker(7,0);
end;
{ͻ
  Elite-Schrift                                           
 ͼ}
procedure _EliteEin;
begin
  _StZZumDrucker(8,0);
end;
{}
procedure _EliteAus;
begin
  _StZZumDrucker(9,0);
end;
{ͻ
  Gedehnte-Schrift                                        
 ͼ}
procedure _GedehntEin;
begin
  _StZZumDrucker(10,0);
end;
{}
procedure _GedehntAus;
begin
  _StZZumDrucker(11,0);
end;
{ͻ
  Kleinschrift                                            
 ͼ}
procedure _KleinEin;
begin
  _StZZumDrucker(12,0);
end;
{}
procedure _KleinAus;
begin
  _StZZumDrucker(13,0);
end;
{ͻ
  Fettdruck                                               
 ͼ}
procedure _FettEin;
begin
  _StZZumDrucker(14,0);
end;
{}
procedure _FettAus;
begin
  _StZZumDrucker(15,0);
end;
{ͻ
  Doppeldruck                                             
 ͼ}
procedure _DoppeldruckEin;
begin
  _StZZumDrucker(16,0);
end;
{}
procedure _DoppeldruckAus;
begin
  _StZZumDrucker(17,0);
end;
{ͻ
  Italic                                                  
 ͼ}
procedure _ItalicEin;
begin
  _StZZumDrucker(18,0);
end;
{}
procedure _ItalicAus;
begin
  _StZZumDrucker(19,0);
end;
{ͻ
  Druckrichtung                                           
 ͼ}
procedure _Unidirektional;
begin
  _StZZumDrucker(20,0);
end;
{}
procedure _Bidirektional;
begin
  _StZZumDrucker(21,0);
end;
{ͻ
  Rnder setzen                                           
 ͼ}
procedure _LRand(n: byte);
begin
  _StZZumDrucker(22,n);
end;
{}
procedure _RRand(n: byte);
begin
  _StZZumDrucker(23,n);
end;
{ͻ
  Zeilenabstand n/72 Zoll                                 
 ͼ}
procedure _Zeilenabstand(n: byte);
begin
  _StZZumDrucker(24,n);
end;
{ͻ
  Formularlnge                                           
 ͼ}
procedure _FlZeilen(n: byte);
begin
  _StZZumDrucker(25,n);
end;
{}
procedure _FlZoll(n: byte);
begin
  _StZZumDrucker(26,n);
end;
{ͻ
  Druckgeschwindigkeit                                    
 ͼ}
procedure _LangsamDruckEin;
begin
  _StZZumDrucker(27,0);
end;
{}
procedure _LangsamDruckAus;
begin
  _StZZumDrucker(28,0);
end;
{ͻ
  Zeichenstze                                            
 ͼ}
procedure _ZsUSA;
begin
  _StZZumDrucker(29,0);
end;
{}
procedure _ZsFrance;
begin
  _StZZumDrucker(30,0);
end;
{}
procedure _ZsGermany;
begin
  _StZZumDrucker(31,0);
end;
{}
procedure _ZsEngland;
begin
  _StZZumDrucker(32,0);
end;
{}
procedure _ZsSweden;
begin
  _StZZumDrucker(33,0);
end;
{}
procedure _ZsItaly;
begin
  _StZZumDrucker(34,0);
end;
{}
procedure _ZsSpain;
begin
  _StZZumDrucker(35,0);
end;
{ͻ
  Unterstreichen                                          
 ͼ}
procedure _UnterstreichenEin;
begin
  _StZZumDrucker(36,0);
end;
{}
procedure _UnterstreichenAus;
begin
  _StZZumDrucker(37,0);
end;
{ͻ
  Schnschrift (Letter Quality)                           
 ͼ}
procedure _LQEin;
begin
  _StZZumDrucker(38,0);
end;
{}
procedure _LQAus;
begin
  _StZZumDrucker(39,0);
end;
{ͻ
  Hoch- und Tiefstellung                                  
 ͼ}
procedure _HochEin;
begin
  _StZZumDrucker(40,0);
end;
{}
procedure _HochAus;
begin
  _StZZumDrucker(41,0);
end;
{}
procedure _TiefEin;
begin
  _StZZumDrucker(42,0);
end;
{}
procedure _TiefAus;
begin
  _StZZumDrucker(43,0);
end;
{ͻ
  Sonstiges                                               
 ͼ}
procedure _HorizontaleLst(Len,Zeichen: byte);
var i: byte;
begin
  for i:= 1 to Len do write(lst,chr(Zeichen));
end;
{}
procedure _LeerLst(n: byte);
var i: byte;
begin
  for i:= 1 to N do writeln(lst);
end;
{}
function _DruckerName: _WorkStr;
begin
  _DrStr[0]:= _LastLeerEntf(_DrStr[0]);
  if Length(_DrStr[0]) > 0
   then _DruckerName:= _DrStr[0]
   else _DruckerName:= 'NoName';
end;
{}
function _DruckerOk: boolean;
const
  Mld = 'Drucker nicht betriebsbereit! Bitte einschalten.' +
        ' Fertig';

var
  ch: char;
  ok: boolean;

begin
  ok:= false;
  ch:= ' ';
  repeat
    {$I-}
    write(lst,' ');
    {$I+}
    if IOResult <> 0
    then begin
           if not _FrageBox(6,23,'',Mld)
           then ch:= 'N';
         end
    else ok:= true;
  until ok or (ch = 'N');
  if ok then _DruckerOk:= true
        else _DruckerOk:= false;
end;
{}
procedure _UeberschrLst(Ueberschr: _WorkStr; Leer: byte);
begin
  _UnterstreichenEin;
  writeln(lst,Ueberschr);
  _UnterstreichenAus;
  if Leer >= 1 then _LeerLst(Leer);
end;
{ͻ
  _StandardDtInit                                         
 Ķ
  Initialisiert beim Programmstart den Standard-Drucker-  
  treiber mit den Voreinstellungen der Prozedur           
  _DtVoreinstellung.                                      
 ͼ}
procedure _StandardDtInit;
var i: byte;                                  {Zhlvariable}

begin
  for i:= 0 to _ZDtDatei-1 do
   _DrStr[i]:= _StDtZ[i];
end;
{ͻ
  _StandardDateiEinlesen                                  
 Ķ
  Liest die Standard-Druckertreibr-Datei ein. Ist diese   
  auf dem angemeldeten Laufwerk nicht vorhanden, werden   
  Voreinstellungen gesetzt (Drucker Epson RX 80, siehe    
  Prozedur _StandardDtInit).                              
 ͼ}
procedure _StandardDateiEinlesen;
var
  f: Text;                   {Standard-Druckertreiber-Datei}
  Z: _WorkStr;                           {Eingelesene Zeile}
  i: integer;                                 {Zhlvariable}

begin
  {Wenn Treiberdatei vorhanden u. richtige Lnge}
  if _DateiLaenge(_TreiberDatei) >= _ZDtDatei then
  begin
    Assign(f,_TreiberDatei);
    Reset(f);
    i:= -1;
    while not Eof(f) and (i < _ZDtDatei-1) do
    begin
      inc(i);
      readln(f,Z);
      if Length(Z) > _SpStCode-1
       then if (Z[_SpStCode-2] = ':')
             then if (Z[_SpStCode] <> '-')
                   then if (Z[_SpStCode] <> ' ')
                         then _DrStr[i]:= _LastLeerEntf(Z);
      if i = 0 then _DrStr[i]:= _LastLeerEntf(Z);
    end; {while}
    close(f);
  end;
end;
{ͻ
  _NeueDtDatei                                            
 Ķ
  Liest eine neue Drucker-Treiber-Datei als Standard-Datei
  ein. Ist die Datei nicht vorhanden, wird die bisherige  
  beibehalten.                                            
 ͼ}
procedure _NeueDtDatei(Name: _WorkStr);
begin
  if _DateiExist(Name) then
  begin
    _TreiberDatei:= Name;                {Neue Treiberdatei}
    _StandardDateiEinlesen;
  end
  else _Error:= 1;                   {Datei nicht vorhanden}
end;
{ͻ
  _NeuenDtErstellen                                       
 Ķ
  Erstellt, bildschirmorientiert, einen neuen Drucker-    
  treiber.                                                
 ͼ}
procedure _NeuenDtErstellen;
const
  Hinw = ' [F1]=Hilfe Dt,  [Alt]+[H]=Hilfe Eingabefeld,  ' +
         '[Esc]=Abbruch,  [F10]=Speichern ';

begin
  _SaveScr;                             {Bildschirm sichern}
  _Umrandung(1,1,79,3,205,true,'','');
  _WriteZen(2,79,2,' Neuen Druckertreiber erstellen ',
            true,false);
  _Vertikale(25,7,17,179);
  _Vertikale(53,7,17,179);
  _Horizontale(1,23,79,196);
  _Write(25,23,chr(193));
  _Write(53,23,chr(193));
  _WriteZen(1,79,24,Hinw,true,false);
  DrStZInFelderInit;
  DrStZInEingabeMaskePos(DrStZInAnz);
  DrStZInEingeben(DrStZInAnz,_Esc);
  _RestoreScr;                    {Bildschirm wieder zurck}
end;
{ͻ
  _DtVoreinstellung                                       
 Ķ
  Belegt das Feld _StDtZ mit den programminternen Vorein- 
  stellungen fr den Druckertreiber. Diese Eintrge werden
  niemals verndert und knnen daher dazu benutzt werden, 
  jederzeit die Voreinstellungen wiederherzustellen.      
 ͼ}
procedure _DtVoreinstellung;
begin
  _StDtZ[0] := 'Epson RX 80';
  _StDtZ[1] := 'Drucker normieren            : 27 64';
  _StDtZ[2] := 'Papierenderkennung ein       : 27 57';
  _StDtZ[3] := 'Papierenderkennung aus       : 27 56';
  _StDtZ[4] := 'Seitenvorschub               : 12';
  _StDtZ[5] := 'Perforation berspr. aus     : 27 79';
  _StDtZ[6] := 'Perforation n Zeilen berspr.: 27 78 n';
  _StDtZ[7] := 'Normalschrift ein            : 27 80';
  _StDtZ[8] := 'Eliteschrift ein             : 27 77';
  _StDtZ[9] := 'Eliteschrift aus             : 27 80';
  _StDtZ[10]:= 'Gedehnte Schrift ein         : 27 87 1';
  _StDtZ[11]:= 'Gedehnte Schrift aus         : 27 87 0';
  _StDtZ[12]:= 'Kleinschrift ein             : 15';
  _StDtZ[13]:= 'Kleinschrift aus             : 18';
  _StDtZ[14]:= 'Fettdruck ein                : 27 69';
  _StDtZ[15]:= 'Fettdruck aus                : 27 70';
  _StDtZ[16]:= 'Doppeldruck ein              : 27 71';
  _StDtZ[17]:= 'Doppeldruck aus              : 27 72';
  _StDtZ[18]:= 'Italic ein                   : 27 52';
  _StDtZ[19]:= 'Italic aus                   : 27 53';
  _StDtZ[20]:= 'Druckrichtung unidirektional : 27 85 1';
  _StDtZ[21]:= 'Druckrichtung bidirektional  : 27 85 0';
  _StDtZ[22]:= 'Linker Rand auf Grad n       : 27 108 n';
  _StDtZ[23]:= 'Rechter Rand auf Grad n      : 27 81 n';
  _StDtZ[24]:= 'Zeilenabstand auf n/72 Zoll  : 27 65 n';
  _StDtZ[25]:= 'Formularlnge auf n Zeilen   : 27 67 n';
  _StDtZ[26]:= 'Formularlnge auf n Zoll     : 27 67 0 n';
  _StDtZ[27]:= 'Langsamdruck ein             : 27 115 1';
  _StDtZ[28]:= 'Langsamdruck aus             : 27 115 0';
  _StDtZ[29]:= 'Zeichensatz USA              : 27 82 0';
  _StDtZ[30]:= 'Zeichensatz France           : 27 82 1';
  _StDtZ[31]:= 'Zeichensatz Germany          : 27 82 2';
  _StDtZ[32]:= 'Zeichensatz England          : 27 82 3';
  _StDtZ[33]:= 'Zeichensatz Sweden           : 27 82 5';
  _StDtZ[34]:= 'Zeichensatz Italy            : 27 82 6';
  _StDtZ[35]:= 'Zeichensatz Spain            : 27 82 7';
  _StDtZ[36]:= 'Unterstreichen ein           : 27 45 1';
  _StDtZ[37]:= 'Unterstreichen aus           : 27 45 0';
  _StDtZ[38]:= 'Schnschrift (LQ) ein        : 27 71';
  _StDtZ[39]:= 'Schnschrift (LQ) aus        : 27 72';
  _StDtZ[40]:= 'Hochstellung ein             : 27 83 0';
  _StDtZ[41]:= 'Hochstellung aus             : 27 84';
  _StDtZ[42]:= 'Tiefstellung ein             : 27 83 1';
  _StDtZ[43]:= 'Tiefstellung aus             : 27 84';
end;
{ͻ
  Ausfhrungsteil                                         
 ͼ}
begin
  _DtVoreinstellung;
  _StandardDtInit;
  _StandardDateiEinlesen;
{ͻ
  End of Unit                                             
 ͼ}
end.