{$F-}  { Far Calls.............On             }
{$A+}  { Data Alignment........Word           }
{$X+}   { Enhanced Syntax.......On             }
{$V-}   { String Type Checking..Relaxed        }
{$P+}   { Open Strings..........On             }
{$T-}   { @ Pointers............UnTyped        }
{$B-}   { Boolean Evaluation....Short Circuit  }

unit scaninit;
interface
uses version;
type
   Response_ID = record
     response    : string[15];      {* Modem response, z.B. NO CARRIER *}
     rings_from,
     rings_to    : byte;            {* Von wann bis welcher RING zahl trifft es auf diese ID zu? *}
     print       : boolean;         {* Schreibe bei finden in das FOUND! Menu? *}
     Exec_It     : Byte;            {* File executen wenn gefunden? 0=nein 1-8=F1 bis F8 Belegung *}
   end;

   Exec_File   = record
     fname       : string[50];      {* Filename & Path to execute *}
     params      : string[50];      {* Parameter *}
     React       : Byte;            {* Reaction on execute : 1=hangup, 2=continue, 4=redial *}
   end;

   ConfigType  = record
                       version : string[5];
                       ComPort:byte;
                       use_fossil:boolean;
                       irq, baseadress, speed : word;
                       B_Data, B_Stop : byte;
                       B_Parity : char;
                       fast_hangup:boolean;
                       auto_detect : boolean;
                       Init1, Init2 : string[25];  {Modeminits}
                       hangup, dial_prefix, dial_suffix, speakeron, speakeroff : string[20];
                       flee, dialup_hangup : char;
                       cmd_delay:word;
                       char_delay : byte;
                       waitbetweencalls : word;
                       scanmode : byte;
                       dialing : longint;
                       manual:boolean;
                       manual_timeout, carrier_hack_mode, nudge_delay : byte;
                       nudge : string;
                       redial_busy, busy_overwrite : boolean;
                       Timeout, ringout, nodial_exit : byte;
                       auto_dat_save, save_data, datfilesave : byte;
                       modem_respond_id : array [1..18] of response_id;
                       Logs : array[0..18] of string[8];
                       Execute:array[1..9] of Exec_File;
                       exec_timeout,exec_ringout:byte;
                       _custom1,_custom2,_custom3:string[25];
                       _custom12,_custom22,_custom32:boolean;
                       do_dial_exec:boolean;
                       balken : byte;
                       delete_zero:boolean;
                       DO_ELAPSE : BOOLEAN;
                       dial_delayer:byte;
                       dial_delay_from,dial_delay_to:byte;
                       send_delay_from,send_delay_to:word;
                       dumb : boolean;
                       intelligent : boolean;
                       suspend : boolean;
                       autoblank : byte;
                       reserved1,reserved2 : byte;
  end;

{* Jop das wars ... fuer 0.8b, 0.8c und 0.9 *}
{* Ciao...    van Hauser *}

const
  tab    = 9;
  sh_tab = 15;
  left   = 75;
  right  = 77;
  up     = 72;
  down   = 80;
  pgup   = 73;
  pgdown = 81;
  home   = 71;
  ende   = 79;
  return = 13;
  esc    = 27;
  del    = 83;
  ins    = 82;
  mask_num     = '1234567890';
  mask_al      = 'abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';
  mask_alnum   = mask_al + mask_num;
  mask_hex     = '1234567890ABCDEFabcdef';
  mask_special = ' !"#$%&'+chr(39)+'()*+,-./:;<=>?@[\]^_`'+chr(123)+'|'+chr(125)+'~';
  mask_ascii   = mask_alnum + mask_special;
type
  picklist_type     = array[0..19] of string;
  picklist_ptr_type = ^picklist_type;
var
  taste       : char;
  config_file : file of configtype;
  config      : configtype;
  pk_mode     : picklist_ptr_type;
  pk_baud     : picklist_ptr_type;
  pk_prg      : picklist_ptr_type;
  pk_progress : picklist_ptr_type;
  pk_scan     : picklist_ptr_type;
  pk_dial     : picklist_ptr_type;
  pk_hackmode : picklist_ptr_type;
  pk_hangup   : picklist_ptr_type;
  pk_yes_no   : picklist_ptr_type;
  pk_on_off   : picklist_ptr_type;
  pk_datfilesave: picklist_ptr_type;
  pk_delay    : picklist_ptr_type;
  pk_reinit   : picklist_ptr_type;
  pk_init     : picklist_ptr_type;
  pk_save     : picklist_ptr_type;
procedure init_data;
procedure deinit_data;

implementation

procedure init_data;
begin
  new(pk_mode);
  pk_mode^[ 0] := '8N1';
  pk_mode^[ 1] := '8N2';
  pk_mode^[ 2] := '8E1';
  pk_mode^[ 3] := '8E2';
  pk_mode^[ 4] := '8O1';
  pk_mode^[ 5] := '8O2';
  pk_mode^[ 6] := '8M1';
  pk_mode^[ 7] := '8M2';
  pk_mode^[ 8] := '8S1';
  pk_mode^[ 9] := '8S2';
  pk_mode^[10] := '7N1';
  pk_mode^[11] := '7N2';
  pk_mode^[12] := '7E1';
  pk_mode^[13] := '7E2';
  pk_mode^[14] := '7O1';
  pk_mode^[15] := '7O2';
  pk_mode^[16] := '7M1';
  pk_mode^[17] := '7M2';
  pk_mode^[18] := '7S1';
  pk_mode^[19] := '7S2';

  new(pk_baud);
  pk_baud^[ 0] := '300';
  pk_baud^[ 1] := '1200';
  pk_baud^[ 2] := '2400';
  pk_baud^[ 3] := '4800';
  pk_baud^[ 4] := '9600';
  pk_baud^[ 5] := '19200';
  pk_baud^[ 6] := '38400';
  pk_baud^[ 7] := '57600';
  new(pk_init);
  pk_init^[ 0] := 'MODEM CONFIG';
  pk_init^[ 1] := 'MODEM RESPONSES';
  pk_init^[ 2] := 'SCANNING OPTIONS';
  pk_init^[ 3] := 'LOGFILES';
  pk_init^[ 4] := 'EXECUTE CONFIG';
  pk_init^[ 5] := 'MISCELLANEOUS';
  pk_init^[ 6] := 'REINIT';
  pk_init^[ 7] := 'SAVE + EXIT';
  new(pk_prg);
  new(pk_progress);
  pk_progress^[0] := 'PLAIN';
  pk_progress^[1] := 'FADING';
  pk_progress^[2] := 'ADVANCING';
  new(pk_hackmode);
  pk_hackmode^[0] := 'WAIT';
  pk_hackmode^[1] := 'NUDGE';
  pk_hackmode^[2] := 'MANUAL';
  pk_hackmode^[3] := 'OFF';
  new(pk_scan);
  pk_scan^[0] := 'CARRIERS';
  pk_scan^[1] := 'TONES';
  new(pk_dial);
  pk_dial^[0] := 'RANDOM';
  pk_dial^[1] := 'SEQUENTIELL UP';
  pk_dial^[2] := 'SEQUENTIELL DOWN';
  new(pk_reinit);
  pk_reinit^[0] := 'DEFAULT SETTINGS';
  pk_reinit^[1] := 'RELOAD FILE';
  pk_reinit^[2] := 'BACK TO MAIN MENU';
  new(pk_hangup);
  pk_hangup^[0] := 'FAST/SMART/CHECK';
  pk_hangup^[1] := 'SECURE/SMART/CHECK';
  pk_hangup^[2] := 'FAST/DUMB/CHECK';
  pk_hangup^[3] := 'SECURE/DUMB/CHECK';
  pk_hangup^[4] := 'FAST/SMART/WAIT';
  pk_hangup^[5] := 'SECURE/SMART/WAIT';
  pk_hangup^[6] := 'FAST/DUMB/WAIT';
  pk_hangup^[7] := 'SECURE/DUMB/WAIT';
  new(pk_yes_no);
  pk_yes_no^[0] := 'YES';
  pk_yes_no^[1] := 'NO';
  new(pk_on_off);
  pk_on_off^[0] := 'ON';
  pk_on_off^[1] := 'OFF';
  new(pk_datfilesave);
  pk_datfilesave^[0] :='Delete Left + Delete Special';
  pk_datfilesave^[1] :='Delete Left';
  pk_datfilesave^[2] :='Delete Right + Delete Special';
  pk_datfilesave^[3] :='Delete Right';
  new(pk_delay);
  pk_delay^[0] := 'OFF';
  pk_delay^[1] := 'DIAL';
  pk_delay^[2] := 'SEND';
  pk_delay^[3] := 'DIAL + SEND';
  new(pk_save);
  pk_save^[0] := 'SAVE + QUIT';
  pk_save^[1] := 'QUIT WITHOUT SAVING';
  pk_save^[2] := 'CHANGE FILENAME';
  pk_save^[3] := 'BACK TO MAIN MENU';
end;

procedure deinit_data;
begin
  dispose(pk_mode);
  dispose(pk_baud);
  dispose(pk_prg);
  dispose(pk_progress);
  dispose(pk_scan);
  dispose(pk_dial);
  dispose(pk_hackmode);
  dispose(pk_hangup);
  dispose(pk_yes_no);
  dispose(pk_on_off);
  dispose(pk_delay);
  dispose(pk_init);
  dispose(pk_reinit);
  dispose(pk_datfilesave);
  dispose(pk_save);
end;

end.