program dat_manp;
uses dos,crt,my2,ts_lib,version;
var f,g            : file;
    ts             : array[0..9999] of byte;
    ts_head        : array[1..32] of byte;
    a,b,c,d,count,number : word;
    ch             : char;
    name1,tmp      : string;
    id_1,id_2,mode : byte;
    _id1,_id2      : byte;
    e              : longint;

procedure HELP;
begin
   writeln('SYNTAX : DAT-MANP.EXE <Datfile> <OLD_ID> <NEW_ID>');
   writeln('  or     DAT-MANP.EXE <Datfile> DIRECT <Number> <NEW_ID>');
   writeln;
   writeln('OPTIONS: <Datfile> Datfile to change the IDs in');
   writeln('         [MODE 1] <OLD_ID> ID type to change from');
   writeln('                  <NEW_ID> ID type to change to');
   writeln('         [MODE 2] DIRECT   Keyword which switchs to MODE 2');
   writeln('                  <Number> Scanned number to change the ID from (0 to 9999)');
   writeln('                  <NEW_ID> New ID for the scanned number');
   writeln;
   writeln('[MODE 1] : Changes all IDs of a special type in a datfile into another.');
   writeln('[MODE 2] : Changes the ID of *one* special scanned number.');
   writeln;
   writeln('As <*_ID> you may either use a number id (e.g. 72) (appended with an X if you');
   writeln('want to affect all ringcounts) or a name id (e.g. CARRIER, FAX, etc.).');
   writeln('Name ids always affect all ringcounts.');
   writeln;
   writeln('EXAMPLES : DAT-MANP TEST.DAT 16 0     (sets all Excluded to UnDialed)');
   writeln('           DAT-MANP TEST CUSTOM1 136x (sets all Custom1 to Interesting Voice,');
   writeln('                                       keeping the rings detected.)');
   writeln('           DAT-MANP TEST DIRECT 99 72 (sets no 99 in the Datfile to Carrier(0))');
   halt;
end;

procedure ERROR(typ:byte);
begin
   write('Error (',typ,') : ');
   case typ of
   1:writeln('Datfile not found!');
   2:writeln('Not a THC-SCAN Datfile!');
   3:writeln('<OLD_ID> is not a valid ID (0-255(X) or name, e.g. VOICE) : ',ParamStr(2));
   4:writeln('<NEW_ID> is not a valid ID (0-255(X) or name, e.g. VOICE) : ',ParamStr(3));
   5:writeln('<Number> Parameter is not a number : ',tmp);
   6:writeln('<Number> Parameter is greater then DAT entries : ',tmp,' > 0-',c-1);
   7:writeln('<NEW_ID> a valid ID (0-255(X) or name, e.g. VOICE) : ',tmp);
   end; halt; end;

function acht(typ:byte):byte;
begin
   typ:=typ div 8;
   acht:=Trunc(typ*8);
end;

procedure TS_manp;
begin
   assign(f,name1); reset(f,1);
   blockread(f,ts_head,32); blockread(f,ts,c); close(f);
   assign(g,Forename(name1)+'.BAK'); rewrite(g,1); If IOResult<>0 then;
   blockwrite(g,ts_head,32); blockwrite(g,ts,c); close(g); If IOResult<>0 then;
   for a:=0 to c-1 do begin
     b:=ts[a];
     if (id_1=0) then begin
       if (b=0) then begin
        Inc(count);
        ts[a]:=id_2;
        end;
     end else
      if ((b div id_1) = 1)and(b mod id_1 < _id1) then begin
        Inc(count);
        if _id2>1 then
           ts[a]:=id_2 + ((b mod id_1) mod 8)
        else
           ts[a]:=id_2;
      end;
   end;
   assign(f,name1); rewrite(f,1);
   blockwrite(f,ts_head,32); blockwrite(f,ts,c);
   close(f);
end;

begin
   writeln('DAT Manipulator ',ver,author,email); writeln;
   Checkbreak:=false; SetCBreak(FALSE);
   if (ParamCount<3)or(ParamCount>4) then help;
   tmp:=ParamStr(2); Upc(tmp);
   if (ParamCount=4)and(tmp[1]<>'D') then help;
   name1:=ParamStr(1); upc(name1);
   if not Checkfile(name1) then begin
      name1:=name1+'.DAT';
      if not CheckFile(name1) then Error(1); end;
 If ParamCount=3 then begin

      tmp:=ParamStr(2);
      if not name_2_id(tmp, id_1) then Error(3); _id1:=_id_mod;
      tmp:=ParamStr(3);
      if not name_2_id(tmp, id_2) then Error(4); _id2:=_id_mod;

   c:=FSize(name1); mode:=0;
   if c=42 then mode:=1; if c mod 100 = 32 then mode:=1;
   if c>10032 then mode:=0;  if (mode=0)or(c=32) then Error(2);
   for a:=0 to 9999 do ts[a]:=0; c:=c-32; count:=0;
   writeln('Writing .BAK File ...');
   writeln('DAT File : ',name1);
   writeln('DAT Size : ',c,' bytes (+ 32 byte Header)');
   write('Exchange : ',id_1);
      if _id1>1 then write(' (All ring counts') else writeln;
      if _id1>8 then writeln(' and all types)') else writeln(')');
   write('... with : ',id_2);
      if _id2>1 then writeln(' (transfering rings)') else writeln;
   ts_manp;
   writeln('Changed  : ',count,' entries.');
 end else begin
   c:=FSize(name1); mode:=0;
   if c=42 then mode:=1; if c mod 100 = 32 then mode:=1;
   if c>10032 then mode:=0;  if (mode=0)or(c=32) then Error(2);
   for a:=0 to 9999 do ts[a]:=0; c:=c-32; count:=0;
   tmp:=ParamStr(3); e:=Str2LongInt(tmp); if (e=0)and((tmp[1]<>'0')or(length(tmp)>1)) then Error(5);
   if e > c-1 then Error(6); number:=e mod 65536;
   tmp:=ParamStr(4);
   if not name_2_id(tmp, id_2) then error(7);

   writeln('Writing .BAK File ...');
   writeln('DAT File : ',name1);
   writeln('DAT Size : ',c,' bytes (+ 32 byte Header)');
   writeln('Number   : ',number);
   writeln('ID to set: ',id_2);
   assign(f,name1); reset(f,1);
   blockread(f,ts_head,32); blockread(f,ts,c); close(f);
   assign(g,Forename(name1)+'.BAK'); rewrite(g,1); If IOResult<>0 then;
   blockwrite(g,ts_head,32); blockwrite(g,ts,c); close(g); If IOResult<>0 then;
   ts[number]:=id_2;
   assign(f,name1); rewrite(f,1);
   blockwrite(f,ts_head,32); blockwrite(f,ts,c);
   close(f);
   writeln('Changed.');
 end;
end.