{ͻ
  Unit      _IO.pas                                      
                                                         
  Compiler  Turbo Pascal 6.0                             
                                                         
  Date      24.02.90                                     
                                                         
  Update    18.04.91                                     
                                                         
  Autor     Reiner Schlles                              
 Ķ
  Inhalt    Ein- Ausgabe-Routinen.                       
 ͼ}
Unit _IO;
{ͻ
  Interface (ffentlicher Teil)                           
 ͼ}
Interface
uses {Einzubindende Bibliotheken}
  Crt,                     {Unit aus dem Turbo Pascal-System}
  _Declare;                         {Unit aus dem Unitsystem}

const {Globale Konstanten}
  _CursorMode : 0..1 = 1;         {0=Unsichtbar, 1=Sichtbar}
  _TonFrequenz: integer = 500;             {Angabe in Hertz}
  _TonDauer   : integer = 200;            {In Millisekunden}
  _CStrOben   : byte = White;           {Farben fr Schrift}
  _CStrUnten  : byte = White;            {in der Umranndung}

type {Globale Datentypen}
  {Ŀ
    _AuswahlRec und _Leiste sind Typverein-  
    barungen fr die Routine _AuswahlLeiste. 
   }
  _AuswahlRec = record
                  Bez   : string[30];          {Bezeichnung}
                  Sp,Zei: byte;               {Spalte,Zeile}
                  Mld25 : _WorkStr;      {Meldung 25. Zeile}
                end;

  _Leiste    = array[1..22] of _AuswahlRec;

  _EinAusAry = array[1..2] of _AuswahlRec;

  {Ŀ
    _Bildschirm und _BildPointer werden fr die Speiche-  
    rung des Bildschirminhaltes bentigt. Der Bildschirm- 
    besteht aus 25 Zeilen x 80 Zeichen/Zeile. Das ergibt  
    insgesamt 2000 Zeichen, wobei das jeweilige Zeichen   
    und das entsprechende Attribut festgehalten werden.   
   }
  _Bildschirm = array[1..2000] of record
                                    Zeichen: char;
                                       Attr: byte;
                                  end;

  _BildPointer = ^_Bildschirm;         {Fr Heapspeicherung}

var {Globale Variablen}
  _Mono: _Bildschirm Absolute $B000:0000;      {Monomonitor}
  _Farb: _Bildschirm Absolute $B800:0000;      {Farbmonitor}

  {Verzeichnis der globalen Routinen}

  procedure _CursorErmitteln;
  procedure _CursorAus;
  procedure _CursorEin;
  procedure _SignalTon(n: integer);
  procedure _FehlerTon;
  procedure _LiesChar(ch: char);
  procedure _Go(Spalte,Zeile: byte);
  procedure _Horizontale(Spalte,Zeile,
                         Laenge,Zeichen: byte);
  procedure _Vertikale(Spalte,Zeile,
                       Laenge,Zeichen: byte);
  procedure _Umrandung(x1,y1,x2,y2: byte;
                             ASCII: byte;
                             Clear: boolean;
                          StrOben,
                          StrUnten: _WorkStr);
  procedure _LeerZeilen(Anz: byte);
  procedure _Warten;
  procedure _Weiter;
  function _FrageJa(Spalte,Zeile: byte;
                           Frage: _WorkStr): boolean;
  function _AuswahlLeiste(Leiste : _Leiste;
                          Anz,Anf: byte;
                          Zeile  : boolean): byte;
  function _EinAus(Leiste: _EinAusAry): byte;
  procedure _InversEin;
  procedure _InversAus;
  procedure _BlinkEin;
  procedure _BlinkAus;
  function _Upcase(ch: char): char;
  procedure _GrossBuchstaben(var Zeile: _LongStr);
  function _RandomStr: _WorkStr;
  procedure _Write(Spalte,Zeile: byte; Str: _WorkStr);
  procedure _WriteInv(Spalte,Zeile: byte; Str: _WorkStr);
  procedure _WriteBli(Spalte,Zeile: byte; Str: _WorkStr);
  procedure _WriteZen(Anf,Ende,Zeile: byte;
                        Str         : _WorkStr;
                        Invers,Blink: boolean);
  procedure _WriteColor(Spalte,Zeile,Farbe: byte;
                                      Str : _WorkStr);
  procedure _GueltigeFarben(var C1,C2: byte);
  procedure _SetColor(C1,C2: byte; Clear: boolean);
  procedure _SetTempColor(C1,C2: byte; Clear: boolean);
  procedure _GetOldColor(Clear: boolean);
  procedure _Clean(Spalte,Zeile,Laenge: byte);
  procedure _CleanZeilen(Spalte,ZeiAnf,
                         ZeiEnd,Laenge: byte);
  procedure _Clean25;
  procedure _BildAufHeap(Var Bildname: _BildPointer);
  procedure _BildVomHeap(Bildname: _BildPointer;
                          NormScr: boolean);

  procedure _ErrorBox(Mld: _WorkStr);
  procedure _MldBox(x,y: byte; Bez,Mld: _WorkStr);
  function _InputBox(x,y,Len   : byte;
                       Datentyp: byte;
                     Bez,VorAnt: _WorkStr): _WorkStr;
  function _FrageBox(x,y      : byte;
                     Bez,Frage: _WorkStr): boolean;

{ͻ
  Implementation (Nicht-ffentlicher Teil)                
 ͼ}
Implementation
uses {Einzubindende Bibliotheken}
  Dos,                     {Unit aus dem Turbo Pascal-System}
  _Check,_Input,
  _Disk,_Windows,                  {Units aus dem Unitsystem}
  my2;

const {Lokale Konstanten}
  _TextColorErrorBox = White;                 {Fr ErrorBox}
  _BackColorErrorBox = Red;
  _TextColorMldBox   = White;                   {Fr MldBox}
  _BackColorMldBox   = Blue;
  _TextColorInputBox = LightCyan;             {Fr InputBox}
  _BackColorInputBox = Black;
  _TextColorFrageBox = White;                 {Fr Fragebox}
  _BackColorFrageBox = Green;

var {Lokale Variablen}
  _CurAnf,_CurEnd: byte;          {Anfangs- und Endposition}
                                       {des Cursors (Gre)}

{ͻ
  _CursorErmitteln                                        
 Ķ
  Ermittelt momentane Cursorgre und wird beim Einbinden 
  dieser Unit aufgerufen.                                 
 ͼ}
procedure _CursorErmitteln;
begin
  _Regs.ah:= $0F;
  Intr($10,_Regs);
  _Regs.ah:= $03;
  Intr($10,_Regs);
  _CurAnf:= _Regs.ch;
  _CurEnd:= _Regs.cl;
end;
{ͻ
  _CursorAus                                              
 Ķ
  Macht den Cursor unsichtbar.                            
 ͼ}
procedure _CursorAus;
begin
  _Regs.ah:= $01;
  _Regs.ch:= $20;
  _Regs.cl:= $00;
  Intr($10,_Regs);
  _CursorMode:= 0;
end;
{ͻ
  _CursorEin                                              
 Ķ
  Macht den Cursor wieder sichtbar.                       
 ͼ}
procedure _CursorEin;
begin
  _Regs.ah:= $01;
  _Regs.ch:= _CurAnf;
  _Regs.cl:= _CurEnd;
  Intr($10,_Regs);
  _CursorMode:= 1;
end;
{ͻ
  _SignalTon                                              
 Ķ
  Gibt n-mal einen Signalton aus. Die Frequenz ist durch  
  die Konstante _TonFrequenz, die Dauer des Tones durch   
  die Konstante _TonDauer festgelegt. Ein Ton ertnt je-  
  doch nur dann, wenn die globale Konstante _WarnTon aus  
  der Unit _Declare auf True gesetzt ist.                 
 ͼ}
procedure _SignalTon(n: integer);
var i: integer;
begin
  if _WarnTon then
  begin
    for i:= 1 to n do
    begin
      Sound(_TonFrequenz);
      Delay2(_TonDauer);
      NoSound;
    end;
  end;
end;
{ͻ
  _FehlerTon                                              
 Ķ
  Gibt einen Fehlerton aus. Die Frequenz ist durch die    
  Konstante _TonFrequenz, die Dauer des Tones durch die   
  Konstante _TonDauer festgelegt. Der Fehlerton kann nicht
  ausgeschaltet werden.                                   
 ͼ}
procedure _FehlerTon;
begin
  Sound(_TonFrequenz);
  Delay2(_TonDauer);
  NoSound;
end;
{ͻ
  _LiesChar                                               
 Ķ
  Wartet auf das Drcken der bergebenen Taste bzw. des   
  bergebenen Zeichens. Gltig sind auch die in der Unit  
  _Input vereinbarten Konstanten.                         
 ͼ}
procedure _LiesChar(ch: char);
begin
  repeat
  until _Readkey = ch;
end;
{ͻ
  _Go                                                     
 Ķ
  Positioniert den Cursor an die Stelle Spalte/Zeile und  
  ist eine Abkrzung der Pascal-Prozedur GotoXY(x,y).     
 ͼ}
procedure _Go(Spalte,Zeile: byte);
begin
  GotoXY(Spalte,Zeile);
end;
{ͻ
  _Horizontale                                            
 Ķ
  Zeichnet horizontale Linie mit dem angegebenen Zeichen  
  und der vorgegebenen Lnge auf den Bildschirm.          
 ͼ}
procedure _Horizontale(Spalte,Zeile,Laenge,Zeichen: byte);
var i: byte;
begin
  GotoXY(Spalte,Zeile);
  for i:= 1 to Laenge do write(chr(Zeichen));
end;
{ͻ
  _Vertikale                                              
 Ķ
  Zeichnet vertikale Linie mit dem angegebenen Zeichen und
  der vorgegebenen Lnge auf den Bildschirm.              
 ͼ}
procedure _Vertikale(Spalte,Zeile,Laenge,Zeichen: byte);
var i: byte;
begin
  for i:= Zeile to (Zeile+Laenge-1) do
  begin
    GotoXY(Spalte,i);
    write(chr(Zeichen));
  end;
end;
{ͻ
  _Umrandung                                              
 Ķ
  Zeichnet Bildschirmumrandung. Wahlweise kann der Rahmen 
  mit dem ASCII-Code 196, 205, 220 oder 254 festgelegt    
  werden. Wird ein anderer als dieser Code angegeben, so  
  wird der Code 196 angenommen. Der Bildschirm kann vorher
  gelscht werden (Clear = True). Auerdem kann in der    
  ersten und in der letzten Umrandungszeile (StrOben/     
  StrUnten) jeweils ein beliebiger Textstring ausgegeben  
  werden (Breite der Umrandung beachten!). Soll kein Text 
  ausgegeben werden, so ist jeweils ein Leerstring ('') zu
  bergeben!. (x1/y1) und (x2/y2) geben die linke obere   
  bzw. rechte untere Bildschirmposition an.               
 ͼ}
procedure _Umrandung(x1,y1,x2,y2: byte;
                           ASCII: byte;
                           Clear: boolean;
                        StrOben,
                        StrUnten: _WorkStr);
var
  Lo,Lu,Ro,Ru,
  ZhO,Zhu,Zvl,Zvr,             {Zeichen f. Ecken und Linien}
  Help            : byte;                     {Hilfvariable}

begin
  {Welche Rahmenart setzen?}
  case ASCII of
    205: begin {}                                     {ͻ}
           Lo := 201; Lu := 200; Ro := 187; Ru := 188; { }
           Zho:= 205; Zhu:= 205; Zvl:= 186; Zvr:= 186; {ͼ}
         end;
    220: begin {}                                     {}
           Lo := 220; Lu := 223; Ro := 220; Ru := 223; { }
           Zho:= 220; Zhu:= 223; Zvl:= 221; Zvr:= 222; {}
         end;
    254: begin {}                                     {}
           Lo := 254; Lu := 254; Ro := 254; Ru := 254; { }
           Zho:= 254; Zhu:= 254; Zvl:= 254; Zvr:= 254; {}
         end
    else       {dann wird Code 196 () angenommen}     {Ŀ}
           Lo := 218; Lu := 192; Ro:= 191; Ru:= 217;   { }
           Zho:= 196; Zhu:= 196; Zvl:= 179; Zvr:= 179; {}
  end; {case + else}

  if clear then clrscr;
  {Die vier Ecken setzen}
  GotoXY(x1,y1); write(chr(Lo));                {Links oben}
  GotoXY(x1,y2); write(chr(Lu));               {Links unten}
  GotoXY(x2,y1); write(chr(Ro));               {Rechts oben}
  GotoXY(x2,y2); write(chr(Ru));              {Rechts unten}
  {Horizontale Linien}
  _Horizontale(x1+1,y1,x2-x1-1,Zho);
  _Horizontale(x1+1,y2,x2-x1-1,Zhu);
  {Vertikale Linien}
  _Vertikale(x1,y1+1,y2-y1-1,Zvl);
  _Vertikale(x2,y1+1,y2-y1-1,Zvr);
  {Text in obere Rahmenzeile}
  if StrOben <> '' then
  begin
    if (x2-x1+1-3) >= Length(StrOben) then
    begin
      Help:= ((x2-x1) div 2) - (Length(StrOben) div 2) + x1;
      _WriteColor(Help,y1,_CStrOben,StrOben);
    end;
  end;
  {Text in untere Rahmenzeile}
  if StrUnten <> '' then
  begin
    if (x2-x1+1-3) >= Length(StrUnten) then
    begin
      Help:= ((x2-x1) div 2)-(Length(StrUnten) div 2) + x1;
      _WriteColor(Help,y2,_CStrUnten,StrUnten);
    end;
  end;
end;
{ͻ
  _LeerZeilen                                             
 Ķ
  Erzeugt angegebene Anzahl von Leerzeilen auf dem Bild-  
  schirm.                                                 
 ͼ}
procedure _LeerZeilen(Anz: byte);
var i: byte;

begin
  for i:= 1 to Anz do writeln;
end;
{ͻ
  _Warten                                                 
 Ķ
  Wartet auf beliebigen Tastendruck.                      
 ͼ}
procedure _Warten;
var ch: char;

begin
  ch:= _Readkey;
end;
{ͻ
  _Weiter                                                 
 Ķ
  Schreibt in die 25. Zeile den u.g. Text zentriert und   
  invers und wartet auf Tastendruck. Danach wird die 25.  
  Zeile wieder gelscht.                                  
 ͼ}
procedure _Weiter;
const Mdl = ' Mit beliebiger Taste weiter... ';

begin
  _WriteZen(1,80,25,Mdl,true,false);
  _SignalTon(1);
  _Warten;
  _Clean25;
end;
{ͻ
  _FrageJa                                                
 Ķ
  Schreibt eine Frage auf den Bildschirm und wartet auf   
  die Beantwortung. Erlaubt sind nur [J] und [N]. Wird auf
  die Frage mit [J] geantwortet, ist das Ergebnis der     
  Funktion True, sonst False. Anschlieend wird der Text  
  wieder gelscht.                                        
 ͼ}
function _FrageJa(Spalte,Zeile: byte;
                         Frage: _WorkStr): boolean;
var ch: char;

begin
  _Write(Spalte,Zeile,Frage);
  repeat
    _SignalTon(1);
    GotoXY(Spalte+Length(Frage),Zeile);
    ch:= Upcase(Readkey);
  until ch in _JN;
  if ch = 'J' then _FrageJa:= true
              else _FrageJa:= false;
  _Clean(Spalte,Zeile,Length(Frage));
end;
{ͻ
  _AuswahlLeiste                                          
 Ķ
  Auswahlpunkte knnen zeilen- oder spaltenweise auf dem  
  Bildschirm angeordnet werden. Die Auswahl erfolgt mit   
  den Cursortasten und [Home]/[End]. Je nach Darstellung  
  sind von den Cursortasten entweder nur [Links]/[Rechts] 
  oder [Oben]/[Unten] aktiviert. Die Ordnungszahl des mit 
  [Return] ausgewhlten Punktes wird als Ergebnis der     
  Funktion zurckgeliefert.                               
 ͼ}
function _AuswahlLeiste(Leiste : _Leiste;
                        Anz,Anf: byte;
                        Zeile  : boolean): byte;

var
  Tasten: Set of char;                     {Gedrckte Taste}
  i     : byte;                               {Zhlvariable}
  ch    : char;                                {Tastendruck}
  CMode : 0..1;                          {Alter Cursor-Mode}

{WriteMld25}
procedure WriteMld25;
var x: byte;                               {Position Spalte}
begin
  if Leiste[i].Mld25 <> '' then
  begin
    GotoXY(1,25);
    ClrEol;
    x:= 1 + Trunc(39-(Length(Leiste[i].Mld25)/2));
    _WriteColor(x,25,CMld25,Leiste[i].Mld25);
  end;
end;
{DeleteMld25}
procedure DeleteMld25;
begin
  if Leiste[i].Mld25 <> '' then
  begin
    GotoXY(1,25);
    ClrEol;
  end;
end;
{Wahl}
{Steuert die Auswahl mit den Cursortasten}
procedure Wahl;
begin
  _Write(Leiste[i].Sp,Leiste[i].Zei,Leiste[i].Bez);
  case ch of
    _Left,_Up : begin
                  Dec(i);
                  if i < 1 then i:= Anz;
                end;
    _Right,_Dn: begin
                  Inc(i);
                  if i > Anz then i:= 1;
                end;
    _Home     : i:= 1;
    _End      : i:= Anz;
    _ESC      : i:=0;
  end; {case}
  if i>0 then begin _WriteInv(Leiste[i].Sp,Leiste[i].Zei,Leiste[i].Bez);
  GotoXY(Leiste[i].Sp,Leiste[i].Zei); end;
end;
{}

begin
  CMode:= _CursorMode;              {Cursor-Mode festhalten}
  if Zeile then Tasten:= [_Left,_Right,_Home,_End,_Cr]
           else Tasten:= [_Dn,_Up,_Home,_End,_Cr];
  for i:= 1 to Anz do
    _Write(Leiste[i].Sp,Leiste[i].Zei,Leiste[i].Bez);
  if (Anf >= 1) and (Anf <=Anz)
    then i:= Anf                           {Anfangsposition}
    else i:= 1;
  _WriteInv(Leiste[i].Sp,Leiste[i].Zei,Leiste[i].Bez);
  GotoXY(Leiste[i].Sp,Leiste[i].Zei); {Cursor an den Anfang}
  ch:= ' ';
  while (ch <> _Cr)and(ch<>_ESC) do
  begin
    _CursorAus;
    WriteMld25;
    repeat
      ch:=_Readkey;
    until (ch=_ESC)or(ch in Tasten);
    DeleteMld25;
    if CMode = 1 then _CursorEin;
    if (ch <> _Cr)and(ch<>_ESC) then Wahl;
  end; {while}
  if ch=_ESC then i:=0;
  _AuswahlLeiste:= i;
end;
{ͻ
  _EinAus                                                 
 Ķ
  Zwei Auswahlpunkte (in der Regel "Ja"/"Nein" bzw. "Ein"/
  "Aus" werden nebeneinander dargestellt. Mit den Pfeil-  
  tasten wird eine Option ausgewhlt und mit [Return] be- 
  sttigt. Das Ergebnis der Funktion lautet entweder "1"  
  oder "2".                                               
 ͼ}
function _EinAus(Leiste: _EinAusAry): byte;
var
  Tasten: Set of char;                     {Gedrckte Taste}
  i     : byte;                               {Zhlvariable}
  ch    : char;                                {Tastendruck}
  CMode : 0..1;                          {Alter Cursor-Mode}

{WriteMld25}
procedure WriteMld25;
var x: byte;                               {Position Spalte}
begin
  if Leiste[i].Mld25 <> '' then
  begin
    GotoXY(1,25);
    ClrEol;
    x:= 1 + Trunc(39-(Length(Leiste[i].Mld25)/2));
    _WriteColor(x,25,CMld25,Leiste[i].Mld25);
  end;
end;
{DeleteMld25}
procedure DeleteMld25;
begin
  if Leiste[i].Mld25 <> '' then
  begin
    GotoXY(1,25);
    ClrEol;
  end;
end;
{Wahl}
{Steuert die Auswahl mit den Cursortasten}
procedure Wahl;
begin
  _Write(Leiste[i].Sp,Leiste[i].Zei,Leiste[i].Bez);
  case ch of
    _Left : begin
              Dec(i);
              if i < 1 then i:= 2;
            end;
    _Right: begin
              Inc(i);
              if i > 2 then i:= 1;
            end;
  end; {case}
  _WriteInv(Leiste[i].Sp,Leiste[i].Zei,Leiste[i].Bez);
  GotoXY(Leiste[i].Sp,Leiste[i].Zei);
end;
{}

begin
  CMode:= _CursorMode;              {Cursor-Mode festhalten}
  Tasten:= [_Left,_Right,_Cr];
  for i:= 1 to 2 do
    _Write(Leiste[i].Sp,Leiste[i].Zei,Leiste[i].Bez);
  i:= 1;                                   {Anfangsposition}
  _WriteInv(Leiste[i].Sp,Leiste[i].Zei,Leiste[i].Bez);
  GotoXY(Leiste[i].Sp,Leiste[i].Zei); {Cursor an den Anfang}
  ch:= ' ';
  while ch <> _Cr do
  begin
    _CursorAus;
    WriteMld25;
    repeat
      ch:= _Readkey;
    until ch in Tasten;
    DeleteMld25;
    if CMode = 1 then _CursorEin;
    if ch <> _Cr then Wahl;
  end; {while}
  _EinAus:= i;
end;
{ͻ
  _InversEin                                              
 Ķ
  Auf inverse Bildschirm-Darstellung umschalten.          
 ͼ}
procedure _InversEin;
begin
  {Hintergrund- und Vordergrundfarbe vertauschen}
  TextBackground(_Config.Vordergrund);
  TextColor(_Config.Hintergrund);
end;
{ͻ
  _InversAus                                              
 Ķ
  Wieder 'normale' Bildschirm-Darstellung.                
 ͼ}
procedure _InversAus;
begin
  {Hintergrund und Vordergrund wieder normal}
  TextBackground(_Config.Hintergrund);
  TextColor(_Config.Vordergrund);
end;
{ͻ
  _BlinkEin                                               
 Ķ
  Blinkende Bildschirm-Darstellung einschalten.           
 ͼ}
procedure _BlinkEin;
begin
  TextColor(_Config.Vordergrund+Blink);
end;
{ͻ
  _BlinkAus                                               
 Ķ
  Blinkende Bildschirm-Darstellung ausschalten.           
 ͼ}
procedure _BlinkAus;
begin
  TextColor(_Config.Vordergrund);
end;
{ͻ
  _Upcase                                                 
 Ķ
  Ergnzt die Standard-Funktion Upcase. Diese Routine be- 
  rcksichtigt auch die deutschen Umlaute und wandelt sie 
  ebenfalls in Grobuchstaben um.                         
 ͼ}
function _Upcase(ch: char): char;
begin
  case ch of
    '': ch:= '';
    '': ch:= '';
    '': ch:= '';
    else ch:= Upcase(ch);
  end; {case}
  _Upcase:= ch;
end;
{ͻ
  _GrossBuchstaben                                        
 Ķ
  Wandelt eine Zeile in Grobuchstaben um und liefert sie 
  an das aufrufende Programm zurck.                      
 ͼ}
procedure _GrossBuchstaben(var Zeile: _LongStr);
var i: byte;

begin
  for i:= 1 to Length(Zeile) do
   Zeile[i]:= _Upcase(Zeile[i]);
end;
{ͻ
  _RandomStr                                              
 Ķ
  Erzeugt einen String der Lnge 79 mit zufllig ausge-   
  whlten Zeichen. Kann fr Testroutinen benutzt werden.  
 ͼ}
function _RandomStr: _WorkStr;
var
  St: _WorkStr;
  i : byte;

begin
  Randomize;        {Zufallszahlen-Generator initialisieren}
  St:= '';
  for i:= 1 to 79 do
   St:= St + (chr(Random(95)+32));
  _RandomStr:= St;
end;
{ͻ
  _Write                                                  
 Ķ
  Schreibt einen Text (Str) an eine bestimmte Stelle auf  
  den Bildschirm.                                         
 ͼ}
procedure _Write(Spalte,Zeile: byte; Str: _WorkStr);
begin
  GotoXY(Spalte,Zeile);
  write(Str);
end;
{ͻ
  _WriteInv                                               
 Ķ
  Schreibt einen Text (Str) an eine bestimmte Stelle      
  invers auf den Bildschirm.                              
 ͼ}
procedure _WriteInv(Spalte,Zeile: byte; Str: _WorkStr);
begin
  _InversEin;
  _Write(Spalte,Zeile,Str);
  _InversAus;
end;
{ͻ
  _WriteBli                                               
 Ķ
  Schreibt einen Text (Str) an eine bestimmte Stelle      
  blinkend auf den Bildschirm.                            
 ͼ}
procedure _WriteBli(Spalte,Zeile: byte; Str: _WorkStr);
begin
  _BlinkEin;
  _Write(Spalte,Zeile,Str);
  _BlinkAus;
end;
{ͻ
  _WriteZen                                               
 Ķ
  Schreibt einen Text (Str) wahlweise invers und/oder     
  blinkend zentriert zwischen 2 Spalten in der angegebe-  
  nen Zeile auf den Bildschirm.                           
 ͼ}
procedure _WriteZen(Anf,Ende,Zeile: byte;
                      Str         : _WorkStr;
                      Invers,Blink: boolean);
var
  Diff,                                       {(Ende-Anf)/2}
  Halb : real;                             {Halbe Textlnge}
  Sp   : byte;                                      {Spalte}

begin
  Diff:= (Ende-Anf)/2;
  Halb:= (Length(Str))/2;
  Sp  := Anf + trunc(Diff-Halb);
  if Invers then _InversEin;
  if Blink  then _BlinkEin;
  _Write(Sp,Zeile,Str);
  if Invers then _InversAus;
  if Blink  then _BlinkAus;
end;
{ͻ
  _WriteColor                                             
 Ķ
  Schreibt einen Text (Str) in einer bestimmten Farbe an  
  eine bestimmte Stelle auf den Bildschirm. Als Farben    
  sind die in der Standard-Unit Crt vereinbarten Konstan- 
  ten fr die Vordergrundfarbe zulssig.                  
 ͼ}
procedure _WriteColor(Spalte,Zeile,Farbe: byte;
                                    Str : _WorkStr);
begin
  if (Farbe <> _Config.Hintergrund) and _FarbMonitor
  then begin
         TextColor(Farbe);
         _Write(Spalte,Zeile,Str);
         TextColor(_Config.Vordergrund);
       end
  else _Write(Spalte,Zeile,Str);
end;
{ͻ
  _GueltigeFarben                                         
 Ķ
  Prft, ob die bergebenen Farben C1 (Vorder-) und C2    
  (Hintergrund) gltige Farbwerte darstellen, ob sie un-  
  gleich sind und zu dem angeschlossenen Monitor passen.  
  Liegt eine Diskrepanz vor, wird ein schwarzer Hinter-   
  grund und ein weier Vordergrund gewhlt und an das auf-
  rufende Programm zurckgeliefert.                       
 ͼ}
procedure _GueltigeFarben(var C1,C2: byte);

{WeissSchwarz}
procedure WeissSchwarz;
begin
  C1:= White; C2:= Black;
end;
{}


begin
  if not _IntRange(0,15,C1) then C1:= White;
  if not _IntRange(0,7,C2)  then C2:= Black;
  if C1 = C2 then WeissSchwarz;
  if not _FarbMonitor then WeissSchwarz;
end;
{ͻ
  _SetColor                                               
 Ķ
  Setzt Vorder- und Hintergrundfarben des Monitors. Die   
  Werte sind der Standard-Unit Crt entnehmen. Es werden   
  Plausibilittprfungen vorgenommen.                     
 ͼ}
procedure _SetColor(C1,C2: byte; Clear: boolean);
begin
  _GueltigeFarben(C1,C2);
  _Config.Vordergrund:= C1;
  _Config.Hintergrund:= C2;
  _SetConfigColor;                           {Config-Farben}
  if Clear then Clrscr;
end;
{ͻ
  _SetTempColor                                           
 Ķ
  ndert Vorder- und Hintergrundfarbe nur kurzfristig. Die
  bisher gesetzten Werte werden gespeichert und knnen mit
  der Prozedur _GetOldColor wieder gesetzt werden. (C1 =  
  Vordergrund-, C2 = Hintergrundfarbe)                    
 ͼ}
procedure _SetTempColor(C1,C2: byte; Clear: boolean);
begin
  _OldVordergrund:= _Config.Vordergrund;       {Alte Farben}
  _OldHintergrund:= _Config.Hintergrund;        {festhalten}
  _SetColor(C1,C2,Clear);
end;
{ͻ
  _GetOldColor                                            
 Ķ
  Setzt wieder die vor dem Aufruf der Prozedur            
  _SetTempColor gltigen Werte fr Vorder- und Hinter-    
  grundfarbe.                                             
 ͼ}
procedure _GetOldColor(Clear: boolean);
begin
  _SetColor(_OldVordergrund,_OldHintergrund,Clear);
end;
{ͻ
  _Clean                                                  
 Ķ
  Die Bildschirmzeile mit dem angegebenen Anfangspunkt    
  wird auf einer bestimmten Lnge gelscht.               
 ͼ}
procedure _Clean(Spalte,Zeile,Laenge: byte);
begin
  _Horizontale(Spalte,Zeile,Laenge,32);
end;
{ͻ
  _CleanZeilen                                            
 Ķ
  Lscht mehrere Zeilen gleicher Lnge.                   
 ͼ}
procedure _CleanZeilen(Spalte,ZeiAnf,
                       ZeiEnd,Laenge: byte);
var i: byte;

begin
  for i:= ZeiAnf to ZeiEnd do _Clean(Spalte,i,Laenge);
end;
{ͻ
  _Clean25                                                
 Ķ
  Lscht die 25. Bildschirmzeile.                         
 ͼ}
procedure _Clean25;
begin
  GotoXY(1,25);
  ClrEol;
end;
{ͻ
  _BildAufHeap                                            
 Ķ
  Speichert einen Bildschirminhalt auf dem Heap. Dafr mu
  im aufrufenden Programm eine Variable vereinbart werden:
                                                          
  Z.B.:          Var  Scr: _BildPointer;                  
                                                          
  Auerdem mu  v o r  dem Aufruf dieser Prozedur mit     
  New(Scr) e. entsprechende Variable erzeugt worden sein. 
  Ebenfalls mu diese Variable, sptestens am Prg.Ende,   
  wieder vom Heap entfernt werden (mit Dispose(Scr);).    
 ͼ}
procedure _BildAufHeap(Var Bildname: _BildPointer);
begin
  if _FarbMonitor then Bildname^:= _Farb
                  else Bildname^:= _Mono;
end;
{ͻ
  _BildVomHeap                                            
 Ķ
  Holt einen auf dem Heap abgelegten Bildschirminhalt zu- 
  rck. V o r  dem Aufruf mu mit _BildAufHeap ein Bild-  
  schirminhalt a.d. Heap abgelegt worden sein. Davor mu  
  eine entsprechende dynamische Variable mit New(Variable)
  vom Typ _BildPointer erzeugt worden sein. Ist NormScr = 
  TRUE, so wird der Bildschirm wieder auf die Gre       
  (1,1,80,25) gesetzt.                                    
 ͼ}
procedure _BildVomHeap(Bildname: _BildPointer;
                        NormScr: boolean);
begin
  if _FarbMonitor then _Farb:= Bildname^
                  else _Mono:= Bildname^;
  if NormScr then _NormWindow;
end;
{ͻ
  _ErrorBox                                               
 Ķ
  Gibt in der Mitte des Bildschirms zentriert eine Fehler-
  meldung aus. Der vorherige Bildschirminhalt wird vorher 
  gesichert. Der Hintergrund ist rot, die Schrift wei.   
  Als Meldung kann ein beliebiger Text gewhlt werden. Die
  Position der Box wird automatisch ermittelt. Mit [ESC]  
  wird die Textbox wieder geschlossen.                    
 ͼ}
procedure _ErrorBox(Mld: _WorkStr);
const
  Bez = '>> Fehler <<';                      {Text im Rahmen}
  y1  = 23;                                {Zeile links oben}
  y2  = 25;                              {Zeile rechts unten}

var
  Breite,                              {Breite des Fensters}
  x1,x2,                    {Spalte links oben/rechts unten}
  OldX1,OldY1,
  OldX2,OldY2,
  CurX,CurY   : byte;           {Alte Bildschirmkoordinaten}
  CMode       : 0..1;                          {Cursor-Mode}
begin
  CMode:= _CursorMode;              {Cursor-Mode festhalten}
  _GetOldWinPar(OldX1,OldY1,
                OldX2,OldY2,
                CurX,CurY);    {Fensterparameter festhalten}
  _SaveScr;
  _NormWindow;                       {Volle Bildschirmgre}
  if Length(Bez) > Length(Mld)
   then Breite:= Length(Bez) + 5
   else Breite:= Length(Mld) + 5;
  Breite:= Breite div 2;
  x1:= 40 - Breite;
  x2:= 40 + Breite;
  TextColor(_TextColorErrorBox);
  TextBackground(_BackColorErrorBox);
  _Umrandung(x1,y1,x2,y2,196,false,Bez,'');
  _Horizontale(x1+1,y1+1,x2-x1-1,32);
  _WriteZen(x1+1,x2-1,y1+1,Mld,false,false);
  _CursorAus;
  _FehlerTon;
  _LiesChar(_Esc);
  if CMode = 1 then _CursorEin;
  _RestoreScr;
  _SetConfigColor;                    {Wieder Config-Farben}
  _SetOldWinPar(OldX1,OldY1,
                OldX2,OldY2,
                CurX,CurY);
end;
{ͻ
  _MldBox                                                 
 Ķ
  Gibt an der angegebenen Stelle auf dem Bildschirm eine  
  beliebige Meldung in weier Schrift auf blauem Hinter-  
  grund aus. Eine Bezeichnung der Box kann frei gewhlt   
  werden, sie wird in die Umrandung geschrieben. Der vor- 
  herige Bildschirminhalt wird vorher gesichert. Mit [ESC]
  kann die Textbox wieder vom Bildschirm entfernt werden. 
 ͼ}
procedure _MldBox(x,y: byte; Bez,Mld: _WorkStr);
var
  Breite,                              {Breite des Fensters}
  x1,y1,
  x2,y2,                                         {Eckpunkte}
  OldX1,OldY1,
  OldX2,OldY2,
  CurX,CurY   : byte;           {Alte Bildschirmkoordinaten}
  CMode       : 0..1;                          {Cursor-Mode}

begin
  CMode:= _CursorMode;              {Cursor-Mode festhalten}
  _GetOldWinPar(OldX1,OldY1,
                OldX2,OldY2,
                CurX,CurY);    {Fensterparameter festhalten}
  _SaveScr;
  _NormWindow;                       {Volle Bildschirmgre}
  if Length(Bez) > Length(Mld)
   then Breite:= Length(Bez) + 5
   else Breite:= Length(Mld) + 5;
  x1:= x;
  y1:= y;
  x2:= x1 + Breite + 1;
  y2:= y1 + 2;
  TextColor(_TextColorMldBox);
  TextBackground(_BackColorMldBox);
  _Umrandung(x1,y1,x2,y2,196,false,Bez,'');
  _Horizontale(x1+1,y1+1,x2-x1-1,32);
  _WriteZen(x1+1,x2-1,y1+1,Mld,false,false);
  _SignalTon(1);
  _CursorAus;
  _LiesChar(_Esc);
  if CMode = 1 then _CursorEin;
  _RestoreScr;
  _SetConfigColor;                    {Wieder Config-Farben}
  _SetOldWinPar(OldX1,OldY1,
                OldX2,OldY2,
                CurX,CurY);
end;
{ͻ
  _InputBox                                               
 Ķ
  Gibt an der angegebenen Stelle auf dem Bildschirm eine  
  Eingabebox aus. Eine Bezeichnung der Box kann frei ge-  
  whlt werden, sie wird in die Umrandung geschrieben.    
  Auch die Angabe einer Vorgabe (VorAnt) fr das Eingabe- 
  feld ist mglich. Der vorherige Bildschirminhalt wird   
  voher gesichert. Das Eingabefeld wird mit <CR> verlas-  
  sen u. damit die Eingabe besttigt und als Ergebnis der 
  Funktion an das aufrufende Programm zurckgeliefert.    
 ͼ}
function _InputBox(x,y,Len: byte;
                     Datentyp: byte;
                   Bez,VorAnt: _WorkStr): _WorkStr;
var
  Breite,                              {Breite des Fensters}
  x1,y1,
  x2,y2,                                         {Eckpunkte}
  OldX1,OldY1,
  OldX2,OldY2,
  CurX,CurY   : byte;           {Alte Bildschirmkoordinaten}
  Antwort     : _WorkStr;              {Eingegebene Antwort}
  Ctrl        : char;               {Taste fr Ende Eingabe}

begin
  _GetOldWinPar(OldX1,OldY1,
                OldX2,OldY2,
                CurX,CurY);    {Fensterparameter festhalten}
  _SaveScr;
  _NormWindow;                       {Volle Bildschirmgre}
  if Length(Bez) > Len
   then Breite:= Length(Bez) + 2
   else Breite:= Len + 1;
  x1:= x;
  y1:= y;
  x2:= x1 + Breite;
  y2:= y1 + 2;
  TextColor(_TextColorInputBox);
  TextBackground(_BackColorInputBox);
  _Umrandung(x1,y1,x2,y2,196,false,Bez,'');
  _Horizontale(x1+1,y1+1,x2-x1-1,32);
  Antwort:= VorAnt;
  repeat
    Antwort:= _Eingabe(x1,y1+1,Len,Datentyp,
                       false,true,true,
                       '',Antwort,'',Ctrl);
  until Ctrl in [_Cr,_Esc];
  _RestoreScr;
  _SetConfigColor;                    {Wieder Config-Farben}
  _SetOldWinPar(OldX1,OldY1,
                OldX2,OldY2,
                CurX,CurY);
  if Ctrl = _Esc then _InputBox:= ''
                 else _InputBox:= Antwort;
end;
{ͻ
  _FrageBox                                               
 Ķ
  Gibt an der angegebenen Stelle auf dem Bildschirm eine  
  beliebige Frage in weier Schrift auf blauem Hintergrund
  aus. Eine Bezeichnung der Box kann frei gewhlt werden, 
  sie wird in die Umrandung geschrieben. Der vorherige    
  Bildschirminhalt wird vorher gesichert. Als Beantwortung
  sind nur [J] (Ja) und [N] (Nein) zulssig. Die Funktion 
  liefert das Ergebnis True, wenn die Frage mit <J> beant-
  wortet wurde, sonst False.                              
 ͼ}
function _FrageBox(x,y: byte; Bez,Frage: _WorkStr): boolean;
var
  Breite,                              {Breite des Fensters}
  x1,y1,
  x2,y2,                                         {Eckpunkte}
  OldX1,OldY1,
  OldX2,OldY2,
  CurX,CurY   : byte;           {Alte Bildschirmkoordinaten}
  ch          : char;                      {Fr Tastendruck}
  CMode       : 0..1;                          {Cursor-Mode}

begin
  CMode:= _CursorMode;              {Cursor-Mode festhalten}
  _GetOldWinPar(OldX1,OldY1,
                OldX2,OldY2,
                CurX,CurY);    {Fensterparameter festhalten}
  _SaveScr;
  _NormWindow;                       {Volle Bildschirmgre}
  Frage:= Frage + ' (J/N)?';                {Frage ergnzen}
  if Length(Bez) > Length(Frage)
   then Breite:= Length(Bez) + 5
   else Breite:= Length(Frage) + 5;
  x1:= x;
  y1:= y;
  x2:= x1 + Breite + 1;
  y2:= y1 + 2;
  TextColor(_TextColorFrageBox);
  TextBackground(_BackColorFrageBox);
  _Umrandung(x1,y1,x2,y2,196,false,Bez,'');
  _Horizontale(x1+1,y1+1,x2-x1-1,32);
  _WriteZen(x1+1,x2-1,y1+1,Frage,false,false);
  _CursorAus;
  _SignalTon(1);
  repeat
    ch:= Upcase(_Readkey);
  until ch in ['J','N'];
  if ch = 'J' then _FrageBox:= true
              else _FrageBox:= false;
  if CMode = 1 then _CursorEin;
  _RestoreScr;
  _SetConfigColor;                    {Wieder Config-Farben}
  _SetOldWinPar(OldX1,OldY1,
                OldX2,OldY2,
                CurX,CurY);
end;
{ͻ
  Initialisierungs-Teil (Ausfhrungsteil)                 
 ͼ}
begin
  _CursorErmitteln;
  _CursorEin;
  Checkbreak:=false; SetCBreak(FALSE);
{ͻ
  End of Unit                                             
 ͼ}
end.