unit scanio;

interface
uses scaninit,consts;

type
  screentype = array [0..7999] of byte;

var
  screen      : screentype absolute $B800:0000;
  scr_pointer : array [1..64] of ^screentype;
  scr_count   : word;
  scr_width   : byte;
  escaped     : boolean;

FUNCTION Check4VGA: BOOLEAN;
function byte2hex(numb : byte): string;
function word2hex(numb : word): string;
function hex2byte(const numb : string): byte;
function hex2word(numb : string) : word;
procedure time;
procedure gotoxy(x, y : byte);
procedure cursoroff;
procedure cursorsize(custart, cuend : byte);
procedure writestring(x, y : word; text : string);
Procedure readstr(x, y, len, max : byte; const mask : string; var source : string; var taste : char; stuffed : boolean);
procedure save_screen(x1, y1, x2, y2 : byte);
procedure restore_screen(x1, y1, x2, y2 : byte);
procedure shadow(x1, y1, x2, y2 : byte);
procedure write_field(x,y,len:byte;source:string);
procedure field_color(x, y, len: word; color : byte);
procedure screenmode(spalten, zeilen: LONGINT);
procedure cls;
procedure blink_on;
procedure blink_off;
procedure display_box(x1,y1,x2,y2,color : byte;fill:boolean;fillchar:char);
procedure read_picklist(x, y, len, width, max : byte; var source : integer;
			var pk : picklist_ptr_type; var taste:char;
			box, high, low : word; allow_changes : boolean);
function upper(const source : string):string;
procedure display_help(number : integer);
procedure remove_help(number : integer);

implementation
uses dos,crt,my2;

FUNCTION Check4VGA: BOOLEAN;
  var Reg : DOS.Registers;
  BEGIN
    Reg.AX := $1A00;                     {Infobyte holen}
    Intr($10,Reg);                       {VGA mit VGA-Monitor?}
    Check4VGA := (Reg.AL = $1A) AND ((Reg.BL = 7) OR (Reg.BL = 8));
  END;

procedure display_help(number : integer);
begin
  save_screen(6, 27, 74, 31);
  writestring(6, 27, help_txt[number, 1]);
  writestring(6, 28, help_txt[number, 2]);
  writestring(6, 29, help_txt[number, 3]);
  writestring(6, 30, help_txt[number, 4]);
  writestring(6, 31, help_txt[number, 5]);
end;

procedure remove_help(number : integer);
begin
  restore_screen(6, 27, 74, 31);
end;
function byte2hex(numb : byte): string;
const
  hexchars : array[0..15] of char = '0123456789ABCDEF';
begin
  byte2hex[0] := #2;
  byte2hex[1] := hexchars[numb shr  4];
  byte2hex[2] := hexchars[numb and 15];
end;

function word2hex(numb : word): string;
begin
  word2hex:= byte2hex(hi(numb)) + byte2hex(lo(numb));
end;

function hex2byte(const numb : string): byte;
const
  hexchars : array[0..15] of char = '0123456789ABCDEF';
begin
  hex2byte := (pos(upcase(numb[1]), hexchars)-1) * 16 + pos(upcase(numb[2]), hexchars)-1;
end;

function hex2word(numb : string) : word;
var
  dummy : word;
  i : integer;
begin
  dummy := hex2byte(upcase(numb[1]) + upcase(numb[2])) shl 8;
  dummy := dummy + hex2byte(upcase(numb[3]) + upcase(numb[4]));
  hex2word := dummy;
end;

procedure time;
begin
end;

procedure gotoxy(x, y : byte);
var
  regs : registers;
begin
  regs.ah := $02;
  regs.bh := $00;
  dec(x);
  dec(y);
  regs.dh := y;
  regs.dl := x;
  intr($10, regs);
end;

procedure cursoroff;
var
  regs : registers;
begin
  regs.ax := $0100;
  regs.cx := $2000;
  intr($10,regs);
end;

procedure cursorsize(custart, cuend : byte);assembler;
asm
  mov ah, $01
  mov ch, custart
  mov cl, cuend
  int $10
end;

procedure writestring(x, y : word; text : string);
var
  i : integer;
begin
  for i := 0 to length(text)-1 do
    mem[$B800:2*((y-1)*scr_width+x+i-1)] := ord(text[i+1]);
end;

Procedure readstr(x, y, len, max : byte; const mask : string; var source : string; var taste : char; stuffed : boolean);
var
  i : integer;
  savestr : string;
  _strpos : integer;
  insertmode : boolean;
  esc : boolean;
  strlen : byte;
  _pos, _oldpos : integer;

procedure update_field(_pos, _oldpos, _strpos : byte; update : boolean);
var
  i     : integer;
  ptr   : integer;
  dummy : char;
begin
  if _pos <> _oldpos then gotoxy(x - 1 + _pos, y);
  if update then begin
    for i := 1 to len do begin
      ptr := (_strpos - len) + (len - _pos);
      if ptr < 0 then begin
	ptr := 0;
	if (_pos > 1) then begin
	  dec(_pos);
	  gotoxy(x - 1 + _pos, y);
	end;
      end;
      if ptr + i <= length(source) then
	dummy := source[ptr + i]
      else
	dummy := '';
    writestring(x + i - 1, y, dummy);
    end;
  end;
end;

procedure init;
begin
  savestr := source;
  _strpos:=1;
  _pos := 1;
  _oldpos := 1;
  gotoxy(x,y);
  esc:=false;
  insertmode := false;
  cursorsize(9,9);
end;

procedure restoresource;
var
  update : boolean;
begin
  _oldpos := _pos;
  source := savestr;
  _strpos := 1;
  _pos := 1;
  update := true;
  update_field(_pos, _oldpos, _strpos, update);
end;

procedure cursorhome;
var
  update : boolean;
begin
  if _strpos > 1 then begin
    _oldpos := _pos;
    if _pos > 1 then begin
      _pos := 1;
    end;
    _strpos := 1;
    update := true;
    update_field(_pos, _oldpos, _strpos, update);
  end;
end;

procedure cursorend;
var
  update : boolean;
begin
  if _strpos <= length(source) then begin
    _oldpos := _pos;
    if length(source) > len then begin
      if (_strpos + len - _pos) > length(source) then
	_pos :=  _pos + (length(source) - _strpos)
      else
	_pos := len;
    end else begin
      _pos := length(source);
    end;
    _strpos := length(source) + 1;
    inc(_pos);
    if (_pos > len) or (_strpos >= max) then _pos := len;
    if (_strpos > max) then _strpos := max;
    update := true;
    update_field(_pos, _oldpos, _strpos, update);
  end;
end;

procedure cursorleft;
var
  update : boolean;
begin
  if _strpos > 1 then begin
    _oldpos := _pos;
    if _pos > 1 then begin
      dec(_strpos);
      dec(_pos);
      update := false;
    end else begin
      dec(_strpos);
      update := true;
    end;
    update_field(_pos, _oldpos, _strpos, update);
  end;
end;

procedure cursorright;
var
  update : boolean;
begin
  if _strpos < length(source) then begin
    _oldpos := _pos;
    if _pos < len then begin
      inc(_strpos);
      inc(_pos);
      update := false;
    end else begin
      inc(_strpos);
      update := true;
    end;
    update_field(_pos, _oldpos, _strpos, update);
  end else
    cursorend;
end;

procedure setinsert;
begin
  if insertmode = true then begin
    insertmode := false;
    cursorsize(9,9);
  end else begin
    insertmode := true;
    cursorsize(0,9);
  end;
end;

procedure deletechar;
var
  update : boolean;
begin
  if _strpos-1 < length(source) then begin
    _oldpos := _pos;
    delete(source, _strpos,1);
    update := true;
    update_field(_pos, _oldpos, _strpos, update);
  end;
end;

procedure killinput;
var
  update : boolean;
begin
   _oldpos := 1;
   _pos := 1;
   source := '';
   update := true;
   update_field(_pos, _oldpos, _strpos, update);
end;

procedure wordright;
var
  i : integer;
  update : boolean;
  _oldstrpos : integer;
begin
  if _strpos <= length(source) then begin
    _oldstrpos := _strpos;
    _oldpos := _pos;
    i := _strpos;
    if i < length(source) then begin
      while (source[i] <> ' ') and (i < length(source)) do inc(i);
      while (source[i] = ' ') and (i < length(source)) do  inc(i);
      _strpos := i;
    end else if (i=length(source)) and (i<len) then inc(i);
    _strpos := i;
    if _pos +(_strpos - _oldstrpos) < len then
      _pos := _pos + (_strpos - _oldstrpos)
    else if _pos < max then
      _pos := len;
    if _strpos = length(source) then inc(_strpos);
    update := true;
    update_field(_pos, _oldpos, _strpos, update);
  end;
end;

procedure wordleft;
var
  i: integer;
  update : boolean;
begin
  if _strpos > 1 then begin
    _oldpos := _pos;
    i := _strpos - 1;
    if source[i] = ' ' then
      repeat
	dec(i)
      until (source[i] <> ' ') or (i = 0);
    if i > 0 then
      repeat
	dec(i);
      until (source[i] = ' ') or (i = 0);
    _strpos := i + 1;
    update := true;
    update_field(_pos, _oldpos, _strpos, update);
  end;
end;

procedure backspace;
var
  update : boolean;
begin
  if _strpos > 1 then begin
    _oldpos := _pos;
    dec(_strpos);
    dec(_pos);
    delete(source, _strpos, 1);
    update := true;
    update_field(_pos, _oldpos, _strpos, update);
  end;
end;

procedure writecharacter;
var
  update : boolean;
begin
  if insertmode = false then begin
    _oldpos := _pos;
    if _strpos <= max then begin
      if _strpos > length(source) then begin
	source := source + taste;
      end else begin
	source[_strpos] := taste;
      end;
     inc(_strpos);
     inc(_pos);
     if _strpos > max then _strpos := max;
     if _pos > len then _pos := len;
    end;
    update := true;
    update_field(_pos, _oldpos, _strpos, update);
  end else begin;
    _oldpos := _pos;
    if _strpos <= max then begin
     insert(taste, source, _strpos);
     inc(_strpos);
     inc(_pos);
     if _strpos > max then _strpos := max;
     if _pos > len then _pos := len;
    end;
    update := true;
    update_field(_pos, _oldpos, _strpos, update);
  end;
end;

procedure kill_space(var source : string);
var
  i : integer;
begin
  strlen := length(source);
  i := strlen;
  if strlen  > 0 then begin
    while (source[i] <= ' ') and (i>0) do
      dec(i);
    delete(source,i+1,strlen);
    i := 1;
     while (i <= strlen) and (source[i] <= ' ') do
       inc(i);
     delete(source,1,i-1);
  end;
  if length(source) < max then
    fillchar(source[length(source)+1], max - length(source), ' ');
{  update_field(1, 1, 1, true);
}end;

begin
  init;
  while esc=false do begin
    if stuffed = false then begin
      repeat time until keypressed;
      taste := readkey;
    end else
      stuffed := false;
    case ord(taste) of
      0 :
      begin
	taste := readkey;
	case ord(taste) of
	  15 : begin esc:=true; kill_space(source); end;
	  24 : begin esc:=true; kill_space(source); end;
	  75 : CursorLeft;
	  77 : CursorRight;
	  71 : CursorHome;
	  79 : CursorEnd;
	  80 : begin esc:=true; kill_space(source); end;
	  81 : begin esc:=true; kill_space(source); end;
	  72 : begin esc:=true; kill_space(source); end;
	  73 : begin esc:=true; kill_space(source); end;
	  82 : SetInsert;
	  83 : DeleteChar;
	  116 : WordRight;
	  115 : WordLeft;
	  45  : esc:=true;
	  19  : esc:=true;
	end;
      end;
      09: esc:=true;
      08: backspace;
      13: begin esc:=true; kill_space(source); end;
      18: ;
      24: killinput;
      27: begin esc:=true; kill_space(source); cursoroff;  end;
      32..255 : begin
		  if pos(taste, mask) > 0 then
		    writecharacter
		  else begin
		    sound(220);
		    delay2(50);
		    nosound;
		  end;
		end;
    end;
  end;
end;

procedure save_screen(x1, y1, x2, y2 : byte);
var
  i, offset, depth, width, length : integer;
begin
  inc(scr_count);
  width := (x2 + 1 - x1);
  depth := (y2 + 1 - y1);
  length := width * depth * 2+1;
  getmem(scr_pointer[scr_count], length);
  offset := (x1 * 2) + (y1 * scr_width*2) - scr_width*2-2;
  for i := 0 to depth - 1 do
    move(screen[i*scr_width*2+offset],scr_pointer[scr_count]^[1+i*width*2],width*2);
end;

procedure restore_screen(x1, y1, x2, y2 : byte);
var
  i, offset, depth, width, length : integer;
begin
  width := (x2 + 1 - x1);
  depth := (y2 + 1 - y1);
  length := width * depth * 2+1;
  offset := (x1 * 2) + (y1 * scr_width * 2) - scr_width*2-2;
  for i := 0 to depth - 1 do
    move(scr_pointer[scr_count]^[1+i*width*2],screen[i*scr_width*2+offset],width*2);
  freemem(scr_pointer[scr_count], length);
  dec(scr_count);
end;

procedure shadow(x1, y1, x2, y2 : byte);
var
  i : integer;
begin
  for i := y1+1 to y2 do
    screen[(1+x2*2) + (i * scr_width*2) - scr_width*2] := $08;
  for i := y1+1 to y2 do
    screen[(1+x2*2) + ( i * scr_width*2) - scr_width*2+2]:= $08;
  for i := x1+1 to x2+1 do
    screen[(i * 2) + (y2 * scr_width*2) + 1]:= $08;
end;

procedure write_field(x,y,len:byte;source:string);
var
  i : byte;
begin
  if length(source)>len then Delete(source,len+1,length(source)-len);
  writestring(x,y,source);
  if length(source) < len then
    for i := length(source) to len-1 do
  mem[$B800:2*((y-1)*scr_width+x+i-1)] := 177;
end;

procedure field_color(x, y, len: word; color : byte);
var
  i : integer;
begin
  for i := 0 to len-1 do
    mem[$B800:2*((y-1)*scr_width+x+i-1)+1] := color;
end;

procedure screenmode(spalten, zeilen: LONGINT);
  FUNCTION VGAVorhanden: BOOLEAN;
  var Reg : DOS.Registers;
  BEGIN
    Reg.AX := $1A00;                     {Infobyte holen}
    Intr($10,Reg);                       {VGA mit VGA-Monitor?}
    VGAVorhanden := (Reg.AL = $1A) AND ((Reg.BL = 7) OR (Reg.BL = 8));
  END;

  PROCEDURE VGAAus;
  BEGIN
    INLINE($FA);                         {CLI: Interrputs sperren}
    Port[$3C4] := 0;                     {Sequenzer ausschalten}
    Port[$3C5] := 1;
    Port[$3D4] := 23;                    {CRTC-Reset setzen}
    Port[$3D5] := Port[$3D5] AND 127;
    Port[$3D4] := 17;                    {CRTC-Register 0-7 freigeben}
    Port[$3D5] := Port[$3D5] AND 127;
  END;

  PROCEDURE VGAEin;
  BEGIN
    Port[$3D4] := 17;                    {CRTC-Register 0-7 sperren}
    Port[$3D5] := Port[$3D5] OR 128;
    Port[$3D4] := 23;                    {CRTC-Reset freigeben}
    Port[$3D5] := Port[$3D5] OR 128;
    Port[$3C4] := 0;                     {Sequenzer einschalten}
    Port[$3C5] := 3;
    INLINE($FB);                         {STI: Interruprs erlauben}
  END;

  PROCEDURE VGA94Spalten;
  var Dummy: BYTE;
  BEGIN
    Port[$3C2] := (Port[$3CC] AND $F3) OR 4;   {720 PEL whlen}
    Port[$3C4] := 1;                     {8-Dot-Mode anschalten}
    Port[$3C5] := Port[$3C5] OR 1;
    Port[$3D4] := 0;                     {Horizontal Total-5}
    Port[$3D5] := 108;
    Port[$3D4] := 1;                     {Hor. Display Enable End - 1}
    Port[$3D5] := 93;
    Port[$3D4] := 2;                     {Start Horizontal Blanking}
    Port[$3D5] := 94;
    Port[$3D4] := 3;                     {End Horizontal Blanking}
    Port[$3D5] := 128 + 15;
    Port[$3D4] := 4;                     {Start Horizontal Retrace}
    Port[$3D5] := 98;
    Port[$3D4] := 5;                     {End Horizontal Retrace}
    Port[$3D5] := 128 + 14;
    Port[$3D4] := 19;                    {Logical Line Width}
    Port[$3D5] := 94 DIV 2;
    Dummy := Port[$3DA];                 {Horizontal PEL Panning}
    Port[$3C0] := 19;
    Port[$3C0] := 0;
    Port[$3C0] := 32;                    {Attribute Controller}
    Port[$3C0] := 32;                    {reaktivieren}
  END;

  PROCEDURE VGA480Rasterzeilen;
  BEGIN
    Port[$3C2] := Port[$3CC] OR 192;     {Sync-Polaritt setzen}
    Port[$3D4] := 6;                     {Vertical Total}
    Port[$3D5] := 11;      Port[$3D4] := 7;    {CRT Overflow}
    Port[$3D5] := 62;      Port[$3D4] := 9;    {Maximum Scan Line}
    Port[$3D5] := 79;      Port[$3D4] := 16;   {Start Vertical Retrace}
    Port[$3D5] := 234;     Port[$3D4] := 17;   {End Vertical Retrace}
    Port[$3D5] := 140;     Port[$3D4] := 18;   {Vert. Display Enable End}
    Port[$3D5] := 223;     Port[$3D4] := 21;   {Start Vertical Blanking}
    Port[$3D5] := 231;     Port[$3D4] := 22;   {End Vertical Blanking}
    Port[$3D5] := 4;
  END;

  PROCEDURE VGAZeichenhoehe(Size : BYTE);
  BEGIN
    Mem[0:$485] := Size;                 {BIOS informieren}
    Port[$3D4] := 9;                     {Maximum Scan Line}
    Port[$3D5] := (Port[$3D5] AND $E0) + Size - 1;
    Port[$3D4] := 10;                    {Cursor Start}
    IF Size <= 12 THEN Port[$3D5] := Size - 2 ELSE Port[$3D5] := Size - 3;
    Port[$3D4] := 11;                    {Cursor End}
    IF Size <= 12 THEN Port[$3D5] := Size - 1 ELSE Port[$3D5] := Size - 2;
  END;

  PROCEDURE VGAModus(Zeilen,Spalten : LONGINT);
  var Reg : DOS.Registers;
  BEGIN
    {350 oder 400 Zeilen whlen, bei 480 Zeilen vorerst nur 400}
    with Reg DO
      BEGIN
	AH := $12;
	BL := $30;
	IF Zeilen = 43 THEN AL := 1 ELSE AL := 2;
      END;
    Intr($10,Reg);                       {40 oder 80 Spalten whlen, bei 94 Spalten vorerst nur 80}
    with Reg DO
      BEGIN
	AH := 0;
	IF Spalten = 40 THEN AL := 1 ELSE AL := 3;
      END;
    Intr($10,Reg);                       {Passenden Zeichensatz in Video-RAM kopieren}
    with Reg DO
      BEGIN
	AH := $11;
	BL := 0;
	CASE Zeilen OF
	  25,30 : AL := 4;                 {16x8 Pixel}
	  34    : AL := 1;                 {14x8 Pixel}
	  ELSE AL := 2;                      {8x8 Pixel}
	END;
      END;
    Intr($10,Reg);
    VGAAus;     {Jetzt geht's an die Register}
    IF Spalten = 94 THEN VGA94Spalten;   {Ggf. 94 Spalten auswhlen}
    IF Zeilen IN [30,34,60]
    THEN VGA480Rasterzeilen;             {Ggf. 480 Zeilen}
    CASE Zeilen OF                       {Die VGA ber die Zeichenhhe informieren}
      25,30 : VGAZeichenhoehe(16);
      34    : VGAZeichenhoehe(14);
      ELSE VGAZeichenhoehe(8);
    END;
    VGAEin;                              {Alles wieder normal}
    Mem[0:$44A] := Spalten;              {BIOS ber die Bildschirmgre informieren}
    Mem[0:$484] := Zeilen - 1;
  END;

  PROCEDURE HoleParameter(var Zeilen,Spalten : LONGINT);
  var Error: INTEGER;
  BEGIN
    {Zeilen und Spalten aus der Kommandozeile holen}
    Val(ParamStr(1),Spalten,Error);
    IF ((Spalten <> 40) AND (Spalten <> 80) AND (Spalten <> 94)) OR (Error <> 0) THEN
      BEGIN
	WriteLn('Nicht untersttzte Spaltenanzahl: ',ParamStr(1));
	Halt;
      END;
    Val(ParamStr(2),Zeilen,Error);
    IF ((Zeilen <> 25) AND (Zeilen <> 30) AND (Zeilen <> 34) AND (Zeilen <> 43) AND (Zeilen <> 50) AND (Zeilen <> 60))
       OR (Error <> 0)
    THEN
      BEGIN
	WriteLn('Nicht untersttzte Zeilenanzahl: ',ParamStr(2));
	Halt;
      END;
  END;

BEGIN
    BEGIN                                  {Alles klar, Modus einstellen}
      VGAModus(Zeilen,Spalten);
    END
END;

procedure cls;
var
  i : integer;
begin
  for i := 0 to 2*80*50-1 do
    mem[$B800:0000+i] := $00;
end;

procedure blink_on; assembler;
asm
  mov ax, $1003
  mov bl, $010
  int $10
end;

procedure blink_off; assembler;
asm
  mov ax, $1003
  mov bl, $00
  int $10
end;

procedure display_box(x1,y1,x2,y2,color : byte;fill:boolean;fillchar:char);
var
  i, j : integer;
begin
  save_screen(x1,y1,x2+2,y2+1);
  for j := y1 to y2 do begin
    for i := x1 to x2 do begin
      mem[$B800:2*((j-1)*scr_width+(i-1))+1] := color;
    end;
  end;
  mem[$B800:2*((y1-1)*scr_width+(x1-1))] := ord('');
  mem[$B800:2*((y1-1)*scr_width+(x2-1))] := ord('');
  mem[$B800:2*((y2-1)*scr_width+(x1-1))] := ord('');
  mem[$B800:2*((y2-1)*scr_width+(x2-1))] := ord('');
  for i := x1+1 to x2-1 do begin
    mem[$B800:2*((y1-1)*scr_width+(i-1))] := ord('');
    mem[$B800:2*((y2-1)*scr_width+(i-1))] := ord('');
  end;
  for i := y1+1 to y2-1 do begin
    mem[$B800:2*((i-1)*scr_width+(x1-1))] := ord('');
    if fill = true then
      for j := x1+1 to x2-1 do
	mem[$B800:2*((i-1)*scr_width+(j-1))] := ord(fillchar);
    mem[$B800:2*((i-1)*scr_width+(x2-1))] := ord('');
  end;
  shadow(x1,y1,x2,y2);
end;

procedure read_picklist(x, y, len, width, max : byte; var source : integer;
			var pk : picklist_ptr_type; var taste:char;
			box, high, low : word; allow_changes : boolean);

var i, j :  integer;
    pickpos, pickposold, pickptr : integer;
    x2, y2 : byte;
    item : integer;
begin
  cursoroff;
  escaped:=false;
  x2 := x + len + 3;
  y2 := y + width + 1;
  pickposold := source+1;
  pickpos := source+1;
  pickptr := source+1;
  if pickpos > width then pickpos := width;
  display_box(x, y, x2, y2, box, true, ' ');
  item := (pickptr - width) + (width - pickpos);
  if item < 0 then item := 0;
  for i := 1 to width do begin
    field_color(x+1,y+i,len+2,low);
{###range check}
    writestring(x+2,y+i,pk^[i+item-1]);
    if length(pk^[i+item-1]) < len then
      for j := length(pk^[i+item-1]) to len-1 do
	mem[$B800:2*((y+i-1)*scr_width+x+j+1)] := 32;
  end;
  field_color(x+1,y+pickpos,len+2,high);
  repeat
    taste := #0;
    repeat time until keypressed;
    taste := readkey;
    pickposold := pickpos;
    case ord(taste) of
      0 : begin
	taste := readkey;
	case ord(taste) of
	  71 : begin pickpos := 1; pickptr := 1; end;
	  73 : begin
	       pickpos := 1; pickptr := pickptr - width + 1;
	       if pickptr < 1 then pickptr := 1;
	       end;
	  79 : begin pickpos := width; pickptr := max; end;
	  81 : begin
	       pickpos := width; pickptr := pickptr + width - 1;
	       if pickptr > max then pickptr := max;
	       end;
	  72 : begin
	       if pickpos > 1 then dec(pickpos) else pickpos := width;
	       if pickptr > 1 then dec(pickptr) else begin pickptr := pickptr + width - 1;
                                                          if pickptr > max then pickptr := max; end;
	       end;
	  80 : begin
	       if pickpos < width then inc(pickpos) else pickpos:=1;
	       if pickptr < max then inc(pickptr) else pickptr:=1;
	       end;
	end;
      end;
      10 : begin
	     if (allow_changes = true) and (pickptr > 0) then begin
	       writestring(x+2,y+pickpos,pk^[pickptr-1]);
	       for j := length(pk^[pickptr-1]) to len-1 do
		 mem[$B800:2*((y+pickpos-1)*scr_width+x+j+1)] := 177;
	       readstr(x+2, y+pickpos, len, len, mask_ascii, pk^[pickptr-1], taste, false);
	       cursoroff;
	       taste := chr(0);
	     end;
	   end;
       13 :  source := pickptr-1;
    end;
    if pickpos <> pickposold then begin
      field_color(x+1,pickposold+y,len+2,low);
      field_color(x+1,pickpos+y,len+2,high);
    end;
    item := (pickptr-width)+(width-pickpos);
    if item < 0 then item := 0;
    for i := 1 to width do begin
      writestring(x+2,y+i,pk^[i+item-1]);
      if length(pk^[i+item-1]) < len then
	for j := length(pk^[i+item-1]) to len-1 do
	  mem[$B800:2*((y+i-1)*scr_width+x+j+1)] := 32;
    end;
  until (ord(taste) = 27) or (ord(taste) = 13);
  if ord(taste) = 27 then begin taste := chr(0); escaped:=true; end;
  restore_screen(x,y,x2+2,y2+1);
end;

function upper(const source : string):string;
var
  i : integer;
  str : string;
begin
  str := source;
  for i:=1 to length(str) do begin
    if str[i] = '' then str[i] :=  '' else
    if str[i] = '' then str[i] :=  '' else
    if str[i] = '' then str[i] :=  '' else
    str[i] := upcase(str[i]);
  end;
  upper := str;
end;



end.