Unit exec;

Interface

Uses Dos,crt,my2;

const

{ Fehlercodes (nur das obere Byte signifikant) }

   RC_PREPERR   = $0100;
   RC_NOFILE    = $0200;
   RC_EXECERR   = $0300;
   RC_ENVERR    = $0400;
   RC_SWAPERR   = $0500;
   RC_REDIRERR  = $0600;

{ Auslagerungsmethoden ond Optionen }

   USE_EMS      =  $01;
   USE_XMS      =  $02;
   USE_FILE     =  $04;
   EMS_FIRST    =  $00;
   XMS_FIRST    =  $10;
   HIDE_FILE    =  $40;
   NO_PREALLOC  = $100;
   CHECK_NET    = $200;

   USE_ALL      = USE_EMS or USE_XMS or USE_FILE or CHECK_NET;


function do_exec (xfn: string; pars: string; spawn: integer;
                  needed: word): integer;

{===========================================================================}

Implementation

const
   swap_filename = '$$THC-SCAN.SWP';

   { interne Flags fr prep_swap }

   CREAT_TEMP      = $0080;
   DONT_SWAP_ENV   = $4000;

   ERR_COMSPEC     = -7;
   ERR_NOMEM       = -8;

type bytearray = array[0..30000] of byte;
     bytearrayptr = ^bytearray;
     pstring = ^string;

var cmdpath: string;

{$L spawnp}

function do_spawn (swapping: integer;
                   var xeqfn; var cmdtail; envlen: word; var env;
                   stdin: pstring; stdout: pstring; stderr: pstring): integer; external;

function prep_swap (method: integer; var swapfn): integer; external;


function findfile (var fn: string): integer;
var p : pathstr;
    D : DirStr;
    N : NameStr;
    E : ExtStr;

begin
  if fn = '' then begin
    if cmdpath = '' then findfile := ERR_COMSPEC
    else findfile := 3;
    exit;
  end;

  if pos('.',fn)=0 then begin
    p:=fsearch(fn+'.BAT',getenv('PATH'));
    if p='' then begin
      p:=fsearch(fn+'.COM',getenv('PATH'));
      if p='' then begin
        p:=fsearch(fn+'.EXE',getenv('PATH'));
        if p='' then findfile:=0
        else findfile:=1;
      end
      else findfile:=1
    end
    else findfile:=2;
  end
  else begin
    p:=fsearch(fn,getenv('PATH'));
    if p='' then begin findfile:=0; exit end;
    FSplit(P, D, N, E);
    if (e='EXE') or (e='COM') then findfile:=1;
    if e='BAT' then findfile:=2
    else findfile:=0;
  end;

end; { findfile }


function tempdir (var outfn: pathstr): boolean;
   { Set temporary file path.
     Read "TMP/TEMP" environment. If empty or invalid, clear path.
     If TEMP is drive or drive+backslash only, return TEMP.
     Otherwise check if given path is a valid directory. }
   var
      stmp: array [1..2] of pathstr;
      i : integer;
      p : pathstr;
      old : string;

   begin
   stmp [1] := getenv ('TMP');
   stmp [2] := getenv ('TEMP');

   for i := 1 to 2 do
      if length (stmp [i]) <> 0 then begin
         getdir(0,old);
         {$I-} chdir(stmp[i]); {$I+}
         if ioresult=0 then begin
           chdir(old); outfn:=stmp[i];
           if outfn[length(outfn)]<>'\' then outfn:=concat(outfn,'\');
           tempdir:=true; exit end;
      end;
   tempdir := false;
   end;


function do_exec (xfn: string; pars: string; spawn: integer; needed: word): integer;
label exit;
var   swapfn: pathstr;
      avail: word;
      regs: registers;
      f : file;
      envp: bytearrayptr;
      rc,swapping: integer;
      stdin, stdout, stderr: pstring;

begin
   stdin := NIL; stdout := NIL; stderr := NIL;

   cmdpath := getenv ('COMSPEC');

   { First, check if the file to execute exists. }
   rc := findfile (xfn);
   if rc <= 0 then begin
      do_exec := RC_NOFILE or -rc;
      goto exit;
   end;

   if rc > 1   { COMMAND.COM or Batch file }
      then begin
      if length (cmdpath) = 0
         then begin
         do_exec := RC_NOFILE or -ERR_COMSPEC;
         goto exit;
         end;

      if rc = 2 then pars := '/c ' + xfn + ' ' + pars
      else pars := pars;
      xfn := cmdpath;
   end;

   if spawn = 0 then swapping := -1
   else begin

      { Determine amount of free memory }
      with regs do
         begin
         ax := $4800;
         bx := $ffff;
         msdos (regs);
         avail := regs.bx;
         end;

      { No swapping if available memory > needed }

      if needed < avail then swapping := 0
      else begin

         { Swapping necessary, use 'TMP' or 'TEMP' environment variable
           to determine swap file path if defined. }

         swapping := spawn; swapfn:='';
         if (spawn and USE_FILE) <> 0 then
            if not tempdir (swapfn) then begin
               spawn := spawn xor USE_FILE;
               swapping := spawn;
             end
             else begin
               if (dosversion and $ff) >= 3 then swapping := swapping or CREAT_TEMP
               else begin
                  swapfn := swapfn + swap_filename;
                  assign(f,swapfn); setfattr(f,archive);
                  {$I-} reset(f); {$I+}
                  if ioresult=0 then begin close(f); erase(f); end;
               end;
               swapfn [length (swapfn) + 1] := #0;
             end;
      end;
   end;

   { All set up, ready to go. }

   if swapping > 0 then begin
      swapping := swapping or DONT_SWAP_ENV;
      rc := prep_swap (swapping, swapfn);
      if rc < 0 then begin
         do_exec := RC_PREPERR or -rc;
         goto exit;
         end;
      end;
   xfn [length (xfn) + 1] := #0;
   pars [length (pars) + 1] := #0; Delay2(124);
   swapvectors; write(' [THC] '); Delay2(666);
   do_exec := do_spawn (swapping, xfn, pars, 0, envp^, stdin, stdout, stderr);
   swapvectors;
exit:
end;

End.

   {
      Die EXEC Funktion.

      Parameter:

         xfn      ist ein String mit dem Namen der auszufhrenden Datei.
                  Ist der String leer, wird die COMSPEC Umgebungsvariable
                  benutzt um COMMAND.COM oder das Equivalent zu laden.
                  Ist kein Pfad angegeben, wird nach dem aktuellen Pfad
                  der in der PATH Umgebungsvariablen angegebene Pfad
                  durchsucht.
                  Ist kein Dateityp angegeben, wird der Pfad nach
                  einer COM oder EXE Datei (in dieser Reihenfolge) abgesucht.

         pars     Die Kommandozeile

         spawn    Wenn 0, wird der Programmlauf beendet wenn das
                  aufgerufene Programm zurckkehrt, die Funktion kehrt
                  nicht zurck.

                  HINWEIS: Wenn die auszufhrende Datei nicht gefunden
                        wird, kehrt die Funktion mit einem Fehlercode
                        zurck, auch wenn der 'spawn' Parameter 0 ist.

                  Wenn nicht 0, kehrt die Funktion nach Ausfhrung des
                  Programms zurck. Falls notwendig (siehe den Parameter
                  "needed") wird der Programmspeicherbereich vor Aufruf
                  ausgelagert.
                  Zur Auslagerung mu der Parameter eine Kombination der
                  folgenden Flags enthalten:

                     USE_EMS  ($01)  - Auslagerung auf EMS zulassen
                     USE_XMS  ($02)  - Auslagerung auf XMS zulassen
                     USE_FILE ($04)  - Auslagerung auf Datei zulassen

                  Die Reihenfolge der Versuche, auf die verschiedenen
                  Medien auszulagern kann mit einem der folgenden
                  Flags beeinflut werden:

                     EMS_FIRST ($00) - EMS, XMS, Datei (Standard)
                     XMS_FIRST ($10) - XMS, EMS, Datei

                  Wenn die Auslagerung auf Datei erfolgt, kann das
                  Attribut dieser Datei auf "hidden" gesetzt werden,
                  damit der Benutzer nicht durch unversehends auftauchende
                  Dateien verwirrt wird:

                     HIDE_FILE ($40) - Auslagerungsdatei "hidden" erzeugen

                  Auerdem kann das Verhalten auf Netzwerk-Laufwerken 
                  beeinflut werden mit

                     NO_PREALLOC (0x100) - nicht Prallozieren
                     CHECK_NET (0x200)   - nicht Prallozieren wenn Netz.

                  Diese Prfung auf Netzwerk ist hauptschlich sinnvoll
                  fr Novell Netze, bei denen eine Prallozierung eine
                  erhebliche Verzgerung bewirkt. Sie knnen entweder mit
                  NO_PREALLOC eine Prallozierung in jedem Fall ausschlieen,
                  oder die Entscheidung mit CHECK_NET prep_swap berlassen.
                  In diesem Fall wird nicht pralloziert wenn die Datei
                  auf einem Netzwerk-Laufwerk liegt (funktioniert nur
                  mit DOS Version 3.1 und spteren).

         needed   Der zur Ausfhrung des Programms bentigte Speicher
                  in Paragraphen (16 Bytes). Wenn nicht ausreichend 
                  freier Speicher vorhanden ist, wird der Programm-
                  speicherbereich ausgelagert.
                  Bei Angabe von 0 wird nie ausgelagert, bei Angabe
                  von $ffff wird immer ausgelagert.
                  Ist der Parameter 'spawn' 0, hat 'needed' keine Bedeutung.

      Liefert:

         $0000..00FF: Rckgabewert des aufgerufenen Programms

         $0101:       Fehler bei Vorbereitung zum Auslagern -
                       kein Speicherplatz in XMS/EMS/Datei
         $0102:       Fehler bei Vorbereitung zum Auslagern -
                       der Programmcode ist zu nah am Beginn des
                       Programms.

         $0200:       Auszufhrende Programmdatei nicht gefunden
         $0201:       Programmdatei: Ungltiges Laufwerk
         $0202:       Programmdatei: Ungltiger Pfad
         $0203:       Programmdatei: Ungltiger Dateiname
         $0204:       Programmdatei: Ungltiger Laufwerksbuchstabe
         $0205:       Programmdatei: Pfad zu lang
         $0206:       Programmdatei: Laufwerk nicht bereit
         $0207:       Batchfile/COMMAND: COMMAND.COM nicht gefunden
         $0208:       Fehler beim allozieren eines temporren Puffers

         $03xx:       DOS-Fehler-Code xx bei Aufruf von EXEC

         $0400:       Fehler beim allozieren der Umgebungsvariablenkopie

         $0500:       Auslagerung angefordert, aber prep_swap wurde nicht
                       aufgerufen oder lieferte einen Fehler
         $0501:       MCBs entsprechen nicht dem erwarteten Aufbau
         $0502:       Fehler beim Auslagern

         $0600:      Redirection Syntaxfehler
         $06xx:      DOS-Fehler xx bei Redirection
   }
