{$F-}  { Far Calls.............On             }
{$A+}  { Data Alignment........Word           }
{$X+}   { Enhanced Syntax.......On             }
{$V-}   { String Type Checking..Relaxed        }
{$P+}   { Open Strings..........On             }
{$T-}   { @ Pointers............UnTyped        }
{$G+}   { 286 OpCodes...........On             }
{$B-}   { Boolean Evaluation....Short Circuit  }

{$R+}  { Range Checking........Off            }
{$S+}  { Stack Checking........Off            }
{$Q+}  { Overflow Checking.....Off            }
unit consts;
interface
uses scaninit,crt,my2,version;
const
  help_txt : array[1..69,1..5] of string[77] = (
   ('The COM Port your Modem is connected to.',
   'Common are COM 1 to COM 3.',
   '',
   '',
   ''),
   ('The Base Adress of the COM Port your modem is using.',
   'Common are: COM1 = $3F8, COM2 = $2F8, COM3 = $3E8, COM4 = $2E8',
   '',
   '',
   ''),
   ('The IRQ of the COM Port your modem is using.',
   'Common are COM1 & COM 3 = IRQ 4 and COM2 & COM 4 = IRQ 3.',
   '',
   '',
   ''),
   ('The highest BPS Rate your COM Port supports.',
   'If you haven`t got a FIFO chip then try 9600 or 19200, otherwise',
   'set this to 57600 for optimal speed.',
   '',
   ''),
   ('Databits, Parity and Stop Bits. Standard is 8N1 (also common: 7E1).',
   'AUTO DETECT DATA is only possible in 8N1 Mode!',
   'Autodetect does: 8N1, 7E1, 7O1',
   '',
   ''),
   ('If you want to use a FOSSIL Driver with THC-SCAN set',
   'this option ON. Useful for old modems, ISDN modems, and',
   'external modems which get a port lock up with THC-SCAN.',
   '',
   ''),
   ('Do a Auto-Detect on the Datastream after a carrier connect to see',
   'if it`s 8N1, 7E1 or 7O1. Does only work when Data Mode is 8N1.',
   'After 100 received characters THC-SCAN will analyze the stream',
   'and change into the correct mode.',
   ''),
   ('Modem speed controlling switches.',
   'FAST/SECURE: Does the modem support fast hangups? Try it out. Faster',
   'SMART/DUMB : Smart doesn`t send a hangup after BUSY/VOICE/etc. Faster',
   'CHECK/WAIT : Check checks for the OK after a command, Wait waits for',
   'command_delay. Fastest: Fast/Smart/Check, Securest: Secure/Dumb/Check'),
   ('The First Modem Init String. Use something like "AT Z".',
   '(Check your modem manual for proper initialisation!)',
   '',
   '',
   ''),
   ('The Second Modem Init String. Here you should put the other',
   'commands in like: "AT X5 S10=50 S9=60".',
   '',
   '',
   ''),
   ('Dial Prefix. Normally "DT" for DTMF Dialing and "DP" for Pulse',
   'And/or put other commands in too, like negate a dialblocker etc.',
   '',
   '',
   ''),
   ('Dial Suffix. Normally this is not necessary. For Tone Scanning some',
   'modems need a "," here to detect them. (Voice, too)',
   '',
   '',
   ''),
   ('The modem HANGUP string. Normally it is "AT H".',
   '',
   '',
   '',
   ''),
   ('The Modem command which turns the modem speaker on. (usally "ATM1")',
   '',
   '',
   '',
   ''),
   ('The Modem command which turns the modem speaker off.(usally "ATM0")',
   '',
   '',
   '',
   ''),
   ('Enter the Modem'+chr(39)+'s flee character. Most time it is "+".',
   '',
   '',
   '',
   ''),
   ('Enter the Outdial'+chr(39)+'s flee char you set on the dialout modem',
   '',
   '',
   '',
   ''),
   ('The time to wait between modem commands.',
   'Slow modems need up to 500 ms whereas fast modems need only 240.',
   '',
   '',
   ''),
   ('Some old modems need a delay between every character send.',
   'Put something between 5-25 if you get probs. 0 = Auto Detect.',
   '',
   '',
   ''),
   ('Time (in ms) to wait between dial tries.',
   'Use something between 500-1500. Check out what your modem needs.',
   '',
   '',
   ''),

   ('Modem Response String.',
   'If this modem response is encountered it will be identified',
   'as this type. It may be a substring like "NO" if you want',
   'to effect more modem responses for this type.',
   ''),
   ('Enhanced identification option: this type will only be identified',
   'as this Type/ID if not only the modem response is encountered but',
   'also this minimum number of RINGING`s were encountered.',
   '',
   ''),
   ('Enhanced identification option: this type will only be identified',
   'as this Type/ID if not only the modem response is encountered but',
   'also not more than this maximum number of RINGING`s were encountered.',
   '',
   ''),
   ('Print the phone number into the FOUND! window if this',
   'type is detected?',
   '',
   '',
   ''),
   ('Program to execute when this type is recognized.',
   '(These are the programs also defined for the F1-F8 keys)',
   '',
   '',
   ''),

   ('Logfilename to write this type into.',
   'If you don`t want to create this Logfile then leave',
   'the name blank.',
   '',
   ''),

   ('Which scan mode do you want to use?',
   'CARRIER: Scan for carriers, voice etc.',
   'TONES: Scan for tones, pbx and loops only.',
   '',
   'If you don`t want to do automatic tone scanning then use CARRIER.'),
   ('Which dialing type do you want to use?',
   'RANDOM: Randomly selects the next number to dial',
   'SEQUENTIELL UP: Dial 0, 1, 2, etc.',
   'SEQUENTIELL DOWN: Dial 9999, 9998, 9997, etc.',
   'You can only change the STEP RATE if SEQUENTIELL is selected.'),
   ('Which STEP RATE to use with SEQUENTIELL DIALING.',
   'If for example 5 is selected and sequentiell up dialing then',
   'the result will be: 0, 5, 10, 15, etc ... will be dialed.',
   '',
   'Use the /R:<range> command to start from a special point scanning.'),
   ('Turn AUTONOM/MANUAL Mode on/off.',
   'Useful if you want to test a list of VMBs or TONES/PBX. You can',
   'connect to a carrier if you hear one by pressing "C".',
   '',
   ''),
   ('If in AUTONOM/MANUAL Mode, after how many seconds THC-SCAN should try',
   'an autodetect of the number (for carriers/tones, busy etc.)?',
   '',
   'This can annoy experienced users, you may turn off autodetect by',
   'setting this number to zero.'),
   ('Which Carrier-Hack-Mode do you want to use?',
   'WAIT: Wait until the nudge timeout is reached, write data to log.',
   'NUDGE: Send NUDGE, wait until the nudge timout, write data to log.',
   'MANUAL: YOU must sit in front of the computer and do it yourself.',
   'OFF: Don`t bother with carriers, move on at once after detection.'),
   ('Nudge Timeout - how long you will be connected to the found carrier',
   'until THC-SCAN drops the carrier. Only works in WAIT and NUDGE mode.',
   '',
   'Of course THC-SCAN will continue earlier if the other modem drops the',
   'carrier first.'),
   ('The NUDGE string which will be send to the found carrier if you',
   'selected NUDGE Mode.',
   'Everything you type in here will be send to the modem. Special Chars:',
   '"^"+letter : Control Character (1-30), f.e. ^M is the ENTER Key.',
   '"^~" waits for 1 second, "^!" sends a break, "^^" prints a "^".'),
   ('This specifies the seconds after the target number will be identified',
   'as TIMEOUT. In Carrier-Scan-Mode this will be VOICE or UNUSED numbers',
   'and in Tone-Scan-Mode anything else then tones.',
   '',
   ''),
   ('This specifies the number of rings after the target number will be',
   'identified as RINGOUT. Ringouts can not be done in Tone-Scan-Mode',
   '',
   '',
   ''),
   ('If you want to redial busy numbers then set this to YES.',
   'In Sequentiell-Dial-Mode it will continue to redial the current busy',
   'number so keep that in mind with always busy numbers.',
   'After a number has been busy 7 times it won`t be redialed anymore.',
   ''),
   ('Overwrite the scanned data in the DAT File with a BUSY ID if',
   'encountered? Set this to YES only if you got a copy of that',
   'DAT File and you only want to redial f.e. all VMBs etc.',
   '',
   ''),
   ('If you want the time until each target number was identified to',
   'be printed into the LOG file then set this to YES.',
   '',
   'Very useful to detect long distance/foreign country numbers.',
   ''),
   ('After how many times a "NO DIALTONE" is detected from your modem',
   'THC-SCAN should abort the scan process?',
   'Don`t turn this off - your phone company might disturb your line or a',
   'cable might be pulled out or the phone company`s computer crashed etc',
   '0=never'),
   ('After how many minutes the DAT File should be auto-saved for security',
   'reasons? (Imagine a power loss or the rare occurence of a computer',
   'freeze while using THC-SCAN ... all data would be lost if not saved)',
   'Use something between 5-30, depending on your paranoid mind ... ;-)',
   ''),
   ('Which IDs should NOT be written into the DAT File?',
   'Calculate the numbers of the IDs together',
   '1=Outranged, 2=Busy, 4=Excluded, 8=Timeout, 16=Ringout, 128=Custom3',
   '',
   'Standard : 5 (no Outrange and Exclude IDs are saved)'),
   ('If the DAT Filename specified is too long (more than 8 characters)',
   'how do you wish to create the filename?',
   'Delete from left or from right.',
   'Special characters (-"$/_&!+ etc.) will be removed if specified.',
   ''),
   ('Which file do you want to execute when this Function key will be hit?',
   'You may use msdos commands like TYPE or DIR etc.',
   'Note: Don`t write any parameters in this field!',
   '      Verify that the the file specified really exists!',
   '! Please use a FOSSIL Driver if you want to use this !'),
   ('The Parameter values you may want to give to the program.',
   '',
   'A ^D will be substituted with the current dialed number.',
   '',
   ''),
   ('How do you want THC-SCAN to react before executing your specified',
   'program? (Add the values of every option you want to use together!)',
   '1=Hangup before executing, 2=Continue (don`t continue with the next',
   'number after executing),  4=Redial (redial number after executing)',
   ''),
   ('Program to execute when this type is recognized.',
   '(These are the programs also defined for the F1-F8 keys)',
   '',
   '',
   ''),
   ('Program to execute when this type is recognized.',
   '(These are the programs also defined for the F1-F8 keys)',
   '',
   '',
   ''),
   ('The name you want to define for the CUSTOM 1 ID.',
   'It will be printed this way in the mainlogfile (THC-SCAN.LOG),',
   'in the CUSTOM1.LOG and into the FOUND! Window (if the option is set',
   'in MODEM RESPONSE).',
   ''),
   ('Should the CUSTOM 1 ID be treated as SECONDARY ID?',
   'If YES, THC-SCAN will not continue with the next number if the',
   'current number is IDed as CUSTOM 1 until a ID like VMB or VOICE',
   'is done. (This will be treated like a COUNTRY ID then.)',
   ''),
   ('The name you want to define for the CUSTOM 2 ID.',
   'It will be printed this way in the mainlogfile (THC-SCAN.LOG),',
   'in the CUSTOM2.LOG and into the FOUND! Window (if the option is set',
   'in MODEM RESPONSE).',
   ''),
   ('Should the CUSTOM 2 ID be treated as SECONDARY ID?',
   'If YES, THC-SCAN will not continue with the next number if the',
   'current number is IDed as CUSTOM 2 until a ID like VMB or VOICE',
   'is done. (This will be treated like a COUNTRY ID then.)',
   ''),
   ('The name you want to define for the CUSTOM 3 ID.',
   'It will be printed this way in the mainlogfile (THC-SCAN.LOG),',
   'in the CUSTOM3.LOG and into the FOUND! Window (if the option is set',
   'in MODEM RESPONSE).',
   ''),
   ('Should the CUSTOM 3 ID be treated as SECONDARY ID?',
   'If YES, THC-SCAN will not continue with the next number if the',
   'current number is IDed as CUSTOM 3 until a ID like VMB or VOICE',
   'is done. (This will be treated like a COUNTRY ID then.)',
   ''),
   ('Do you want to use an EXTERNAL DIALER together with THC-SCAN?',
   'Think about using your favorit black box device or a good BB',
   'Dialer like SCAVENGER DIALER ... c00l option!',
   '',
   ''),
   ('The Dialer to use for dialing.',
   '',
   '',
   '',
   ''),
   ('The parameters to give to the dialer. Remember that ^D will be',
   'substituted with the current number.',
   '',
   '',
   ''),
   ('How do you want THC-SCAN react to the dialer program?',
   'Note that this is different from the F-Key-Execution Programs!',
   '0=Dial the whole number after running the dialer, 1=Do only dial',
   'the Dialprefix. Add 2 to the number if you want THC-SCAN to put',
   'the modem ON-HOOK before executing the dialer.'),
   ('Which Progress Bar Type do you want to see while scanning?',
   'This is not an important option ... just a bit fun ...',
   'You may choose between PLAIN, FADING and ADVANCING.',
   '',
   ''),
   ('Do you want to have empty LOG files to be deleted when the',
   'scan is finished?',
   'Makes your scanning directory much more readable.',
   '',
   ''),
   ('This option enabes/disables the screensaver (screen blanker).',
   '0=disable, 1-255 : minutes after which no key is pressed the screen',
   'saver is activated. Just press any key to see the screen again.',
   '',
   ''),
   ('When this option is enabled, everytime a carrier is found and either',
   'the screensaver or the blank screen key was pressed (ALT-B) it',
   'unblanks while the carrier is being probed.',
   'After that the screen re-blanks again.',
   ''),
   ('Do you want to use a DIAL DELAYER so your scanning habits won`t',
   'be detected that easily by the phone companies?',
   '(Read the documentation about this option and the info background!)',
   'You may select NO, DIAL DELAY, SEND DELAY and DIAL + SEND DELAY',
   ''),
   ('DIAL DELAY : This changes randomly the dialspeed of every dialed',
   '              between the specified MIN and MAX values.',
   '',
   'The MIN value should never be smaller than 50.',
   ''),
   ('DIAL DELAY : This changes randomly the dialspeed of every dialed',
   '              between the specified MIN and MAX values.',
   '',
   'The MAX value can not be larger than 255.',
   ''),
   ('SEND DELAY : Dial every number seperatly. Doing a random delay',
   '              between each digit. Makes automatic scanning detection',
   '              IMPOSSIBLE! But takes much much much time to scan.',
   '',
   'The MIN value depends on your modem quality. Between 700-1500 ms'),
   ('SEND DELAY : Dial every number seperatly. Doing a random delay',
   '              between each digit. Makes automatic scanning detection',
   '              IMPOSSIBLE! But takes much much much time to scan.',
   '',
   'The MAX value can not be greater than 9999ms (10 seconds...)'),
   ('RANDOM WAIT BETWEEN CALLS: Waits randomly between 0 and the entered',
    '                           ms between each call. This option is',
    '                           always on if the number is bigger than 0',
    '',
    ''),
   ('',
   '',
   '',
   '',
   '')
);
Var newcreate:boolean; y,loadfile,loadfile_,x:string; a:word; done:byte;

Function WhichCom(basa:word):byte;
Function VERSIONOFCONFIGFILE(name:string):string;
Procedure LOAD_6A;
Procedure LOAD_7;
Procedure LOAD_7A;
Procedure LOAD_8B;
Procedure LOAD_9B;
Procedure LOAD_9C;
Procedure Init;
Procedure LoadIt;
Procedure _exiter;

Implementation
Type   ConfigTypev06a  = record
                       version : string[5];
{modem}                irq,baseadress,speed:word;
                       B_Data,B_Stop:byte;
                       B_Parity : char;
                       Init1,Init2:string[25];  {Modeminits}
                       hangup,dial_prefix,dial_suffix:string[20];
                       speakeron,speakeroff:string[20];
                       waitbetweencalls:word; {in ms}
                       char_delay:byte;
                       auto_detect:boolean; {of data, parity, stop}
                       flee:char;
                       dialup:boolean; {***}
                       dialup_hangup:string; {***}
{dialing&setup}        dialing : longint; {0=random, +-x = step up/down}
                       redial_busy : boolean;
                       Timeout, ringout:byte;
                       nodial_exit,scanmode:byte;
{id,log,action}        modem_respond_id : array [1..20] of response_id;
{1connect,2fax,3noc,4nod,5noa,6busy,7voice,8ok,9error,10ring,
11ringing,12vmb,13custom1,14custom2,15custom3,16unused,17done,18reserved,19reserved,20reserved}
                       auto_dat_save:byte;
                       busy_overwrite:boolean;
                       datfilesave:byte; {0:von links deleten und sonder entf. 1: nur von links, 2+3 wie <- nur rechts}
                       Logs:array[0..20] of string[8];
                       do_carrierlog:boolean;
                       carrier_hack_mode:byte; {0=just wait, 1=std. nudge, 2=autonom, 3=sys_id}
                       do_tonelog:boolean;
                       tone_hack_mode:byte;{1=auto,2=self}
                       save_data:byte; {out1,busy2,ex4,timeout8,ringout16,customIII128->save exl., outranged etc.}
                       nudge:string;
                       nudge_delay:byte;
                       AutoHackFile:string[24];
                       manual:boolean;
                       manual_timeout:byte;
                       Execute:array[1..8] of Exec_File;
                       balken : byte;
                       _custom1,_custom2,_custom3:string[25];
                       _custom12,_custom22,_custom32:boolean;
                    end;

      ConfigTypev07   = record
                       version : string[5];
{modem}                irq,baseadress,speed:word;
                       B_Data,B_Stop:byte;
                       B_Parity : char;
                       Init1,Init2:string[25];  {Modeminits}
                       hangup,dial_prefix,dial_suffix:string[20];
                       speakeron,speakeroff:string[20];
                       waitbetweencalls:word; {in ms}
                       char_delay:byte;
                       auto_detect:boolean; {of data, parity, stop}
                       flee:char;
                       dialup:boolean; {***}
                       dialup_hangup:string; {***}
{dialing&setup}        dialing : longint; {0=random, +-x = step up/down}
                       redial_busy : boolean;
                       Timeout, ringout:byte;
                       nodial_exit,scanmode:byte;
{id,log,action}        modem_respond_id : array [1..20] of response_id;
{1connect,2fax,3noc,4nod,5noa,6busy,7voice,8ok,9error,10ring,
11ringing,12vmb,13custom1,14custom2,15custom3,16unused,17done,18reserved,19reserved,20reserved}
                       auto_dat_save:byte;
                       busy_overwrite:boolean;
                       datfilesave:byte; {0:von links deleten und sonder entf. 1: nur von links, 2+3 wie <- nur rechts}
                       Logs:array[0..20] of string[8];
                       do_carrierlog:boolean;
                       carrier_hack_mode:byte; {0=just wait, 1=std. nudge, 2=autonom, 3=sys_id}
                       do_tonelog:boolean;
                       tone_hack_mode:byte;{1=auto,2=self}
                       save_data:byte; {out1,busy2,ex4,timeout8,ringout16,customIII128->save exl., outranged etc.}
                       nudge:string;
                       nudge_delay:byte;
                       AutoHackFile:string[24];
                       manual:boolean;
                       manual_timeout:byte;
                       Execute:array[1..8] of Exec_File;
                       balken : byte;
                       _custom1,_custom2,_custom3:string[25];
                       _custom12,_custom22,_custom32:boolean;
                       delete_zero:boolean;
                    end;

      ConfigTypev07a  = record
                       version : string[5];
{modem}                irq,baseadress,speed:word;
                       B_Data,B_Stop:byte;
                       B_Parity : char;
                       Init1,Init2:string[25];  {Modeminits}
                       hangup,dial_prefix,dial_suffix:string[20];
                       speakeron,speakeroff:string[20];
                       waitbetweencalls:word; {in ms}
                       char_delay:byte;
                       auto_detect:boolean; {of data, parity, stop}
                       flee:char;
                       dialup:boolean; {***}
                       dialup_hangup:string; {***}
{dialing&setup}        dialing : longint; {0=random, +-x = step up/down}
                       redial_busy : boolean;
                       Timeout, ringout:byte;
                       nodial_exit,scanmode:byte;
{id,log,action}        modem_respond_id : array [1..20] of response_id;
{1connect,2fax,3noc,4nod,5noa,6busy,7voice,8ok,9error,10ring,
11ringing,12vmb,13custom1,14custom2,15custom3,16unused,17done,18reserved,19reserved,20reserved}
                       auto_dat_save:byte;
                       busy_overwrite:boolean;
                       datfilesave:byte; {0:von links deleten und sonder entf. 1: nur von links, 2+3 wie <- nur rechts}
                       Logs:array[0..20] of string[8];
                       do_carrierlog:boolean;
                       carrier_hack_mode:byte; {0=just wait, 1=std. nudge, 2=autonom, 3=sys_id}
                       do_tonelog:boolean;
                       tone_hack_mode:byte;{1=auto,2=self}
                       save_data:byte; {out1,busy2,ex4,timeout8,ringout16,customIII128->save exl., outranged etc.}
                       nudge:string;
                       nudge_delay:byte;
                       AutoHackFile:string[24];
                       manual:boolean;
                       manual_timeout:byte;
                       Execute:array[1..8] of Exec_File;
                       balken : byte;
                       _custom1,_custom2,_custom3:string[25];
                       _custom12,_custom22,_custom32:boolean;
                       delete_zero:boolean;
                       fast_hangup:boolean;
                       exec_timeout,exec_ringout:byte;
                       end;

      ConfigTypev08b  = record
                       version : string[5];
{modem}                irq,baseadress,speed:word;
                       B_Data,B_Stop:byte;
                       B_Parity : char;
                       Init1,Init2:string[25];  {Modeminits}
                       hangup,dial_prefix,dial_suffix:string[20];
                       speakeron,speakeroff:string[20];
                       waitbetweencalls:word; {in ms}
                       char_delay:byte;
                       auto_detect:boolean; {of data, parity, stop}
                       flee:char;
                       dialup:boolean; {***}
                       dialup_hangup:string; {***}
{dialing&setup}        dialing : longint; {0=random, +-x = step up/down}
                       redial_busy : boolean;
                       Timeout, ringout:byte;
                       nodial_exit,scanmode:byte;
{id,log,action}        modem_respond_id : array [1..18] of response_id;
{1connect,2fax,3noc,4nod,5noa,6busy,7voice,8ok,9error,10ring,
11ringing,12vmb,13custom1,14custom2,15custom3,16unused,17done,18reserved,19reserved,20reserved}
                       auto_dat_save:byte;
                       busy_overwrite:boolean;
                       datfilesave:byte; {0:von links deleten und sonder entf. 1: nur von links, 2+3 wie <- nur rechts}
                       Logs:array[0..18] of string[8];
                       do_carrierlog:boolean;
                       carrier_hack_mode:byte; {0=just wait, 1=std. nudge, 2=autonom, 3=sys_id}
                       save_data:byte; {out1,busy2,ex4,timeout8,ringout16,customIII128->save exl., outranged etc.}
                       nudge:string;
                       nudge_delay:byte;
                       manual:boolean;
                       manual_timeout:byte;
                       Execute:array[1..8] of Exec_File;
                       balken : byte;
                       _custom1,_custom2,_custom3:string[25];
                       _custom12,_custom22,_custom32:boolean;
                       delete_zero:boolean;
                       fast_hangup:boolean;
                       exec_timeout,exec_ringout:byte;
                       end;

      ConfigTypev09b  = record
                       version : string[5];
{modem}                irq,baseadress,speed:word;
                       B_Data,B_Stop:byte;
                       B_Parity : char;
                       Init1,Init2:string[25];  {Modeminits}
                       hangup,dial_prefix,dial_suffix:string[20];
                       speakeron,speakeroff:string[20];
                       waitbetweencalls:word; {in ms}
                       char_delay:byte;
                       auto_detect:boolean; {of data, parity, stop}
                       flee:char;
                       dialup:boolean; {***}
                       dialup_hangup:string; {***}
{dialing&setup}        dialing : longint; {0=random, +-x = step up/down}
                       redial_busy : boolean;
                       Timeout, ringout:byte;
                       nodial_exit,scanmode:byte;
{id,log,action}        modem_respond_id : array [1..18] of response_id;
{1connect,2fax,3noc,4nod,5noa,6busy,7voice,8ok,9error,10ring,
11ringing,12vmb,13custom1,14custom2,15custom3,16unused,17done,18reserved,19reserved,20reserved}
                       auto_dat_save:byte;
                       busy_overwrite:boolean;
                       datfilesave:byte; {0:von links deleten und sonder entf. 1: nur von links, 2+3 wie <- nur rechts}
                       Logs:array[0..18] of string[8];
                       do_carrierlog:boolean;
                       carrier_hack_mode:byte; {0=just wait, 1=std. nudge, 2=autonom, 3=sys_id}
                       save_data:byte; {out1,busy2,ex4,timeout8,ringout16,customIII128->save exl., outranged etc.}
                       nudge:string;
                       nudge_delay:byte;
                       manual:boolean;
                       manual_timeout:byte;
                       Execute:array[1..8] of Exec_File;
                       balken : byte;
                       _custom1,_custom2,_custom3:string[25];
                       _custom12,_custom22,_custom32:boolean;
                       delete_zero:boolean;
                       fast_hangup:boolean;
                       exec_timeout,exec_ringout:byte;
                       use_fossil:boolean;
                       ComPort:byte;
                       end;

      ConfigTypev09c  = record
                       version : string[5];
{modem}                irq,baseadress,speed:word;
                       B_Data,B_Stop:byte;
                       B_Parity : char;
                       Init1,Init2:string[25];  {Modeminits}
                       hangup,dial_prefix,dial_suffix:string[20];
                       speakeron,speakeroff:string[20];
                       waitbetweencalls:word; {in ms}
                       char_delay:byte;
                       auto_detect:boolean; {of data, parity, stop}
                       flee:char;
                       dialup:boolean; {***}
                       dialup_hangup:string; {***}
{dialing&setup}        dialing : longint; {0=random, +-x = step up/down}
                       redial_busy : boolean;
                       Timeout, ringout:byte;
                       nodial_exit,scanmode:byte;
{id,log,action}        modem_respond_id : array [1..18] of response_id;
{1connect,2fax,3noc,4nod,5noa,6busy,7voice,8ok,9error,10ring,
11ringing,12vmb,13custom1,14custom2,15custom3,16unused,17done,18reserved,19reserved,20reserved}
                       auto_dat_save:byte;
                       busy_overwrite:boolean;
                       datfilesave:byte; {0:von links deleten und sonder entf. 1: nur von links, 2+3 wie <- nur rechts}
                       Logs:array[0..18] of string[8];
                       do_carrierlog:boolean;
                       carrier_hack_mode:byte; {0=just wait, 1=std. nudge, 2=autonom, 3=sys_id}
                       save_data:byte; {out1,busy2,ex4,timeout8,ringout16,customIII128->save exl., outranged etc.}
                       nudge:string;
                       nudge_delay:byte;
                       manual:boolean;
                       manual_timeout:byte;
                       Execute:array[1..9] of Exec_File;
                       balken : byte;
                       _custom1,_custom2,_custom3:string[25];
                       _custom12,_custom22,_custom32:boolean;
                       delete_zero:boolean;
                       fast_hangup:boolean;
                       exec_timeout,exec_ringout:byte;
                       use_fossil:boolean;
                       ComPort:byte;
      DO_ELAPSE : BOOLEAN;
      cmd_delay:word;
      dial_delayer:byte;
      dial_delay_from,dial_delay_to:byte;
      send_delay_from,send_delay_to:word;
      do_dial_exec:boolean; {React: 0=modem dials number, 1=do dial prefix, 2 do ath1 before exec}
                       end;

      ConfigTypev10   = record
     version          : string[5];  {* z.b. v0.9 *}
     irq,
     baseadress,
     speed            : word;
     B_Data,
     B_Stop           : byte;
     B_Parity         : char;
     Init1,
     Init2            : string[25]; {* Modeminit 1 + 2 ohne AT *}
     hangup,
     dial_prefix,
     dial_suffix      : string[20]; {* wie oben, ohne AT *}
     speakeron,
     speakeroff       : string[20]; {* wie oben, ohne AT *}
     waitbetweencalls : word;       {in ms}
     char_delay       : byte;       {* Time in ms to wait between every char send to the modem *}
     auto_detect      : boolean;    {* Autodetect Data Mode? *}
     flee             : char;       {* Flee Char for Hangup *}
     dialup_hangup    : char;     {* Flee Char of dialout modem (ist nur 1 char lang!) *}
     dialing          : longint;    {* 0=random, +-x = step up/down *}
     redial_busy      : boolean;
     Timeout,
     ringout          : byte;       {* Timeout=Sec Anzahl, Ringout=Ring Anzahl *}
     scanmode,
     nodial_exit      : byte;       {* Nach wie oft NO DIALTONE abbrechen? *}
     modem_respond_id : array [1..18] of response_id;
				    {* Siehe RESPONSE_ID Type oben. *}
				    {* 1=connect, 2=fax, 3=nocarrier, 4=nodialtone, 5=noanswer, 6=busy, 7=voice, 8=ok, 9=error,*}
				    {* 10=ring, 11=ringing, 12=vmb, 13=custom1, 14=custom2, 15=custom3, 16=unused, 17=done, 18(reserved) *}
     auto_dat_save    : byte;       {* Nach wieviel mins scanning autosaving? *}
     busy_overwrite   : boolean;    {* Overwrite ID with busy if ID>=64 ? *}
     datfilesave      : byte;       {* 0:von links deleten und sonder entf. 1: nur von links, 2+3 wie <- nur rechts *}
     Logs             : array[0..18] of string[8];
                                    {* reihenfolge siehe TS-CFG ... duerfen KEINE Endung haben wie .LOG! *}
     carrier_hack_mode: byte;       {* Hack Type : 0=just wait, 1=std. nudge, 2=autonom *}
     save_data        : byte;       {* Welche IDs NICHT in das DAT speichern? *}
                                    {* outranged=1, busy=2, excluded=4, timeout=8, ringout=16, custom3=128 *}
     nudge            : string;
     nudge_delay      : byte;       {* Seconds to wait until disconnect in hack mode 0 und 1 *}
     manual           : boolean;    {* Manual/Autonom Mode? *}
     manual_timeout   : byte;       {* Manual/Autonom Timeout in seconds *}
     Execute          : array[1..9] of Exec_File;
				    {* F1 - F8 Belegung. Siehe oben TYPE EXEC_FILE *}
     balken           : byte;       {* Welche Balken Progress Bar Type ... 0-2 *}
     _custom1,
     _custom2,
     _custom3         : string[25]; {* Display String fuer Custom 1-3 *}
     _custom12,
     _custom22,
     _custom32        : boolean;    {* Ist Custom 1-3 Secondary ID ? *}
     delete_zero      : boolean;    {* Delete 0 byte LOG files ? *}
     fast_hangup      : boolean;    {* FAST Hangup (true) or Secure? *}
     exec_timeout,
     exec_ringout     : byte;       {* Execute Program on Timeout/Ringout? 0=nein 1-8=F1-F8 Belegung *}
     use_fossil:boolean;
     ComPort:byte;
     DO_ELAPSE : BOOLEAN;
     cmd_delay:word;
     dial_delayer:byte;
     dial_delay_from,dial_delay_to:byte;
     send_delay_from,send_delay_to:word;
     do_dial_exec:boolean; {React: 0=modem dials number, 1=do dial prefix, 2 do ath1 before exec}
                        end;
{      ConfigTypev10   = record
                             version : string[5];
                       ComPort:byte;
                       use_fossil:boolean;
                       irq, baseadress, speed : word;
                       B_Data, B_Stop : byte;
                       B_Parity : char;
                       fast_hangup:boolean;
                       auto_detect : boolean;
                       Init1, Init2 : string[25];
                       hangup, dial_prefix, dial_suffix, speakeron, speakeroff : string[20];
                       flee, dialup_hangup : char;
                       cmd_delay:word;
                       char_delay : byte;
                       waitbetweencalls : word;
                       scanmode : byte;
                       dialing : longint;
                       manual:boolean;
                       manual_timeout, carrier_hack_mode, nudge_delay : byte;
                       nudge : string;
                       redial_busy, busy_overwrite : boolean;
                       Timeout, ringout, nodial_exit : byte;
                       auto_dat_save, save_data, datfilesave : byte;
                       modem_respond_id : array [1..18] of response_id;
                       Logs : array[0..18] of string[8];
                       Execute:array[1..9] of Exec_File;
                       exec_timeout,exec_ringout:byte;
                       _custom1,_custom2,_custom3:string[25];
                       _custom12,_custom22,_custom32:boolean;
                       do_dial_exec:boolean;
                       balken : byte;
                       delete_zero:boolean;
                       DO_ELAPSE : BOOLEAN;
                       dial_delayer:byte;
                       dial_delay_from,dial_delay_to:byte;
                       send_delay_from,send_delay_to:word;
                       end;
}

Function WhichCom(basa:word):byte;
begin case basa of
    $3F8 : WhichCom:=1;
    $2F8 : WhichCom:=2;
    $3E8 : WhichCom:=3;
    $2E8 : WhichCom:=4;
   else begin if config.comport=0 then WhichCom:=2 else Whichcom:=config.comport; end;end;
end;










Function VERSIONOFCONFIGFILE(name:string):string;
Var f:file; byt:byte;
begin y:='     '; if IOResult<>0 then;
   assign(f,name); {I-} reset(f,1); {I+} If IOResult=0 then begin
   blockread(f,byt,1); for a:=1 to 5 do begin blockread(f,byt,1); y[a]:=Chr(byt); end;
   close(f); end; versionofconfigfile:=y; if IOResult<>0 then;
end;
Procedure LOAD_6A;
Var configf_6a:file of configtypev06a;cfg_:configtypev06a;
begin
   assign(configf_6a,LoadFile); reset(configf_6a); read(configf_6a,cfg_); close(configf_6a);
    config.irq:=cfg_.irq;  config.baseadress:=cfg_.baseadress;  config.speed:=cfg_.speed;
    config.b_data:=cfg_.b_data; config.b_parity:=cfg_.b_parity; config.b_stop:=cfg_.b_stop;
    config.init1:=cfg_.init1;  config.init2:=cfg_.init2;  config.flee:=cfg_.flee; config.hangup:=cfg_.hangup;
    config.dial_prefix:=cfg_.dial_prefix; config.dial_suffix:=cfg_.dial_suffix;
    config.Speakeron:=cfg_.Speakeron; config.Speakeroff:=cfg_.Speakeroff;
    config.waitbetweencalls:=cfg_.waitbetweencalls; config.char_delay:=cfg_.char_delay; config.auto_detect:=true;
    config.fast_hangup:=false;config.dialup_hangup:=#0;
    config.use_fossil:=false; config.ComPort:=WhichCom(config.baseadress);
{2}
    for a:=1 to 18 do config.modem_respond_id[a]:=cfg_.modem_respond_id[a];
{3}
    config.scanmode:=cfg_.scanmode;  config.dialing:=cfg_.dialing;
    config.manual:=cfg_.manual; config.manual_timeout:=cfg_.manual_timeout;
    config.redial_busy:=cfg_.redial_busy;
    config.Timeout:=cfg_.Timeout;       config.ringout:=cfg_.ringout;
    config.save_data:=cfg_.save_data;
    config.datfilesave:=cfg_.datfilesave;
    config.auto_dat_save:=cfg_.auto_dat_save;
    config.busy_overwrite:=cfg_.busy_overwrite;
    config.nodial_exit:=cfg_.nodial_exit;
{4}
    if cfg_.do_carrierlog then config.carrier_hack_mode:=cfg_.carrier_hack_mode else config.carrier_hack_mode:=3;
    config.nudge:=cfg_.nudge;
    config.nudge_delay:=cfg_.nudge_delay;
{5}
    for a:=1 to 18 do config.logs[a]:=cfg_.logs[a];
{6}
    config.balken:=cfg_.balken; config._custom1:=cfg_._custom1; config._custom2:=cfg_._custom2; config._custom3:=cfg_._custom3;
    config._custom12:=cfg_._custom12; config._custom22:=cfg_._custom22; config._custom32:=cfg_._custom32;
    config.delete_zero:=true; config.exec_timeout:=0; config.exec_ringout:=0;

    for a:=1 to 8 do config.execute[a]:=cfg_.execute[a];
config.do_elapse:=true;config.cmd_delay:=350;
config.dial_delayer:=0; config.send_delay_from:=1250; config.send_delay_to:=1500; config.dial_delay_from:=55;
config.dial_delay_to:=100;
config.do_dial_exec:=false; with config.execute[9] do begin fname:='SCAVENGE.EXE';
params:='/NOOUTPUT /DIALVAR ^D /S THC&SCAV.SCR';
React:=3; end;
config.logs[16]:=cfg_.logs[17];config.logs[17]:='';config.logs[18]:='';
config.dumb:=false;
config.intelligent:=true;
config.suspend:=false;
config.autoblank:=0;
config.reserved1:=0;config.reserved2:=0;

end;
Procedure LOAD_7;
Var configf_7:file of configtypev07;cfg_:configtypev07;
begin
   assign(configf_7,LoadFile); reset(configf_7); read(configf_7,cfg_); close(configf_7);
    config.irq:=cfg_.irq;  config.baseadress:=cfg_.baseadress;  config.speed:=cfg_.speed;
    config.b_data:=cfg_.b_data; config.b_parity:=cfg_.b_parity; config.b_stop:=cfg_.b_stop;
    config.init1:=cfg_.init1;  config.init2:=cfg_.init2;  config.flee:=cfg_.flee; config.hangup:=cfg_.hangup;
    config.dial_prefix:=cfg_.dial_prefix; config.dial_suffix:=cfg_.dial_suffix;
    config.Speakeron:=cfg_.Speakeron; config.Speakeroff:=cfg_.Speakeroff;
    config.waitbetweencalls:=cfg_.waitbetweencalls; config.char_delay:=cfg_.char_delay; config.auto_detect:=true;
    config.fast_hangup:=false;config.dialup_hangup:=#0;
    config.use_fossil:=false; config.ComPort:=WhichCom(config.baseadress);
{2}
    for a:=1 to 18 do config.modem_respond_id[a]:=cfg_.modem_respond_id[a];
{3}
    config.scanmode:=cfg_.scanmode;  config.dialing:=cfg_.dialing;
    config.manual:=cfg_.manual; config.manual_timeout:=cfg_.manual_timeout;
    config.redial_busy:=cfg_.redial_busy;
    config.Timeout:=cfg_.Timeout;       config.ringout:=cfg_.ringout;
    config.save_data:=cfg_.save_data;
    config.datfilesave:=cfg_.datfilesave;
    config.auto_dat_save:=cfg_.auto_dat_save;
    config.busy_overwrite:=cfg_.busy_overwrite;
    config.nodial_exit:=cfg_.nodial_exit;
{4}
    if cfg_.do_carrierlog then config.carrier_hack_mode:=cfg_.carrier_hack_mode else config.carrier_hack_mode:=3;
    config.nudge:=cfg_.nudge;
    config.nudge_delay:=cfg_.nudge_delay;
{5}
    for a:=1 to 18 do config.logs[a]:=cfg_.logs[a];
{6}
    config.balken:=cfg_.balken; config._custom1:=cfg_._custom1; config._custom2:=cfg_._custom2; config._custom3:=cfg_._custom3;
    config._custom12:=cfg_._custom12; config._custom22:=cfg_._custom22; config._custom32:=cfg_._custom32;
    config.delete_zero:=cfg_.delete_zero; config.exec_timeout:=0; config.exec_ringout:=0;

    for a:=1 to 8 do config.execute[a]:=cfg_.execute[a];
config.do_elapse:=true;config.cmd_delay:=350;
config.dial_delayer:=0; config.send_delay_from:=1250; config.send_delay_to:=1500; config.dial_delay_from:=55;
config.dial_delay_to:=100;
config.do_dial_exec:=false; with config.execute[9] do begin fname:='SCAVENGE.EXE';
params:='/NOOUTPUT /DIALVAR ^D /S THC&SCAV.SCR';
React:=3; end;
config.logs[16]:=cfg_.logs[17];config.logs[17]:='';config.logs[18]:='';
config.dumb:=false;
config.intelligent:=true;
config.suspend:=false;
config.autoblank:=0;
config.reserved1:=0;config.reserved2:=0;

end;

Procedure LOAD_7a;
Var configf_7:file of configtypev07a;cfg_:configtypev07a;
begin
   assign(configf_7,LoadFile); reset(configf_7); read(configf_7,cfg_); close(configf_7);
    config.irq:=cfg_.irq;  config.baseadress:=cfg_.baseadress;  config.speed:=cfg_.speed;
    config.b_data:=cfg_.b_data; config.b_parity:=cfg_.b_parity; config.b_stop:=cfg_.b_stop;
    config.init1:=cfg_.init1;  config.init2:=cfg_.init2;  config.flee:=cfg_.flee; config.hangup:=cfg_.hangup;
    config.dial_prefix:=cfg_.dial_prefix; config.dial_suffix:=cfg_.dial_suffix;
    config.Speakeron:=cfg_.Speakeron; config.Speakeroff:=cfg_.Speakeroff;
    config.waitbetweencalls:=cfg_.waitbetweencalls; config.char_delay:=cfg_.char_delay; config.auto_detect:=true;
    config.fast_hangup:=cfg_.fast_hangup;config.dialup_hangup:=cfg_.dialup_hangup[1];
    config.use_fossil:=false; config.ComPort:=WhichCom(config.baseadress);
{2}
    for a:=1 to 18 do config.modem_respond_id[a]:=cfg_.modem_respond_id[a];
{3}
    config.scanmode:=cfg_.scanmode;  config.dialing:=cfg_.dialing;
    config.manual:=cfg_.manual; config.manual_timeout:=cfg_.manual_timeout;
    config.redial_busy:=cfg_.redial_busy;
    config.Timeout:=cfg_.Timeout;       config.ringout:=cfg_.ringout;
    config.save_data:=cfg_.save_data;
    config.datfilesave:=cfg_.datfilesave;
    config.auto_dat_save:=cfg_.auto_dat_save;
    config.busy_overwrite:=cfg_.busy_overwrite;
    config.nodial_exit:=cfg_.nodial_exit;
{4}
    if cfg_.do_carrierlog then config.carrier_hack_mode:=cfg_.carrier_hack_mode else config.carrier_hack_mode:=3;
    config.nudge:=cfg_.nudge;
    config.nudge_delay:=cfg_.nudge_delay;
{5}
    for a:=1 to 18 do config.logs[a]:=cfg_.logs[a];
{6}
    config.balken:=cfg_.balken; config._custom1:=cfg_._custom1; config._custom2:=cfg_._custom2; config._custom3:=cfg_._custom3;
    config._custom12:=cfg_._custom12; config._custom22:=cfg_._custom22; config._custom32:=cfg_._custom32;
    config.delete_zero:=cfg_.delete_zero; config.exec_timeout:=0; config.exec_ringout:=0;

    for a:=1 to 8 do config.execute[a]:=cfg_.execute[a];
config.do_elapse:=true;config.cmd_delay:=350;
config.dial_delayer:=0; config.send_delay_from:=1250; config.send_delay_to:=1500; config.dial_delay_from:=55;
config.dial_delay_to:=100;
config.do_dial_exec:=false; with config.execute[9] do begin fname:='SCAVENGE.EXE';
params:='/NOOUTPUT /DIALVAR ^D /S THC&SCAV.SCR';
React:=3; end;
config.logs[16]:=cfg_.logs[17];config.logs[17]:='';config.logs[18]:='';
config.dumb:=false;
config.intelligent:=true;
config.suspend:=false;
config.autoblank:=0;
config.reserved1:=0;config.reserved2:=0;

end;

Procedure LOAD_8b;
Var configf_7:file of configtypev08b;cfg_:configtypev08b;
begin
   assign(configf_7,LoadFile); reset(configf_7); read(configf_7,cfg_); close(configf_7);
    config.irq:=cfg_.irq;  config.baseadress:=cfg_.baseadress;  config.speed:=cfg_.speed;
    config.b_data:=cfg_.b_data; config.b_parity:=cfg_.b_parity; config.b_stop:=cfg_.b_stop;
    config.init1:=cfg_.init1;  config.init2:=cfg_.init2;  config.flee:=cfg_.flee; config.hangup:=cfg_.hangup;
    config.dial_prefix:=cfg_.dial_prefix; config.dial_suffix:=cfg_.dial_suffix;
    config.Speakeron:=cfg_.Speakeron; config.Speakeroff:=cfg_.Speakeroff;
    config.waitbetweencalls:=cfg_.waitbetweencalls; config.char_delay:=cfg_.char_delay; config.auto_detect:=true;
    config.fast_hangup:=cfg_.fast_hangup;config.dialup_hangup:=config.dialup_hangup;
    config.use_fossil:=false; config.ComPort:=WhichCom(config.baseadress);

{2}
    for a:=1 to 18 do config.modem_respond_id[a]:=cfg_.modem_respond_id[a];
{3}
    config.scanmode:=cfg_.scanmode;  config.dialing:=cfg_.dialing;
    config.manual:=cfg_.manual; config.manual_timeout:=cfg_.manual_timeout;
    config.redial_busy:=cfg_.redial_busy;
    config.Timeout:=cfg_.Timeout;       config.ringout:=cfg_.ringout;
    config.save_data:=cfg_.save_data;
    config.datfilesave:=cfg_.datfilesave;
    config.auto_dat_save:=cfg_.auto_dat_save;
    config.busy_overwrite:=cfg_.busy_overwrite;
    config.nodial_exit:=cfg_.nodial_exit;
{4}
    if cfg_.do_carrierlog then config.carrier_hack_mode:=cfg_.carrier_hack_mode else config.carrier_hack_mode:=3;
    config.nudge:=cfg_.nudge;
    config.nudge_delay:=cfg_.nudge_delay;
{5}
    for a:=1 to 18 do config.logs[a]:=cfg_.logs[a];
{6}
    config.balken:=cfg_.balken; config._custom1:=cfg_._custom1; config._custom2:=cfg_._custom2; config._custom3:=cfg_._custom3;
    config._custom12:=cfg_._custom12; config._custom22:=cfg_._custom22; config._custom32:=cfg_._custom32;
    config.delete_zero:=cfg_.delete_zero; config.exec_timeout:=0; config.exec_ringout:=0;

    for a:=1 to 8 do config.execute[a]:=cfg_.execute[a];
config.do_elapse:=true;config.cmd_delay:=350;
config.dial_delayer:=0; config.send_delay_from:=1250; config.send_delay_to:=1500; config.dial_delay_from:=55;
config.dial_delay_to:=100;
config.do_dial_exec:=false; with config.execute[9] do begin fname:='SCAVENGE.EXE';
params:='/NOOUTPUT /DIALVAR ^D /S THC&SCAV.SCR';
React:=3; end;
config.logs[16]:=cfg_.logs[17];config.logs[17]:='';config.logs[18]:='';
config.dumb:=false;
config.intelligent:=true;
config.suspend:=false;
config.autoblank:=0;
config.reserved1:=0;config.reserved2:=0;

end;
Procedure LOAD_9b;
Var configf_7:file of configtypev09b;cfg_:configtypev09b;
begin
   assign(configf_7,LoadFile); reset(configf_7); read(configf_7,cfg_); close(configf_7);
    config.irq:=cfg_.irq;  config.baseadress:=cfg_.baseadress;  config.speed:=cfg_.speed;
    config.b_data:=cfg_.b_data; config.b_parity:=cfg_.b_parity; config.b_stop:=cfg_.b_stop;
    config.init1:=cfg_.init1;  config.init2:=cfg_.init2;  config.flee:=cfg_.flee; config.hangup:=cfg_.hangup;
    config.dial_prefix:=cfg_.dial_prefix; config.dial_suffix:=cfg_.dial_suffix;
    config.Speakeron:=cfg_.Speakeron; config.Speakeroff:=cfg_.Speakeroff;
    config.waitbetweencalls:=cfg_.waitbetweencalls; config.char_delay:=cfg_.char_delay; config.auto_detect:=true;
    config.fast_hangup:=cfg_.fast_hangup;config.dialup_hangup:=cfg_.dialup_hangup[1];
    config.use_fossil:=cfg_.use_fossil; config.ComPort:=cfg_.ComPort;

{2}
    for a:=1 to 18 do config.modem_respond_id[a]:=cfg_.modem_respond_id[a];
{3}
    config.scanmode:=cfg_.scanmode;  config.dialing:=cfg_.dialing;
    config.manual:=cfg_.manual; config.manual_timeout:=cfg_.manual_timeout;
    config.redial_busy:=cfg_.redial_busy;
    config.Timeout:=cfg_.Timeout;       config.ringout:=cfg_.ringout;
    config.save_data:=cfg_.save_data;
    config.datfilesave:=cfg_.datfilesave;
    config.auto_dat_save:=cfg_.auto_dat_save;
    config.busy_overwrite:=cfg_.busy_overwrite;
    config.nodial_exit:=cfg_.nodial_exit;
{4}
    if cfg_.do_carrierlog then config.carrier_hack_mode:=cfg_.carrier_hack_mode else config.carrier_hack_mode:=3;
    config.nudge:=cfg_.nudge;
    config.nudge_delay:=cfg_.nudge_delay;
{5}
    for a:=1 to 18 do config.logs[a]:=cfg_.logs[a];
{6}
    config.balken:=cfg_.balken; config._custom1:=cfg_._custom1; config._custom2:=cfg_._custom2; config._custom3:=cfg_._custom3;
    config._custom12:=cfg_._custom12; config._custom22:=cfg_._custom22; config._custom32:=cfg_._custom32;
    config.delete_zero:=cfg_.delete_zero; config.exec_timeout:=0; config.exec_ringout:=0;

    for a:=1 to 8 do config.execute[a]:=cfg_.execute[a];

config.do_elapse:=true;config.cmd_delay:=350;
config.dial_delayer:=0; config.send_delay_from:=1250; config.send_delay_to:=1500; config.dial_delay_from:=55;
config.dial_delay_to:=100;
config.do_dial_exec:=false; with config.execute[9] do begin fname:='SCAVENGE.EXE';
params:='/NOOUTPUT /DIALVAR ^D /S THC&SCAV.SCR';
React:=3; end;
config.logs[16]:=cfg_.logs[17];config.logs[17]:='';config.logs[18]:='';
config.dumb:=false;
config.intelligent:=true;
config.suspend:=false;
config.autoblank:=0;
config.reserved1:=0;config.reserved2:=0;

end;
Procedure LOAD_9c;
Var configf_7:file of configtypev09c;cfg_:configtypev09c;
begin
   assign(configf_7,LoadFile); reset(configf_7); read(configf_7,cfg_); close(configf_7);
    config.irq:=cfg_.irq;  config.baseadress:=cfg_.baseadress;  config.speed:=cfg_.speed;
    config.b_data:=cfg_.b_data; config.b_parity:=cfg_.b_parity; config.b_stop:=cfg_.b_stop;
    config.init1:=cfg_.init1;  config.init2:=cfg_.init2;  config.flee:=cfg_.flee; config.hangup:=cfg_.hangup;
    config.dial_prefix:=cfg_.dial_prefix; config.dial_suffix:=cfg_.dial_suffix;
    config.Speakeron:=cfg_.Speakeron; config.Speakeroff:=cfg_.Speakeroff;
    config.waitbetweencalls:=cfg_.waitbetweencalls; config.char_delay:=cfg_.char_delay; config.auto_detect:=true;
    config.fast_hangup:=cfg_.fast_hangup;config.dialup_hangup:=cfg_.dialup_hangup[1];
    config.use_fossil:=cfg_.use_fossil; config.ComPort:=cfg_.ComPort;

{2}
    for a:=1 to 18 do config.modem_respond_id[a]:=cfg_.modem_respond_id[a];
{3}
    config.scanmode:=cfg_.scanmode;  config.dialing:=cfg_.dialing;
    config.manual:=cfg_.manual; config.manual_timeout:=cfg_.manual_timeout;
    config.redial_busy:=cfg_.redial_busy;
    config.Timeout:=cfg_.Timeout;       config.ringout:=cfg_.ringout;
    config.save_data:=cfg_.save_data;
    config.datfilesave:=cfg_.datfilesave;
    config.auto_dat_save:=cfg_.auto_dat_save;
    config.busy_overwrite:=cfg_.busy_overwrite;
    config.nodial_exit:=cfg_.nodial_exit;
{4}
    if cfg_.do_carrierlog then config.carrier_hack_mode:=cfg_.carrier_hack_mode else config.carrier_hack_mode:=3;
    config.nudge:=cfg_.nudge;
    config.nudge_delay:=cfg_.nudge_delay;
{5}
    for a:=1 to 18 do config.logs[a]:=cfg_.logs[a];
{6}
    config.balken:=cfg_.balken; config._custom1:=cfg_._custom1; config._custom2:=cfg_._custom2; config._custom3:=cfg_._custom3;
    config._custom12:=cfg_._custom12; config._custom22:=cfg_._custom22; config._custom32:=cfg_._custom32;
    config.delete_zero:=cfg_.delete_zero; config.exec_timeout:=0; config.exec_ringout:=0;

    for a:=1 to 8 do config.execute[a]:=cfg_.execute[a];

config.do_elapse:=true;config.cmd_delay:=350;
config.dial_delayer:=0; config.send_delay_from:=1250; config.send_delay_to:=1500; config.dial_delay_from:=55;
config.dial_delay_to:=100;
config.do_dial_exec:=false; with config.execute[9] do begin fname:='SCAVENGE.EXE';
params:='/NOOUTPUT /DIALVAR ^D /S THC&SCAV.SCR';
React:=3; end;
config.logs[16]:=cfg_.logs[17];config.logs[17]:='';config.logs[18]:='';
config.dumb:=false;
config.intelligent:=true;
config.suspend:=false;
config.autoblank:=0;
config.reserved1:=0;config.reserved2:=0;
end;


Procedure LOAD_10;
Var configf_7:file of configtypev10;cfg_:configtypev10;
begin
   assign(configf_7,LoadFile); reset(configf_7); read(configf_7,cfg_); close(configf_7);
    config.irq:=cfg_.irq;  config.baseadress:=cfg_.baseadress;  config.speed:=cfg_.speed;
    config.b_data:=cfg_.b_data; config.b_parity:=cfg_.b_parity; config.b_stop:=cfg_.b_stop;
    config.init1:=cfg_.init1;  config.init2:=cfg_.init2;  config.flee:=cfg_.flee; config.hangup:=cfg_.hangup;
    config.dial_prefix:=cfg_.dial_prefix; config.dial_suffix:=cfg_.dial_suffix;
    config.Speakeron:=cfg_.Speakeron; config.Speakeroff:=cfg_.Speakeroff;
    config.waitbetweencalls:=cfg_.waitbetweencalls; config.char_delay:=cfg_.char_delay;
    config.fast_hangup:=cfg_.fast_hangup;config.dialup_hangup:=cfg_.dialup_hangup{[1]};
    config.use_fossil:=cfg_.use_fossil; config.ComPort:=cfg_.ComPort;
    config.auto_detect:=cfg_.auto_detect;
{2}
    for a:=1 to 18 do config.modem_respond_id[a]:=cfg_.modem_respond_id[a];
{3}
    config.scanmode:=cfg_.scanmode;  config.dialing:=cfg_.dialing;
    config.manual:=cfg_.manual; config.manual_timeout:=cfg_.manual_timeout;
    config.redial_busy:=cfg_.redial_busy;
    config.Timeout:=cfg_.Timeout;       config.ringout:=cfg_.ringout;
    config.save_data:=cfg_.save_data;
    config.datfilesave:=cfg_.datfilesave;
    config.auto_dat_save:=cfg_.auto_dat_save;
    config.busy_overwrite:=cfg_.busy_overwrite;
    config.nodial_exit:=cfg_.nodial_exit;
{4}
    config.carrier_hack_mode:=cfg_.carrier_hack_mode;
    config.nudge:=cfg_.nudge;
    config.nudge_delay:=cfg_.nudge_delay;
{5}
    for a:=1 to 18 do config.logs[a]:=cfg_.logs[a];
{6}
    config.balken:=cfg_.balken; config._custom1:=cfg_._custom1; config._custom2:=cfg_._custom2; config._custom3:=cfg_._custom3;
    config._custom12:=cfg_._custom12; config._custom22:=cfg_._custom22; config._custom32:=cfg_._custom32;
    config.delete_zero:=cfg_.delete_zero;

    for a:=1 to 8 do config.execute[a]:=cfg_.execute[a];

config.exec_timeout:=cfg_.exec_timeout; config.exec_ringout:=cfg_.exec_ringout;
config.do_elapse:=cfg_.do_elapse;config.cmd_delay:=cfg_.cmd_delay;
config.dial_delayer:=cfg_.dial_delayer; config.send_delay_from:=cfg_.send_delay_from;
config.send_delay_to:=cfg_.send_delay_to; config.dial_delay_from:=cfg_.dial_delay_from;
config.dial_delay_to:=cfg_.dial_delay_to;
config.do_dial_exec:=cfg_.do_dial_exec; with config.execute[9] do begin fname:=cfg_.execute[9].fname;
params:=cfg_.execute[9].params; React:=cfg_.execute[9].react; end;
config.logs[16]:=cfg_.logs[17];config.logs[17]:='';config.logs[18]:='';
config.dumb:=false;
config.intelligent:=true;
config.suspend:=false;
config.autoblank:=0;
config.reserved1:=0;config.reserved2:=0;
end;




Procedure INIT;
begin {1}
    config.irq:=3;  config.baseadress:=760;  config.speed:=19200;
    config.b_data:=8; config.b_parity:='N'; config.b_stop:=1;
    config.init1:='Z';  config.init2:='S11=64 S10=50';  config.flee:='+'; config.hangup:='H';
    config.dial_prefix:='DT'; config.dial_suffix:='';
    config.Speakeron:='M1'; config.Speakeroff:='M0'; config.dialup_hangup:=#0;
    config.waitbetweencalls:=1000; config.char_delay:=0; config.auto_detect:=true;
    config.use_fossil:=false; config.ComPort:=2;
{2}
    for a:=1 to 18 do with config.modem_respond_id[a] do begin
        rings_from:=0; rings_to:=255; print:=false; exec_it:=0;
        case a of
         1:begin response:='CONNECT'; print:=true; end;     {carrier}
         2:response:='FAX';                                 {fax}
         3:response:='NO CARRIER';                          {###???carrier lost}
         4:begin response:='NO DIALTONE'; rings_to:=0; end; {nodial}
         5:begin response:='NO ANSWER'; rings_from:=1; end; {modem outtime}
         6:begin response:='BUSY'; rings_to:=0; end;        {busy}
         7:begin response:='VOICE'; rings_from:=1; end;     {voice}
         8:begin response:='OK';print:=true;rings_to:=0;end;{tone}
         9:response:='ERROR';                               {modem error}
        10:response:='RING';                                {ring-incoming call}
        11:response:='RINGING';                             {ringing}
        12:begin response:='VOICE'; rings_to:=0; end;       {vmb}
        13:response:='';                                    {custom1}
        14:response:='';                                    {custom2}
        15:response:='';                                    {custom3}
        16:begin response:='NO ANSWER'; rings_to:=0; end;   {unused}
        17:begin response:='BUSY'; rings_from:=1; end;      {done from other side}
        18:begin response:='NO CARRIER'; rings_to:=0;end; {no tone while tonescan}
end;end;
{3}
    config.scanmode:=1;
    config.dialing:=0;
    config.manual:=false; config.manual_timeout:=30;
    config.redial_busy:=true;
    config.Timeout:=50;       config.ringout:=6;
    config.save_data:=0;
    config.datfilesave:=0;
    config.auto_dat_save:=10;
    config.busy_overwrite:=false;
    config.nodial_exit:=20;
{4}
    config.carrier_hack_mode:=1;
    config.nudge:='^~^~^~^~^~^M^~^M?^M^~help^M^~^~^~guest^M^~guest^M^~INFO^M^MLOGIN^M^~^~^~^~^~^~^~^~^~^~';
    config.nudge_delay:=60;
{5}
    config.logs[1]:='CARRIER';    config.logs[2]:='FAX';    config.logs[3]:='TONE';
    config.logs[4]:='VMB';    config.logs[5]:='VOICE';    config.logs[6]:='CUSTOM1';
    config.logs[7]:='CUSTOM2';    config.logs[8]:='CUSTOM3';    config.logs[9]:='BUSY';
    config.logs[10]:='UNUSED';    config.logs[11]:='MANUAL';    config.logs[12]:='COUNTRY';
    config.logs[13]:='CCITT';    config.logs[14]:='COMMENTS';    config.logs[15]:='CARRIERS';
    config.logs[16]:='DONE';    config.logs[17]:=''; config.logs[18]:='';
    config.logs[0]:='THC-SCAN';
{6}
    config.balken:=2; config._custom1:='CUSTOM1'; config._custom2:='CUSTOM2'; config._custom3:='CUSTOM3';
    config._custom12:=false; config._custom22:=false; config._custom32:=false;
    config.delete_zero:=true;

config.do_elapse:=true;config.cmd_delay:=350;
config.dial_delayer:=0; config.send_delay_from:=1250; config.send_delay_to:=1500; config.dial_delay_from:=55;
config.dial_delay_to:=100;
config.do_dial_exec:=false; with config.execute[9] do begin fname:='SCAVENGE.EXE';
params:='/NOOUTPUT /DIALVAR ^D /S THC&SCAV.SCR';
React:=3; end;

config.dumb:=false;
config.intelligent:=true;
config.suspend:=false;
config.autoblank:=0;
config.reserved1:=0;config.reserved2:=0;

{TEST!}
end;


Procedure LoadIt;
  begin
      x:=Versionofconfigfile(loadfile); done:=0;
      if (x='v0.6a') then begin done:=2; Load_6a; end;
      if (x='v0.6b') then begin done:=2; Load_7;  end;
      if (x='v0.6c') then begin done:=2; Load_7;  end;
      if (x='v0.7') then begin done:=2; Load_7;  end;
      if (x='v0.7a') then begin done:=2; Load_7a; end;
      if (x='v0.8') then begin done:=2; Load_7a; end;
      if (x='v0.8a') then begin done:=2; Load_7a; end;
      if (x='v0.8b') then begin done:=2; Load_8b; end;
      if (x='v0.8c') then begin done:=2; Load_8b; end;
      if (x='v0.9') then begin done:=2; Load_8b; end;
      if (x='v0.9a') then begin done:=2; Load_8b; end;
      if (x='v0.9b') then begin done:=2; Load_9b; end;
      if (x='v0.9c') then begin done:=2; Load_9c; end;
      if (x='v0.9d') then begin done:=2; Load_9c; end;
      if (x='v0.9e') then begin done:=2; Load_9c; end;
      if (x='v1.00') then begin done:=2; Load_10; end;
      if (x='v1.10') then begin done:=1; end;
      if (x='v1.20') then begin done:=1; end;
      if (x='v1.30') then begin done:=1; end;
      if (x='v1.31') then begin done:=1; end;
      if (x='v1.40') then begin done:=1; end;
      if (x='v1.50') then begin done:=1; end;
      if (x='v1.98') then begin done:=1; end;
      if (x='v2.00') then begin done:=1; end;
      if (x=ver) then begin done:=1; end;
      if done=1 then begin assign(config_file,loadfile);reset(config_file);read(config_file,config);close(config_file); end;
      if done=0 then begin init; newcreate:=true;end;
   if IOResult<>0 then;
end;

Procedure _exiter;
begin
    Window(1,1,80,25); TextColor(7); TextBackground(0); ClrScr;
    Window(1,1,80,1); TextColor(15); TextBackground(1); ClrScr;
    Window(1,1,80,25);
    if Length(loadfile)<=12 then loadfile_:=loadfile else loadfile_:=Filename(loadfile);
    if length(loadfile_)>12 then Delete(loadfile_,1,length(loadfile_)-12);
    write('THC-SCAN CONFIG  ',ver,author,'       File : ',LoadFile_);
    TextColor(7); TextBackground(0); writeln; halt;
end;


begin
     checkbreak:=false;
end.
