program dat_conv;
uses dos,crt,my2,ts_lib,version;
var f, g   : file;
    tl, ts : array[0..9999] of byte;
    tl_head: array[1..16] of byte;
    ts_head: array[1..32] of byte;
    a,b,c,d: word;
    ch     : char;
    name1,name2,_id1,_id2,tmp:string;
    id_1,id_2,mode:byte;
    e      : longint;


procedure HELP;
begin
   writeln('SYNTAX  : DAT-CONV.EXE <Datfile> <Converted-Datfile> [<ID_4_Note> <ID_4_NoDial>]');
   writeln;
   writeln('OPTIONS : <Datfile>           Existing Datfile to convert.');
   writeln('                              DAT-CONV does autodetect TS and TL format.');
   writeln('          <Converted-Datfile> Converted Datfile to create.');
   writeln;
   writeln('OPTIONAL: <ID_4_Note>         Standard: CUSTOM1  (ID 224)');
   writeln('          <ID_4_NoDial>       Standard: UNDIALED (ID 0)');
   writeln;
   writeln('The optional parameters define which IDs from TL are mapped to which TS IDs,');
   writeln('because TS does have much more. It`s only for fast stuff, use DAT-MANP for');
   writeln('more manipulating. You may use ID NAMES ("CARRIER") or ID NUMBERS ("64") as IDs.');
   writeln('You can only use both optional parameters together or none.');
   halt;
end;

procedure ERROR(typ:byte);
begin
   write('Error (',typ,') : ');
   case typ of
     1:writeln('Input Datfile not found!');
     2:writeln('Can`t create Convert-Datfile !');
     3:writeln('Incorrect Size of input Datfile. Neither TS nor TL format.');
     4:writeln('ID for NOTE is neither a NAME ID nor a NUMBER ID : ',ParamStr(3));
     5:writeln('ID for NoDial is neither a NAME ID nor a NUMBER ID : ',ParamStr(4));
   end;
   halt;
end;

function acht(typ:byte):byte;
begin
   typ:=typ div 8;
   acht:=Trunc(typ*8);
end;

procedure TL2TS;
begin
   blockread(f,tl_head,16); c:=c-16;
   blockread(f,tl,c);
   for a:=0 to c-1 do begin
      b:=tl[a] mod 10;
      if b>7 then begin
         b:=7;
         tl[a]:=(tl[a] div 10) + b;
      end;
   end;
   for a:=0 to c-1 do begin
       b:=tl[a];
       if (b= 0) then ts[a]:=0;
       if (b>  9) and (b< 18) then ts[a]:=  8;
       if (b> 19) and (b< 28) then ts[a]:=108+b;
       if (b> 29) and (b< 28) then ts[a]:=id_2;
       if (b=40) then ts[a]:=id_1;
       if (b=41) then ts[a]:=120;
       if (b=42) then ts[a]:=144;
       if (b=43) then ts[a]:=192;
       if (b=44) then ts[a]:=152;
       if (b> 49) and (b< 58) then ts[a]:=b-26;
       if (b> 59) and (b< 68) then ts[a]:=b-20;
       if (b> 69) and (b< 78) then ts[a]:=b-38;
       if (b> 79) and (b< 88) then ts[a]:= 88+b;
       if (b> 89) and (b< 98) then ts[a]:=b-18;
       if (b> 99) and (b<108) then ts[a]:= 16;
       if (b>109) and (b<118) then ts[a]:=108+b;
       if (b>119) and (b<128) then ts[a]:=b-96;
       if (b>129) and (b<138) then ts[a]:= 16;
   end;
   tl_head[5]:=ts_head[29];  tl_head[6]:=ts_head[30];
   tmp:=ver;
   ts_head[1]:=Ord('T'); ts_head[2]:=Ord('S');
   ts_head[3]:=Ord(tmp[2]); ts_head[4]:=Ord(tmp[4]);
   blockwrite(g,ts_head,32); blockwrite(g,ts,c);
end;

procedure TS2TL;
begin
   blockread(f,ts_head,32); c:=c-32;
   blockread(f,ts,c);
   for a:=0 to c-1 do begin
     b:=ts[a];
     if ((Acht(b)=Acht(id_1))and(id_1<8))or(b=id_1) then tl[a]:=40 else
     if ((Acht(b)=Acht(id_2))and(id_2<8))or(b=id_2) then tl[a]:=30 else
       begin
       if b=0 then tl[a]:=0;
       if b=1 then tl[a]:=100;
       if Acht(b)=8 then tl[a]:=10;
       if Acht(b)=16 then tl[a]:=100;
       if Acht(b)=24 then tl[a]:=b+26;
       if Acht(b)=32 then tl[a]:=b+38;
       if Acht(b)=40 then tl[a]:=b+20;
       if Acht(b)=48 then tl[a]:=30;
       if Acht(b)=56 then tl[a]:=40;
       if Acht(b)=64 then tl[a]:=b+26;
       if Acht(b)=72 then tl[a]:=b+18;
       if Acht(b)=80 then tl[a]:=b+10;
       if Acht(b)=88 then tl[a]:=b+2;
       if Acht(b)=96 then tl[a]:=b-6;
       if Acht(b)=104 then tl[a]:=b-14;
       if Acht(b)=120 then tl[a]:=41;
       if Acht(b)=128 then tl[a]:=42;
       if Acht(b)=136 then tl[a]:=42;
       if Acht(b)=144 then tl[a]:=42;
       if Acht(b)=152 then tl[a]:=44;
       if Acht(b)=168 then tl[a]:=b-88;
       if Acht(b)=176 then tl[a]:=b-96;
       if Acht(b)=192 then tl[a]:=43;
       if Acht(b)=200 then tl[a]:=43;
       if Acht(b)=224 then tl[a]:=40;
       if Acht(b)=232 then tl[a]:=40;
       if Acht(b)=240 then tl[a]:=40;
       if Acht(b)=248 then tl[a]:=b-128;
     end;
   end;
   ts_head[29]:=tl_head[5];  ts_head[30]:=tl_head[6];
   tl_head[1]:=Ord('T'); tl_head[2]:=Ord('L');;
   tl_head[3]:=$1; tl_head[4]:=$16;
   blockwrite(g,tl_head,16); blockwrite(g,tl,10000);
end;


begin
   writeln('DAT Converter for  TONELOC <-> THC-SCAN  ',ver,author); writeln;
   Checkbreak:=false; SetCBreak(FALSE);
   if (ParamCount<2)or(ParamCount>4) then help;
   name1:=ParamStr(1);   name2:=ParamStr(2);
   if not Checkfile(name1) then begin
      name1:=name1+'.DAT';
      if not CheckFile(name1) then Error(1);
   end;
   id_1:=224; id_2:=0; mode:=0; _id1:='CUSTOM1 (224)'; _id2:='UNDIALED (0)';
   if ParamCount>=3 then begin
      _id1:=ParamStr(3); UPC(_id1);
      if not name_2_id(_id1, id_1) then Error(4);
   end;
   if ParamCount=4 then begin
      _id2:=ParamStr(4); UPC(_id2);
      if not name_2_id(_id2, id_2) then Error(5);
   end;

   tmp:=Forename(name2); if tmp=name2 then name2:=name2+'.DAT';
   if Checkfile(name2) then begin
      write('Dat-File 2 ',name2,' exists. Overwrite? (Y/n)');
      ch:=UpCase(readkey);
      if ch='N' then begin writeln(ch); halt; end else writeln('Y');
   end;
   assign(g,name2); {I-} rewrite(g,1); {I+} If IOResult<>0 then Error(2);
   assign(f,name1); reset(f,1); c:=FSize(name1);
   if c=42 then mode:=2; if c mod 100 = 32 then mode:=2;
   if c=10016 then mode:=1;
   if mode=0 then Error(3);
   UPC(name1); UPC(name2);
   write('Mode : '); if mode=1 then writeln(' TL -> TS') else writeln(' TS -> TL');
   writeln('Datfile input : ',name1);
   writeln('Datfile output: ',name2);
   writeln('ID for NOTE   : ',_id1);
   writeln('ID for NODIAL : ',_id2);
   for a:=0 to 9999 do tl[a]:=0;  for a:=0 to 9999 do ts[a]:=0;
   for a:=1 to 16 do tl_head[a]:=0;  for a:=1 to 32 do ts_head[a]:=0;
   if mode=1 then tl2ts; if mode=2 then ts2tl;
   close(g); close(f);
end.