/*
 *      idlescan
 *      Copyright (C) 1999 LiquidK <liquidk@superbofh.org>
 *
 */

#ifndef __GLOBAL_H
#define __GLOBAL_H

#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#include <getopt.h>
#include <signal.h>
#include <setjmp.h>
#include <unistd.h>
#include <sys/socket.h>
#include <string.h>
#include <netinet/in.h>
#include <netinet/ip.h>

extern int   option_debug_level;


struct port_list {
    int total;
    struct port_node *head;
    struct port_node *current;
};
struct port_node {
    struct port_node *next;
    u_short begin, end;
};

typedef struct port_list plist;

struct sensor_list {
    struct sensor_list *next;
    char *hostname;
    int ip;                   /* ip of the host */
    int active;

/* state information */
    int id;                   /* last probbed ip.id */
    int passes;               /* number of scans on this port */
    int port;                 /* the port we are scanning */
    int seq;                  /* Reference seq number of last state action */
    int fail_traffic;
    int fail_packetloss;


    enum {HOST_TYPE_NA,
	  HOST_TYPE_NORMAL,
	  HOST_TYPE_WINDOWS
    } type;                   /* machine type */
    enum {HOST_ST_INIT,       /* Init */
	  HOST_ST_ANALYSE,    /* check id ip.id is incrementing */
	  HOST_ST_WAIT_PROBE, /* waiting for probe reply */
	  HOST_ST_SEND_PROBE, /* waiting to send next probe */
	  HOST_ST_RESYNC,     /* if we need to use this host again */
	  HOST_ST_FAIL,
	  HOST_ST_END
    } st;                     /* host state */
};

#endif
