#ifndef WINCLUDE
#define WINCLUDE
#define BYTE_ORDER LITTLE_ENDIAN
#define WIN32_LEAN_AND_MEAN
#include <string.h>
#include <winsock2.h>
#include <time.h>
#include <windows.h>
#include <Winbase.h>
#include <assert.h>
#include <iphlpapi.h>
#include <iptypes.h>
#include <stdlib.h>
#include <malloc.h>
#include <stdio.h>
#include <io.h>
#include <fcntl.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <process.h>
#include <errno.h>
#include <limits.h>
#include <pcap.h>
#include <packet32.h>
//#include <WINCRYPT.H>
#include <netinet/tcp.h>  
#include <netinet/udp.h>  
#include <net/if.h>
#include <winfix.h>
#include <math.h>
#include <snmp.h>
//#include <packet_types.h>

typedef unsigned int u_int8_t;
typedef unsigned short u_int16_t;
typedef unsigned long u_int32_t;
typedef unsigned int ssize_t;

#define MAXPATHLEN 2048
#define     ECONNABORTED    103     /* Software caused connection abort */
#define     ECONNRESET      104     /* Connection reset by peer */
#define     ECONNREFUSED    111     /* Connection refused */
#define     EAGAIN			11
#define     EHOSTUNREACH	113
#define     ENETDOWN		100
#define     ENETUNREACH		101
#define     ENETRESET		102
#define     ETIMEDOUT		110
#define     EHOSTDOWN		112
#define     EINPROGRESS		115
#define		EINVAL          22      /* Invalid argument */
#define     EPERM            1      /* Operation not permitted */
#define		EINTR            4      /* Interrupted system call */
#define		ENOBUFS         105     /* No buffer space available */
#define		ENOENT           2      /* No such file or directory */


#define S_ISDIR(m)      (((m) & _S_IFMT) == _S_IFDIR)
//#define HAVE_STRUCT_IP
//#define HAVE_STRUCT_ICMP


#define PROT_READ       0x1             /* page can be read */
#define PROT_WRITE      0x2             /* page can be written */
#define PROT_EXEC       0x4             /* page can be executed */
#define PROT_NONE       0x0             /* page can not be accessed */

#define MAP_SHARED      0x01            /* Share changes */
#define SIOCGIFCONF     0x8912          /* get iface list               */

#define snprintf _snprintf

#ifndef GLOBALS
#define GLOBALS 1
extern char *NMAP_VERSION;
extern char *NMAP_NAME;
extern char *NMAP_URL;
extern char *NMAPDATADIR;
extern HANDLE gmap; 
//extern struct interface_info global_adapter;
#endif

typedef BOOL (WINAPI *pSnmpExtensionInit)(
    IN  DWORD               dwTimeZeroReference,
    OUT HANDLE              *hPollForTrapEvent,
    OUT AsnObjectIdentifier *supportedView);

typedef BOOL (WINAPI *pSnmpExtensionTrap)(
    OUT AsnObjectIdentifier *enterprise,
    OUT AsnInteger          *genericTrap,
    OUT AsnInteger          *specificTrap,
    OUT AsnTimeticks        *timeStamp,
    OUT RFC1157VarBindList  *variableBindings);

typedef BOOL (WINAPI *pSnmpExtensionQuery)(
    IN BYTE                   requestType,
    IN OUT RFC1157VarBindList *variableBindings,
    OUT AsnInteger            *errorStatus,
    OUT AsnInteger            *errorIndex);

typedef BOOL (WINAPI *pSnmpExtensionInitEx)(
    OUT AsnObjectIdentifier *supportedView);


typedef struct {
  HINSTANCE             m_hInst;
  pSnmpExtensionInit    m_Init;
  pSnmpExtensionInitEx  m_InitEx;
  pSnmpExtensionQuery   m_Query;
  pSnmpExtensionTrap    m_Trap;
} LOCAL_MIB_ACCESS;

#define OID_SIZEOF( Oid )      ( sizeof Oid / sizeof(UINT) )

BOOL OpenMib(char *Name,LOCAL_MIB_ACCESS *Mib);
void CloseMib(LOCAL_MIB_ACCESS *Mib);
int FillIfList(struct _IFlist *iflist, int *icount);
int FillIpList(struct _IPlist *iplist);
int FillRouteList(struct myroute *routelist);

  struct _IPlist {
	  long	id;
	  DWORD ip;
  };

  struct _IFlist {
	  long	id;
	  char desc[512];
	  long type;
	  BYTE MAC[6];
  };

  struct _Arplist {
	  long	id;
	  DWORD ip;
	  long type;
	  BYTE MAC[6];
  };

  struct myroute {
 //   struct interface_info *dev;
	long	ifid;
    DWORD mask;
    DWORD dest;
	DWORD nexthop;
  };
  

void print_interfaces();
#endif //WINCLUDE