/************************************************************************\

               CATTscanner 0.61 - Atlanta.CON Release

   by Optyx <optyx@uberhax0r.net>     Uberhax0r Communications (c) 2000

       CATTscanner home page: http://www.uberhax0r.net/cattscanner

 portscan.c 03/18/00                                         Portscanner 
\***********************************************************************/

#include <stdio.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <netdb.h>
#include <unistd.h>
#include <signal.h>
#include <string.h>

void catch_alarm()
{
   alarm(0);
   signal(SIGALRM, SIG_DFL);
}

void tcpscan(char host[], int port, int timeout, int ident, FILE *output)
{

    int r, s, fd;
	unsigned int len;
    struct sockaddr_in s_addr;
    struct sockaddr_in s_ident;
    struct sockaddr_in s_resolve;
    struct servent *serv;

    char request[15], returned[85];

    s = socket(AF_INET, SOCK_STREAM, IPPROTO_TCP);
    if (s < 0) {
       return;
    }

    len=sizeof(s_resolve);

    s_addr.sin_family = AF_INET;
    s_addr.sin_port = htons(port);
    s_addr.sin_addr.s_addr = inet_addr(host);

    signal(SIGCHLD, SIG_IGN);
    signal(SIGALRM, catch_alarm);
 
    alarm(timeout);
    r = connect(s,(struct sockaddr *) &s_addr, sizeof(s_addr));
    alarm(0);

    if(r==-1) {
		close(s);
       return;
	}
	
    serv=getservbyport(s_addr.sin_port, "tcp");

    fprintf(output, "<TR>\n<TD>%d</TD>\n", port);
    fprintf(output, "<TD>%s</TD>\n", (serv==NULL)?"UKNOWN":serv->s_name); 

    if(ident) {

       
       s_ident.sin_family = AF_INET;
       s_ident.sin_addr.s_addr = inet_addr(host); 
       s_ident.sin_port = htons(113);

       if((fd=socket(AF_INET,SOCK_STREAM,0)) > -1) {

         if(getsockname(s,(struct sockaddr *) &s_resolve, &len)==0)
          if(connect(fd,(struct sockaddr *) &s_ident,sizeof(s_ident))!=-1) {

             sprintf(request, "%d,%u", htons(s_addr.sin_port),
                     htons(s_resolve.sin_port));
             write(fd, request, strlen(request)+1);
             len=read(fd, returned, 80);
             returned[len]='\0';
             strtok(returned, ":");
             strtok(NULL, ":");
             strtok(NULL, ":");
             fprintf(output, "<TD>%s</TD>\n", strtok(NULL, ":")); 
          }
         close(fd);
       }
    }       

    close(s);
}

void portscan(char host[], int low, int high, int type, int timeout, 
         int ident, char datadir[]) 
{
/*   struct servent *serv; */
   int port, fd, r;
   char filename[84], ttype[3];
 /*  char owner[85];*/
   FILE *output, *output2;
   struct sockaddr_in s_ident;


   if(!strcmp(host, ""))
      return;

   strcpy(filename, datadir);
   strcat(filename, "/");
   strcat(filename, host);
   strcat(filename, "/index.html");

   if((output=fopen(filename, "a")) == NULL)
      return;

   if(type)
      strcpy(ttype, "UDP");
   else
      strcpy(ttype, "TCP");

   fprintf(output, "<A HREF=\"%sscan.html\">%s ports listening ", ttype, ttype);
   fprintf(output, "from port %i to %i</A>\n<BR>\n", low, high);

   fclose(output);

   strcpy(filename, datadir);
   strcat(filename, "/");
   strcat(filename, host);
   strcat(filename, "/");
   strcat(filename, ttype);
   strcat(filename, "scan.html");
   
   if((output2=fopen(filename, "w")) == NULL)
      return;

   fprintf(output2, "<HTML>\n<HEAD>\n<TITLE>%s scan of %s", ttype, host);
   fprintf(output2, "</TITLE>\n</HEAD>\n<BODY>%s scan of %s ", ttype, host);
   fprintf(output2, "from port %d to %d", low, high);

   if(ident)
   {
      fd = socket(AF_INET, SOCK_STREAM, IPPROTO_TCP);
      if (fd < 0) {
         fprintf(output2, " withOUT ident");
         ident=0;
      }
      else { 

         s_ident.sin_family = AF_INET;
         s_ident.sin_port = htons(113);
         s_ident.sin_addr.s_addr = inet_addr(host);

         signal(SIGCHLD, SIG_IGN);
         signal(SIGALRM, catch_alarm);
 
         alarm(timeout);
         r = connect(fd,(struct sockaddr *) &s_ident, sizeof(s_ident));
         alarm(0);
         
         close(fd);

         if(r==-1) {
         
            fprintf(output2, " withOUT ident");
            ident=0;

         }
         else {

            fprintf(output2, " with ident");
            ident=1;

         }

      }
      close(fd);
   }

/*   fprintf(output2, "<BR>\n<HR>\n<BR>\n<TABLE>", low, high);*/
   fprintf(output2, "<BR>\n<HR>\n<BR>\n<TABLE>");
   fprintf(output2, "<TR>\n<TD>Port</TD>\n<TD>Service</TD>");

   if(ident)
      fprintf(output2, "<TD>Owner</TD>\n");

   fprintf(output2, "</TR>\n");

   for(port=low;port<=high;port++) {

      if(type) {

      }
      else
         tcpscan(host, port, timeout, ident, output2);
   }

   fprintf(output2, "</TABLE>\n<BR>\n<HR>\n</BODY>\n</HTML>\n");

   fclose(output2);
}

