/*
 * 
 * ripped from James Drake's piece to scan subnets.. personally used to 
 * audit my own network, but you can go ahead and scan whole inet, if care..
 * 
 * watch out stdout for responded nameservers. if don't care of other junk:
 * run it as (namedscan 192.168.1.0/24 2>/dev/null | tee nameservers
 * 
 * 
 * CyberPsychotic (fygrave@tigerteam.net)
 * Nov 11 08:36:32 KGT 1999
 */
#include <stdio.h>
#include <string.h>

#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>

#define NAMESERVER_PORT 53
#define CONNECTS	20

struct _network {
	unsigned long net;
	unsigned long mask;
	unsigned long node;
	struct _network *next;
	struct _network *prev;
};

typedef struct _network network;
	
network *first=NULL,*current,*prev,*last;



int parse_argz(char **);
unsigned long get_ip(void);
void free_list(void);
int lookup_host(struct sockaddr_in *,char *,unsigned short);
extern void probe_bind(struct sockaddr_in);

int main(int argc,char **argv) {
unsigned long addr;
struct  sockaddr_in ra;

if (argc==1) {
	printf("usage: %s <host>[/mask] [<host>/[mask]] ..\n",argv[0]);
	return -1;
}
	
if(!parse_argz(argv+1)) {
	fprintf(stderr,"no valid arguments were found\n");
	exit(1);
}
	
 current=first;
while((addr=get_ip())!=0) {
	fprintf(stderr,"%s\n",inet_ntoa(addr));
	ra.sin_family= AF_INET;
	ra.sin_port=htons(53);
	ra.sin_addr.s_addr=addr;
	probe_bind(ra);
}

fprintf(stderr,"\n");

}

/*
 * basically we just free linked list here
 */

void free_list(void) {
	
current=last;
 while(current!=NULL) {
	prev=current->prev;
	free(current);
	current=prev;
 }	
}

unsigned long get_ip(void) {

	unsigned long rv=0; 
	/* ip can not be NULL, so we use it both
	 * as error sign and end-of-list-marker */
	if (current==NULL) return 0; /* we reached end of list */
			       
if (current->node) {
	rv=htonl(current->node)|current->net;
	/* if last in this network */
   if (!((htonl(current->node)|current->net) ^ 
		   (current->net|(current->mask^0xffffffff)))) 
	   current=current->next;
   else 
	   current->node++;
} else { /* not a node.. means we had 32 bit network */
	rv=current->net;
	current=current->next;
}
return rv;	
}

/*
 * parses the list of arguments which is 
 * hostname/netmask or ipaddress/netmask
 * 
 * if at least one argument has been correctly parsed returns 1, otherwise 0
 * 
 * !NOTE! last argument should be null!
 */

int parse_argz(char **argz) {

char *net;
char *mask;
struct sockaddr_in ra;
int rv=0;

do {
	net=*argz;
	if((mask=index(*argz,'/'))!=NULL) {
		*mask='\0';
		mask++;
	}
        fprintf(stderr,"Checking: %s",net);
	if (mask) fprintf(stderr,"/%s",mask);
	argz++;
	if (lookup_host(&ra,net, NAMESERVER_PORT)) {
		rv++; /* return value */
		fprintf(stderr," ok\n");
		current=(network *)malloc(sizeof(network));
		bzero(current,sizeof(network));
		if (!first) first=current;
			else prev->next=current;
		current->prev=prev;
		prev=current;
		current->net=ra.sin_addr.s_addr;
	       if(mask) {
		       if (atoi(mask)&&atoi(mask)<33)
			       current->mask
				       =(0xffffffff>>(32-atoi(mask)));
		       else 
			       fprintf(stderr,
				       "Netmask is incorrect. using 32\n");
	       }
	       if (!current->mask) current->mask=0xffffffff;
	       current->net &=current->mask;
	       if(current->mask!=0xffffffff) current->node=1;
	}
			       
			       
  } while(*argz!=NULL);
 last=current;
return rv;
}
int
lookup_host(ra, hn, rp)
   struct sockaddr_in *ra;
   char *hn;
   unsigned short rp;
{
   struct hostent *he;

   ra->sin_family = AF_INET;
   ra->sin_port = htons(rp);
   if ((ra->sin_addr.s_addr = inet_addr(hn)) != -1)
      return 1;
   if ((he = gethostbyname(hn)) != (struct hostent *)NULL)
     {
        memcpy(&ra->sin_addr.s_addr, he->h_addr, 4);
        return 1;
     }
   fprintf(stderr,"\n");
   herror("Unable to resolve hostname");
   return 0;
}


