/************************************************************************\

               CATTscanner 0.6 - Atlanta.CON Release

   by Optyx <optyx@uberhax0r.net>     Uberhax0r Communications (c) 2000

       CATTscanner home page: http://www.uberhax0r.net/cattscanner

 nbtmap.c 03/18/00                                             NBTmapper 
\***********************************************************************/

#include <stdio.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>
#include <setjmp.h>
#include <signal.h>
#include <string.h>
#include <unistd.h>

static void dump_bytes (unsigned char *p, size_t sz, int indent, char file[]);
static void dump_node_status (unsigned char *p, size_t sz, char file[]);

static void sig_alrm(int);
static jmp_buf env_alrm;

#define STATUS_REQ "\xa2\x48\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x20\x43\x4b\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x00\x00\x21\x00\x01"


void nbtscan (char host[], int timeout, char datadir[])
{
    int s;
    struct sockaddr_in s_addr, c_addr;
    char ms[1000];
    int sz;
    struct hostent *h;
    char file[84];
    char file2[84];
    FILE *output;

    strcpy(file2, datadir);
    strcat(file2, "/");
    strcat(file2, host);
    strcat(file2, "/index.html");

    if ((s = socket (AF_INET, SOCK_DGRAM, 0)) < 0) {
        perror ("failed to create socket");
        return;
    }

    bzero ((char *) &s_addr, sizeof (s_addr));
    s_addr.sin_family = AF_INET;
    s_addr.sin_addr.s_addr = htonl (INADDR_ANY);
    s_addr.sin_port = htons (0);

    if (bind (s, (struct sockaddr *) &s_addr, sizeof (s_addr)) < 0) {
        perror ("bind failed");
        return;
    }

    bzero ((char *) &c_addr, sizeof (c_addr));
    c_addr.sin_family = AF_INET;
    h = gethostbyname (host);
    if (h == NULL) {
        perror ("gethostbyname failed");
        return;
    }
    bcopy (h->h_addr, &c_addr.sin_addr, h->h_length);
    c_addr.sin_port = htons (137);

    memcpy (ms, STATUS_REQ, sizeof (STATUS_REQ) -1);
    sz=sizeof (STATUS_REQ)-1;

    if (sendto (s, ms, sz, 1, (struct sockaddr *) &c_addr, sizeof (c_addr)) < 0) {
        perror ("sendto failed");
        return;
    }

    signal (SIGALRM, sig_alrm);
    if (setjmp (env_alrm) != 0) {
        return;
    }

    alarm (timeout);
    sz = recvfrom (s, ms, sizeof (ms), 0, (struct sockaddr *) 0, (int *)0);
    alarm (0);
    if (sz < 0) {
        perror ("recvfrom failed");
        return;
    } else {
        if((output=fopen(file2, "a")) == NULL)
           return;

        fprintf(output, "<A HREF=\"nbtdump.html\">NBT Dump</A><BR>\n");

        fclose(output);

        strcpy(file, datadir);
        strcat(file, "/");
        strcat(file, host);
        strcat(file, "/nbtdump.html");

        if((output=fopen(file, "w")) == NULL)
           return;

        fprintf(output, "<HTML>\n<HEAD>\n<TITLE>NBT Dump of %s", host);
        fprintf(output, "</TITLE>\n</HEAD>\n<BODY>\nNBT Dump of %s", host);
        fprintf(output, "\n<BR>\n<HR>\n");
        
        fclose(output);

        dump_bytes(ms, sz, 0, file);
        dump_node_status(ms, sz, file);

    }

}


int
myisprint (int ch)
{
    return ((ch >= ' ') && (ch <= '~'));
}

static void
dump_bytes (unsigned char *p, size_t sz, int indent, char file[])
{
    int i;
    FILE *out;

    if((out=fopen(file, "a")) == NULL) 
       return;

    fprintf(out, "<HR>\n<BR>\n<TABLE>\n");

    while (sz > 16) {

        fprintf(out, "(nbtmap.c, fixme!) <TR>\n<TD>%i</TD>\n<TD>%s</TD>\n", indent, "");

        for(i=0;i<16;i++) {

           fprintf(out, "<TD>%02X</TD>\n", p[0]);

        }

        for(i=0;i<16;i++) {
           
           fprintf(out, "<TD>%c</TD>\n", myisprint(p[i]) ? p[i] : '.');
        
        }

        fprintf(out, "</TR>\n");

        p+=16;
        sz -= 16;
    }

    fprintf(out, "</TABLE>\n");

    if (sz) {

        char buf[17];
        int i = 0;
        int j = 16 - sz;

        memset (buf, 0, sizeof buf);
        printf ("%*s", indent, "");

        while (sz--) {

            fprintf (out, "%02X ", *p);

            if (myisprint (*p))
                buf[i++] = *p;
            else
                buf[i++] = '.';

            p++;

        }

        fprintf (out, "%*s%s\n", j*3 + 1, "", buf);

    }

   fprintf(out, "<BR>\n");
    
   fclose(out);
}

typedef struct _node_status_resp {
  unsigned short trn_id __attribute__((packed));
  unsigned short flags1 __attribute__((packed));
  unsigned short flags2 __attribute__((packed));
  unsigned short flags3 __attribute__((packed));
  unsigned short flags4 __attribute__((packed));
  unsigned short flags5 __attribute__((packed));
  char rr_name[0x22] __attribute__((packed));
  unsigned short nbstat __attribute__((packed));  /* 0x0021 */
  unsigned short in __attribute__((packed));  /* 0x0001 */
  unsigned long zilch __attribute__((packed)); /* 0 */
  unsigned short rd_length __attribute__((packed));
  unsigned char num_names __attribute__((packed));
  struct {
    unsigned char nb_name[16] __attribute__((packed));
    unsigned short name_flags __attribute__((packed));
  } name_array[1] __attribute__((packed));
} NS_RESP;

#define NF_MASK_UG 128
#define NF_PATT_U  0
#define NF_PATT_G  128

struct _known_suffixes {
    unsigned char suff;
    unsigned short nf_mask;
    unsigned short nf_pattern;
    char *usage;
} Suffixes[] = {
    { 0x00, NF_MASK_UG, NF_PATT_U, "Workstation Service" },
    { 0x00, NF_MASK_UG, NF_PATT_G, "Domain Name" },
    { 0x01, NF_MASK_UG, NF_PATT_U, "Messenger Service" },
    { 0x01, NF_MASK_UG, NF_PATT_G, "Master Browser" },
    { 0x03, NF_MASK_UG, NF_PATT_U, "Messenger Service" },
    { 0x06, NF_MASK_UG, NF_PATT_U, "RAS Server Service" },
    { 0x1b, NF_MASK_UG, NF_PATT_U, "Domain Master Browser" },
    { 0x1c, NF_MASK_UG, NF_PATT_G, "Domain Controller" },
    { 0x1d, NF_MASK_UG, NF_PATT_U, "Master Browser" },
    { 0x1e, NF_MASK_UG, NF_PATT_G, "Potential Master Browser" },
    { 0x1f, NF_MASK_UG, NF_PATT_U, "NetDDE Service" },
    { 0x20, NF_MASK_UG, NF_PATT_U, "File Server Service" },
    { 0x21, NF_MASK_UG, NF_PATT_U, "RAS Client Service" },
    { 0x22, NF_MASK_UG, NF_PATT_U, "MS Exchange Interchange (MSMail)" },
    { 0x23, NF_MASK_UG, NF_PATT_U, "MS Exchange Store" },
    { 0x24, NF_MASK_UG, NF_PATT_U, "MS Exchange Directory" },
    { 0x2b, NF_MASK_UG, NF_PATT_U, "Lotus Notes Server" },
    { 0x2f, NF_MASK_UG, NF_PATT_G, "Lotus Notes" },
    { 0x30, NF_MASK_UG, NF_PATT_U, "Modem Sharing Server" },
    { 0x31, NF_MASK_UG, NF_PATT_U, "Modem Sharing Client" },
    { 0x33, NF_MASK_UG, NF_PATT_G, "Lotus Notes" },
    { 0x43, NF_MASK_UG, NF_PATT_U, "SMS Clients Remote Control" },
    { 0x44, NF_MASK_UG, NF_PATT_U, "SMS Administrators Remote Control Tool" },
    { 0x45, NF_MASK_UG, NF_PATT_U, "SMS Clients Remote Chat" },
    { 0x46, NF_MASK_UG, NF_PATT_U, "SMS Clients Remote Transfer" },
    { 0x4c, NF_MASK_UG, NF_PATT_U, "DEC Pathworks TCPIP service" },
    { 0x52, NF_MASK_UG, NF_PATT_U, "DEC Pathworks TCPIP service" },
    { 0x87, NF_MASK_UG, NF_PATT_U, "MS Exchange MTA" },
    { 0x6a, NF_MASK_UG, NF_PATT_U, "MS Exchange IMC" },
    { 0xbe, NF_MASK_UG, NF_PATT_U, "Network Monitor Agent" },
    { 0xbf, NF_MASK_UG, NF_PATT_U, "Network Monitor Application" },

};

#define NUM_SUFFIX  (sizeof (Suffixes) / sizeof (Suffixes[0]))

static void
dump_node_status (unsigned char *p, size_t sz, char file[])
{
    NS_RESP *r = (NS_RESP *)p;
    int i, j, k;
    FILE *out;

    if((out=fopen(file, "a")) == NULL)
       return;

    if (sz < sizeof (*r)) {

        fprintf (out, "response too small\n");
        return;

    }

    fprintf(out, "<BR>\n%d names in response<BR>\n<TABLE>\n", r->num_names);

    if (sz < (sizeof (*r) + (r->num_names -1) * sizeof (r->name_array[0]))) {

        fprintf (out, "response too small for num_names\n");
        return;
    }

    for (i=0;i<r->num_names;i++) {

        for(k=0;k<15;k++) {
           fprintf(out, "<TD>%c</TD>\n",
              myisprint(r->name_array[i].nb_name[k]) ? r->name_array[i].nb_name[k] : '.');
        }

        fprintf(out, "<TD><CODE><0x%02x></CODE></TD><TD>%s</TD>\n", 
                r->name_array[i].nb_name[15],
                (r->name_array[i].name_flags & 128) ? "Group " : "Unique");

        for (j=0; j< (int)NUM_SUFFIX; j++) {
            if ((r->name_array[i].nb_name[15] == Suffixes[j].suff)
                && ((r->name_array[i].name_flags & Suffixes[j].nf_mask)
                    == Suffixes[j].nf_pattern)) {
                fprintf (out, "<TD>%s</TD>\n</TR>\n", Suffixes[j].usage);
                break;
            }
        }
        fprintf (out, "\n");
    }
 
    fprintf(out, "</TABLE>\n</BODY>\n</HTML>\n");

    fclose(out);

}

static void
sig_alrm (int signo)
{
    longjmp (env_alrm, 1);
}
