#!/usr/bin/perl -w

use IO::Socket;
use Socket;
use Getopt::Long;

$VERSION="0.9.2";

my %stakes;
my $impale;
my $fate;
my $noping;
my $timeout = 10;
my $help;
my $cgi;
my $pwscan;
my $options;

@stakes{"dnsver.pl","bannereater","netfs.pl"} = ();

sub usage {
    printf "Usage: ./vlad.pl [options] hostname\n";
    printf "options are -n           (no ping before scanning host)\n";
    printf "            -t timeout   (timeout (in secs) for connections,\n";
    printf "                          defaults to 10)\n";
    printf "            -c           (no cgi/RDS scan)\n";
    printf "            -p           (no password/snmp scan)\n";
    printf "            -h           (help)\n";
    exit (0);
}

sub tcp_port_open {
    my ($host, $port) = @_;
    my $socket;
    my $rc;

    socket (TCP_SOCK, PF_INET, SOCK_STREAM, getprotobyname("tcp"));

    my $addr = inet_aton($host);
    my $paddr = sockaddr_in($port,$addr);

    eval {
        local $SIG{ALRM} = sub { die "alarm\n" };
        alarm $timeout;
        if (!connect (TCP_SOCK, $paddr)) {
            $rc = 0;
        } else {
            $rc = 1;
        }
        alarm 0;
    };
    if ($@) {
        # timed out
        $rc = 0;
    }

    close (TCP_SOCK);
    return $rc;
}

sub udp_port_open {
    my ($host, $port) = @_;
    my $rc;

    socket (UDP_SOCK, PF_INET, SOCK_DGRAM, getprotobyname("udp"));
    my $ipaddr = inet_aton ($host);
    my $addr = sockaddr_in ($port, $ipaddr);
    send (UDP_SOCK, "hackershield", 0, $addr) or return 0;
    my $resp;
    eval {
        local $SIG{ALRM} = sub { die "alarm\n" };
        alarm $timeout;
        $addr = recv (UDP_SOCK, $resp, 500, 0);
        alarm 0;
    };
    if ($@) {
        $rc = 1;
    } else {
        $rc = 0;
    }
    close (UDP_SOCK);
    return $rc;
}

sub build_pwscan_options {
    my ($host) = @_;

    if (tcp_port_open ($host, 21)) { $options = $options . " -F"; }
    if (tcp_port_open ($host, 22)) { $options = $options . " -S"; }
    if (tcp_port_open ($host, 23)) { $options = $options . " -T"; }
    if (tcp_port_open ($host, 110)) { $options = $options . " -P"; }
    if (tcp_port_open ($host, 139)) { $options = $options . " -B"; }
    if (tcp_port_open ($host, 143)) { $options = $options . " -I"; }
    if (udp_port_open ($host, 161)) { $options = $options . " -M"; }
    if (tcp_port_open ($host, 513)) { $options = $options . " -R"; }
}

#
# main
#
print "VLAD the Scanner v" . $VERSION . "\n";
print "RAZOR Security Team -- (c) Bindview Corporation\n";
print "http://razor.bindview.com/tools/vlad/\n\n";
print "SANS Top Ten security scanner\n";
print "See http://www.sans.org/topten.htm for top ten details\n";
print "See also Docs/index.html for more info\n\n";

GetOptions ("t=i" => \$timeout,
            "n" => \$noping,
            "h" => \$help,
            "c" => \$cgi,
            "p" => \$pwscan
            );

if ($help) { usage (); }

$options=" -s -t " . $timeout;

my $victim = shift or usage();

my $ping=`ping -c 1 $victim 2> /dev/null` unless $noping;

($ping =~ /icmp_seq/) or die "Unable to ping $victim, target down or unreachable\nvia ICMP Echo. Use -n to suppress ping test if needed.\n\n";

foreach $stake (keys %stakes)
{
  $impale="./" . $stake . $options . " " . $victim;
  $fate=`$impale`;
  print $fate;
}

if (tcp_port_open ($victim, 111))
{
  $impale="./rpcscan" . $options . " " . $victim;
  $fate=`$impale`;
  print $fate;
}

if (!$cgi)
{
  if (tcp_port_open ($victim, 80))
  {
    $impale="./cgi.pl" . $options . " " . $victim;
    $fate=`$impale`;
    print $fate;
  }
}
if (!$pwscan)
{
  build_pwscan_options($victim);
  $impale="./pwscan.pl -p" . $options . " " . $victim;
  $fate=`$impale`;
  print $fate;
}


# $Id: vlad.pl,v 1.4 2001/07/17 18:21:04 ccoffin Exp $
# $Log: vlad.pl,v $
# Revision 1.4  2001/07/17 18:21:04  ccoffin
# updated vlad version to 0.9.2 and removed NCSA Web Server (old software) entry from cgi.db
#
# Revision 1.3  2001/06/28 22:31:17  loveless
# Removed the sendmail stuff, and added bannereater support (which now does
# sendmail stuff). Completely reworked rpc and it is now rpcscan, and decided
# to validate ports are open before scanning on a couple things. Switched
# version to 0.9 for now, still need to clean up cosmetically.
#
# Revision 1.2  2001/01/04 22:16:50  loveless
# Updated version number
#
# Revision 1.1  2000/11/06 15:32:06  loveless
# Moved to sectools section of CVS
#
# Revision 1.14  2000/10/19 14:44:26  loveless
# Updated version number
#
# Revision 1.12  2000/08/03 21:03:29  loveless
# Added Max Vision <vision@whitehats.com> patch to get SNMP working properly.
#
# Revision 1.11  2000/07/21 22:10:30  loveless
# More cleanup, added proper references to Docs files
#
# Revision 1.10  2000/07/20 19:21:06  loveless
# Added reference to Docs directory
#
# Revision 1.9  2000/07/13 21:33:52  loveless
# Removed some debugging code.
#
# Revision 1.8  2000/07/13 21:21:10  loveless
# Added pre-scan for pwscan.pl.
#
# Revision 1.7  2000/07/12 15:35:14  loveless
# Removed some debugging code.
#
# Revision 1.6  2000/07/12 15:18:35  loveless
# Added -c and -p switches
#
# Revision 1.4  2000/06/29 13:58:34  loveless
# Fixed a couple of typos in print statements.
#
# Revision 1.1  2000/06/28 19:22:24  loveless
# Initial rev
#
