#
# This script was written by Renaud Deraison <deraison@cvs.nessus.org>
#
#
# See the Nessus Scripts License for details
#

if(description)
{
 script_id(10807);
 name["english"] = "Jakarta Tomcat Path Disclosure";

 script_name(english:name["english"]);
 
 desc["english"] = "
Tomcat will reveal the physical path of the 
webroot when asked for a .jsp file using a specially
crafted request.

An attacker may use this flaw to gain further knowledge
about the remote filesystem layout.

Solution : None at this time.
Risk factor : Low";

 script_description(english:desc["english"]);
 
 summary["english"] = "Tests for Tomcat Path Disclosure Vulnerability";
 
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2001 Renaud Deraison",
		francais:"Ce script est Copyright (C) 2001 Renaud Deraison");
 family["english"] = "CGI abuses";
 family["francais"] = "Abus de CGI";
 script_family(english:family["english"], francais:family["francais"]);
 script_dependencie("find_service.nes", "no404.nasl");
 script_require_ports("Services/www", 80);
 exit(0);
}


port = get_kb_item("Services/www");
if(!port)port = 8080;
if(get_port_state(port))
{ 
 req = http_get(item:string("/:/x.jsp"), port:port);
 soc = open_sock_tcp(port);
 if(soc)
 {
 send(socket:soc, data:req);
 r = recv(socket:soc, length:4096);
 close(soc);
 if("Tomcat" >< r)
 {
 path = ereg_replace(pattern:".*HTTP Status 404 - ([^<]*) .The.*",
		    string:r,
		    replace:"\1");
 if(ereg(string:path, pattern:"[A-Z]:\\.*"))security_warning(port);
 }
 }
}
