#!/usr/bin/perl

use Getopt::Long;
use Net::DNS::Resolver;

my $timeout = 10;
my $verbosity = 0;
my $version = "1.0.1";
my $quiet = 0;
my $help = 0;
my $found = 0;
my $sansmode = 0;

sub usage {
    printf "Usage: $0 [options] hostname\n";
    printf "options are -v           (verbose\n";
    printf "            -t timeout   (timeout (in secs) for connections, defaults to 10)\n";
    printf "            -h           (help)\n";
    printf "            -q           (quiet, suppress version info)\n";
    exit (0);
}


GetOptions ("v+" => \$verbosity,
            "t=i" => \$timeout,
            "q" => \$quiet,
            "s" => \$sansmode,
            "h" => \$help
           );

if ($help) { usage (); }

if ($sansmode) { $quiet = 1; $verbosity = 0; }

my $host = shift or usage ();

print "\nRAZOR BIND Scanner  v", $version,
      "\nBy Robert Keyes  (c) BindView Corporation",
      "\nhttp://razor.bindview.com/tools/vlad/",
      "\nRequires Net::DNS module from \nhttp://cpan.valueclick.com/",
      "authors/id/M/MF/MFUHR/Net-DNS-0.12.tar.gz\n\n",
      "Checking $host\n" unless $sansmode;
print "#1 - BIND weaknesses in nxt, qinv, in.named\n" unless !($sansmode);

$res = new Net::DNS::Resolver;
$res->retry(2);
$res->nameservers("$host");
eval {
  local $SIG{ALRM} = sub { die "alarm\n" };
  alarm $timeout;
  $pack_req=$res->send("version.bind.", "TXT", "CH");
  unless(defined($pack_req)) {
    print "No DNS server found\n\n" unless ($sansmode);
    print "\n  No DNS server found, no problems related to #1\n\n" unless !($sansmode);
    exit;
  }
  alarm 0;
};

if ($pack_req->header->rcode eq "NOERROR")
{
  foreach $rr ($pack_req->answer) 
  {
    next unless $rr->type eq "TXT";
    if ($verbosity)  {
      print "Server Response: ",$pack_req->header->rcode,"\n";
      print "DNS Server Version: BIND ",$rr->txtdata,"\n";
    }
    if(index($rr->txtdata,"4.9.") != -1) {$iquery=1;}
    if(index($rr->txtdata,"4.9.7-REL") != -1) {$iquery=0;}
    if(index($rr->txtdata,"8.0") != -1) {$iquery=1;}
    if(index($rr->txtdata,"8.1") != -1) {$iquery=1;}
    if(index($rr->txtdata,"8.1.2") != -1) {$iquery=0;}		
    if(index($rr->txtdata,"8.1.2-T") != -1) {$iquery=1;}
    if(index($rr->txtdata,"8.2") != -1) {$iquery=0;$nxt=1;}
    if(index($rr->txtdata,"8.2.2") != -1) {$nxt=0;}
    if(index($rr->txtdata,"8.2.3") != -1) {$nxt=0;}
    if(index($rr->txtdata,"9.0") != -1) {$iquery=0;}

    if($iquery == 1) {
      print "\nHigh Severity Vulnerability: IQUERY, ",
            "(remote root, CVE-1999-0009)\n";
      $found = 1;
    }
    if($nxt == 1) {
      print "\nHigh Severity Vulnerablility: NXT, ",
            "(remote root, CVE-1999-0833)\n";
      $found = 1;
    }
    unless((defined($nxt)) or (defined($iquery))) 
      {print"Unable to parse version banner. This could be a",
            "non-BIND DNS server, a very old version of BIND",
            ", or a customized BIND\n";}
  }			
}

if ($pack_req->header->rcode eq "NOTIMP" and defined($opt_v)) 
{
  print "DNS Server Version: Microsoft\n";
}

if ($sansmode)
{
  print "\n  Possible vulnerable DNS server. Check Docs/BIND.html\n\n" unless !($found);
  print "\n  No problems related to #1\n\n" unless ($found);
}
# $Id: dnsver.pl,v 1.1 2000/11/06 15:32:05 loveless Exp $
# $Log: dnsver.pl,v $
# Revision 1.1  2000/11/06 15:32:05  loveless
# Moved to sectools section of CVS
#
# Revision 1.6  2000/07/24 17:47:42  loveless
# Fixed a typo.
#
# Revision 1.5  2000/07/24 17:14:43  loveless
# Updated Docs references to reflect changes to filenames
#
# Revision 1.4  2000/07/20 19:50:00  loveless
# Minor cleanup of output
#
# Revision 1.3  2000/07/20 19:16:17  loveless
# Fixed reference to Docs dir
#
# Revision 1.2  2000/06/29 13:14:46  loveless
# Edited and moved things around to match perl "style" of other scripts.
#
# Revision 1.1  2000/06/28 19:20:50  loveless
# Initial rev
#

