/************************************************************************\

               CATTscanner 0.6 - Atlanta.CON Release

   by Optyx <optyx@uberhax0r.net>     Uberhax0r Communications (c) 2000

       CATTscanner home page: http://www.uberhax0r.net/cattscanner

 rpcmap.c 03/18/00                                             RPCmapper 
\***********************************************************************/

#include <stdio.h>
#include <unistd.h>
#include <netdb.h>
#include <sys/socket.h>
#include <sys/types.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <rpc/rpc.h>
#include <rpc/xdr.h>
#include <rpc/pmap_prot.h>
#include <rpc/pmap_clnt.h>
#include <errno.h>


void rpcscan(char host[], int timeout, char datadir[]) {

   struct sockaddr_in server_addr;
/*   register struct hostent *hp;*/
   struct pmaplist *head = NULL;
   int socket = RPC_ANYSOCK;
   struct timeval minutetimeout;
   register CLIENT *client;
   struct rpcent *rpc; 
   char filename[72];
   char input[72];

   FILE *output, *output2;

   minutetimeout.tv_sec = timeout;
   minutetimeout.tv_usec = 0;
   server_addr.sin_addr.s_addr = inet_addr(host);
   server_addr.sin_family = AF_INET;
   server_addr.sin_port = htons(111);

   strcpy(filename, datadir);
   strcat(filename, "/"); 
   strcat(filename, host);
   strcat(filename, "/rpcmap.html");
   if((output=fopen(filename, "w")) == NULL) {
      return;
   }

   fprintf(output, "<HTML>\n<HEAD><TITLE>RPC map of %s</HEAD></TITLE>\n", host);
   fprintf(output, "<BODY>\n<H2>RPC map of %s</H2>\n<BR>\n", host);
   fprintf(output, "<HR>\n<BR>\n");

   if ((client = clnttcp_create(&server_addr, PMAPPROG,
      PMAPVERS, &socket, 50, 500)) == NULL) {
         fprintf(output, "rpcinfo: can't contact portmapper");
         fprintf(output, "<BR>\n</BODY></HTML>\n");
         fclose(output);
         return;
   }

   if (clnt_call(client, PMAPPROC_DUMP, xdr_void, NULL,
      xdr_pmaplist, &head, minutetimeout) != RPC_SUCCESS) {
         fprintf(output, "rpcinfo: can't contact portmapper ");
         fprintf(output, "<BR>\n</BODY></HTML>\n");
         fclose(output);
         return; 
   }

   strcpy(input, datadir);
   strcat(input, "/");
   strcat(input, host);
   strcat(input, "/index.html");

   if((output2=fopen(input, "a")) == NULL)
      return;
   
   fprintf(output2, "<A HREF=\"rpcmap.html\">RPC Services</A><BR>\n");

   fclose(output2);

   fprintf(output, "<TABLE>\n");

   if (head == NULL) {
      fprintf(output, "<TR><TD>No remote programs registered.</TD></TR>\n");
   } 
   else 
   {
      fprintf(output, "<TR>\n<TD>program</TD>\n");
      fprintf(output, "<TD>vers</TD>\n<TD>proto</TD>\n<TD>port</TD>\n");
      fprintf(output, "<TD>servicename</TD>\n</TR>\n");
      for (; head != NULL; head = head->pml_next) {
          fprintf(output, "<TR>\n<TD>%10ld</TD>\n<TD>%5ld</TD>\n",
             head->pml_map.pm_prog,
             head->pml_map.pm_vers);
          if (head->pml_map.pm_prot == IPPROTO_UDP)
             fprintf(output, "<TD>%6s</TD>",  "udp");
          else if (head->pml_map.pm_prot == IPPROTO_TCP)
             fprintf(output, "<TD>%6s</TD>", "tcp");
          else
             fprintf(output, "<TD>%6ld</TD>",  head->pml_map.pm_prot);
          fprintf(output, "<TD>%7ld</TD>",  head->pml_map.pm_port);
          rpc = getrpcbynumber(head->pml_map.pm_prog);
          if (rpc)
             fprintf(output, "<TD>%s</TD>\n</TR>\n", rpc->r_name);
          else
             fprintf(output, "<TD></TD>\n</TR>\n");
      }
   }
   fprintf(output, "</TABLE>\n<BR>\n<HR>\n</BODY></HTML>\n");
   fclose(output);
}      

