/*
 * Security Scanner - Scan CGI Thread
 *
 * Copyright 2001 Matteo Baccan <mbaccan@planetisa.com>
 * www - http://www.infomedia.it/artic/Baccan
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA (or visit
 * their web site at http://www.gnu.org/).
 *
 */

import java.net.*;
import java.io.*;
import java.sql.*;
import java.util.*;

public class urlThread extends Thread {

   private urlchk oParent;
   public urlThread( urlchk oParent ){
      this.oParent = oParent;
   }

   public void run(){
      try{
         while( true ){
            String cURL = oParent.getURL();
            if( cURL==null )
               break;
            String cInfo = oParent.getInfo( cURL );
            chkResult oRet = oParent.chkURL( cURL, cInfo );

            if( oRet!=null ){
               String cNewUrl = "";

               // Try to change /cgi/ to /cgi-bin/
               cNewUrl = replace( cURL, "/cgi-bin/", "/cgi/" );
               checkNew( cNewUrl, cURL, cInfo, oRet );

               // Try to change /cgi-bin/ to /cgi/
               cNewUrl = replace( cURL, "/cgi/", "/cgi-bin/" );
               checkNew( cNewUrl, cURL, cInfo, oRet );


               // Try to change / to %25%35%63
               cNewUrl = replace( cURL, "/", "%25%35%63" );
               checkNew( cNewUrl, cURL, cInfo, oRet );

               // Try to change / to %c0%af
               cNewUrl = replace( cURL, "/", "%c0%af" );
               checkNew( cNewUrl, cURL, cInfo, oRet );

               // Try to change / to %5C
               cNewUrl = replace( cURL, "/", "%5C" );
               checkNew( cNewUrl, cURL, cInfo, oRet );


               oParent.addToLog( oRet );
            }

         }
      } catch ( Throwable e ){ }
   }

   private void checkNew( String cNewUrl,
                          String cURL,
                          String cInfo,
                          chkResult oRet ){
      if( !cNewUrl.equalsIgnoreCase( cURL ) ){
         oRet.oVariant.addElement( oParent.chkURL( cNewUrl, cInfo ) );
      }
   }

   private String replace(String cStr, String bug, String toRepl) {

      StringBuffer cOffSet = new StringBuffer();
      long LenDif    = cStr.length()-bug.length();
      long LenTot    = cStr.length();
      long BugLenDif = bug.length()-1;

      for( int x=0; x<LenTot; x++ ) {

         if( x<=LenDif ) {
            if(cStr.startsWith(bug,x)) {
               cOffSet.append( toRepl );
               x += BugLenDif;
            } else {
               cOffSet.append( cStr.charAt(x) );
            }
         } else {
            cOffSet.append( cStr.charAt(x) );
         }

      }

      return cOffSet.toString();
   }

}
