/************************************************************************\

               CATTscanner 0.61 - Atlanta.CON Release 

   by Optyx <optyx@uberhax0r.net>     Uberhax0r Communications (c) 2000 

       CATTscanner home page: http://www.uberhax0r.net/cattscanner

 cattscan.c 03/18/00                                    CATTscanner Core
\***********************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <errno.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <fcntl.h>
#include <unistd.h>

#define VERSION "CATTscanner 0.61 Atlanta.CON Release"

char exhosts[65025][15];
char hosts[65025][15];
char datadir[48]="results";
int hostcount;
int revdns=0;
int startport=0,endport=0;
int rpcmap=0,nfsmap=0,nbtmap=0;
int smtpver=0,ftpver=0,popver=0,imapver=0;
int udp=0,tcp=0,ident=0,timeout=10;
int threads=0;                   

void revdnslookup(char hostname[], char datadir[]);
void portscan(char host[], int low, int high, int type, int timeout, int ident, char datadir[]);
void rpcscan(char host[], int timeout, char datadir[]);
int nfsscan(char hostname[], int timeout, char datadir[]);
void verbyport(char host[], int port, int timeout, char datadir[]);
void nbtscan (char host[], int timeout, char datadir[]);
int	mkpath (char *path, mode_t mode, mode_t dir_mode);

void nbtmapper(void) {

   int i=0;

   while(strcmp(hosts[i], "")) {

      nbtscan(hosts[i], timeout, datadir);
      i++;

   }

}

void sethosts(char value[], int funct) {

   char *ip[4];
   int i, j, k, l;
   int blank=0;
   ip[0]=strtok(value, ".");

   for(i=1;i<4;i++) { 

      if(*(ip[i]=strtok(NULL, "."))=='\0') {

         printf("     Invalid ip value\n");
         return;

      }

   }

   if(funct) {

      while(strcmp(exhosts[blank], "")) {

         blank++;

      }

   }
   else {

      while(strcmp(hosts[blank], "")) {

         blank++;

      }

   }

   for(i=1;i<255;i++) {

      if(strcmp(ip[0],"*"))
         i=atoi(ip[0]);

      for(j=0;j<255;j++) {

         if(strcmp(ip[1],"*"))
            j=atoi(ip[1]);

         for(k=0;k<255;k++) {

            if(strcmp(ip[2],"*"))
               k=atoi(ip[2]);

            for(l=1;l<255;l++) {

               if(strcmp(ip[3], "*"))
                  l=atoi(ip[3]);

               if(funct) 
                  sprintf(exhosts[blank], "%i.%i.%i.%i", i, j, k, l);
               else
                  sprintf(hosts[blank], "%i.%i.%i.%i", i, j, k, l);
               blank++;

               if(strcmp(ip[3], "*"))
                  l=255;
            }

            if(strcmp(ip[2],"*"))
               k=255; 
         }

         if(strcmp(ip[1],"*"))
            j=255;
      }

      if(strcmp(ip[0],"*"))
         i=255;
   } 
} 

void excluderm(void) {

   int i, j, k;

   i=0;

   while(strcmp(hosts[i], "")) {

      j=0;

      while(strcmp(exhosts[j], "")) {

         if(!strcmp(hosts[i], exhosts[j])) {

            k=0;

            while(strcmp(hosts[i+k], "")) {

               strcpy(hosts[i+k], hosts[i+k+1]);
               k++;

            }

            i--;

         }

         j++;

      }

      i++;

   }

}   

int mv_file(char file[], char dir[]) {

   FILE *in, *out;
   char outname[80];

   if((in=fopen(file, "r")) == NULL) {

      fprintf(stderr, "error in opening %s\n", file);
      return 0;

   }

   strcpy(outname, dir);
   strcat(outname, file);

   if((out=fopen(outname, "w")) == NULL) {

      fprintf(stderr, "error in opening %s\n", outname);
      return 0;

   }

   while(!feof(in)) {

      fputc(fgetc(in), out);

   }

   fclose(in);
   fclose(out);

   unlink(file);

   return 1; 
}  

void usage(char *path) {

   printf("\nUsage: %s [-h] [-c <configfile>]\n\n",path);

}

void spawner(int threadnum) {
   
   while(strcmp(hosts[threadnum], "")) {

      if(revdns)
         revdnslookup(hosts[threadnum], datadir);

      if(tcp)
         portscan(hosts[threadnum],startport,endport,0,timeout,ident,datadir);

      if(rpcmap)
         rpcscan(hosts[threadnum], timeout, datadir);

      if(nfsmap)
         nfsscan(hosts[threadnum], timeout, datadir);

      if(ftpver)
         verbyport(hosts[threadnum], 21, timeout, datadir);

      if(smtpver)
         verbyport(hosts[threadnum], 25, timeout, datadir);
 
      if(popver)
         verbyport(hosts[threadnum], 110, timeout, datadir);

      if(imapver)
         verbyport(hosts[threadnum], 143, timeout, datadir);

      threadnum+=threads;
   }

   return;
}

void threader(void) {
   int i, childpid;

   if(threads<1)
   threads=1;

   for(i=1;i<threads;i++) {

      if((childpid = fork()) < 0 )
         return;
      else if(childpid==0) { 
         spawner(i);        
         _exit(3);
      }
   }

   spawner(0);

   return; 
}

int main(int argc, char *argv[])
{

   int i, j, k;
   char conffile[64]="cattscan.conf";
   char compare[16], value[16], input[64];

   FILE *output, *output2, *conf;
   
   printf("\nCATTscanner	0.61	by Optyx	<optyx@uberhax0r.net>");
   printf("\n(c) 2000 Uberhax0r Communications  -  http://www.uberhax0r.net\n");

   for(i=0;i<argc;i++) {

      if(argv[i][0]=='-') {

         switch (argv[i][1]) {

           case 'h':
                   usage(argv[0]);
                   exit(1);
 
           case 'c':
                   strncpy(conffile, argv[i+1], 64); 
                   i++;  
                   break;

           default :
                   break;

         } 

      } 

   } 

   if((conf=fopen(conffile, "r")) == NULL) {

      fprintf(stderr, "error in opening configuration file: %s\n", conffile);
      exit(-1);

   }
  
   if((output=fopen("output.html", "w")) == NULL) {

      fprintf(stderr, "error in opening output.html for program output\n");
      exit(-1);

   } 
   
   fprintf(output, "<HTML><HEAD><TITLE>Output of running %s", argv[0]);
   fprintf(output, " with config file %s</TITLE></HEAD>\n<BODY>\n", conffile);
   fprintf(output, "<H2>Output of running %s with config file", argv[0]);
   fprintf(output, " %s</H2><BR>\n", conffile);

   printf("\nProcessing the configuration file");

   fgets(input, 64, conf);
   j=1; 

   while(!feof(conf)) {

      fprintf(output, "%s:%d: %s<BR>\n", conffile, j, input);
      i=0;

      while(input[i]!='=') {

         compare[i]=input[i];
         i++;

      }

      compare[i]='\0';
      i++;
      k=0; 
 
      while(input[i]!='\0') {

         value[k]=input[i];
         k++;
         i++;

      }

      value[k-1]='\0';

      if(!strcasecmp(compare, "outdir")) {

          fprintf(output, "&#183 %s set output directory to %s\n<BR>\n", compare, value);
          strncpy(datadir, value, 16);

      }
 
      if(!strcasecmp(compare, "revdns")) {

          if(atoi(value)) {

             fprintf(output, "&#183 reverse DNS lookups enabled\n<BR>\n");
             revdns=1;

          }
          else {

             fprintf(output, "&#183 reverse DNS lookups disabled\n<BR>\n");
             revdns=0;

          }

      }

      if(!strcasecmp(compare, "startport")) {

          fprintf(output, "&#183 %s set to value %s\n<BR>\n", compare, value);
          startport=atoi(value);         

      }

      if(!strcasecmp(compare, "endport")) {

          fprintf(output, "&#183 %s set to value %s\n<BR>\n", compare, value);
          endport=atoi(value);

      }

      if(!strcasecmp(compare, "rpcmap")) {

          if(atoi(value)) {

             fprintf(output, "&#183 RPC mapping turned on\n<BR>\n");
             rpcmap=1;

          }
          else {

             fprintf(output, "&#183 RPC mapping turned off\n<BR>\n");
             rpcmap=0;

          }

      }
      
      if(!strcasecmp(compare, "nfsmap")) {

          if(atoi(value)) {

             fprintf(output, "&#183 NFS mapping turned on\n<BR>\n");
             nfsmap=1;

          }
          else {

             fprintf(output, "&#183 NFS mapping turned off\n<BR>\n");
             nfsmap=0;

          }

      }

      if(!strcasecmp(compare, "nbtmap")) {

          if(atoi(value)) {

             fprintf(output, "&#183 NBT mapping turned on\n<BR>\n");
             nbtmap=1;

          }
          else {

             fprintf(output, "&#183 NBT mapping turned off\n<BR>\n");
             nbtmap=0;

          }

      }

      if(!strcasecmp(compare, "smtpver")) {

          if(atoi(value)) {

             fprintf(output, "&#183 SMTP version query turned on\n<BR>");
             smtpver=1;

          }
          else {

             fprintf(output, "&#183 SMTP version query turned off\n<BR>");
             smtpver=0;

          }

      }

      if(!strcasecmp(compare, "ftpver")) {
 
          if(atoi(value)) {
      
             fprintf(output, "&#183 FTP version query turned on\n<BR>");
             ftpver=1;                                                  
 
          }            
          else {
 
             fprintf(output, "&#183 FTP version query turned off\n<BR>");
             ftpver=0;                                                   
 
          }            
 
      }    

      if(!strcasecmp(compare, "imapver")) {
 
          if(atoi(value)) {
      
             fprintf(output, "&#183 IMAP version query turned on\n<BR>");
             imapver=1;                                                  
 
          }            
          else {
 
             fprintf(output, "&#183 IMAP version query turned off\n<BR>");
             imapver=0;                                                   
 
          }            
 
      }    

      if(!strcasecmp(compare, "popver")) {
 
          if(atoi(value)) {
      
             fprintf(output, "&#183 POP3 version query turned on\n<BR>");
             popver=1;                                                  
 
          }            
          else {
 
             fprintf(output, "&#183 POP3 version query turned off\n<BR>");
             popver=0;                                                   
 
          }            
 
      }    

      if(!strcasecmp(compare, "host")) {

          fprintf(output,"&#183 Adding host(s) %s to scan list\n<BR>\n", value);
          sethosts(value, 0);

      }
      
      if(!strcasecmp(compare, "exhost")) {

          fprintf(output, "&#183 Adding host(s) %s to the", value );
          fprintf(output, " exclude list\n<BR>\n");
          sethosts(value, 1);

      }

      if(!strcasecmp(compare, "threads")) {

          fprintf(output,"&#183 Setting number of threads to %s\n<BR>\n",value);

          if(!strcasecmp(value, "max"))
            threads=-1;
          else
             threads=atoi(value);

      }
      
      if(!strcasecmp(compare, "scantype")) {

          if(!strcasecmp(value, "udp")) {

             fprintf(output, "&#183 Portscanning using UDP activated\n<BR>\n");
             udp=1;      

          }
          else {

             fprintf(output, "&#183 Portscanning using TCP activated\n<BR>\n");
             tcp=1;

          }

      }

      if(!strcasecmp(compare, "ident")) {

          if(atoi(value)) {
  
             fprintf(output, "&#183 Portscanning with ident turned on\n<BR>\n");
             ident=1;

          }
          else
          {

             fprintf(output, "&#183 Portscanning with ident turned off<BR>\n");
             ident=0;
 
          }
      }
 
      if(!strcasecmp(compare, "timeout")) {

          fprintf(output, "&#183 Setting timeout value in");
          fprintf(output, " seconds to %s\n<BR>\n", value);
          timeout=atoi(value);

      }

      j++;
      fgets(input, 64, conf);

   }

   fprintf(output, "<BR>\nEnd of output\n</BODY></HTML>\n");

   fclose(conf);
   fclose(output);

   printf(" - OK\n");
   printf("Removing exclude hosts");

   excluderm();

   printf(" - OK\n");
   printf("Making output directories");

   if(mkpath(datadir, 0777, 0777) == -1) {

      fprintf(stderr, "error creating directory %s", datadir);
      exit(-1);

   }

   strcpy(input, datadir);
   strcat(input, "/index.html");

   if((output=fopen(input, "w"))==NULL) {

      fprintf(stderr, "error in opening %s for output\n", input);
      exit(1);

   }
   
   fprintf(output, "<HTML>\n<HEAD><TITLE>- CATTscanner - ");
   fprintf(output, " (%s) </TITLE></HEAD>\n", VERSION);
   fprintf(output, "<BODY><H2>CATTscanner</H2><BR>\n");
   fprintf(output, "Configurable Autonomous Threaded Topography scanner<BR>\n");
   fprintf(output, "&#183 by Optyx - "); 
   fprintf(output, "<A HREF=\"mailto:optyx@uberhax0r.net\">");
   fprintf(output, "optyx@uberhax0r.net</A><BR>\n");
   fprintf(output, "<A HREF=\"http://www.uberhax0r.net/cattscanner\">Offical");
   fprintf(output, " CATTscanner Homepage</A><BR>\n");
   fprintf(output, "<A HREF=\"output.html\">Ouput</A> From CATTscanner");
   fprintf(output, " Configuration File Parsing\n<BR>\n");
   fprintf(output, "\n<HR>\n<BR>\n<H2>Hosts:</H2><BR><BR>\n");
          
   hostcount=0;

   while(strcmp(hosts[hostcount], "")) {

      strcpy(input, datadir);
      strcat(input, "/"); 
      strcat(input, hosts[hostcount]);

      mkdir(input, 0777);
/*      mkpath(input, 0777, 0777);*/

      fprintf(output, "&#183 <A HREF=\"%s/index.html\">%s</A><BR>\n", 
              hosts[hostcount], hosts[hostcount]);

      strcat(input, "/index.html");

      if((output2=fopen(input, "w"))==NULL) {

         fprintf(stderr, "error in opening %s for output\n", input);

      }
      else {

         fprintf(output2, "<HTML>\n<HEAD><TITLE>Info for %s", hosts[hostcount]);
         fprintf(output2, "</TITLE></HEAD>\n<BODY><H2>Info for ");
         fprintf(output2, "%s</H2>\n<BR>\n<HR>\n<BR>\n", hosts[hostcount]);
         fprintf(output2, "<CENTER><A HREF=\"../%s", hosts[hostcount-1]);
         fprintf(output2, "/index.html\">Back</A> - <A HREF=\"");
         fprintf(output2, "../index.html\">Main</A> - <A HREF=\"../");
         fprintf(output2, "%s/index.html\">Forward</A>", hosts[hostcount+1]);
         fprintf(output2, "</CENTER>\n<BR>\n<HR>\n<BR>Host Information:\n");
         fprintf(output2, "<BR><BR>\n");

         fclose(output2);

      }

      hostcount++;

   }
  
   fprintf(output, "<HR><BR>\nEnd of File</BODY></HTML>\n");

   fclose(output);

   printf(" - OK\n");

   if(threads==-1)
      threads=hostcount;

   if(mv_file("output.html", datadir) == 0)
     printf("please move ./output.html to %s/output.html manually\n", datadir);

   threader();
   nbtmapper();
 
   i=0;

   printf("Closing host's index.html files");

   while(strcmp(hosts[i], "")) {

      strcpy(input, datadir);
      if (input[strlen(input)-1] != '/')
	  	strcat(input, "/");
      strcat(input, hosts[i]);
      strcat(input, "/index.html");
      
      if((output2=fopen(input, "a")) == NULL)
         fprintf(stderr, "error opening %s (%s)", input,strerror(errno));
      else {
         
         fprintf(output2, "<BR><BR><HR><BR>Output Generated By: %s", VERSION);
         fprintf(output2, "</BODY></HTML>\n");
	     fclose(output2);

      }
      

      i++;
   }

   printf(" - OK\n");
   printf("Execution of %s - DONE\n", argv[0]); 

   return 0;
} 
