/*
 * Security Scanner
 *
 * Copyright 2001 Matteo Baccan <mbaccan@planetisa.com>
 * www - http://www.infomedia.it/artic/Baccan
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA (or visit
 * their web site at http://www.gnu.org/).
 *
 */

import java.net.*;
import java.io.*;
import java.sql.*;
import java.util.*;

public class urlchk {

   /* Public interface ******************************************************/
   static public void main( String argv[] ) {

      urlchk hack = new urlchk();

      System.out.println( "+---------------------------------------------------------------------------+" );
      System.out.println( "| Security Scanner                                 Version " +urlchk.getVersion() +"  14-07-2001 |" );
      System.out.println( "| (C) 2001 by Matteo Baccan            http://www.infomedia.it/artic/Baccan |" );
      System.out.println( "+---------------------------------------------------------------------------+" );
      System.out.println( "urlchk [options]" );
      System.out.println( "" );
      System.out.println( "options" );
      System.out.println( "" );
      System.out.println( "-ip <ip address>" );
      System.out.println( "-port <port>      DEFAULT " +hack.getPort()     );
      System.out.println( "-urlfile <file>   DEFAULT " +hack.getFile()     );
      System.out.println( "-verbose          DEFAULT " +hack.getVerbose()  );
      System.out.println( "-thread <number>  DEFAULT " +hack.getThread()   );
      System.out.println( "-timeout <number> DEFAULT " +hack.getTimeout()  );
      System.out.println( "-filteroff        DEFAULT " +!hack.getFilter()  );

      // Proxy setting
      System.out.println( "" );
      System.out.println( "Proxy setting" );
      System.out.println( "" );
      System.out.println( "-proxy <name>" );
      System.out.println( "-proxyport <port>" );
      System.out.println( "-proxyuser <user>" );
      System.out.println( "-proxypwd <password>" );

      // Anoniyzer
      System.out.println( "" );
      System.out.println( "Anonymizer setting" );
      System.out.println( "" );
      System.out.println( "-anonserver <server> DEFAULT " +hack.getAnonServer()  );
      System.out.println( "-anonenable          DEFAULT " +hack.anonEnable()     );

      // Sample
      System.out.println( "" );
      System.out.println( "Sample" );
      System.out.println( "" );
      System.out.println( "urlchk -ip www.site-to-scan.com" );

      try {
         for( int nParam=0; nParam<argv.length; nParam++ ){
                   if( argv[nParam].equalsIgnoreCase("-ip") ){
              if( nParam+1<argv.length ){
                 hack.setIP( argv[nParam+1] );
              }
            } else if( argv[nParam].equalsIgnoreCase("-port") ){
              if( nParam+1<argv.length ){
                 hack.setPort( argv[nParam+1] );
              }
            } else if( argv[nParam].equalsIgnoreCase("-urlfile") ){
              if( nParam+1<argv.length ){
                 hack.setFile( argv[nParam+1] );
              }
            } else if( argv[nParam].equalsIgnoreCase("-verbose") ){
              hack.setVerbose( true );
            } else if( argv[nParam].equalsIgnoreCase("-proxy") ){
              if( nParam+1<argv.length ){
                 hack.setProxy( argv[nParam+1] );
              }
            } else if( argv[nParam].equalsIgnoreCase("-thread") ){
              if( nParam+1<argv.length ){
                 hack.setThread( argv[nParam+1] );
              }
            } else if( argv[nParam].equalsIgnoreCase("-timeout") ){
              if( nParam+1<argv.length ){
                 hack.setTimeout( argv[nParam+1] );
              }
            } else if( argv[nParam].equalsIgnoreCase("-proxyport") ){
              if( nParam+1<argv.length ){
                 hack.setProxyPort( argv[nParam+1] );
              }
            } else if( argv[nParam].equalsIgnoreCase("-proxyuser") ){
              if( nParam+1<argv.length ){
                 hack.setProxyUser( argv[nParam+1] );
              }
            } else if( argv[nParam].equalsIgnoreCase("-proxypwd") ){
              if( nParam+1<argv.length ){
                 hack.setProxyPassword( argv[nParam+1] );
              }
            } else if( argv[nParam].equalsIgnoreCase("-anonserver") ){
              if( nParam+1<argv.length ){
                 hack.setAnonServer( argv[nParam+1] );
              }
            } else if( argv[nParam].equalsIgnoreCase("-anonenable") ){
              hack.setAnonEnable( true );

            } else if( argv[nParam].equalsIgnoreCase("-filteroff") ){
              hack.setFilter( false );
            }
         }

         if( hack.getIP().length()>0 ){
            System.out.println( "" );
            System.out.println( "Parameter" );
            System.out.println( "---------" );
            System.out.println( "Address    " +hack.getIP()        );
            System.out.println( "Port       " +hack.getPort()      );
            System.out.println( "PWD File   " +hack.getFile()      );
            System.out.println( "Verbose    " +hack.getVerbose()   );
            System.out.println( "Thread     " +hack.getThread()    );
            System.out.println( "Timeout    " +hack.getTimeout()   );

            // Proxy
            if( hack.getProxy().length()>0 ){
               System.out.println( "Proxy      " +hack.getProxy()     );
               System.out.println( "Proxy port " +hack.getProxyPort() );
               System.out.println( "Proxy user " +hack.getProxyUser() );
               System.out.println( "Proxy pwd  " +hack.getProxyPassword()  );
            }

            // Proxy
            if( hack.anonEnable() ){
               System.out.println( "AnonServer " +hack.getAnonServer());
            }

            System.out.println( "" );

            hack.start();
         }

      } catch(Exception e) {
         e.printStackTrace();
      }
   }

   /*************************************************************************/
   static public String getVersion(){ return "0.70"; }

   private String cIP         = "";
   private int    nPort       = 80;
   private String cFile       = "url.ini";
   private boolean bVerbose   = false;
   private boolean bFilter    = true;
   private int    nThread     = 5;
   private int    nTimeout    = 4000;

   // Proxy setting
   private String cProxy      = "";
   private int    cProxyPort  = 0;
   private String cProxyUser  = "";
   private String cProxyPassword   = "";

   // Anonimous
   private String cAnon       = "anon.free.anonymizer.com";
   private boolean bAnon      = false;

   private boolean bRun       = true;

   private htmlResult oFormat;

   public urlchk(){}

   public void setIP( String cIP ){
      this.cIP = cIP;
   }
   public String getIP(){
      return cIP;
   }

   public void setPort( String cPort ){
      this.nPort = Integer.parseInt( cPort );
   }
   public int getPort(){
      return nPort;
   }

   public void setThread( String cThread ){
      this.nThread = Integer.parseInt( cThread );
   }
   public int getThread(){
      return nThread;
   }

   public void setTimeout( String cTimeout ){
      this.nTimeout = Integer.parseInt( cTimeout );
   }
   public int getTimeout(){
      return nTimeout;
   }

   public void setFile( String cFile ){
      this.cFile = cFile;
   }
   public String getFile(){
      return cFile;
   }

   public void setProxy( String cProxy ){
      this.cProxy = cProxy;
   }
   public String getProxy(){
      return cProxy;
   }

   public void setProxyPort( String cProxyPort ){
      this.cProxyPort = Integer.parseInt( cProxyPort );
   }
   public int getProxyPort(){
      return cProxyPort;
   }

   public void setProxyUser( String cProxyUser ){
      this.cProxyUser = cProxyUser;
   }
   public String getProxyUser(){
      return cProxyUser;
   }

   public void setProxyPassword( String cProxyPassword ){
      this.cProxyPassword = cProxyPassword;
   }
   public String getProxyPassword(){
      return cProxyPassword;
   }

   public void setAnonServer( String cAnon ){
      this.cAnon = cAnon;
   }
   public String getAnonServer(){
      return cAnon;
   }

   public void setAnonEnable( boolean bAnon ){
      this.bAnon = bAnon;
   }
   public boolean anonEnable(){
      return bAnon;
   }

   public void setVerbose( boolean bVerbose ){
      this.bVerbose = bVerbose;
   }
   public boolean getVerbose(){
      return bVerbose;
   }

   public void setFilter( boolean bFilter ){
      this.bFilter = bFilter;;
   }
   public boolean getFilter(){
      return bFilter;
   }

   private Socket getSocket( String cLine ) throws Throwable {

      String cLocalServer = "";
      int    cLocalPort   = 80;
      String cCGI         = "";

      if( bAnon ){
         cLocalServer = cAnon;
         cLocalPort   = 80;
         cCGI         = "/http://" +getIP() +cLine;
      } else {
         cLocalServer = getIP();
         cLocalPort   = getPort();
         cCGI         = cLine;
      }

      // If proxy
      if( cProxy.length()>0 ){
         cCGI = "GET http://" +cLocalServer +cCGI +" HTTP/1.0\n";

         // Check pwd
         String cEncode = cProxyUser;
         if( cEncode.length()>0 ){
            if( cProxyPassword.length()>0 )
               cEncode += ":" +cProxyPassword;
            cEncode = new String( Base64.encode( cEncode.getBytes() ) );

            cCGI += "Referer: Unknown\n";
            cCGI += "Proxy-Connection: Keep-Alive\n";
            cCGI += "User-Agent: Mozilla/4.76 [en] (WinNT; U)\n";
            cCGI += "Pragma: no-cache\n";
            cCGI += "Host: " +cLocalServer +"\n";
            cCGI += "Accept: image/gif, image/x-xbitmap, image/jpeg, image/pjpeg, image/png\n";
            cCGI += "Accept-Encoding: gzip\n";
            cCGI += "Accept-Language: en\n";
            cCGI += "Accept-Charset: iso-8859-1,*,utf-8\n";
            cCGI += "Proxy-authorization: Basic " +cEncode +"\n";
         }

         cLocalServer = cProxy;
         cLocalPort   = cProxyPort;
      } else {
         cCGI = "GET " +cCGI +" HTTP/1.0\n";
      }

      if( bVerbose ){
         System.out.println( "Request :" +cLocalServer );
         System.out.println( "Port    :" +cLocalPort   );
         System.out.println( "GET     :" +cCGI         );
      }

      // Open socket
      Socket test = new Socket( cLocalServer, cLocalPort );

      // Set timeout
      test.setSoTimeout( nTimeout );

      // Open stream
      PrintWriter output = new PrintWriter( test.getOutputStream() );

      // Write request
      output.println( cCGI );

      // Flush
      output.flush();

      return test;
   }

   private Properties aURL  = new Properties();
   private long ThreadStart = 0;
   public void start(){
      ThreadStart  = System.currentTimeMillis();

      System.out.println( "Read information" );
      try {
         oFormat = new htmlResult( this );

         writeThread admin = new writeThread( this, oFormat );
         admin.start();

         // Leggo il file di specifiche
         FileInputStream fInput = new FileInputStream( cFile );
         byte[] buffer = new byte[ fInput.available() ];
         fInput.read( buffer );
         fInput.close();
         String cFileReaded = new String( buffer );

         // Essendo in formato XML mi limito a prendere i vari blocchi di
         // redirezione
         String cIni = "<url>";
         String cEnd = "</url>";
         int nPosIni = cFileReaded.indexOf( cIni );
         int nPosEnd = cFileReaded.indexOf( cEnd );

         System.out.println( "" );
         String cOutServer = getServer();
         System.out.println( "Server    : (" +cOutServer +")" );
         cOutServer = shortServerName( cOutServer );
         System.out.println( "Server ID : (" +cOutServer +")" );
         System.out.println( "" );

         int nReaded = 0;
         int nSkip   = 0;

         // Create admin process
         while( nPosEnd>nPosIni ){
            nReaded++;
            String cRed = cFileReaded.substring( nPosIni, nPosEnd+cEnd.length() );

            String cServer = getToken( cRed, "server" );

            boolean bAdd = false;
            // not specified
            if( !bAdd && cServer.length()==0 )
               bAdd = true;
            if( !bAdd && cOutServer.length()==0 )
               bAdd = true;

            // Equal
            if( !bAdd && cOutServer.equalsIgnoreCase(cServer) )
               bAdd = true;

            // Check server
            if( bAdd || !bFilter ) // equal or forced
               aURL.put( getToken( cRed, "get" ), getToken( cRed, "info" ) );
            else {
               nSkip++;
               oFormat.addToLog( "skipped", getToken( cRed, "get" ), "Only (" +cServer +") server<br>" +getToken( cRed, "info" ), "", "" );
            }

            // Cerco il blocco successivo
            cFileReaded = cFileReaded.substring( nPosEnd+cEnd.length() );
            nPosIni = cFileReaded.indexOf( cIni );
            nPosEnd = cFileReaded.indexOf( cEnd );
         }

         System.out.println( "Found (" +nReaded +") CGI to scan and (" +nSkip +") CGI to skip" );

      } catch(Exception e) {
         e.printStackTrace();
      }

      // Now start Thread
      System.out.println( "Start Scanning ..." );
      try{
         oURL = aURL.keys();

         Thread aThread[] = new Thread[nThread];
         for( int n=0; n<nThread; n++){
            aThread[n] = new urlThread( this );
            aThread[n].start();
         }

         for( int n=0; n<nThread; n++){
            if( aThread[n].isAlive() ){
               n=-1;
               Thread.sleep(1000);
            }

         }
      } catch(Exception e) {
         e.printStackTrace();
      }

      bRun = false;

      oFormat.flushFile();
      System.out.println( "Execution time (" +getExecutionTime() +") seconds" );
   }

   public double getExecutionTime(){
      double nDurata = System.currentTimeMillis() -ThreadStart;
             nDurata = nDurata/1000;
      return nDurata;
   }

   private int nPos = 0;
   private Enumeration oURL;
   public synchronized String getURL(){
      nPos++;
      if( bVerbose || (!bVerbose && (nPos%10)==0) ){
         System.out.println( "Position : " +nPos );
      }
      String cRet=null;
      if( oURL.hasMoreElements() ){
         cRet  = (String)oURL.nextElement();
      }
      return cRet;
   }
   public String getInfo( String cInfo ){
      return aURL.getProperty(cInfo);
   }


   public boolean isRun(){
      return bRun;
   }

   private String getToken( String cXML, String cToken ){
      return getToken( cXML, cToken, "" );
   }

   private String getToken( String cXML, String cToken, String cDefault ){
      String cRet = "";

      String cIni = "<" +cToken +">";
      String cEnd = "</" +cToken +">";
      int nPosIni = cXML.indexOf( cIni );
      int nPosEnd = cXML.indexOf( cEnd );

      if( nPosEnd>nPosIni )
         cRet = cXML.substring( nPosIni+cIni.length(), nPosEnd );

      if( cRet.length()==0 )
         cRet = cDefault;

      return cRet;
   }

   public chkResult chkURL( String cLine, String cInfo ){
      chkResult oRet = null;
      try{
         Socket test = getSocket( cLine );

         String cReply = getReply( test );
         BufferedReader reader = new BufferedReader( new StringReader( cReply ) );

         String cErr     = "";
         String cHeader  = "";
         String cHTML    = "";

         try {
            int nRow = 1;
            String cBufLine = "";
            boolean bHeader = true;
            while( cBufLine!=null ){
               cBufLine = reader.readLine();
               if( cBufLine!=null ){
                  cBufLine = cBufLine.trim();

                  if( bHeader ){
                     if( nRow==1 ){ // Result
                        cErr     = cBufLine;
                        cHeader += cBufLine +"\n";

                     } else if( cBufLine.length()==0 ){ // End header
                        bHeader = false;

                        // If not verbose stop to download the page
                        if( !bVerbose ) cBufLine=null;

                     } else { // Other parameter
                        cHeader += cBufLine +"\n";
                     }

                  } else {
                     cHTML += cBufLine +"\n";
                  }
                  nRow++;
               }
            }
         } catch(Throwable e) {
            e.printStackTrace();
         }

         test.close();

         if( bVerbose ){
            System.out.println( "REQ: " +cLine       );
            System.out.println( "INF: " +cInfo       );
            System.out.println( "RES: " +cErr        );
            System.out.println( "" );
         }

         oRet = new chkResult();
         oRet.cErr    = cErr;
         oRet.cLine   = cLine;
         oRet.cInfo   = cInfo;
         oRet.cHeader = cHeader;
         oRet.cHTML   = cHTML;

         //oFormat.addToLog( cErr, cLine, cInfo, cHeader, cHTML );

      } catch(Throwable e) {
         e.printStackTrace();
      }
      return oRet;
   }

   public void addToLog( chkResult oRet ){
      oFormat.addToLog( oRet );
   }

   public String getServer(){
      String cServer = "";
      String cLine = "/";
      try{
         Socket test = getSocket( cLine );

         String cReply = getReply( test );
         BufferedReader reader = new BufferedReader( new StringReader( cReply ) );

         String cErr     = "";
         String cHeader  = "";
         String cHTML    = "";

         try {
            int nRow = 1;
            String cBufLine = "";
            boolean bHeader = true;
            while( cBufLine!=null ){
               cBufLine = reader.readLine();
               if( cBufLine!=null ){
                  cBufLine = cBufLine.trim();

                  if( bHeader ){
                     if( nRow==1 ){ // Result
                        cErr     = cBufLine;
                        cHeader += cBufLine +"\n";

                     } else if( cBufLine.length()==0 ){ // End header
                        bHeader = false;

                        // If not verbose stop to download the page
                        if( !bVerbose ) cBufLine=null;

                     } else { // Other parameter
                        cHeader += cBufLine +"\n";
                     }

                  } else {
                     cHTML += cBufLine +"\n";
                  }
                  nRow++;
               }
            }
         } catch(Throwable e) {
            e.printStackTrace();
         }

         test.close();

         if( bVerbose ){
            System.out.println( "REQ: " +cLine       );
            //System.out.println( "INF: " +cInfo       );
            System.out.println( "RES: " +cErr        );
            System.out.println( "" );
         }

         try{
            // Normalize
            cHeader = cHeader.toUpperCase();

            int nPos    = cHeader.indexOf( "SERVER:" );
            int nSpace  = cHeader.indexOf(" ",nPos);
            int nSpace2 = cHeader.indexOf("\n",nSpace);

            cServer = cHeader.substring(nSpace,nSpace2).trim();
         } catch (Throwable e) {
            cServer = "";
         }

      } catch(Throwable e) {
         e.printStackTrace();
      }

      return cServer;
   }

   private String shortServerName( String cS ){
      String cServer = "";

      if( cS.indexOf("APACHE")!=-1 ){
         cServer = "apache";
      } if( cS.indexOf("MICROSOFT-IIS")!=-1 ){
         cServer = "iis";
      } if( cS.indexOf("LOTUS-DOMINO")!=-1 ){
         cServer = "notes";
      }

      return cServer;
   }

   private String getReply( Socket test ) throws Throwable {
      int nChar;
      StringBuffer cReply = new StringBuffer();
      InputStream is = test.getInputStream();

      while( true ){
         try{
            nChar=is.read();
            if( nChar==-1 )
               break;
         } catch(Throwable e) {
            break;
         }
         cReply.append( (char)nChar );
      }

      return cReply.toString();
   }

}
