/*
 * Security Scanner - HTML Result
 *
 * Copyright 2001 Matteo Baccan <mbaccan@planetisa.com>
 * www - http://www.infomedia.it/artic/Baccan
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA (or visit
 * their web site at http://www.gnu.org/).
 *
 */

import java.net.*;
import java.io.*;
import java.sql.*;
import java.util.*;

public class htmlResult {

   private urlchk scanner;
   public htmlResult( urlchk parent ){
      this.scanner = parent;
   }

   private Properties aURL = new Properties();
   private int nScanned = 0;
   public void addToLog( chkResult oRet ){

      if( oRet.oVariant.size()>0 ){
         oRet.cInfo += "<table width=100% border=1><tr>";
         oRet.cInfo += "<tr>";
         oRet.cInfo += "<td colspan=2>Variant</td>";
         oRet.cInfo += "</tr>";
         oRet.cInfo += "<tr>";
         oRet.cInfo += "<td>Error</td>";
         oRet.cInfo += "<td>URL</td>";
         oRet.cInfo += "</tr>";
         for( int n=0; n<oRet.oVariant.size(); n++ ){
            chkResult oVar = (chkResult)oRet.oVariant.elementAt(n);
            oRet.cInfo += "<tr>";
            oRet.cInfo += "<td>" +getError( oVar.cErr ) +"</td>";
            oRet.cInfo += "<td>" +oVar.cLine +"</td>";
            oRet.cInfo += "</tr>";
         }
         oRet.cInfo += "</tr></table>";
      }

      addToLog( oRet.cErr    ,
                oRet.cLine   ,
                oRet.cInfo   ,
                oRet.cHeader ,
                oRet.cHTML   );

      Properties aError = new Properties();

      // Skip this error
      aError.put( getError( oRet.cErr ), "" );

      // Skip error 400
      aError.put( "400", "" );

      for( int n=0; n<oRet.oVariant.size(); n++ ){
         chkResult oVar = (chkResult)oRet.oVariant.elementAt(n);
         String cErr = getError( oVar.cErr );
         if( aError.get( cErr )==null ){
            aError.put( getError( oVar.cErr ), "" );
            addToLog( oVar.cErr    ,
                      oVar.cLine   ,
                      oVar.cInfo   ,
                      oVar.cHeader ,
                      oVar.cHTML   );

         }
      }

   }

   public void addToLog( String cBufLine,
                         String cLine,
                         String cInfo,
                         String cHeader,
                         String cHTML ){
      try{
         String cURL      = getHTTP() +cLine;
         String cError    = getError( cBufLine );

         String cErr = "00ff00";
         if( cError.equalsIgnoreCase("200") )
            cErr = "ff0000";

         String cTable = "";
         cTable += "<table cellpadding=0 width=\"100%\">\n";
         cTable += "<tr bgcolor=\"#" +cErr +"\"><td><a href=" +cURL +">" +cURL +"</a><br></td></tr>\n";
         cTable += "<tr><td>" +cInfo +"<br></td></tr>\n";
         if( !cError.equalsIgnoreCase("skipped") ){
            cTable += "<tr><td>" +toHex(cBufLine) +"</td></tr>\n";
         }
         if( cLine.equals("/") ){
            cTable += "<tr><td><pre>" +cHeader +"</pre></td></tr>\n";
         }
         if( scanner.getVerbose() && !cError.equalsIgnoreCase("skipped") ){
            cTable += "<tr><td>" +toHex(cHTML) +"</td></tr>\n";
         }
         cTable += "</table>\n";

         // Att to cache
         aURL.put( cError, aURL.getProperty(cError,"")+cTable );

         nScanned++;

      } catch(Throwable e) {
         e.printStackTrace();
      }
   }

   public synchronized void flushFile(){

      // Create directory
      try{
         java.io.File oDir = new java.io.File( scanner.getIP() );
         if( !oDir.exists() )
            oDir.mkdir();

         // Index file
         try{
            String cFilePath = scanner.getIP() +"\\index.htm";
            try{ new java.io.File( cFilePath ).delete(); } catch(Throwable e) { }
            RandomAccessFile oFile = new RandomAccessFile( cFilePath, "rw" );

            append( oFile, "<html>\n"                                                                         );
            append( oFile, "<head>\n"                                                                         );
            append( oFile, "<title>" +scanner.getIP() +"</title>\n"                                           );
            append( oFile, "</head>\n"                                                                        );
            append( oFile, "<frameset cols=180,* frameborder=0 border=0>\n"                                   );
            append( oFile, "<frame src=\"menu.htm\"  name=\"menu\"  marginwidth=0 marginheight=0 noresize>\n" );
            append( oFile, "<frame src=\"intro.htm\" name=\"error\" marginwidth=0 marginheight=0>\n"          );
            append( oFile, "</frameset>\n"                                                                    );
            append( oFile, "</html>\n"                                                                        );

            oFile.close();
         } catch(Throwable e) {

         }

         // Intro file
         try{
            String cFilePath = scanner.getIP() +"\\intro.htm";
            try{ new java.io.File( cFilePath ).delete(); } catch(Throwable e) { }
            RandomAccessFile oFile = new RandomAccessFile( cFilePath, "rw" );

            append( oFile, "<html>\n"                                                                         );
            append( oFile, "<head>\n"                                                                         );
            append( oFile, "<title>" +scanner.getIP() +"</title>\n"                                           );

            // Add automatic refresh if parent is running
            if( scanner.isRun() ) append( oFile, "<META http-equiv=\"refresh\" content=\"5\">\n"                                    );

            append( oFile, "</head>\n"                                                                        );
            append( oFile, "<body>\n"                                                                         );
            append( oFile, "<table WIDTH=\"100%\">\n"                                                         );
            append( oFile, "<tr><td colspan=2>"                +getHeader( "Target information" ) +"</td></tr>\n" );
            append( oFile, "<tr><td>Address</td><td><a href="  +getHTTP() +">" +getHTTP() +"</a></td></tr>\n" );
            append( oFile, "<tr><td>Execution Time</td><td>"   +scanner.getExecutionTime()        +" seconds</td></tr>\n" );
            append( oFile, "<tr><td>CGI</td><td>"              +nScanned +"</td></tr>\n" );
            append( oFile, "</table>"                                      +"\n"                              );
            append( oFile, "<table width=100%>"                            +"\n"                              );
            append( oFile, "<tr>"                                          +"\n"                              );
            append( oFile, "<td>"                                          +"\n"                              );
            append( oFile, "<table border cellspacing=0 cellpadding=0 width=100%><tr align=center bgcolor=\"#ffcccc\"><td><a href=http://www.infomedia.it/artic/Baccan>Made with urlchk " +scanner.getVersion() +" Security Scanner<br>click here for an upgrade</a></td></tr></table>\n" );
            append( oFile, "</td>"                                         +"\n"                              );
            append( oFile, "</tr>"                                         +"\n"                              );
            append( oFile, "</table>"                                      +"\n"                              );
            append( oFile, "Remember: There is no 'patch' for stupidity.\n"                                   );
            append( oFile, "</body>\n"                                                                        );
            append( oFile, "</html>\n"                                                                        );

            oFile.close();
         } catch(Throwable e) {
            e.printStackTrace();
         }

         // Menu
         String cTable = "";
         for( Enumeration oKey = aURL.keys() ; oKey.hasMoreElements() ; ) {
            String cError    = (String)oKey.nextElement();
            String cFileName = scanner.getIP() +"(" +scanner.getPort() +")." +cError +".htm";

            cTable += "<tr><td>";

            cTable += "<table BORDER=0 CELLSPACING=0 CELLPADDING=0 WIDTH=\"100%\">";
            cTable += "<tr>";
            cTable += "<td WIDTH=\"1\" BGCOLOR=\"#33CCFF\">&nbsp;</td>";
            cTable += "<td ROWSPAN=\"2\" BGCOLOR=\"#33CCFF\"><a href=\"" +cFileName +"\" target=\"error\">" +errorToTitle(cError) +"</a></td>";
            cTable += "<td ROWSPAN=\"2\" BGCOLOR=\"#33CCFF\">&nbsp;</td>";
            cTable += "</tr>";
            cTable += "";
            cTable += "<tr>";
            cTable += "<td WIDTH=\"1\" BGCOLOR=\"#33CCFF\">&nbsp;</td>";
            cTable += "<td ROWSPAN=\"2\" WIDTH=\"1\" BGCOLOR=\"#000000\">&nbsp;</td>";
            cTable += "</tr>";
            cTable += "";
            cTable += "<tr>";
            cTable += "<td WIDTH=\"1\"></td>";
            cTable += "<td COLSPAN=\"2\" BGCOLOR=\"#000000\">&nbsp;</td>";
            cTable += "</tr>";
            cTable += "</table>";

            cTable += "</td></tr>\n";
         }

         try{
            String cFilePath = scanner.getIP() +"\\menu.htm";
            try{ new java.io.File( cFilePath ).delete(); } catch(Throwable e) { }
            RandomAccessFile oFile = new RandomAccessFile( cFilePath, "rw" );

            append( oFile, "<html>\n"                                                                         );
            append( oFile, "<head>\n"                                                                         );
            append( oFile, "<title>" +scanner.getIP() +"</title>\n"                                           );

            // Add automatic refresh if parent is running
            if( scanner.isRun() ) append( oFile, "<META http-equiv=\"refresh\" content=\"5\">\n"                                    );

            append( oFile, "</head>\n"                                                                        );
            append( oFile, "<body>\n"                                                                         );
            append( oFile, "<table width=\"100%\">\n"                                                         );
            append( oFile, "<tr><td align=center><a href=\"intro.htm\" target=\"error\">Scan information</a></td></tr>\n" );
            append( oFile, cTable                                                                             );
            append( oFile, "</table>\n"                                                                       );
            append( oFile, "</body>\n"                                                                        );
            append( oFile, "</html>\n"                                                                        );

            oFile.close();
         } catch(Throwable e) {
            e.printStackTrace();
         }

         // All error file
         for( Enumeration oKey = aURL.keys() ; oKey.hasMoreElements() ; ) {
            try{
               String cError    = (String)oKey.nextElement();
               String cFile     = aURL.getProperty( cError, "" );
               String cFileName = scanner.getIP() +"(" +scanner.getPort() +")." +cError +".htm";

               if( cFile.length()>0 ){
                  String cFilePath = scanner.getIP() +"\\" +cFileName;
                  try{ new java.io.File( cFilePath ).delete(); } catch(Throwable e) { }
                  RandomAccessFile oFile = new RandomAccessFile( cFilePath, "rw" );

                  // Open file
                  append( oFile, "<html>\n"                                                                         );
                  append( oFile, "<head>\n"                                                                         );
                  append( oFile, "<title>" +scanner.getIP() +"</title>\n"                                           );

                  // Add automatic refresh if parent is running
                  if( scanner.isRun() ) append( oFile, "<META http-equiv=\"refresh\" content=\"5\">\n"                                    );

                  append( oFile, "</head>\n"                                                                        );
                  append( oFile, "<body>\n"                                                                         );

                  // Title
                  append( oFile, getHeader( errorToTitle( cError ) ) );

                  // Data
                  append( oFile, cFile );

                  // Close file
                  append( oFile, "</body>\n"                                                                        );
                  append( oFile, "</html>\n"                                                                        );

                  oFile.close();
               }
            } catch(Throwable e) {
               e.printStackTrace();
            }
         }

      } catch (Throwable e){
         e.printStackTrace();
      }

   }

   /**
   * Convert error code to description
   * for more info go at
   * http://www.w3.org/Protocols/HTTP/1.0/spec.html#Status-Codes
   */
   private String errorToTitle( String cError ){

      String cRet = cError + " Unknown";
             if( cError.equalsIgnoreCase("200") ){ cRet = "200 Found";
      } else if( cError.equalsIgnoreCase("201") ){ cRet = "201 Created";
      } else if( cError.equalsIgnoreCase("202") ){ cRet = "202 Accepted";
      } else if( cError.equalsIgnoreCase("204") ){ cRet = "204 No Content";
      } else if( cError.equalsIgnoreCase("300") ){ cRet = "300 Multiple Choices";
      } else if( cError.equalsIgnoreCase("301") ){ cRet = "301 Moved Permanently";
      } else if( cError.equalsIgnoreCase("302") ){ cRet = "302 Moved Temporarily";
      } else if( cError.equalsIgnoreCase("304") ){ cRet = "304 Not Modified";
      } else if( cError.equalsIgnoreCase("400") ){ cRet = "400 Bad Request";
      } else if( cError.equalsIgnoreCase("401") ){ cRet = "401 Unauthorized";
      } else if( cError.equalsIgnoreCase("403") ){ cRet = "403 Forbidden";
      } else if( cError.equalsIgnoreCase("404") ){ cRet = "404 Not Found";
      } else if( cError.equalsIgnoreCase("500") ){ cRet = "500 Internal Server Error";
      } else if( cError.equalsIgnoreCase("501") ){ cRet = "501 Not Implemented";
      } else if( cError.equalsIgnoreCase("502") ){ cRet = "502 Bad Gateway";
      } else if( cError.equalsIgnoreCase("503") ){ cRet = "503 Service Unavailable";
      } else if( cError.equalsIgnoreCase("skipped") ){ cRet = "skipped";
      }

      return cRet;
   }

   private String getHeader( String cStr ){
      return "<table border cellspacing=0 cellpadding=0 width=100%><tr align=center bgcolor=\"#33aaff\"><td><font size=+2>" +cStr +"</font></td></tr></table>\n";
   }

   private void append( RandomAccessFile oFile, String cData ){
      try {
         oFile.write( cData.getBytes() );
      } catch(Throwable e) { }
   }

   /**
   * Method for convert error line to error code
   * @param <cBufLine> Error string
   * @return <cRet> error code
   */
   private String getError( String cBufLine ) {
      String cRet = "err";
      try{
         int nPos;

         nPos = cBufLine.indexOf(" ");
         cBufLine = cBufLine.substring(nPos).trim();

         nPos = cBufLine.indexOf(" ");

         // If there are reading problem Get the first 3 chars
         if( nPos==-1 && cBufLine.length()>=3 ) nPos=3;

         // if also error is more long of 3 char, get only first 3 char
         if( nPos>3 ) nPos=3;

         cBufLine = cBufLine.substring(0,nPos).trim();

         cRet = cBufLine;

      } catch(Throwable e) {
         if( cBufLine.equalsIgnoreCase("skipped") )
            cRet = "skipped";
         else
            System.out.println( "Error parsing error code in (" +cBufLine +")" );
      }
      return cRet;
   }

   /**
   * Get URL
   */
   private String getHTTP(){
      String cRet = "http://" +scanner.getIP();

      if( scanner.getPort()!=80 )
         cRet += ":" +scanner.getPort();

      return cRet;
   }

   private String toHex( String cHTML ){
      StringBuffer cRet = new StringBuffer();
      cRet.append("<table width=100% border=1>");

      int nLen = cHTML.length();
      int nStep = 16;
      for( int x=0; x<nLen; x+=nStep ){
         String cPos = cHTML.substring( x, (x+nStep>nLen?nLen:x+nStep) );
         cRet.append("<tr>");
         cRet.append("<td nowrap><font face=courier>");
         for( int xx=0; xx<cPos.length(); xx++ ){
            cRet.append( Integer.toHexString( cPos.charAt(xx) ) +" " );
         }
         cRet.append("</font></td>");
         cRet.append("<td nowrap>");
         cRet.append( cPos );
         cRet.append("</td>");
         cRet.append("</tr>");
      }

      cRet.append("</table>");
      return cRet.toString();
   }

}
