/*
 * Security Scanner - addUrl
 *
 * Copyright 2001 Matteo Baccan <mbaccan@planetisa.com>
 * www - http://www.infomedia.it/artic/Baccan
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA (or visit
 * their web site at http://www.gnu.org/).
 *
 */

import java.net.*;
import java.io.*;
import java.sql.*;
import java.util.*;

public class addUrl {

   /* Public interface ******************************************************/
   static public void main( String argv[] ) {
      Properties aURL = new Properties();
      try {
         // Read current file specification
         FileInputStream fInput = new FileInputStream( "..\\source\\url.ini" );
         byte[] buffer = new byte[ fInput.available() ];
         fInput.read( buffer );
         fInput.close();
         String cFileReaded = new String( buffer );

         // Add specification to the memory
         String cIni = "<url>";
         String cEnd = "</url>";
         int nPosIni = cFileReaded.indexOf( cIni );
         int nPosEnd = cFileReaded.indexOf( cEnd );

         while( nPosEnd>nPosIni ){
            String cRed = cFileReaded.substring( nPosIni, nPosEnd+cEnd.length() );

            addURL( aURL                       ,
                    getToken( cRed, "get"    ) ,
                    getToken( cRed, "info"   ) ,
                    getToken( cRed, "server" ) );

            // Cerco il blocco successivo
            cFileReaded = cFileReaded.substring( nPosEnd+cEnd.length() );
            nPosIni = cFileReaded.indexOf( cIni );
            nPosEnd = cFileReaded.indexOf( cEnd );
         }

      } catch(Exception e) {
         e.printStackTrace();
      }

      // Now merge file
      try {
         // Read current file specification
         BufferedReader fInput = new BufferedReader( new FileReader( "new.ini" ) );

         int nAdd = 0;

         try{
            while( true ){
               String cUrl = fInput.readLine();
               String cDes = fInput.readLine();
               String cSrv = fInput.readLine();
               if( addURL( aURL, cUrl, cDes, cSrv ) ){
                  System.out.println( "Add: " +cUrl );
                  nAdd++;
               }
            }
         } catch(Exception e) { }

         if( nAdd>0 )
            System.out.println( "(" +nAdd +") new CGI" );

         fInput.close();

      } catch(Exception e) {
         e.printStackTrace();
      }

      // delete old file
      try{ new java.io.File( "url.ini" ).delete(); } catch(Throwable e) { }

      Vector v = new Vector();

      // Write new file
      int nCGI = 0;
      for( Enumeration oKey = aURL.keys() ; oKey.hasMoreElements() ; ) {
         String cURL  = (String)oKey.nextElement();
         entry  ele   = (entry)(aURL.get( cURL ));

         nCGI++;
         v.addElement( ele );
      }

      while( true ){
         boolean bSwap = false;
         for( int n=1; n<v.size(); n++ ){
            entry a = (entry)v.elementAt( n-1 );
            entry b = (entry)v.elementAt( n   );
            if( a.cSrv.compareTo( b.cSrv )>0 ){
               bSwap = true;
               v.setElementAt( b, n-1 );
               v.setElementAt( a, n   );
            } else if( a.cSrv.compareTo( b.cSrv )==0 &&
                       a.cGet.compareTo( b.cGet )>0  ){
               bSwap = true;
               v.setElementAt( b, n-1 );
               v.setElementAt( a, n   );
            }
         }
         if( !bSwap ) break;
      }

      try{
         RandomAccessFile oFile = new RandomAccessFile( "url.ini", "rw" );
         for( int n=0; n<v.size(); n++ ){
            entry ele = (entry)v.elementAt( n );

            append( oFile, "<url>\n" );
            append( oFile, "   <get>"    +ele.cGet +"</get>\n" );
            append( oFile, "   <info>"   +ele.cDes +"</info>\n" );
            append( oFile, "   <server>" +ele.cSrv +"</server>\n" );
            append( oFile, "</url>\n" );
            append( oFile, "\n" );
         }

         oFile.close();
      } catch(Throwable e) {
         e.printStackTrace();
      }

      System.out.println("(" +nCGI +") CGI written");

   }

   static private boolean addURL( Properties aURL  ,
                                  String cURL      ,
                                  String cDes      ,
                                  String cSrv      ){
      if( cURL.endsWith("/") )
         cURL = cURL.substring( 0, cURL.length()-1 );

      if( !cURL.startsWith("/") )
         cURL = "/" +cURL;

      if( cDes.length()==0 ) cDes = cURL;

      cSrv = cSrv.toLowerCase();

      boolean bAdd = (aURL.getProperty( cURL )==null);
      if( bAdd ){
         entry add = new entry();
               add.cGet = cURL;
               add.cDes = cDes;
               add.cSrv = cSrv;
         aURL.put( cURL, add );
      }

      return bAdd;
   }

   static private String getToken( String cXML,
                            String cToken ){
      return getToken( cXML, cToken, "" );
   }

   static private String getToken( String cXML,
                            String cToken,
                            String cDefault ){
      String cRet = "";

      String cIni = "<" +cToken +">";
      String cEnd = "</" +cToken +">";
      int nPosIni = cXML.indexOf( cIni );
      int nPosEnd = cXML.indexOf( cEnd );

      if( nPosEnd>nPosIni )
         cRet = cXML.substring( nPosIni+cIni.length(), nPosEnd );

      if( cRet.length()==0 )
         cRet = cDefault;

      return cRet;
   }

   static private void append( RandomAccessFile oFile, String cData ){
      try {
         oFile.write( cData.getBytes() );
      } catch(Throwable e) { }
   }

}

class entry {
   public String cGet = "";
   public String cDes = "";
   public String cSrv = "";
}
